/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.api.AppointmentClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.push.pojo.miniapp.AlibabaMedicalPushReqVO;
import com.ebaiyihui.push.pojo.miniapp.RegistrationPushReqVo;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.TimeArrangeIdTypeEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.gateway.RouteEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.HospitalConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DoDayAppointmentDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PayRequestVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.appoint.CancelRegisterReq;
import his.pojo.vo.appoint.CancelRegisterRes;
import his.pojo.vo.appoint.ConfirmRegisterReq;
import his.pojo.vo.appoint.ConfirmRegisterRes;
import his.pojo.vo.appoint.DayRegisterReq;
import his.pojo.vo.appoint.DayRegisterRes;
import his.pojo.vo.appoint.GetAppointRecordReq;
import his.pojo.vo.appoint.GetAppointRecords;
import his.pojo.vo.appoint.LockOrderReq;
import his.pojo.vo.appoint.LockOrderRes;
import his.pojo.vo.appoint.PayRegistrationMsg;
import his.pojo.vo.appoint.PayRegistrationReq;
import his.pojo.vo.appoint.PayRegistrationRes;
import his.pojo.vo.appoint.ReturnRegisterReq;
import his.pojo.vo.appoint.ReturnRegisterRes;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.base.GatewayRequest;
import his.pojo.vo.base.GatewayResponse;
import his.pojo.vo.nucleic.nucleicAcidAppointmentReq;
import his.pojo.vo.nucleic.nucleicAcidAppointmentRes;
import his.pojo.vo.outpatient.PayItemReq;
import his.pojo.vo.outpatient.PayItemRes;
import his.pojo.vo.outpatient.datas.PayItemResDatas;
import his.pojo.vo.outpatient.items.GetAdmissionItems;
import his.pojo.vo.schedule.GetScheduleReqVO;
import his.pojo.vo.schedule.GetScheduleResVO;
import his.pojo.vo.schedule.items.GetScheduleResItems;
import his.pojo.vo.schedule.items.TimeArrangeItems;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class AppointmentServiceImpl
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    public static final int HAF_HOURS = 1800;
    public static final int TWO_HOURS = 7200;
    public static final int CURRENT_DAY_APPOINTMENT = 2;
    public static final int NOT_CURRENT_DAY_APPOINTMENT = 1;
    public static final String YES_TOPAY = "1";
    public static final String NOT_TOPAY = "0";
    public static final String SUCCESS = "Y";
    public static final int HAVE_TIME_ARRANGE_FLAG = 1;
    public static final String HIS_MORNING = "0";
    public static final String HIS_AFTERNOON = "1";
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PushService pushService;
    public static final List<Integer> WAIT_CONFIRMED = Arrays.asList(11, 15, 16, 17, 18);
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private AppointmentClient appointmentClient;
    private String hisOrderNumber = "his-order-number";

    public String confirmAppointment(ConfirmAppointmentVo confirmAppointmentVo) throws ScheduleException {
        String admDate = confirmAppointmentVo.getAdmDate();
        List getScheduleResItemsList = this.getHisDaySchedule(confirmAppointmentVo);
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            throw new ScheduleException("\u5b9e\u65f6\u67e5\u8be2\u533b\u751f\u6392\u73ed\u6570\u636e\u5f02\u5e38,\u8bf7\u91cd\u8bd5");
        }
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)getScheduleResItemsList.get(0);
        confirmAppointmentVo = this.buildConfirmAppointmentVo(getScheduleResItems, confirmAppointmentVo);
        String confirmAppointmentId = String.valueOf(this.snowflakeIdWorker.nextId());
        if (String.valueOf(LocalDate.now()).equals(admDate)) {
            confirmAppointmentVo.setAppointmentType(2);
        } else {
            confirmAppointmentVo.setAppointmentType(1);
        }
        String confirmAppointmentVoStr = JSON.toJSONString((Object)confirmAppointmentVo);
        this.jedisCluster.set(confirmAppointmentId, confirmAppointmentVoStr);
        this.jedisCluster.expire(confirmAppointmentId, 7200);
        return confirmAppointmentId;
    }

    public String dayAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u5165\u53c2{}", (Object)JSON.toJSONString((Object)createOrderVoReq, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null == cardDetail) {
            throw new AppointmentException("\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25\uff0c\u6302\u53f7\u5f02\u5e38!");
        }
        this.registrationRules(createOrderVoReq.getIdNo(), createOrderVoReq.getDeptCode());
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        LockOrderRes dayRegisterRes = new LockOrderRes();
        GetScheduleResItems getScheduleResItems = this.builGetScheduleResItems(createOrderVoReq);
        AppointmentRecordEntity appointmentRecordEntity = this.buildLockSourceAppointmentRecordEntity(sysAppointmentId, dayRegisterRes, getScheduleResItems, createOrderVoReq);
        log.info("\u8ba2\u5355\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        FrontRequest frontRequest = this.buildPayRegistrationReq(createOrderVoReq);
        log.info("\u8bf7\u6c42\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u63a5\u53e3\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse payRegistrationResFrontResponse = this.appointmentClient.dayPayRegistration(frontRequest);
        log.info("\u8bf7\u6c42\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u63a5\u53e3\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)payRegistrationResFrontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!"1".equals(payRegistrationResFrontResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u5931\u8d25");
            throw new AppointmentException("\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u5931\u8d25" + payRegistrationResFrontResponse.getMessage());
        }
        if (null == ((PayRegistrationRes)payRegistrationResFrontResponse.getBody()).getReceiptId()) {
            log.error("\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u5931\u8d25 his\u6ca1\u6709\u8fd4\u56de\u552f\u4e00\u53d1\u7968");
            throw new AppointmentException("\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u5931\u8d25" + payRegistrationResFrontResponse.getMessage());
        }
        FrontRequest dayRegisterReqFrontRequest = this.bulidDayRegisterReq(createOrderVoReq, payRegistrationResFrontResponse);
        log.info("\u8bf7\u6c42\u5f53\u65e5\u6302\u53f7\u63a5\u53e3\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)dayRegisterReqFrontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse dayRegisterResFrontResponse = this.appointmentClient.dayRegister(dayRegisterReqFrontRequest);
        log.info("\u8bf7\u6c42\u5f53\u65e5\u6302\u53f7\u63a5\u53e3\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)dayRegisterResFrontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!"1".equals(dayRegisterResFrontResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7\u5931\u8d25");
            throw new AppointmentException("\u5f53\u65e5\u6302\u53f7\u5931\u8d25" + dayRegisterResFrontResponse.getMessage());
        }
        if (null == ((DayRegisterRes)dayRegisterResFrontResponse.getBody()).getAppointId()) {
            log.error("\u5f53\u65e5\u6302\u53f7\u5931\u8d25 his\u6ca1\u6709\u8fd4\u56de\u552f\u4e00\u53d1\u7968");
            throw new AppointmentException("\u5f53\u65e5\u6302\u53f7\u5931\u8d25" + dayRegisterResFrontResponse.getMessage());
        }
        appointmentRecordEntity.setReceptId(((DayRegisterRes)dayRegisterResFrontResponse.getBody()).getAppointId());
        appointmentRecordEntity.setAppointmentId(((DayRegisterRes)dayRegisterResFrontResponse.getBody()).getAppointId());
        appointmentRecordEntity.setAppointmentNo(((DayRegisterRes)dayRegisterResFrontResponse.getBody()).getNo());
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        this.jedisCluster.set(appointmentRecordEntity.getSysAppointmentId() + "_authCode", createOrderVoReq.getAuthCode(), "NX", "EX", 43200L);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private void registrationRules(String idNo, String deptCode) throws AppointmentException {
        log.info("registrationRules \u5165\u53c2 idNo - >{}, deptCode - > {}", (Object)idNo, (Object)deptCode);
        String gender = Convert.toStr((Object)IdcardUtil.getGenderByIdCard((String)idNo));
        int age = IdcardUtil.getAgeByIdCard((String)idNo);
        String[] pediatricClinic = new String[]{"200701", "200706"};
        if (Arrays.asList(pediatricClinic).contains(deptCode) && age > 18) {
            throw new AppointmentException("\u513f\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb818\u5468\u5c81\u53ca\u4ee5\u4e0b\u6302\u53f7");
        }
        String[] gynecology = new String[]{"800501"};
        if (Arrays.asList(gynecology).contains(deptCode) && "1".equals(gender)) {
            throw new AppointmentException("\u5987\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb8\u5973\u6027\u6302\u53f7");
        }
    }

    private FrontRequest<DayRegisterReq> bulidDayRegisterReq(DayAppointmentCreateOrderVoReq createOrderVoReq, FrontResponse<PayRegistrationRes> payRegistrationResFrontRespons) {
        FrontRequest frontRequest = new FrontRequest();
        DayRegisterReq dayRegisterReq = new DayRegisterReq();
        dayRegisterReq.setRbasId(createOrderVoReq.getScheduleHisId());
        dayRegisterReq.setAdmNo(((PayRegistrationRes)payRegistrationResFrontRespons.getBody()).getReceiptId());
        dayRegisterReq.setTimeArrangeId(createOrderVoReq.getStarTime());
        dayRegisterReq.setRegFee(createOrderVoReq.getRegFee());
        dayRegisterReq.setPayChannel(createOrderVoReq.getHl());
        dayRegisterReq.setCardNo(createOrderVoReq.getPatientCardNo());
        dayRegisterReq.setTimeFlag(createOrderVoReq.getEndTime());
        if (createOrderVoReq.getHl().equals("2")) {
            dayRegisterReq.setDoctorNo(createOrderVoReq.getDocCode() + "*" + createOrderVoReq.getDocName());
        } else {
            dayRegisterReq.setDeptNo(createOrderVoReq.getDeptCode() + "*" + createOrderVoReq.getDeptName());
        }
        dayRegisterReq.setMedicalFee(createOrderVoReq.getDiagFee());
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)dayRegisterReq);
        return frontRequest;
    }

    private FrontRequest<PayRegistrationReq> buildPayRegistrationReq(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        FrontRequest frontRequest = new FrontRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setPatientId(createOrderVoReq.getDocCode());
        payRegistrationReq.setCardNo(createOrderVoReq.getPatientCardNo());
        payRegistrationReq.setAppointId(createOrderVoReq.getDeptCode());
        payRegistrationReq.setScheduleId(createOrderVoReq.getHl());
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)payRegistrationReq);
        return frontRequest;
    }

    private GetScheduleResItems builGetScheduleResItems(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
        getScheduleResItems.setLocName(createOrderVoReq.getDeptName());
        getScheduleResItems.setScheduleId(createOrderVoReq.getScheduleHisId());
        getScheduleResItems.setAdmDate(createOrderVoReq.getAdmDate() + createOrderVoReq.getStarTime());
        getScheduleResItems.setDocCode(createOrderVoReq.getDocCode());
        getScheduleResItems.setDocName(createOrderVoReq.getDocName());
        getScheduleResItems.setRegFee(createOrderVoReq.getRegFee());
        getScheduleResItems.setDiagFee(createOrderVoReq.getDiagFee());
        getScheduleResItems.setRegTitleName(createOrderVoReq.getRegTitleName());
        getScheduleResItems.setScheduleLevelName(createOrderVoReq.getScheduleLevelName());
        return getScheduleResItems;
    }

    public String nucleicAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException, OutpatientPaymentException {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null == cardDetail) {
            throw new AppointmentException("\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25\uff0c\u6302\u53f7\u5f02\u5e38!");
        }
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6392\u73ed\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u5f53\u524d\u65f6\u6bb5\u6ca1\u6709\u6392\u73ed\u4fe1\u606f");
        }
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        if (!Objects.isNull(createOrderVoReq.getScheduleHisId())) {
            List collect = scheduleResItemsList.stream().filter(i -> createOrderVoReq.getScheduleHisId().equals(i.getScheduleId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
                throw new AppointmentException("\u5f53\u524d\u6392\u73ed\u5df2\u88ab\u5360\u7528\uff0c\u5237\u65b0\u540e\u91cd\u8bd5");
            }
            getScheduleResItem = (GetScheduleResItems)collect.get(0);
        }
        AppointmentRecordEntity appointmentRecordEntity = null;
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        GatewayRequest dayGatewayRequest = this.buildDayConfirmRegisterReq(sysAppointmentId, createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1a" + dayGatewayRequest);
        GatewayResponse dayGatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), dayGatewayRequest.getOrganCode(), RouteEnum.CONFIRM_REGISTER.getValue(), dayGatewayRequest, LockOrderRes.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + dayGatewayResponse);
        if (null == dayGatewayResponse) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        if (!"1".equals(dayGatewayResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayGatewayResponse.getErrCode(), (Object)dayGatewayResponse.getMsg());
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
        }
        if (null == dayGatewayResponse.getData()) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
        }
        LockOrderRes dayRegisterRes = (LockOrderRes)dayGatewayResponse.getData();
        appointmentRecordEntity = this.buildLockSourceAppointmentRecordEntity(sysAppointmentId, (LockOrderRes)dayGatewayResponse.getData(), getScheduleResItem, createOrderVoReq);
        GatewayRequest dayPayGatewayRequest = this.buildNucleicRegisterParams(appointmentRecordEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayPayGatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), dayPayGatewayRequest.getOrganCode(), RouteEnum.REGISTERHT_PAY.getValue(), dayPayGatewayRequest, PayRegistrationRes.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)gatewayResponse));
        if (null == dayPayGatewayResponse.getData() || null == dayPayGatewayResponse) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 ========= -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(dayPayGatewayResponse.getMsg());
        }
        if (!"1".equals(dayPayGatewayResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 ========= -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayPayGatewayResponse.getErrCode(), (Object)dayPayGatewayResponse.getMsg());
            throw new AppointmentException(dayPayGatewayResponse.getMsg());
        }
        GetAdmissionReqVO getAdmissionReqVO = new GetAdmissionReqVO();
        getAdmissionReqVO.setCardNo(appointmentRecordEntity.getPatientId());
        List getAdmissionItemsList = this.outpatientPaymentService.getAdmission(getAdmissionReqVO);
        getAdmissionItemsList.removeIf(o -> !o.getDeptName().equals("\u6838\u9178\u68c0\u6d4b\u4fbf\u6c11\u95e8\u8bca"));
        getAdmissionItemsList.sort(Comparator.comparing(GetAdmissionItems::getAdmDate).reversed());
        GetAdmissionItems getAdmissionItems = (GetAdmissionItems)getAdmissionItemsList.get(0);
        if (getAdmissionItemsList.size() <= 0 || null == getAdmissionItems) {
            log.error("\u6838\u9178\u7f34\u8d39\u5904\u65b9\u5217\u8868 ========= -> his\u67e5\u8be2\u5931\u8d25");
            throw new AppointmentException("\u672a\u67e5\u8be2\u5230\u6838\u9178\u5f85\u7f34\u8d39\u5904\u65b9");
        }
        GatewayRequest detilGatewayRequest = this.buildNucleicOutDetialParams(appointmentRecordEntity, getAdmissionItems);
        GatewayResponse detilGatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), detilGatewayRequest.getOrganCode(), RouteEnum.PATIENT_PAYMENT_DETAILS.getValue(), detilGatewayRequest, PayItemRes.class);
        PayItemRes data = (PayItemRes)detilGatewayResponse.getData();
        PayItemResDatas payItemResDatas = (PayItemResDatas)data.getDatas().get(0);
        if (data.getDatas().size() <= 0 || null == payItemResDatas) {
            log.error("\u6838\u9178\u7f34\u8d39\u5904\u65b9\u8be6\u60c5 ========= -> his\u67e5\u8be2\u5931\u8d25");
            throw new AppointmentException("\u672a\u67e5\u8be2\u5230\u6838\u9178\u5f85\u7f34\u8d39\u5904\u65b9\u8be6\u60c5");
        }
        if (!"1".equals(detilGatewayResponse.getCode())) {
            log.error("\u6838\u9178\u7f34\u8d39\u5904\u65b9\u8be6\u60c5 ========= -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)detilGatewayResponse.getErrCode(), (Object)detilGatewayResponse.getMsg());
            throw new AppointmentException(detilGatewayResponse.getMsg());
        }
        appointmentRecordEntity.setReceptId(payItemResDatas.getAdmId());
        appointmentRecordEntity.setPayAmount(payItemResDatas.getAmount());
        log.info("\u8ba2\u5355\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        AppointmentRecordEntity recordEntity = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setOrderId(String.valueOf(recordEntity.getId()));
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private GatewayRequest<PayItemReq> buildNucleicOutDetialParams(AppointmentRecordEntity appointmentRecordEntity, GetAdmissionItems getAdmissionItems) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayItemReq payItemReq = new PayItemReq();
        payItemReq.setAdmId(getAdmissionItems.getAdmId());
        payItemReq.setCardNo(appointmentRecordEntity.getPatientId());
        gatewayRequest.setBody((Object)payItemReq);
        return gatewayRequest;
    }

    private AppointmentRecordEntity buildAppointmentRecordEntity(long sysAppointmentId, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAdmAddress(StringUtils.isEmpty((String)getScheduleResItem.getAdmLocation()) ? "null" : getScheduleResItem.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getPatientId());
        }
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        return appointmentRecordEntity;
    }

    private AppointmentRecordEntity buildLockSourceAppointmentRecordEntity(long sysAppointmentId, LockOrderRes dayRegisterRes, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAppointmentId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setAppointmentNo(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setAdmAddress(getScheduleResItem.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        if (createOrderVoReq.getAdmTimeRange().equals("\u4e0a\u5348")) {
            createOrderVoReq.setAdmTimeRange("1");
        } else if (createOrderVoReq.getAdmTimeRange().equals("\u4e0b\u5348")) {
            createOrderVoReq.setAdmTimeRange("2");
        } else {
            createOrderVoReq.setAdmTimeRange("3");
        }
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime((Date)DateUtil.parse((CharSequence)createOrderVoReq.getAdmDate()));
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(StringUtils.isBlank((String)getScheduleResItem.getHospitalArea()) ? "\u91d1\u5ddd\u96c6\u56e2\u6709\u9650\u516c\u53f8\u804c\u5de5\u533b\u9662\uff08\u91d1\u660c\u5e02\u4e2d\u5fc3\u533b\u9662\uff09" : getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getTimeArrange());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientCardNo(cardDetail.getOrganPmi());
        }
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u5f53\u65e5\u6302\u53f7\u6210\u529f");
        appointmentRecordEntity.setCreatetime((Date)DateUtil.date());
        appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
        appointmentRecordEntity.setScheduleLevelName("1");
        try {
            appointmentRecordEntity.setTakeTime(appointmentRecordEntity.getAdmTimeRange().substring(6, appointmentRecordEntity.getAdmTimeRange().length() - 3));
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u622a\u53d6\u51fa\u73b0\u9519\u8bef{}", (Throwable)e);
        }
        return appointmentRecordEntity;
    }

    public ConfirmAppointmentVo getConfirmAppointment(String confirmAppointmentId) {
        String confirmAppointmentVoStr = this.jedisCluster.get(confirmAppointmentId);
        ConfirmAppointmentVo confirmAppointmentVo = (ConfirmAppointmentVo)JSON.parseObject((String)confirmAppointmentVoStr, ConfirmAppointmentVo.class);
        List timeArrangeItemsList = null;
        if (null != confirmAppointmentVo && !CollectionUtils.isEmpty((Collection)confirmAppointmentVo.getTimeArrangeItems())) {
            timeArrangeItemsList = confirmAppointmentVo.getTimeArrangeItems();
            timeArrangeItemsList.sort(Comparator.comparing(TimeArrangeItems::getStartTime));
        }
        return confirmAppointmentVo;
    }

    public GetConfirmPayInfoVoRes getConfirmPayInfo(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = new GetConfirmPayInfoVoRes();
        getConfirmPayInfoVoRes.setCreateTime(appointmentRecordEntity.getCreatetime());
        getConfirmPayInfoVoRes.setPayAccount(appointmentRecordEntity.getPayAmount());
        getConfirmPayInfoVoRes.setSysAppointmentId(sysAppointmentId);
        getConfirmPayInfoVoRes.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        getConfirmPayInfoVoRes.setPatientName(appointmentRecordEntity.getPatientName());
        return getConfirmPayInfoVoRes;
    }

    public List<AppointmentRecordVo> selectByUserIdAndStatus(Map<String, Object> queryMap, String appCode, String channelCode) throws Exception {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId((String)queryMap.get("userId"));
        reqVo.setOrganCode((String)queryMap.get("hospitalCode"));
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        List appointmentRecordEntityList = null;
        if (cardIdList.size() < 1) {
            return new ArrayList<AppointmentRecordVo>();
        }
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(dayAppointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(dayAppointmentCreateOrderVoReq.getDocCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayAppointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public List<AppointmentRecordVo> getAppointRecordByCardList(String userId, String hospitalCode, String appCode, String channelCode) throws AppointmentException {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId(userId);
        reqVo.setOrganCode(hospitalCode);
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        if (CollectionUtils.isEmpty((Collection)cardIdList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        List appointmentRecordEntityList = null;
        Date startDate = DateUtils.getCurrentDate();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("admDateStart", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("admDateEnd", DateUtils.dateToSimpleString((Date)DateUtils.getDateAfter((Date)startDate, (int)7)));
        queryMap.put("userId", userId);
        ArrayList<Integer> appointStatusList = new ArrayList<Integer>();
        appointStatusList.add(AppointmentStatusEnum.PAY.getValue());
        appointStatusList.add(AppointmentStatusEnum.WAIT_PAY.getValue());
        queryMap.put("appointStatus", appointStatusList);
        queryMap.put("now", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("hospitalCode", hospitalCode);
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().filter(appointmentRecordEntity -> appointmentRecordEntity.getAppointmentType() != AppointmentTypeEnums.DAY_APPOINTMENT.getValue().intValue() || !appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.WAIT_PAY.getValue())).collect(Collectors.toList());
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private List<String> getCardIdList(UcCardListReqVO reqVo) throws AppointmentException {
        ArrayList<String> cardIdList = new ArrayList<String>();
        log.error("getCardIdList start-------reqVo:{}", (Object)reqVo);
        BaseResponse resp = this.getCardInfoUtil.getUserCardList(reqVo);
        List UserPatientListRespVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), UserPatientListRespVO.class);
        for (UserPatientListRespVO userPatientListRespVO : UserPatientListRespVOList) {
            List userCardListRespVOList = userPatientListRespVO.getUserCardListRespVOS();
            if (userCardListRespVOList == null && userCardListRespVOList.size() <= 0) continue;
            for (UserCardListRespVO userCardListRespVO : userCardListRespVOList) {
                if (userCardListRespVO == null || userCardListRespVO.getCardId() == null || "".equals(userCardListRespVO.getCardId())) continue;
                cardIdList.add(userCardListRespVO.getCardId());
            }
        }
        return cardIdList;
    }

    public List<AppointmentRecordVo> getMyRegistrationList(RegisterationQueryParamsDTO registerationQueryParamsDTO) throws Exception {
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u5165\u53c2\uff1a" + JSON.toJSONString((Object)registerationQueryParamsDTO));
        String hospitalCode = registerationQueryParamsDTO.getHospitalCode();
        List appointmentRecordEntityList = this.appointmentRecordMapper.getMyRegistrationList(registerationQueryParamsDTO);
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)appointmentRecordEntityList));
        List appointmentRecordVoList = this.buildAppointmentRecordVo(appointmentRecordEntityList);
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        for (int i = 0; i < appointmentRecordVoList.size(); ++i) {
            AppointmentRecordVo appointmentRecordVo = (AppointmentRecordVo)appointmentRecordVoList.get(i);
            String admDate = appointmentRecordVo.getAdmDate();
            boolean flag = DateUtils.judgeDate((String)appointmentRecordVo.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            if (admDate.equals(String.valueOf(LocalDate.now()))) {
                appointmentRecordVo.setIsTheDay(0L);
            } else if (flag) {
                appointmentRecordVo.setIsTheDay(1L);
            } else if (!flag) {
                appointmentRecordVo.setIsTheDay(-1L);
            }
            if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
                int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
                appointmentRecordVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
                appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
                continue;
            }
            appointmentRecordVo.setExpiredtime(480L);
            appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + appointmentRecordVo.getExpiredtime() * 1000L);
        }
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u8fd4\u56de\u5bf9\u8c61 \uff1a" + JSON.toJSONString((Object)appointmentRecordVoList));
        return appointmentRecordVoList;
    }

    private List<AppointmentRecordVo> buildAppointmentRecordVo(List<AppointmentRecordEntity> appointmentRecordEntityList) throws AppointmentException {
        if (CollectionUtils.isEmpty(appointmentRecordEntityList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        log.info("\u672c\u4eba\u8bca\u7597\u6302\u53f7\u6570\u636e ------>{}", appointmentRecordEntityList);
        ArrayList<AppointmentRecordVo> appointmentRecordVoList = new ArrayList<AppointmentRecordVo>();
        for (int i = 0; i < appointmentRecordEntityList.size(); ++i) {
            AppointmentRecordEntity appointmentRecordEntity = appointmentRecordEntityList.get(i);
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getPayAmount())) continue;
            AppointmentRecordVo appointmentRecordVo = new AppointmentRecordVo();
            appointmentRecordVo.setAdmDate(appointmentRecordEntity.getAdmDate());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (WAIT_CONFIRMED.contains(appointStatus)) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            appointmentRecordVo.setAppointStatus(appointStatus);
            appointmentRecordVo.setDeptName(appointmentRecordEntity.getDeptName());
            appointmentRecordVo.setDocName(appointmentRecordEntity.getDocName());
            appointmentRecordVo.setPatientIdCard(appointmentRecordEntity.getCardId());
            appointmentRecordVo.setUserId(appointmentRecordEntity.getUserId());
            appointmentRecordVo.setPatientName(appointmentRecordEntity.getPatientName());
            appointmentRecordVo.setAdmRange(appointmentRecordEntity.getAdmRange());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            appointmentRecordVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            appointmentRecordVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            if (appointmentRecordEntity.getCreatetime() != null) {
                long createtime = appointmentRecordEntity.getCreatetime().getTime();
                appointmentRecordVo.setCreatetime(createtime);
            }
            long daysRemaining = 0L;
            try {
                daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            }
            catch (Exception e) {
                log.error("-------\u8ba1\u7b97\u8ddd\u79bb\u5c31\u8bca\u65e5\u5931\u8d25-------");
            }
            appointmentRecordVo.setDaysRemaining(daysRemaining);
            boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            appointmentRecordVo.setIsTheDay(flag ? 1L : -1L);
            CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
            cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
            cardDetailsInfoReqVO.setChannelCode("app");
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
            if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
                appointmentRecordVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            }
            appointmentRecordVoList.add(appointmentRecordVo);
        }
        return appointmentRecordVoList;
    }

    public AppointmentRecordDetailVo getMyRegistrationDetail(String sysAppointmentId) throws AppointmentException {
        log.info("AppointmentServiceImpl.getMyRegistrationDetail->\u8bf7\u6c42\u53c2\u6570sysAppointmentId:{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            log.error("AppointmentServiceImpl.getMyRegistrationDetail->\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570sysAppointmentId\u4e3a:{}", (Object)sysAppointmentId);
            throw new AppointmentException();
        }
        String hospitalCode = appointmentRecordEntity.getHospitalCode();
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        AppointmentRecordDetailVo appointmentRecordDetailVo = new AppointmentRecordDetailVo();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
            appointmentRecordDetailVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            int age = 0;
            try {
                age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
            }
            catch (ParseException e) {
                throw new AppointmentException("\u5e74\u9f84\u8f6c\u5316\u5f02\u5e38\uff01");
            }
            appointmentRecordDetailVo.setPatientAge(Integer.valueOf(age));
            appointmentRecordDetailVo.setPatientSex(Integer.valueOf(cardDetailsInfoRespVO.getGender().intValue()));
            appointmentRecordDetailVo.setPatientId(appointmentRecordEntity.getPatientId());
        }
        this.buildAppointmentRecordDetailVo(appointmentRecordDetailVo, appointmentRecordEntity, hospitalCode);
        return appointmentRecordDetailVo;
    }

    private void buildAppointmentRecordDetailVo(AppointmentRecordDetailVo appointmentRecordDetailVo, AppointmentRecordEntity appointmentRecordEntity, String hospitalCode) {
        appointmentRecordDetailVo.setRemark(appointmentRecordEntity.getRemark());
        appointmentRecordDetailVo.setId(appointmentRecordEntity.getId());
        appointmentRecordDetailVo.setPatientName(appointmentRecordEntity.getPatientName());
        appointmentRecordDetailVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        Date admDate = DateUtils.stringToSimpleDate((String)appointmentRecordEntity.getAdmDate());
        appointmentRecordDetailVo.setAdmDate(DateUtils.dateToYMDString((Date)admDate));
        appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        appointmentRecordDetailVo.setWeekday(DateUtils.getWeekZhou((String)appointmentRecordEntity.getAdmDate()));
        appointmentRecordDetailVo.setPatientId(appointmentRecordEntity.getPatientId());
        appointmentRecordDetailVo.setDocName(appointmentRecordEntity.getDocName());
        appointmentRecordDetailVo.setDeptName(appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getHospitalName() + " " + appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setPatientCardNo(appointmentRecordEntity.getPatientCardNo());
        appointmentRecordDetailVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
            int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
            appointmentRecordDetailVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordDetailVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
        } else {
            appointmentRecordDetailVo.setExpiredtime(480L);
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 480000L);
        }
        appointmentRecordDetailVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        appointmentRecordDetailVo.setAdmRange(appointmentRecordEntity.getAdmRange());
        appointmentRecordDetailVo.setRegTitleName(appointmentRecordEntity.getRegTitleName());
        appointmentRecordDetailVo.setTakeTime(appointmentRecordEntity.getTakeTime());
        appointmentRecordDetailVo.setTakeAddress(appointmentRecordEntity.getTakeAddress());
        appointmentRecordDetailVo.setScheduleLevelName(appointmentRecordEntity.getScheduleLevelName());
        appointmentRecordDetailVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentRecordDetailVo.setAppointmentNo(appointmentRecordEntity.getAppointmentNo());
        appointmentRecordDetailVo.setPayAccdate(appointmentRecordEntity.getPayAccdate());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (WAIT_CONFIRMED.contains(appointStatus)) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        }
        String ade = appointmentRecordEntity.getAdmDate();
        boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
        if (ade.equals(String.valueOf(LocalDate.now()))) {
            appointmentRecordDetailVo.setIsTheDay(0L);
        } else if (flag) {
            appointmentRecordDetailVo.setIsTheDay(1L);
        } else if (!flag) {
            appointmentRecordDetailVo.setIsTheDay(-1L);
        }
        try {
            long daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            appointmentRecordDetailVo.setDaysRemaining(daysRemaining);
        }
        catch (Exception e) {
            log.error("======\u8ba1\u7b97\u8ddd\u8bca\u65ad\u65e5\u8fd8\u5269\u4e0b\u5929\u6570\u5931\u8d25=====");
        }
        appointmentRecordDetailVo.setAppointStatus(appointStatus.intValue());
        appointmentRecordDetailVo.setRefundMoney(appointmentRecordEntity.getReturnAmount());
        appointmentRecordDetailVo.setRefundTime(appointmentRecordEntity.getReturnAccdate());
        appointmentRecordDetailVo.setCancelType(Integer.valueOf(appointmentRecordEntity.getCancleType()));
    }

    public void cancelAppointment(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        List<Integer> cancelAble = Arrays.asList(2, 20);
        if (null == appointmentRecordEntity || !cancelAble.contains(appointmentRecordEntity.getAppointStatus())) {
            throw new AppointmentException("\u6b64\u8ba2\u5355\u4e0d\u53ef\u53d6\u6d88\uff01");
        }
        if (AppointmentStatusEnum.APPOINT_SUCCESS.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
            GatewayRequest gatewayRequest = this.buildCancelRegisterGatewayReq(cancelAppointmentVoReq, appointmentRecordEntity);
            BusinessResultEntity businessResultEntity = new BusinessResultEntity();
            businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
            businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
            businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
            this.businessResultMapper.insertSelective(businessResultEntity);
            GatewayResponse gatewayResponse = this.invokeHisCancelRegister(gatewayRequest, "");
            businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
            businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
            businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
            businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
            businessResultEntity.setStatus(new Byte("0"));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u60a8\u5df2\u53d6\u6d88\u672c\u6b21\u9884\u7ea6\u6302\u53f7");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    public BaseResponse<String> withdrawNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        boolean overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
        if (!overdueRefundDate) {
            throw new AppointmentException("\u5c31\u8bca\u5f53\u65e5\u4e0d\u80fd\u9000\u53f7\uff0c\u5982\u9700\u9000\u53f7\u8bf7\u81f3\u533b\u9662\u7a97\u53e3\u54a8\u8be2\u529e\u7406\u3002");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        GatewayRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.CANCEL_APPOINTMENT.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7 withdrawNumber";
        GatewayResponse gatewayResponse = this.invokeHisReturnRegister(gatewayRequest, message);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(appointmentRecordEntity.getPayTransationId());
        businessResultEntity.setStatus(new Byte("0"));
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.CURRENT_SYSTEM_REFUND.getValue().intValue()));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity payorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (payorderEntity == null || payorderEntity.getDealSeq() == null || "".equals(payorderEntity.getDealSeq())) {
            throw new AppointmentException("DealSeq\u4e3a\u7a7a\uff01");
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(withdrawNumberVoReq.getPayChannel());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(payorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        log.info("refund method--------> begain");
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        log.info("refund\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundTime(new Date());
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        businessResultEntity.setPlatformResponse(JSON.toJSONString((Object)baseResponse));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        return baseResponse;
    }

    public BaseResponse<String> appointReturnNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        boolean overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
        if (!overdueRefundDate) {
            throw new AppointmentException("\u5c31\u8bca\u5f53\u65e5\u4e0d\u80fd\u9000\u53f7\uff0c\u5982\u9700\u9000\u53f7\u8bf7\u81f3\u533b\u9662\u7a97\u53e3\u54a8\u8be2\u529e\u7406\u3002");
        }
        GatewayRequest gatewayRequest = this.returnRegGatewayReq(withdrawNumberVoReq, appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.invokeHisReturnRegister(gatewayRequest, "");
        if (gatewayResponse.isSuccess()) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setCancleTime(new Date());
            appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
            appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
            appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
            appointmentRecordEntity.setCancleChannelCode(withdrawNumberVoReq.getPayChannel());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
            businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
            businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
            businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
            businessResultEntity.setStatus(new Byte("0"));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        } else {
            log.info("his\u9000\u53f7\u5931\u8d25\uff1a" + gatewayResponse.getMsg());
            appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
            appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
            appointmentRecordEntity.setRemark("HIS\u9000\u53f7\u5931\u8d25:" + gatewayResponse.getMsg());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
        return BaseResponse.success();
    }

    public GatewayRequest<ReturnRegisterReq> returnRegGatewayReq(WithdrawNumberVoReq withdrawNumberVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAdmId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(withdrawNumberVoReq.getPayChannel());
        gatewayRequest.setChannel(withdrawNumberVoReq.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("returnAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        BaseResponse baseResponse;
        GatewayRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2================ -^.^-\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.REGISTERHT_PAY.getValue(), gatewayRequest, PayRegistrationRes.class);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2================ -^.^-\uff1a" + JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
            requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
            Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
            String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
            requestRefundOrderVoReq.setSign(sign);
        }
        log.info("\u9884\u7ea6\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        if (gatewayResponse == null) {
            baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg());
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg() + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        PayRegistrationRes payRegistrationRes = (PayRegistrationRes)gatewayResponse.getData();
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        updatePayAppointment.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        updatePayAppointment.setPayPostId(responseNotifyRestVo.getMchId());
        updatePayAppointment.setPayTransationId(responseNotifyRestVo.getTradeNo());
        updatePayAppointment.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        if (null != payRegistrationRes) {
            updatePayAppointment.setAdmId(payRegistrationRes.getAdmId());
            updatePayAppointment.setAdmAdress(payRegistrationRes.getAdmitAddress());
        }
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        updatePayAppointment.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelRegister(GatewayRequest<CancelRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.CANCEL_REGISTERHT.getValue(), gatewayRequest, CancelRegisterRes.class);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error(message + " -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayResponse<ReturnRegisterRes> invokeHisReturnRegister(GatewayRequest<ReturnRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.RETURN_REGISTER.getValue(), gatewayRequest, ReturnRegisterRes.class);
        if (gatewayResponse.getCode() == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u9000\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayRequest<CancelRegisterReq> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
        cancelRegisterReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        cancelRegisterReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        cancelRegisterReq.setLockQueueNo(appointmentRecordEntity.getAppointmentNo());
        gatewayRequest.setBody((Object)cancelRegisterReq);
        gatewayRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setChannel(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<PayRegistrationReq> cancelRegGatewayReq(WithdrawNumberVoReq withdrawNumberVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq registrationReq = new PayRegistrationReq();
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        registrationReq.setAppointId(appointmentRecordEntity.getReceptId());
        registrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationMsg.setOrderid(appointmentRecordEntity.getPayTransationId());
        registrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)registrationReq);
        gatewayRequest.setChannelName(withdrawNumberVoReq.getPayChannel());
        gatewayRequest.setChannel(withdrawNumberVoReq.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<ReturnRegisterReq> buildWithdrawNumberGatewayReq(AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public String appointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        log.info("\u9884\u7ea6\u6302\u53f7\u5165\u53c2 - > {}", (Object)JSON.toJSONString((Object)createOrderVoReq, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        this.registrationRules(createOrderVoReq.getIdNo(), createOrderVoReq.getDeptCode());
        FrontRequest frontRequest = this.buildConfirmRegisterReq(createOrderVoReq);
        log.info("\u8bf7\u6c42his\u9884\u7ea6\u6302\u53f7\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse confirmRegisterResFrontResponse = this.appointmentClient.confirmRegister(frontRequest);
        log.info("\u8bf7\u6c42his\u9884\u7ea6\u6302\u53f7\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)confirmRegisterResFrontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!"1".equals(confirmRegisterResFrontResponse.getCode())) {
            log.error("\u9884\u7ea6\u6302\u53f7\u5931\u8d25");
            throw new AppointmentException("\u9884\u7ea6\u6302\u53f7\u5931\u8d25" + confirmRegisterResFrontResponse.getMessage());
        }
        long sysAppointmnetId = this.snowflakeIdWorker.nextId();
        this.jedisCluster.set(this.hisOrderNumber + sysAppointmnetId, ((ConfirmRegisterReq)frontRequest.getBody()).getAdmNo());
        AppointmentRecordEntity appointmentRecordEntity = this.buildnewSuccessAppointmentRecordEntity(sysAppointmnetId, confirmRegisterResFrontResponse, createOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\uff1aappointmentRecordEntity:{}", (Object)appointmentRecordEntity);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\u6210\u529f");
        this.jedisCluster.set(appointmentRecordEntity.getSysAppointmentId() + "_authCode", createOrderVoReq.getAuthCode(), "NX", "EX", 43200L);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private FrontRequest<ConfirmRegisterReq> buildConfirmRegisterReq(AppointmentCreateOrderVoReq createOrderVoReq) {
        FrontRequest frontRequest = new FrontRequest();
        ConfirmRegisterReq confirmRegisterReq = new ConfirmRegisterReq();
        confirmRegisterReq.setCardNo(createOrderVoReq.getPatientCardNo());
        confirmRegisterReq.setDeptNo(createOrderVoReq.getDeptCode());
        confirmRegisterReq.setDoctorNo(createOrderVoReq.getDocCode());
        confirmRegisterReq.setTimeFlag(createOrderVoReq.getAdmTimeRange());
        confirmRegisterReq.setClinicDate(createOrderVoReq.getAdmDate());
        confirmRegisterReq.setRbasId(createOrderVoReq.getHl());
        confirmRegisterReq.setAdmNo(createOrderVoReq.getScheduleHisId());
        confirmRegisterReq.setFlowNo(createOrderVoReq.getLocName());
        confirmRegisterReq.setMedicalFee(createOrderVoReq.getStarTime());
        confirmRegisterReq.setPayChannel("\u652f\u4ed8\u5b9d\u5e73\u53f0");
        confirmRegisterReq.setRegFee(createOrderVoReq.getEndTime());
        frontRequest.setBody((Object)confirmRegisterReq);
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private void checkAppointmentInfo(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650(2\u6b21\u5305\u542b\u53d6\u6d88)");
        }
    }

    private GetScheduleResItems isHasAppointmentInfo(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildScheduleGetwayRequest(appointmentCreateOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO.getItems() == null || getScheduleResVO.getItems().isEmpty()) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        scheduleResItemsList.removeIf(o -> !o.getScheduleId().equals(appointmentCreateOrderVoReq.getScheduleHisId()));
        getScheduleResVO.setItems(scheduleResItemsList);
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)scheduleResItemsList.get(0);
        if (!Objects.isNull(appointmentCreateOrderVoReq.getScheduleHisId())) {
            List collect = scheduleResItemsList.stream().filter(i -> appointmentCreateOrderVoReq.getScheduleHisId().equals(i.getScheduleId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
                throw new AppointmentException("\u5f53\u524d\u6392\u73ed\u5df2\u88ab\u5360\u7528\uff0c\u5237\u65b0\u540e\u91cd\u8bd5");
            }
            getScheduleResItems = (GetScheduleResItems)collect.get(0);
        }
        return getScheduleResItems;
    }

    private GatewayRequest<GetScheduleReqVO> buildScheduleGetwayRequest(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(appointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(appointmentCreateOrderVoReq.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("appointmentCreateOrder");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private GatewayRequest<LockOrderReq> buildConfirmRegisterReq(long sysAppointmentId, AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        LockOrderReq lockOrderReq = new LockOrderReq();
        lockOrderReq.setBeginTime(appointmentCreateOrderVoReq.getStarTime());
        lockOrderReq.setEndTime(appointmentCreateOrderVoReq.getEndTime());
        lockOrderReq.setScheduleCode(appointmentCreateOrderVoReq.getScheduleHisId());
        lockOrderReq.setPatientId(appointmentCreateOrderVoReq.getPatientId());
        lockOrderReq.setOrderId(String.valueOf(sysAppointmentId));
        lockOrderReq.setTradeTime(DateUtils.getCurrentTime());
        lockOrderReq.setTradeDate(DateUtils.getCurrentDateSimpleToString());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(appointmentCreateOrderVoReq.getCardId());
        if (null != cardDetail) {
            lockOrderReq.setPatientId(cardDetail.getOrganPmi());
            lockOrderReq.setCardNo(cardDetail.getCardId());
        }
        gatewayRequest.setBody((Object)lockOrderReq);
        gatewayRequest.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("appointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<LockOrderReq> buildDayConfirmRegisterReq(long sysAppointmentId, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        LockOrderReq lockOrderReq = new LockOrderReq();
        lockOrderReq.setBeginTime(createOrderVoReq.getStarTime());
        lockOrderReq.setEndTime(createOrderVoReq.getEndTime());
        lockOrderReq.setScheduleCode(createOrderVoReq.getScheduleHisId());
        lockOrderReq.setPatientId(createOrderVoReq.getPatientCardNo());
        lockOrderReq.setOrderId(String.valueOf(sysAppointmentId));
        lockOrderReq.setTradeTime(DateUtils.getCurrentTime());
        lockOrderReq.setTradeDate(DateUtils.getCurrentDateSimpleToString());
        gatewayRequest.setBody((Object)lockOrderReq);
        gatewayRequest.setChannelName(createOrderVoReq.getChannelName());
        gatewayRequest.setChannel(createOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayConfirmRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private AppointmentRecordEntity buildSuccessAppointmentRecordEntity(long sysAppointmentId, ConfirmRegisterRes confirmRegisterRes, AppointmentCreateOrderVoReq createOrderVoReq, GetScheduleResItems getScheduleResItems, String patientId) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(confirmRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmAddress(confirmRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeAddress(confirmRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeTime(confirmRegisterRes.getTakeTime());
        appointmentRecordEntity.setAdmTimeRange(TimeArrangeIdTypeEnum.getDisplay((String)createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentNo(confirmRegisterRes.getNo());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientId(patientId);
        appointmentRecordEntity.setAdmTimeRange(confirmRegisterRes.getAdmitTimeRange());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientCardNo(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setCardId(cardDetail.getCardId());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)cardDetail.getCredNo()) == "M" ? 1 : 2);
        }
        appointmentRecordEntity.setPatientIdCard(createOrderVoReq.getCardId());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItems.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItems.getScheduleId());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6302\u53f7\u6210\u529f\uff0c\u5f85\u652f\u4ed8");
        return appointmentRecordEntity;
    }

    private AppointmentRecordEntity buildnewSuccessAppointmentRecordEntity(long sysAppointmentId, FrontResponse<ConfirmRegisterRes> confirmRegisterResFrontResponse, AppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(((ConfirmRegisterRes)confirmRegisterResFrontResponse.getBody()).getNo());
        appointmentRecordEntity.setAppointmentNo(((ConfirmRegisterRes)confirmRegisterResFrontResponse.getBody()).getNo());
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getTimeArrange());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getStarTime());
        if (createOrderVoReq.getAdmTimeRange().equals("\u4e0a\u5348")) {
            createOrderVoReq.setAdmTimeRange("1");
        } else if (createOrderVoReq.getAdmTimeRange().equals("\u4e0b\u5348")) {
            createOrderVoReq.setAdmTimeRange("2");
        } else {
            createOrderVoReq.setAdmTimeRange("3");
        }
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(StringUtils.isBlank((String)createOrderVoReq.getHospitalName()) ? "\u91d1\u5ddd\u96c6\u56e2\u6709\u9650\u516c\u53f8\u804c\u5de5\u533b\u9662\uff08\u91d1\u660c\u5e02\u4e2d\u5fc3\u533b\u9662\uff09" : createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientCardNo(cardDetail.getOrganPmi());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setCardId(cardDetail.getCardId());
            appointmentRecordEntity.setPatientId(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)cardDetail.getCredNo()) == "M" ? 1 : 2);
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
        }
        BigDecimal totalFee = new BigDecimal(createOrderVoReq.getRegFee()).add(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(createOrderVoReq.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setScheduleHisId(((ConfirmRegisterRes)confirmRegisterResFrontResponse.getBody()).getNo());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(createOrderVoReq.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(createOrderVoReq.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6302\u53f7\u6210\u529f");
        appointmentRecordEntity.setCreatetime((Date)DateUtil.date());
        appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
        appointmentRecordEntity.setScheduleLevelName("1");
        try {
            appointmentRecordEntity.setTakeTime(appointmentRecordEntity.getAdmTimeRange().substring(6, appointmentRecordEntity.getAdmTimeRange().length() - 3));
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u622a\u53d6\u51fa\u73b0\u9519\u4f4d{}", (Throwable)e);
        }
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity getAppointmentRecordBySysAppointmentId(String sysAppointmentId) {
        return this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
    }

    public void autoCancelDelayAppointment(UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo) {
        this.appointmentRecordMapper.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private void updateDoDayRegisterRes(DoDayAppointmentDTO doDayAppointmentDTO) {
        this.appointmentRecordMapper.updateDoDayAppointmentRecord(doDayAppointmentDTO);
    }

    public BaseResponse<String> dayAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)dayAppointmentPayVoReq));
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
        payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
        payRequestVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        payRequestVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        payRequestVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        payRequestVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        payRequestVoReq.setServiceCode(ServiceCodeEnum.DAY_APPOINTMENT.getValue());
        payRequestVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payRequestVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payRequestVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
        payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        payRequestVoReq.setPayNotifyUrl(this.propertiesConstant.getDayPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        payRequestVoReq.setSign(sign);
        BaseResponse baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
        return baseResponse;
    }

    public static void main(String[] args) {
        FrontResponse nucleicAcidAppointmentResFrontResponse = (FrontResponse)JSON.parseObject((String)"{\"body\":{\"attention\":\"\u6838\u9178\u9884\u7ea6\u524d\u4e24\u5c0f\u65f6\u7981\u6b62\u8fdb\u98df\",\"fee\":\"4\",\"orderId\":\"22112490193\"},\"code\":\"1\",\"errCode\":null,\"message\":null,\"transactionId\":\"com.ebaiyihui.his.utils.SnowflakeIdWorker@21a913a8\"}", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        log.info(JSON.toJSONString((Object)nucleicAcidAppointmentResFrontResponse));
    }

    public List<GetAdmissionItems> nucleicAcidAppointmentRes(DayAppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        nucleicAcidAppointmentReq nucleicAcidAppointmentReq2 = this.buildNucleicAcidAppointmentReq(createOrderVoReq);
        log.info("\u8bf7\u6c42his\u6838\u9178\u9884\u7ea6\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)nucleicAcidAppointmentReq2, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse nucleicAcidAppointmentRes2 = this.appointmentClient.nucleicAcidAppointmentRes(nucleicAcidAppointmentReq2);
        log.info("\u8bf7\u6c42his\u6838\u9178\u9884\u7ea6\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)nucleicAcidAppointmentRes2, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (null == nucleicAcidAppointmentRes2) {
            throw new AppointmentException("\u6838\u9178\u9884\u7ea6\u5931\u8d25");
        }
        if (nucleicAcidAppointmentRes2.getCode().equals("0")) {
            log.info(nucleicAcidAppointmentRes2.getMessage());
            throw new AppointmentException("\u6838\u9178\u9884\u7ea6\u5931\u8d25" + nucleicAcidAppointmentRes2.getMessage());
        }
        if (null == nucleicAcidAppointmentRes2.getBody()) {
            throw new AppointmentException("\u6838\u9178\u9884\u7ea6\u5931\u8d25" + nucleicAcidAppointmentRes2.getMessage());
        }
        if (null == ((nucleicAcidAppointmentRes)nucleicAcidAppointmentRes2.getBody()).getOrderId()) {
            throw new AppointmentException("\u6838\u9178\u9884\u7ea6\u5931\u8d25" + nucleicAcidAppointmentRes2.getMessage());
        }
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setSysAppointmentId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setAppointmentId(((nucleicAcidAppointmentRes)nucleicAcidAppointmentRes2.getBody()).getOrderId());
        appointmentRecordEntity.setSysScheduleId(nucleicAcidAppointmentReq2.getSchedId());
        appointmentRecordEntity.setAdmAddress(((nucleicAcidAppointmentRes)nucleicAcidAppointmentRes2.getBody()).getAttention());
        appointmentRecordEntity.setRegFee(new BigDecimal(((nucleicAcidAppointmentRes)nucleicAcidAppointmentRes2.getBody()).getFee()));
        appointmentRecordEntity.setPayAmount("0");
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setScheduleHisId(nucleicAcidAppointmentReq2.getSchedId());
        appointmentRecordEntity.setSysScheduleId(nucleicAcidAppointmentReq2.getTradeId());
        appointmentRecordEntity.setSysTimeArrangeId(nucleicAcidAppointmentReq2.getTradeId());
        appointmentRecordEntity.setAppointmentTime((Date)DateUtil.date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setCancleType(0);
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setServiceFee(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setRegFee(new BigDecimal(createOrderVoReq.getRegFee()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientSex(IdcardUtil.getGenderByIdCard((String)createOrderVoReq.getIdNo()) == 0 ? 2 : 1);
        appointmentRecordEntity.setPatientAge(IdcardUtil.getAgeByIdCard((String)createOrderVoReq.getIdNo()));
        appointmentRecordEntity.setPatientId(nucleicAcidAppointmentReq2.getPatientId());
        appointmentRecordEntity.setPatientIdCard(createOrderVoReq.getIdNo());
        appointmentRecordEntity.setPatientPhone(createOrderVoReq.getPhoneNo());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setAdmDate(DateUtil.today());
        appointmentRecordEntity.setAdmRange(4);
        appointmentRecordEntity.setDeptName(createOrderVoReq.getDeptName());
        appointmentRecordEntity.setRemark("\u6838\u9178\u9884\u7ea6\u6210\u529f");
        appointmentRecordEntity.setCreatetime((Date)DateUtil.date());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getCardId());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getCardId());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getCardId());
        appointmentRecordEntity.setAdmTimeRange("00:00-23:59");
        appointmentRecordEntity.setDocName("\u6838\u9178\u68c0\u6d4b");
        appointmentRecordEntity.setReceptId(((nucleicAcidAppointmentRes)nucleicAcidAppointmentRes2.getBody()).getClinicNo());
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        GetAdmissionReqVO getAdmissionReqVO = this.BuildGetAdmissionReqVO(createOrderVoReq);
        List admission = this.outpatientPaymentService.getAdmission(getAdmissionReqVO);
        if (admission.size() == 0) {
            throw new AppointmentException("\u6838\u9178\u9884\u7ea6\u6210\u529f,\u7f34\u8d39\u5217\u8868\u67e5\u8be2\u5931\u8d25,\u8bf7\u624b\u52a8\u524d\u5f80\u7f34\u8d39\u5217\u8868\u8fdb\u884c\u7f34\u8d39");
        }
        List<GetAdmissionItems> collect = admission.stream().filter(item -> item.getReceptId().equals(appointmentRecordEntity.getReceptId())).collect(Collectors.toList());
        if (collect.size() == 0) {
            throw new AppointmentException("\u6838\u9178\u9884\u7ea6\u6210\u529f,\u7f34\u8d39\u5217\u8868\u67e5\u8be2\u5931\u8d25,\u8bf7\u624b\u52a8\u524d\u5f80\u7f34\u8d39\u5217\u8868\u8fdb\u884c\u7f34\u8d39");
        }
        return collect;
    }

    private GetAdmissionReqVO BuildGetAdmissionReqVO(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GetAdmissionReqVO getAdmissionReqVO = new GetAdmissionReqVO();
        getAdmissionReqVO.setCardId(createOrderVoReq.getCardId());
        getAdmissionReqVO.setCardNo(createOrderVoReq.getPatientCardNo());
        getAdmissionReqVO.setOrganCode("130211");
        getAdmissionReqVO.setChannelCode("PATIENT_ALIPAY");
        getAdmissionReqVO.setBgDate(DateUtil.today());
        getAdmissionReqVO.setEdDate(DateUtil.today());
        return getAdmissionReqVO;
    }

    private nucleicAcidAppointmentReq buildNucleicAcidAppointmentReq(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        nucleicAcidAppointmentReq nucleicAcidAppointmentReq2 = new nucleicAcidAppointmentReq();
        nucleicAcidAppointmentReq2.setPatientId(createOrderVoReq.getPatientId());
        nucleicAcidAppointmentReq2.setTradeId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        nucleicAcidAppointmentReq2.setTelphone(createOrderVoReq.getPhoneNo());
        nucleicAcidAppointmentReq2.setCardNO(createOrderVoReq.getPatientCardNo());
        nucleicAcidAppointmentReq2.setSchedId(createOrderVoReq.getScheduleHisId());
        return nucleicAcidAppointmentReq2;
    }

    private GatewayRequest<PayRegistrationReq> buildNucleicRegisterParams(AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setAppointDate(appointmentRecordEntity.getAdmDate());
        payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayChannel());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setAccdate(appointmentRecordEntity.getAdmDate());
        payRegistrationMsg.setOrderid(appointmentRecordEntity.getSysAppointmentId());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("nucleicRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public AppointmentPayVoReq byPayData(DayAppointmentPayVoReq dayAppointmentPayVoReq, AppointmentRecordEntity appointmentRecordEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setMchCode(this.propertiesConstant.getMchCode());
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        appointmentPayVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        appointmentPayVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        appointmentPayVoReq.setServiceCode(ServiceCodeEnum.DAY_APPOINTMENT.getValue());
        appointmentPayVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        appointmentPayVoReq.setNonceStr(SignUtil.getNonceStr());
        appointmentPayVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        appointmentPayVoReq.setPayNotifyUrl(this.propertiesConstant.getDayPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)appointmentPayVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        appointmentPayVoReq.setSign(sign);
        return appointmentPayVoReq;
    }

    public BaseResponse<String> appointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
        payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
        payRequestVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        payRequestVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        payRequestVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        payRequestVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        payRequestVoReq.setServiceCode(ServiceCodeEnum.APPOINTMENT.getValue());
        payRequestVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payRequestVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payRequestVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
        payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        payRequestVoReq.setPayNotifyUrl(this.propertiesConstant.getPayNotifyUrl());
        log.info("\u9884\u7ea6\u652f\u4ed8\u672a\u52a0\u5bc6:{}", (Object)JSON.toJSONString((Object)payRequestVoReq));
        Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
        log.info("\u9884\u7ea6\u652f\u4ed8\u52a0\u5bc6\u540e:{}", (Object)JSON.toJSONString((Object)map));
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        payRequestVoReq.setSign(sign);
        BaseResponse baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
        return baseResponse;
    }

    private BaseResponse<String> payCreateOrder(AppointmentPayVoReq appointmentPayVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)appointmentPayVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            this.taskExecutor.execute(() -> {
                String data = (String)baseResponse.getData();
                String prepayId = data.substring(data.indexOf("prepay_id=") + 10, data.indexOf("\",\"paySign"));
                log.info("prepayId: " + prepayId);
                String sysAppointmentId = appointmentPayVoReq.getOutTradeNo();
                this.jedisCluster.set(sysAppointmentId, prepayId);
                this.jedisCluster.expire(sysAppointmentId, 518400);
            });
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private GatewayRequest<PayRegistrationReq> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setPayChannel("HLWYYWXZF");
        payRegistrationReq.setFlowNo(responseNotifyRestVo.getTradeNo());
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(responseNotifyRestVo.getOutTradeNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationMsg.setAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("PayRegistrationReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private void updateScheduleByDayAppointmentCreateOrderVoReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        this.scheduleRecordMapper.updateScheduleByDayAppointmentCreateOrderVoReq(dayAppointmentCreateOrderVoReq);
    }

    private GatewayRequest<GetScheduleReqVO> buildConfirmScheduleGetwayRequest(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setEdDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setLocCode(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setDocCode(confirmAppointmentVo.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("confirmAppointmentVo");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private List<GetScheduleResItems> getHisDaySchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDocCode().equals(confirmAppointmentVo.getDocCode())).collect(Collectors.toList());
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private List<GetScheduleResItems> getHisSchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_SCHEDULE.getValue(), gatewayRequest, GetScheduleResVO.class);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private ConfirmAppointmentVo buildConfirmAppointmentVo(GetScheduleResItems getScheduleResItems, ConfirmAppointmentVo confirmAppointVo) {
        ConfirmAppointmentVo confirmAppointmentVo = new ConfirmAppointmentVo();
        confirmAppointmentVo.setDoctorHeadPortrait(confirmAppointVo.getDoctorHeadPortrait());
        confirmAppointmentVo.setAdmDate(confirmAppointVo.getAdmDate());
        confirmAppointmentVo.setAdmTimeRange(confirmAppointVo.getAdmTimeRange());
        confirmAppointmentVo.setDocCode(confirmAppointVo.getDocCode());
        confirmAppointmentVo.setDocName(confirmAppointVo.getDocName());
        confirmAppointmentVo.setHospitalName(confirmAppointVo.getHospitalName());
        confirmAppointmentVo.setIsAppend(confirmAppointVo.getIsAppend());
        confirmAppointmentVo.setIsTimeArrange(confirmAppointVo.getIsTimeArrange());
        confirmAppointmentVo.setLocCode(confirmAppointVo.getLocCode());
        confirmAppointmentVo.setLocName(confirmAppointVo.getLocName());
        confirmAppointmentVo.setRegFee(getScheduleResItems.getRegFee());
        confirmAppointmentVo.setDiagFee(getScheduleResItems.getDiagFee());
        confirmAppointmentVo.setTotalFee(confirmAppointVo.getTotalFee());
        confirmAppointmentVo.setRegTitleCode(confirmAppointVo.getRegTitleCode());
        confirmAppointmentVo.setRegTitleName(confirmAppointVo.getRegTitleName());
        confirmAppointmentVo.setScheduleHisId(confirmAppointVo.getScheduleHisId());
        confirmAppointmentVo.setScheduleLevelName(confirmAppointVo.getScheduleLevelName());
        List timeArrangeItemsList = getScheduleResItems.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            confirmAppointmentVo.setTimeArrangeItems(new ArrayList());
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public BaseResponse<String> appointmentRefund(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (null == appointmentPayorderEntity || null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        if (!WAIT_CONFIRMED.contains((int)appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        int appointmentType = appointmentRecordEntity.getAppointmentType();
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(appointmentPayorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        if ("1".equals(baseResponse.getCode())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            appointmentRecordEntity.setRemark(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        } else {
            BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    public void unLock(CancelRegisterReq cancelAppointmentVoReq) {
        log.info("\u6267\u884c\u53d6\u6d88\u9501\u53f7------>{}", (Object)cancelAppointmentVoReq);
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)cancelAppointmentVoReq);
        gatewayRequest.setKeyWord("unLockRegister");
        gatewayRequest.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8bf7\u6c42\u53c2\u6570 gatewayRequest: " + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.CANCEL_REGISTERHT.getValue(), gatewayRequest, CancelRegisterRes.class);
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8fd4\u56de\u53c2\u6570 gatewayResponse:" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
        }
    }

    public GetAppointRecords appointmentRecord(GetAppointRecordReq getAppointRecordReq) {
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)getAppointRecordReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        FrontResponse appointRecord = this.appointmentClient.getAppointRecord(gatewayRequest);
        return (GetAppointRecords)appointRecord.getBody();
    }

    public BaseResponse<String> cancelAppointment(String sysAppointmentId, String authCode) throws Exception {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u6ca1\u6709\u5f53\u524d\u6302\u53f7\u8ba2\u5355\u53d6\u6d88\u5931\u8d25");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            return BaseResponse.error((String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88 \u8bf7\u8054\u7cfb\u7a97\u53e3\u8fdb\u884c\u53d6\u6d88");
        }
        CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
        cancelRegisterReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        String s = this.jedisCluster.get(this.hisOrderNumber + sysAppointmentId);
        if (StrUtil.isBlank((CharSequence)s)) {
            return BaseResponse.error((String)"\u83b7\u53d6\u53f7\u6e90\u5931\u8d25\u65e0\u6cd5\u53d6\u6d88");
        }
        cancelRegisterReq.setLockQueueNo(s);
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)cancelRegisterReq);
        FrontResponse cancelRegisterResFrontResponse = this.appointmentClient.cancelRegister(frontRequest);
        if (BeanUtil.isEmpty((Object)cancelRegisterResFrontResponse, (String[])new String[0])) {
            return BaseResponse.error((String)"\u8bf7\u6c42his\u9000\u53f7\u5931\u8d25");
        }
        if ("0".equals(cancelRegisterResFrontResponse.getCode())) {
            return BaseResponse.error((String)("\u8bf7\u6c42his\u9000\u53f7\u5931\u8d25" + cancelRegisterResFrontResponse.getMessage()));
        }
        this.jedisCluster.del(this.hisOrderNumber + sysAppointmentId);
        RegistrationPushReqVo registrationPushReqVo = new RegistrationPushReqVo();
        AlibabaMedicalPushReqVO alibabaMedicalPushReqVO = new AlibabaMedicalPushReqVO();
        alibabaMedicalPushReqVO.setData((Object)registrationPushReqVo);
        alibabaMedicalPushReqVO.setType("1");
        alibabaMedicalPushReqVO.setClientCode("ALI_JCSZXYY");
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setScheduleLevelName("8");
        appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
        int i = this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        this.jedisCluster.set(appointmentRecordEntity.getSysAppointmentId() + "_authCode", authCode, "NX", "EX", 43200L);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
        return BaseResponse.success();
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private void checkRegistBase(String idNo, String deptCode) throws AppointmentException {
        Period period = Period.between(LocalDate.parse(IdCardUtil.getBirthByIdCard((String)idNo), DateTimeFormatter.ofPattern("yyyyMMdd")), LocalDate.now());
        if ("10248".equals(deptCode)) {
            if (period.getYears() == 0 && period.getMonths() <= 7) {
                return;
            }
            throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u65b0\u751f\u513f\u95e8\u8bca\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e7\u4e2a\u6708)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
        }
        List<String> pediatricList = Arrays.asList("1015");
        if (pediatricList.contains(deptCode)) {
            if (period.getYears() > 14) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u513f\u79d1\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e14\u5c81)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
            }
            return;
        }
        List<String> gynaecologyList = Arrays.asList("1044");
        if (gynaecologyList.contains(deptCode)) {
            String gender = IdCardUtil.getGenderByIdCard((String)idNo);
            if ("M".equals(gender)) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u5987\u4ea7\u79d1\u6302\u53f7\u6761\u4ef6(\u4ec5\u9650\u5973\u6027)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6539\u6210\u9009\u62e9\u5176\u4ed6\u5c31\u8bca\u4eba\uff01");
            }
            return;
        }
    }
}

