/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctoruser.api.pojo.base.dto.OrganIdReq;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.vo.doctor.OrganDeptInfoVO;
import com.ebaiyihui.api.ScheduleClient;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.schedule.GetDeptScheduleReqVO;
import his.pojo.vo.schedule.GetDeptScheduleResVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentServiceImpl.class);
    private static final String POP_DEPT = "\u63a8\u8350\u79d1\u5ba4";
    private static final int ALREADY_VISITING = 1;
    private static final int NOT_VISITING = 0;
    private static final String[] NOT_INCLUDED_DEPT = new String[]{"\u6838\u9178\u68c0\u6d4b\u95e8\u8bca", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca2", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca3", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca4", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca5"};
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private DeptCategoryMapper deptCategoryMapper;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private ScheduleClient scheduleClient;
    private static int RECENT_SEARCH_RECORD_SIZE = 5;

    public List<GetDeptListVoRes> getDeptList() throws Exception {
        List deptCategoryEntities = this.deptCategoryMapper.selectAll();
        if (deptCategoryEntities.size() == 0) {
            return new ArrayList<GetDeptListVoRes>();
        }
        ArrayList<GetDeptListVoRes> list = new ArrayList<GetDeptListVoRes>();
        deptCategoryEntities.forEach(item -> {
            GetDeptListVoRes getDeptListVoRes = new GetDeptListVoRes();
            getDeptListVoRes.setFirstDepId(item.getDeptCategoryCode());
            getDeptListVoRes.setFirstDepName(item.getDeptCategoryName());
            list.add(getDeptListVoRes);
        });
        return list;
    }

    public List<GetDeptListVoRes> getDeptList(String hl, String date) throws Exception {
        FrontRequest getDeptScheduleReqVOFrontRequest = this.buildGetDeptScheduleReqVO(hl, date);
        log.info("\u8bf7\u6c42his\u6839\u636e\u53f7\u7c7b\u83b7\u53d6\u79d1\u5ba4\u4fe1\u606f\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)getDeptScheduleReqVOFrontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse deptSchedule = this.scheduleClient.getDeptSchedule(getDeptScheduleReqVOFrontRequest);
        log.info("\u8bf7\u6c42his\u6839\u636e\u53f7\u7c7b\u83b7\u53d6\u79d1\u5ba4\u4fe1\u606f\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)deptSchedule, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!"1".equals(deptSchedule.getCode())) {
            log.error("\u83b7\u53d6\u79d1\u5ba4\u51fa\u9519");
            return new ArrayList<GetDeptListVoRes>();
        }
        ArrayList<GetDeptListVoRes> getDeptListVoResList = new ArrayList<GetDeptListVoRes>();
        GetDeptListVoRes getDeptListVoRes = new GetDeptListVoRes();
        ArrayList hospitalDepVoResList = new ArrayList();
        ((GetDeptScheduleResVO)deptSchedule.getBody()).getItems().stream().forEach(item -> {
            HospitalDeptVo hospitalDeptVo = new HospitalDeptVo();
            if (!Arrays.asList(NOT_INCLUDED_DEPT).contains(item.getDeptName())) {
                hospitalDeptVo.setHospitalDepCode(item.getDeptCode());
                hospitalDeptVo.setHospitalDepName(item.getDeptName());
                hospitalDepVoResList.add(hospitalDeptVo);
            }
        });
        getDeptListVoRes.setHospitalDepVoResList(hospitalDepVoResList);
        getDeptListVoResList.add(getDeptListVoRes);
        log.info("\u83b7\u53d6\u79d1\u5ba4\u5217\u8868\u51fa\u53c2->{}", (Object)JSON.toJSONString(getDeptListVoResList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return getDeptListVoResList;
    }

    private FrontRequest<GetDeptScheduleReqVO> buildGetDeptScheduleReqVO(String hl, String date) {
        FrontRequest frontRequest = new FrontRequest();
        GetDeptScheduleReqVO getDeptScheduleReqVO = new GetDeptScheduleReqVO();
        getDeptScheduleReqVO.setPageSize("50");
        getDeptScheduleReqVO.setRequestPage("1");
        getDeptScheduleReqVO.setTypeId(hl);
        getDeptScheduleReqVO.setOrderId("1");
        if (DateUtil.today().equals(date)) {
            getDeptScheduleReqVO.setOrderId("0");
        }
        getDeptScheduleReqVO.setBgDate(DateUtil.format((Date)DateUtil.parse((CharSequence)date), (String)"yyyyMMdd"));
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)getDeptScheduleReqVO);
        return frontRequest;
    }

    private List<HospitalDeptVo> getHospitalDeptVo(List<String> visitingDeptCodeList, List<DepartmentEntity> departmentEntityList) {
        ArrayList<HospitalDeptVo> hospitalDeptVoList = new ArrayList<HospitalDeptVo>();
        if (CollectionUtils.isEmpty(departmentEntityList)) {
            return hospitalDeptVoList;
        }
        return departmentEntityList.stream().map(departmentEntity -> {
            HospitalDeptVo hospitalDepVo = new HospitalDeptVo();
            String deptCode = departmentEntity.getDeptCode();
            hospitalDepVo.setHospitalDepCode(deptCode);
            hospitalDepVo.setHospitalDepName(departmentEntity.getDeptName());
            if (!CollectionUtils.isEmpty((Collection)visitingDeptCodeList) && visitingDeptCodeList.contains(deptCode)) {
                hospitalDepVo.setVisiting(1);
            } else {
                hospitalDepVo.setVisiting(0);
            }
            hospitalDeptVoList.add(hospitalDepVo);
            return hospitalDepVo;
        }).collect(Collectors.toList());
    }

    private List<DepartmentEntity> getPopOrganDept(String organId) throws AppointmentException {
        List departmentEntityList = this.getDoctorInfoUtil.getHotDepartmentList(organId);
        return departmentEntityList;
    }

    private List<OrganDeptInfoVO> getOrganDeptList(String organId, String organCode) throws AppointmentException {
        OrganIdReq organIdReq = new OrganIdReq();
        organIdReq.setOrganId(organId);
        organIdReq.setOrganCode(organCode);
        List organDeptInfoVOList = this.getDoctorInfoUtil.getListOrganDept(organIdReq);
        return organDeptInfoVOList;
    }

    public void saveSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String redisKey = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.add((Object)redisKey, (Object)keyword, (double)System.currentTimeMillis());
        log.info("\u3010redis\u5b58\u50a8\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, value:{}", (Object)redisKey, (Object)keyword);
        Long size = zSetOperations.size((Object)redisKey);
        if (size > (long)RECENT_SEARCH_RECORD_SIZE) {
            zSetOperations.removeRange((Object)redisKey, 0L, size - (long)RECENT_SEARCH_RECORD_SIZE - 1L);
        }
        this.redisTemplate.expire((Object)redisKey, 30L, TimeUnit.DAYS);
    }

    public List<HospitalDeptVo> searchDept(String organCode, String userId, String key) throws AppointmentException {
        this.saveSearchRecord(organCode, userId, key);
        List list = this.deptRecordMapper.selectByNameAndHospitalCode(organCode, key);
        return list;
    }

    public List<String> getRecentSearchDeptList(String organCode, String userId) throws AppointmentException {
        ArrayList<String> list = new ArrayList<String>();
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        Set range = zSetOperations.reverseRangeWithScores((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u83b7\u53d6\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, object:{} ", (Object)key, (Object)JSON.toJSONString((Object)range));
        for (ZSetOperations.TypedTuple tuple : range) {
            list.add((String)tuple.getValue());
        }
        return list;
    }

    public void deleteOneSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.remove((Object)key, new Object[]{keyword});
        log.info("\u3010redis\u5220\u9664\u6307\u5b9a\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}, value:{} ", (Object)key, (Object)keyword);
    }

    public void deleteAllSearchRecords(String organCode, String userId) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.removeRange((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u5220\u9664\u6240\u6709\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}", (Object)key);
    }
}

