/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.api.InHospitalClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.gateway.RouteEnum;
import com.ebaiyihui.wisdommedical.mapper.DepositSetEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IhHospitalOrderFreeTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospitalRechargeDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PayRequestVoReq;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.base.GatewayRequest;
import his.pojo.vo.base.GatewayResponse;
import his.pojo.vo.hospitalization.DepositReq;
import his.pojo.vo.hospitalization.DepositRes;
import his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import his.pojo.vo.hospitalization.GetInpAdmissionReq;
import his.pojo.vo.hospitalization.GetInpAdmissionRes;
import his.pojo.vo.hospitalization.GetOrdItemsReq;
import his.pojo.vo.hospitalization.GetOrdItemsRes;
import his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InHospitalServiceImpl
implements InHospitalService {
    private static final Logger log = LoggerFactory.getLogger(InHospitalServiceImpl.class);
    @Autowired
    private InHospitalClient InHospitalApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private DepositSetEntityMapper depositSetEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private InHospitalClient inHospitalClient;

    public List<GetInpAdmissionResItems> getInpAdmissionItems(GetInpAdmissionReqVO getInpAdmissionReqVO) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            return new ArrayList<GetInpAdmissionResItems>();
        }
        return getInpAdmissionResItemsList;
    }

    public InHospitalRechargeDetailResVO getRechargeDetail(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) throws InHospitalException {
        InHospitalRechargeDetailResVO inHospitalRechargeDetailResVO = new InHospitalRechargeDetailResVO();
        BigDecimal detailTotalMoney = new BigDecimal("0");
        GatewayRequest gatewayRequest = this.buildGetRechargeDetailReq(inHospitalRechargeDetailReqVO);
        List rechargeDetailList = this.getRechargeDetail(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)rechargeDetailList)) {
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u9884\u4ea4\u91d1\u5145\u503c\u660e\u7ec6\u8bb0\u5f55");
        }
        for (GetIPDepositRecordsItems items : rechargeDetailList) {
            if (null == items.getAmout()) continue;
            detailTotalMoney = detailTotalMoney.add(new BigDecimal(items.getAmout()));
        }
        for (GetIPDepositRecordsItems getIPDepositRecordsItems : rechargeDetailList) {
            getIPDepositRecordsItems.setPrePayDateTime(getIPDepositRecordsItems.getPrePayDateTime());
            if (null == getIPDepositRecordsItems.getAmout()) continue;
            getIPDepositRecordsItems.setAmout(getIPDepositRecordsItems.getAmout());
        }
        List collect = rechargeDetailList.stream().sorted(Comparator.comparing(GetIPDepositRecordsItems::getPrePayDateTime).reversed()).collect(Collectors.toList());
        inHospitalRechargeDetailResVO.setDetailTotalMoney(String.valueOf(detailTotalMoney));
        inHospitalRechargeDetailResVO.setDetailRechargeList(collect);
        return inHospitalRechargeDetailResVO;
    }

    public GetIhHospitalOrderItemsResVo getIhHospitalOrderItems(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) throws InHospitalException {
        FrontRequest getOrdItemsReqGatewayRequest = this.buildGetInHospitalOrderItemDetailReq(getHospitalOrderItemsReqVo);
        GetOrdItemsRes getOrdItemsRes = this.getInHospFeeDetail(getOrdItemsReqGatewayRequest);
        if (null == getOrdItemsRes) {
            new GetOrdItemsRes();
        }
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = new GetIhHospitalOrderItemsResVo();
        BeanUtils.copyProperties((Object)getOrdItemsRes, (Object)getIhHospitalOrderItemsResVo);
        List getOrdItemsResItemsList = getOrdItemsRes.getOrdItem();
        if (CollectionUtils.isEmpty((Collection)getOrdItemsResItemsList)) {
            return getIhHospitalOrderItemsResVo;
        }
        List amountList = getOrdItemsResItemsList.stream().map(getOrdItemsResItems -> new BigDecimal(getOrdItemsResItems.getAmount())).collect(Collectors.toList());
        log.info("\u5904\u7406\u540e\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u8fd4\u56de\u503c\u4e3a:{}", (Object)getOrdItemsResItemsList);
        BigDecimal totalMoney = new BigDecimal("0");
        for (BigDecimal amount : amountList) {
            totalMoney = totalMoney.add(amount);
        }
        Map getOrdItemsResItemsMap = getOrdItemsResItemsList.stream().collect(Collectors.groupingBy(GetOrdItemsResItems::getFeeType, Collectors.toList()));
        log.info("\u5904\u7406\u540e\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u8fd4\u56de\u503c\u7684\u533b\u5631\u96c6\u5408\u4e3a:{}", getOrdItemsResItemsMap);
        ArrayList ihHospitalOrderFreeTypeVoList = new ArrayList();
        getOrdItemsResItemsMap.keySet().forEach(freeType -> {
            IhHospitalOrderFreeTypeVo ihHospitalOrderFreeTypeVo = new IhHospitalOrderFreeTypeVo();
            ihHospitalOrderFreeTypeVo.setFreeType(freeType);
            ihHospitalOrderFreeTypeVo.setGetOrdItemsResItemsList((List)getOrdItemsResItemsMap.get(freeType));
            ihHospitalOrderFreeTypeVoList.add(ihHospitalOrderFreeTypeVo);
        });
        getIhHospitalOrderItemsResVo.setTotalMoney(totalMoney);
        getIhHospitalOrderItemsResVo.setIhHospitalOrderFreeTypeVoList(ihHospitalOrderFreeTypeVoList);
        return getIhHospitalOrderItemsResVo;
    }

    public InHospDepositCreateOrderResVO inHospDepositCreateOrder(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) throws InHospitalException {
        GetInpAdmissionReqVO getInpAdmissionReqVO = new GetInpAdmissionReqVO();
        getInpAdmissionReqVO.setOrganCode(this.propertiesConstant.getOrganCode());
        getInpAdmissionReqVO.setChannelCode(inHospDepositCreateOrderReqVO.getChannelCode());
        getInpAdmissionReqVO.setHospitalCode(inHospDepositCreateOrderReqVO.getHospitalCode());
        getInpAdmissionReqVO.setCardNo(inHospDepositCreateOrderReqVO.getCardId());
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        ArrayList<GetInpAdmissionResItems> getInpAdmissionResItemsList = new ArrayList<GetInpAdmissionResItems>();
        GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
        getInpAdmissionResItems.setPatientId(inHospDepositCreateOrderReqVO.getCardId());
        getInpAdmissionResItems.setPatientName(inHospDepositCreateOrderReqVO.getPatientName());
        getInpAdmissionResItems.setTotalMoney(inHospDepositCreateOrderReqVO.getRechargeMoney());
        getInpAdmissionResItemsList.add(getInpAdmissionResItems);
        if (CollectionUtils.isEmpty(getInpAdmissionResItemsList)) {
            throw new InHospitalException("\u901a\u8fc7\u4f4f\u9662\u53f7\u672a\u83b7\u53d6\u5230\u4f4f\u9662\u4fe1\u606f,\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.buildInpatientDepositDetailEntity((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0), inHospDepositCreateOrderReqVO);
        try {
            this.inpatientDepositDetailEntityMapper.insertSelective(inpatientDepositDetailEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientPayorderEntity inpatientPayorderEntity = this.buildInpatientPayorderEntity(inHospDepositCreateOrderReqVO, inpatientDepositDetailEntity.getId());
        try {
            this.inpatientPayorderEntityMapper.insertSelective(inpatientPayorderEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("pay\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        inHospDepositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        inHospDepositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        inHospDepositCreateOrderResVO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        inHospDepositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        return inHospDepositCreateOrderResVO;
    }

    public BaseResponse<String> InHospDepositPay(InHospDepositPayReqVO inHospDepositPayReqVO) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inHospDepositPayReqVO.getOrderSeq());
        DepositPayReqVO depositPayReqVO = new DepositPayReqVO();
        depositPayReqVO.setActuallyAmount(inpatientDepositDetailEntity.getMoney());
        depositPayReqVO.setMchCode(this.propertiesConstant.getMchCode());
        depositPayReqVO.setOutTradeNo(inHospDepositPayReqVO.getOrderSeq());
        depositPayReqVO.setPayChannel(inHospDepositPayReqVO.getPayChannel());
        depositPayReqVO.setPayType(inHospDepositPayReqVO.getPayType());
        depositPayReqVO.setProductInfo("\u4f4f\u9662\u9884\u4ea4\u91d1");
        depositPayReqVO.setServiceCode(ServiceCodeEnum.DEPOSITPAY.getValue());
        depositPayReqVO.setTotalAmount(inpatientDepositDetailEntity.getMoney());
        depositPayReqVO.setUserSign(inHospDepositPayReqVO.getOpenId());
        depositPayReqVO.setNonceStr(SignUtil.getNonceStr());
        depositPayReqVO.setPayNotifyUrl(this.propertiesConstant.getInHospitalPayNotifyUrl());
        depositPayReqVO.setCardNo(inpatientDepositDetailEntity.getCardNo());
        depositPayReqVO.setOpenId(inHospDepositPayReqVO.getOpenId());
        depositPayReqVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositPayReqVO.setOrderSeq(inpatientDepositDetailEntity.getId().toString());
        return this.payCreateOrder(depositPayReqVO, inpatientDepositDetailEntity);
    }

    public DepositRes InHospDeposit(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildDepositReqGetWay(inpatientDepositDetailEntity, responseNotifyRestVo);
        return this.getDepositRes(gatewayRequest);
    }

    public List<String> getMoneyList(String hospitalCode) {
        List depositSetEntityList = null;
        depositSetEntityList = this.depositSetEntityMapper.selectByOrganCode(hospitalCode);
        if (null == depositSetEntityList || depositSetEntityList.size() < 1) {
            return new ArrayList<String>();
        }
        List<String> moneysList = depositSetEntityList.stream().map(a -> a.getMoneys()).collect(Collectors.toList());
        return moneysList;
    }

    public InHospDepositCreateOrderResVO getInHospDepositCreateOrderRes(String orderSeq) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderSeq);
        InHospDepositCreateOrderResVO depositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        depositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositCreateOrderResVO.setOrderSeq(orderSeq);
        depositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        depositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        return depositCreateOrderResVO;
    }

    private GatewayRequest<GetInpAdmissionReq> buildGetInpAdmissionReq(GetInpAdmissionReqVO getInpAdmissionReqVO) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetInpAdmissionReq getInpAdmissionReq = new GetInpAdmissionReq();
        getInpAdmissionReq.setCardNo(getInpAdmissionReqVO.getCardNo());
        gatewayRequest.setBody((Object)getInpAdmissionReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getInpAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getInpAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInpAdmissionItems");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetIPDepositRecordsReq> buildGetRechargeDetailReq(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetIPDepositRecordsReq getIPDepositRecordsReq = new GetIPDepositRecordsReq();
        getIPDepositRecordsReq.setInHospNo(inHospitalRechargeDetailReqVO.getInHospNo());
        getIPDepositRecordsReq.setStartDate(inHospitalRechargeDetailReqVO.getStartDate());
        getIPDepositRecordsReq.setEndDate(inHospitalRechargeDetailReqVO.getEndDate());
        getIPDepositRecordsReq.setAdmId(inHospitalRechargeDetailReqVO.getAdmId());
        gatewayRequest.setBody((Object)getIPDepositRecordsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inHospitalRechargeDetailReqVO.getChannelCode()));
        gatewayRequest.setChannel(inHospitalRechargeDetailReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetRechargeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private FrontRequest<GetOrdItemsReq> buildGetInHospitalOrderItemDetailReq(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) {
        FrontRequest gatewayRequest = new FrontRequest();
        GetOrdItemsReq getOrdItemsReq = new GetOrdItemsReq();
        getOrdItemsReq.setInHospNo(getHospitalOrderItemsReqVo.getInHospNo());
        if (StringUtils.isBlank((CharSequence)getHospitalOrderItemsReqVo.getFreeDate())) {
            getOrdItemsReq.setStartDate(DateUtils.dateToSimpleString((Date)DateUtils.getSubtractMonth((Date)new Date(), (int)1)));
            getOrdItemsReq.setEndDate(DateUtils.dateToSimpleString((Date)new Date()));
        } else {
            getOrdItemsReq.setStartDate(getHospitalOrderItemsReqVo.getFreeDate());
            getOrdItemsReq.setEndDate(getHospitalOrderItemsReqVo.getFreeDate());
        }
        gatewayRequest.setBody((Object)getOrdItemsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getHospitalOrderItemsReqVo.getChannelCode()));
        gatewayRequest.setChannel(getHospitalOrderItemsReqVo.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<DepositReq> buildDepositReqGetWay(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DepositReq depositReq = new DepositReq();
        depositReq.setInHospNo(inpatientDepositDetailEntity.getPatientId());
        depositReq.setAdmID(inpatientDepositDetailEntity.getAdmissionNo());
        depositReq.setPayChannel("HLWYYWXZF");
        depositReq.setFlowNo(inpatientDepositDetailEntity.getOrderSeq());
        depositReq.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        DepositRespmsg depositRespmsg = new DepositRespmsg();
        depositRespmsg.setPosId(responseNotifyRestVo.getTradeNo());
        depositRespmsg.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositRespmsg.setOrderid(responseNotifyRestVo.getTradeNo());
        depositRespmsg.setPayment(String.valueOf(responseNotifyRestVo.getTotalAmount()));
        depositRespmsg.setAccDate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        depositReq.setRespmsg(depositRespmsg);
        gatewayRequest.setBody((Object)depositReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inpatientDepositDetailEntity.getChannel()));
        gatewayRequest.setChannel(inpatientDepositDetailEntity.getChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("InHospDeposit");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private List<GetInpAdmissionResItems> getInpAdmission(GatewayRequest<GetInpAdmissionReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GetInpAdmissionReq body = (GetInpAdmissionReq)gatewayRequest.getBody();
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)body);
        frontRequest.setTransactionId(gatewayRequest.getTransactionId());
        FrontResponse inpAdmission = this.inHospitalClient.getInpAdmission(frontRequest);
        if (null == inpAdmission) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(inpAdmission.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)inpAdmission.getErrCode(), (Object)inpAdmission.getMessage());
            return null;
        }
        GetInpAdmissionRes getInpAdmissionRes = (GetInpAdmissionRes)inpAdmission.getBody();
        if (null == getInpAdmissionRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionRes.getItems())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u65e0\u4f4f\u9662\u8bb0\u5f55\u4fe1\u606f\u4fe1\u606f");
            return null;
        }
        return getInpAdmissionRes.getItems();
    }

    private List<GetIPDepositRecordsItems> getRechargeDetail(GatewayRequest<GetIPDepositRecordsReq> gatewayRequest) {
        ArrayList rechargeDetailList = null;
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.INPATIENT_GETPREPAY_RECORD.getValue(), gatewayRequest, GetIPDepositRecordsRes.class);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        GetIPDepositRecordsRes getIPDepositRecordsRes = (GetIPDepositRecordsRes)gatewayResponse.getData();
        if (null == getIPDepositRecordsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        rechargeDetailList = getIPDepositRecordsRes.getItems();
        if (null == rechargeDetailList || rechargeDetailList.isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u65e0\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8fd4\u56dehis\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868 Items:{}", (Object)getIPDepositRecordsRes.getItems());
        return rechargeDetailList;
    }

    private GetOrdItemsRes getInHospFeeDetail(FrontRequest<GetOrdItemsReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        FrontResponse gatewayResponse = this.InHospitalApi.getOrdItems(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        GetOrdItemsRes getOrdItemsRes = (GetOrdItemsRes)gatewayResponse.getBody();
        if (null == getOrdItemsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        if (null == getOrdItemsRes.getOrdItem() || getOrdItemsRes.getOrdItem().isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
            throw new InHospitalException("\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8fd4\u56dehis\u4f4f\u9662\u8d39\u7528\u6e05\u5355 OrdItems:{}", (Object)getOrdItemsRes);
        return getOrdItemsRes;
    }

    private DepositRes getDepositRes(GatewayRequest<DepositReq> gatewayRequest) throws InHospitalException {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.INP_ATIENTDOPRE_PAY.getValue(), gatewayRequest, DepositRes.class);
        if (null == gatewayResponse) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        DepositRes depositRes = (DepositRes)gatewayResponse.getData();
        if (null == depositRes) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8fd4\u56dehis\u5145\u503c\u6210\u529f\u51ed\u8bc1 depositRes:{}", (Object)depositRes);
        return depositRes;
    }

    private InpatientDepositDetailEntity buildInpatientDepositDetailEntity(GetInpAdmissionResItems getInpAdmissionResItems, InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) {
        InpatientDepositDetailEntity depositDetailEntity = new InpatientDepositDetailEntity();
        depositDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        depositDetailEntity.setOrganName(inHospDepositCreateOrderReqVO.getHospitalName());
        depositDetailEntity.setAdmissionNo(inHospDepositCreateOrderReqVO.getAdmID());
        depositDetailEntity.setInpatientDate(DateUtils.stringToSimpleDateJS((String)getInpAdmissionResItems.getStartDate()));
        depositDetailEntity.setOrderSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        depositDetailEntity.setPatientId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientOrganId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientName(getInpAdmissionResItems.getPatientName());
        depositDetailEntity.setCardId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        depositDetailEntity.setCardNo(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setStatus(new Byte("0"));
        depositDetailEntity.setMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        depositDetailEntity.setChannel(inHospDepositCreateOrderReqVO.getChannelCode());
        depositDetailEntity.setCreateTime(new Date());
        depositDetailEntity.setUpdateTime(new Date());
        depositDetailEntity.setInHospitalProduceMoney(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyTotalMoney(new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0"));
        BigDecimal preMoneyBalance = new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0").subtract(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyBalance(preMoneyBalance);
        depositDetailEntity.setRemark("\u521b\u5efa\u8ba2\u5355\u6210\u529f\uff0c\u672a\u652f\u4ed8");
        return depositDetailEntity;
    }

    private InpatientPayorderEntity buildInpatientPayorderEntity(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, Long id) {
        InpatientPayorderEntity inpatientPayorderEntity = new InpatientPayorderEntity();
        inpatientPayorderEntity.setInpatientDepositId(id);
        inpatientPayorderEntity.setOrderType(new Byte("1"));
        inpatientPayorderEntity.setDealMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        inpatientPayorderEntity.setBizSysSeq(ServiceCodeEnum.DEPOSITPAY.getValue());
        inpatientPayorderEntity.setPayStatus(new Byte("0"));
        inpatientPayorderEntity.setDealSeq("");
        inpatientPayorderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        inpatientPayorderEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        inpatientPayorderEntity.setCreateTime(new Date());
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRemark("\u521b\u5efapay\u8ba2\u5355\uff0c\u7b49\u5f85\u652f\u4ed8");
        return inpatientPayorderEntity;
    }

    private BaseResponse<String> payCreateOrder(DepositPayReqVO depositPayReqVO, InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)depositPayReqVO));
            ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
            if (null == serviceMerchantConfigEntity) {
                return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
            }
            PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
            payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
            payRequestVoReq.setOutTradeNo(depositPayReqVO.getOutTradeNo());
            payRequestVoReq.setPayChannel(depositPayReqVO.getPayChannel());
            payRequestVoReq.setPayType(depositPayReqVO.getPayType());
            payRequestVoReq.setProductInfo("\u5904\u65b9\u7f34\u8d39");
            payRequestVoReq.setServiceCode(ServiceCodeEnum.DEPOSITPAY.getValue());
            payRequestVoReq.setActuallyAmount(depositPayReqVO.getTotalAmount());
            payRequestVoReq.setTotalAmount(depositPayReqVO.getTotalAmount());
            payRequestVoReq.setUserSign(depositPayReqVO.getUserSign());
            payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
            payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            payRequestVoReq.setPayNotifyUrl(depositPayReqVO.getPayNotifyUrl());
            Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
            String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
            payRequestVoReq.setSign(sign);
            baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1.payCreateOrder->\u53d1\u8d77\u652f\u4ed8\u8fd4\u56de\u53c2\u6570baseResponse: " + baseResponse);
        }
        catch (Exception e) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        return baseResponse;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

