/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.api.NetReportClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsReq;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosReq;
import com.ebaiyihui.wisdommedical.pojo.vo.NetReportBaseRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportInfo;
import com.ebaiyihui.wisdommedical.service.NetReportService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.report.GetReportListsReq;
import his.pojo.vo.report.GetReportListsRes;
import his.pojo.vo.report.LisReportListReq;
import his.pojo.vo.report.LisReportListRes;
import his.pojo.vo.report.PacsReportListReq;
import his.pojo.vo.report.PacsReportListRes;
import his.pojo.vo.report.datas.GetReportListsData;
import his.pojo.vo.report.datas.LisReportListResData;
import his.pojo.vo.report.datas.micDatas.LisReportListResMicData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NetReportServiceImpl
implements NetReportService {
    private static final Logger log = LoggerFactory.getLogger(NetReportServiceImpl.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private NetReportClient ElectronicReportApi;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseResponse<GetReportListsRes> queryReportHosList(ListReportHosReq param) {
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(param.getCardNo());
        listReportParam.setPatientId(param.getCardNo());
        listReportParam.setReportType(param.getReportType());
        if (StringUtils.isNotBlank((CharSequence)param.getBeginDate())) {
            listReportParam.setBeginTime(param.getBeginDate());
            listReportParam.setEndTime(param.getEndDate());
        } else {
            String endDate = DateUtils.getCurrentDateSimpleToString();
            String startDate = DateUtils.dateToSimpleString((Date)DateUtils.getAddYear((Date)new Date(), (int)-2));
            listReportParam.setBeginTime(startDate);
            listReportParam.setEndTime(endDate);
        }
        FrontRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        FrontResponse reportLists = this.ElectronicReportApi.getReportLists(gatewayRequest);
        GetReportListsRes gateWayData = (GetReportListsRes)this.checkHisResponse(reportLists);
        if (gateWayData == null) {
            this.logger.error("request his  - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        List reportDataList = gateWayData.getDatas();
        if (reportDataList.size() <= 0) {
            this.logger.error("request his  - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        reportDataList.sort(Comparator.comparing(GetReportListsData::getReportDate).reversed());
        gateWayData.setDatas(reportDataList);
        log.info("\u5217\u8868\u667a\u6167\u5c31\u533b\u51fa\u53c2{}", (Object)gateWayData);
        return BaseResponse.success((Object)gateWayData);
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(ReportDetailReq param) {
        LisReportListReq lisReportListReq = new LisReportListReq();
        lisReportListReq.setReportNo(param.getReportNo());
        FrontRequest gateWayParam = this.getGateWayParam((NetReportBaseRequest)param, (Object)lisReportListReq);
        FrontResponse response = this.ElectronicReportApi.lisReportList(gateWayParam);
        LisReportListRes gateWayData = (LisReportListRes)this.checkHisResponse(response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        ReportDetailRes reportDetail = new ReportDetailRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        List lisReportListResDataList = gateWayData.getDatas();
        if (lisReportListResDataList.size() == 0) {
            this.logger.error("request his  - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        this.logger.info(">{}", (Object)lisReportListResDataList);
        List reportDetailDataList = lisReportListResDataList.stream().map(arg_0 -> this.matchJyReportDetail(arg_0)).collect(Collectors.toList());
        reportDetail.setDatas(reportDetailDataList);
        try {
            if (StringUtils.isNotEmpty((CharSequence)reportDetail.getPatientDOB())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date birthday = simpleDateFormat.parse(reportDetail.getPatientDOB());
                String age = String.valueOf(DateUtils.getAgeByBirth((Date)birthday));
                reportDetail.setAge(age);
            }
        }
        catch (ParseException e) {
            this.logger.info(e.toString());
        }
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<CheckReportDetailsRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        PacsReportListReq pacsReportListReq = new PacsReportListReq();
        pacsReportListReq.setReportNo(param.getReportNo());
        FrontRequest gateWayParam = this.getGateWayParam((NetReportBaseRequest)param, (Object)pacsReportListReq);
        FrontResponse response = this.ElectronicReportApi.pacsReportList(gateWayParam);
        PacsReportListRes gateWayData = (PacsReportListRes)this.checkHisResponse(response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        CheckReportDetailsRes reportDetail = new CheckReportDetailsRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reportDetail.getAge()})) {
            reportDetail.setAge(reportDetail.getAge().replace("Y", ""));
        }
        return BaseResponse.success((Object)reportDetail);
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> T checkHisResponse(FrontResponse<T> response) {
        if (response == null) {
            this.logger.error("request his  error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(response.getCode())) {
            this.logger.error("request his  error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getBody() == null) {
            this.logger.error("request his  error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        if (response.getCode().equals("0")) {
            this.logger.error(response.getMessage());
            return null;
        }
        return (T)response.getBody();
    }

    private <T> FrontRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}---{}", (Object)transactionId, (Object)JSON.toJSONString((Object)gatewayRequest));
        return gatewayRequest;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

