/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.api.OutpatientPaymentClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.ItemTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.OrderTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.PayItemDatasDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetAdmissionRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetPayItemRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GuidedInfoResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ItemTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderDetailRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PayItemResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PaySuccessInfoRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetPayItemReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PayRequestVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.QueryPayStatusReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.RefundOrderVoReq;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.base.GatewayRequest;
import his.pojo.vo.outpatient.ComfirmPayNewReq;
import his.pojo.vo.outpatient.GetAdmissionReq;
import his.pojo.vo.outpatient.GetAdmissionRes;
import his.pojo.vo.outpatient.PayItemReq;
import his.pojo.vo.outpatient.PayItemRes;
import his.pojo.vo.outpatient.datas.PayItemResDatas;
import his.pojo.vo.outpatient.items.GetAdmissionItems;
import his.pojo.vo.outpatient.items.PayItemResItems;
import his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final byte OUTPATIENT_DEPARTMENT = 1;
    public static final byte EMERGENCY_TREATMENT = 2;
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    public static final String WECHAT = "WECHAT";
    public static final String ALIPAY = "ALIPAY";
    @Autowired
    private OutpatientPaymentClient OutpatientPaymentApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private OutpatientPaymentClient outpatientPaymentClient;

    public List<GetAdmissionItems> getAdmission(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        FrontRequest gatewayRequest = this.buildGetAdmissionGatewayReq(getAdmissionReqVO);
        log.info("OutpatientPaymentServiceImpl.getAdmission->\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
        List getAdmissionItemsList = this.getAdmission(gatewayRequest);
        getAdmissionItemsList.sort(Comparator.comparing(GetAdmissionItems::getAdmDate).reversed());
        return getAdmissionItemsList;
    }

    private List<GetAdmissionItems> getAdmission(FrontRequest<GetAdmissionReq> gatewayRequest) throws OutpatientPaymentException {
        FrontResponse gatewayResponse = this.OutpatientPaymentApi.getAdmission(gatewayRequest);
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868:" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMessage());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
            throw new OutpatientPaymentException(gatewayResponse.getMessage());
        }
        if (null == gatewayResponse.getBody()) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMessage());
        }
        GetAdmissionRes getAdmissionRes = (GetAdmissionRes)gatewayResponse.getBody();
        if (getAdmissionRes.getItems().size() == 0) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
        }
        ArrayList items = getAdmissionRes.getItems();
        return OutpatientPaymentServiceImpl.consolidatePaymentProcessing((List)items);
    }

    private static List<GetAdmissionItems> consolidatePaymentProcessing(List<GetAdmissionItems> itemList) {
        HashMap<String, GetAdmissionItems> itemMap = new HashMap<String, GetAdmissionItems>();
        for (GetAdmissionItems item : itemList) {
            String key = item.getDeptCode() + "-" + item.getDocCode() + "-" + item.getReceptId() + "-" + item.getDocName() + "-" + item.getName();
            if (itemMap.containsKey(key)) {
                GetAdmissionItems existingItem = (GetAdmissionItems)itemMap.get(key);
                existingItem.getAdmIds().add(item.getAdmId());
                continue;
            }
            item.setAdmIds(new ArrayList());
            item.getAdmIds().add(item.getAdmId());
            itemMap.put(key, item);
        }
        log.info("\u5408\u5e76\u5217\u8868\u8ba2\u5355\u5904\u7406\u5b8c\u6210{}", (Object)JSON.toJSONString(itemMap));
        return new ArrayList<GetAdmissionItems>(itemMap.values());
    }

    private List<GetAdmissionRespVO> buildOutpatientPaymentRespVOList(List<GetAdmissionItems> getAdmissionItemsList, String cardId) {
        if (CollectionUtils.isEmpty(getAdmissionItemsList)) {
            return new ArrayList<GetAdmissionRespVO>();
        }
        List<GetAdmissionItems> listGetAdmissionItems = getAdmissionItemsList;
        List<GetAdmissionRespVO> listOutpatientPaymentRespVOs = getAdmissionItemsList.stream().map(getAdmissionItems -> {
            GetAdmissionRespVO getAdmissionRespVO = new GetAdmissionRespVO();
            BeanUtils.copyProperties((Object)getAdmissionItems, (Object)getAdmissionRespVO);
            getAdmissionRespVO.setAdmDate(getAdmissionItems.getAdmDate());
            getAdmissionRespVO.setCardId(cardId);
            getAdmissionRespVO.setPayStatus("0");
            return getAdmissionRespVO;
        }).collect(Collectors.toList());
        return listOutpatientPaymentRespVOs;
    }

    private FrontRequest<GetAdmissionReq> buildGetAdmissionGatewayReq(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        String endDate = DateUtils.getCurrentDateSimpleToString();
        Date dateBefore = DateUtils.getDateBefore((Date)new Date(System.currentTimeMillis()), (int)2);
        String bgDate = new SimpleDateFormat("yyyy-MM-dd").format(dateBefore);
        GetAdmissionReq getAdmissionReq = new GetAdmissionReq();
        getAdmissionReq.setBgDate(getAdmissionReqVO.getBgDate());
        getAdmissionReq.setEdDate(getAdmissionReqVO.getEdDate());
        getAdmissionReq.setCardNo(getAdmissionReqVO.getCardNo());
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)getAdmissionReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public GetPayItemRespVO getPayItem(GetPayItemReqVO getPayItemReqVO) throws Exception {
        GetPayItemRespVO getPayItemRespVO = new GetPayItemRespVO();
        List payItemResDatasList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)getPayItemReqVO.getAdmIds())) {
            log.info("\u6709\u5408\u5e76\u5c5e\u6027\uff0c\u5f00\u59cb\u5408\u5e76\u67e5\u8be2\u3002{}", (Object)JSON.toJSONString((Object)getPayItemReqVO));
            for (String admId : getPayItemReqVO.getAdmIds()) {
                getPayItemReqVO.setAdmId(admId);
                FrontRequest gatewayRequest = this.buildPayItemGatewayReq(getPayItemReqVO);
                payItemResDatasList.addAll(this.payItem(gatewayRequest));
            }
        } else {
            FrontRequest gatewayRequest = this.buildPayItemGatewayReq(getPayItemReqVO);
            payItemResDatasList = this.payItem(gatewayRequest);
        }
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(getPayItemReqVO.getCardId());
        String outPatientId = String.valueOf(this.snowflakeIdWorker.nextId());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
        getPayItemRespVO.setOutPatientId(outPatientId);
        Date date = DateUtils.stringToSimpleDateJS((String)getPayItemReqVO.getAdmDate());
        getPayItemReqVO.setAdmDate(DateUtils.dateToSimpleString((Date)date));
        this.buildPayItemDatasRespVO(outPatientId, getPayItemReqVO, getPayItemRespVO, payItemResDatasList, cardDetailsInfoRespVO);
        PayItemDatasDTO payItemDatasDTO = this.buildPayItemDatasDTOForRedis(outPatientId, getPayItemReqVO, payItemResDatasList, cardDetailsInfoRespVO);
        String payItemDatasDTOStr = JSON.toJSONString((Object)payItemDatasDTO);
        this.jedisCluster.set(outPatientId, payItemDatasDTOStr);
        this.jedisCluster.expire(outPatientId, 7200);
        return getPayItemRespVO;
    }

    private List<PayItemResDatas> payItem(FrontRequest<PayItemReq> gatewayRequest) throws OutpatientPaymentException {
        FrontResponse gatewayResponse = this.OutpatientPaymentApi.payItem(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMessage());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
            throw new OutpatientPaymentException(gatewayResponse.getMessage());
        }
        if (StringUtils.isEmpty((Object)gatewayResponse.getBody())) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMessage());
        }
        PayItemRes payItemRes = (PayItemRes)gatewayResponse.getBody();
        if (null == payItemRes.getDatas() || payItemRes.getDatas().isEmpty()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
        }
        return payItemRes.getDatas();
    }

    private void buildPayItemDatasRespVO(String outPatientId, GetPayItemReqVO getPayItemReqVO, GetPayItemRespVO getPayItemRespVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        getPayItemRespVO.setOutPatientId(outPatientId);
        getPayItemRespVO.setName(cardDetailsInfoRespVO.getPatientName());
        getPayItemRespVO.setSex(cardDetailsInfoRespVO.getGender().toString());
        getPayItemRespVO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        getPayItemRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        if (CollectionUtils.isEmpty((Collection)payItemResVos)) {
            getPayItemRespVO.setDeptName(getPayItemReqVO.getDeptName());
        } else {
            getPayItemRespVO.setDeptCode(((PayItemResItems)((PayItemResVo)payItemResVos.get(0)).getItems().get(0)).getExcutDeptId());
            getPayItemRespVO.setDeptName(((PayItemResItems)((PayItemResVo)payItemResVos.get(0)).getItems().get(0)).getExcutDeptName());
        }
        getPayItemRespVO.setAmount(amount.toString());
        getPayItemRespVO.setPayItemResVoList(payItemResVos);
        getPayItemRespVO.setCardNo(getPayItemReqVO.getCardNo());
        getPayItemRespVO.setDocName(getPayItemReqVO.getDocName());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
        getPayItemRespVO.setCreateTime(DateUtil.now());
    }

    private List<PayItemResVo> buildPayItemResVoList(List<PayItemResDatas> payItemResDatasList, String admId) {
        ArrayList<PayItemResVo> payItemResList = new ArrayList<PayItemResVo>();
        PayItemResVo treatmentPayItemResVo = this.buildPayItemResVo(payItemResDatasList);
        if (null != treatmentPayItemResVo) {
            payItemResList.add(treatmentPayItemResVo);
        }
        return payItemResList;
    }

    private PayItemResVo buildPayItemResVo(List<PayItemResDatas> payList) {
        if (!CollectionUtils.isEmpty(payList)) {
            PayItemResVo payItemResVo = new PayItemResVo();
            BigDecimal amount = BigDecimal.ZERO;
            ArrayList items = new ArrayList();
            ArrayList feeIdList = new ArrayList();
            for (PayItemResDatas payItemResDatas : payList) {
                amount = amount.add(new BigDecimal(payItemResDatas.getAmount()));
                items.addAll(payItemResDatas.getItems());
            }
            payItemResVo.setFeeId(feeIdList);
            payItemResVo.setItemType(payList.get(0).getItemType());
            payItemResVo.setItems(items);
            payItemResVo.setAmount(amount.toString());
            return payItemResVo;
        }
        return null;
    }

    private PayItemDatasDTO buildPayItemDatasDTOForRedis(String outPatientId, GetPayItemReqVO getPayItemReqVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        PayItemDatasDTO payItemDatasDTO = new PayItemDatasDTO();
        payItemDatasDTO.setIdCard(cardDetailsInfoRespVO.getCredNo());
        payItemDatasDTO.setPatientId(outPatientId);
        payItemDatasDTO.setOutPatientId(outPatientId);
        payItemDatasDTO.setPatientOrganId(cardDetailsInfoRespVO.getCardNo());
        payItemDatasDTO.setCardId(cardDetailsInfoRespVO.getCardId());
        payItemDatasDTO.setCardNo(cardDetailsInfoRespVO.getOrganPmi());
        payItemDatasDTO.setAdmDate(getPayItemReqVO.getAdmDate());
        payItemDatasDTO.setAdmType(getPayItemReqVO.getAdmType());
        payItemDatasDTO.setName(cardDetailsInfoRespVO.getPatientName());
        payItemDatasDTO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        payItemDatasDTO.setSex(cardDetailsInfoRespVO.getGender().toString());
        payItemDatasDTO.setAdmId(getPayItemReqVO.getAdmId());
        payItemDatasDTO.setDeptName(getPayItemReqVO.getDeptName());
        payItemDatasDTO.setDeptCode(getPayItemReqVO.getDeptCode());
        payItemDatasDTO.setDocName(getPayItemReqVO.getDocName());
        payItemDatasDTO.setDocCode(getPayItemReqVO.getDocCode());
        payItemDatasDTO.setAdmIds(getPayItemReqVO.getAdmIds());
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList feeIdList = new ArrayList();
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
            feeIdList.addAll(payItemResVo.getFeeId());
        }
        payItemDatasDTO.setFeeIds(String.join((CharSequence)",", feeIdList));
        payItemDatasDTO.setAmount(amount.toString());
        payItemDatasDTO.setPayItemResVoList(payItemResVos);
        return payItemDatasDTO;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) throws OutpatientPaymentException {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        log.info("\u83b7\u53d6\u5c31\u8bca\u5361\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cardDetailsInfoReqVO));
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private FrontRequest<PayItemReq> buildPayItemGatewayReq(GetPayItemReqVO getPayItemReqVO) {
        PayItemReq payItemReq = new PayItemReq();
        payItemReq.setAdmId(getPayItemReqVO.getAdmId());
        payItemReq.setCardNo(getPayItemReqVO.getCardNo());
        payItemReq.setAdmDate(getPayItemReqVO.getAdmDate());
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getPayItemReqVO.getChannelCode()));
        gatewayRequest.setChannel(getPayItemReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)payItemReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private OpBusinessOrderEntity buildOpBusinessOrderEntity(PayItemDatasDTO payItemDatasDTO, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opBusinessOrderEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
        opBusinessOrderEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        opBusinessOrderEntity.setOrganName(outpatientPaymentReqVO.getHospitalName());
        opBusinessOrderEntity.setAdmId(payItemDatasDTO.getAdmId());
        opBusinessOrderEntity.setAdmTime(outpatientPaymentReqVO.getAdmDate());
        if ("E".equals(payItemDatasDTO.getAdmType())) {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)2));
        } else {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)1));
        }
        opBusinessOrderEntity.setDeptName(payItemDatasDTO.getDeptName());
        opBusinessOrderEntity.setDeptCode(payItemDatasDTO.getDeptCode());
        opBusinessOrderEntity.setDocName(payItemDatasDTO.getDocName());
        opBusinessOrderEntity.setDocCode(payItemDatasDTO.getDocCode());
        opBusinessOrderEntity.setPatientId(payItemDatasDTO.getPatientId());
        opBusinessOrderEntity.setPatientOrganId(payItemDatasDTO.getPatientOrganId());
        opBusinessOrderEntity.setPatientName(payItemDatasDTO.getName());
        opBusinessOrderEntity.setPatientGender(Integer.valueOf(Integer.parseInt(payItemDatasDTO.getSex())));
        opBusinessOrderEntity.setIdCard(payItemDatasDTO.getIdCard());
        opBusinessOrderEntity.setUserId(outpatientPaymentReqVO.getUserId());
        opBusinessOrderEntity.setCardNo(payItemDatasDTO.getCardNo());
        opBusinessOrderEntity.setPatientAge(payItemDatasDTO.getAge());
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.NOT_PAY.getValue());
        opBusinessOrderEntity.setMoney(new BigDecimal(payItemDatasDTO.getAmount()));
        opBusinessOrderEntity.setPayTime(new Date());
        List payItemResVoList = payItemDatasDTO.getPayItemResVoList();
        for (PayItemResVo payItemResVo : payItemResVoList) {
            List items = payItemResVo.getItems();
            for (PayItemResItems payItemResItems : items) {
                opBusinessOrderEntity.setReceiptId(payItemResItems.getPrescriptionNo());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)payItemDatasDTO.getAdmIds())) {
            String admIds = String.join((CharSequence)"|", payItemDatasDTO.getAdmIds());
            opBusinessOrderEntity.setAdmIds(admIds);
        }
        return opBusinessOrderEntity;
    }

    private List<OpBusinessOrderDetailEntity> buildOpBusinessOrderDetailEntity(PayItemDatasDTO payItemDatasDTO, String hospitalName) {
        ArrayList<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntityList = new ArrayList<OpBusinessOrderDetailEntity>();
        List payItemResVoList = payItemDatasDTO.getPayItemResVoList();
        for (PayItemResVo payItemResVo : payItemResVoList) {
            List items = payItemResVo.getItems();
            for (PayItemResItems payItemResItems : items) {
                OpBusinessOrderDetailEntity opBusinessOrderDetailEntity = new OpBusinessOrderDetailEntity();
                opBusinessOrderDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
                opBusinessOrderDetailEntity.setOrganName(hospitalName);
                opBusinessOrderDetailEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
                opBusinessOrderDetailEntity.setItemName(payItemResItems.getDesc());
                opBusinessOrderDetailEntity.setItemType(payItemResItems.getItemType());
                opBusinessOrderDetailEntity.setItemId(payItemResItems.getId());
                opBusinessOrderDetailEntity.setQuantity(Double.valueOf(Double.parseDouble(payItemResItems.getQty())));
                opBusinessOrderDetailEntity.setUnit(payItemResItems.getUnit());
                opBusinessOrderDetailEntity.setPrice(new BigDecimal(payItemResItems.getPrice()));
                BigDecimal bigDecimal = new BigDecimal(payItemResItems.getPrice());
                BigDecimal sumPrice = new BigDecimal(payItemResItems.getQty());
                BigDecimal mulNum1 = bigDecimal.multiply(sumPrice);
                BigDecimal big2 = new BigDecimal(payItemResItems.getSum());
                if (mulNum1.compareTo(big2) == 0) {
                    opBusinessOrderDetailEntity.setMoney(new BigDecimal(payItemResItems.getSum()));
                } else {
                    log.info("\u603b\u4ef7\u4e0d\u5bf9\uff0c\u53d6\u8ba1\u7b97\u7684\u91d1\u989d\uff0c\u5355\u4ef7{},\u6570\u91cf{},\u8fd4\u56de\u7684\u91d1\u989d{}", new Object[]{payItemResItems.getPrice(), payItemResItems.getQty(), payItemResItems.getSum()});
                    opBusinessOrderDetailEntity.setMoney(mulNum1);
                }
                opBusinessOrderDetailEntity.setPrescriptionNo(payItemResItems.getId());
                opBusinessOrderDetailEntityList.add(opBusinessOrderDetailEntity);
            }
        }
        return opBusinessOrderDetailEntityList;
    }

    public OutpatientPaymentOrderDetailRespVO getOutpatientSucssessDetail(OutpatientPaymentOrderDetailReqVO outpatientPaymentOrderDetailReqVO) throws Exception {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderEntity) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
        }
        List opBusinessOrderDetailEntitiesList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderDetailEntitiesList) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
        }
        OutpatientPaymentOrderDetailRespVO outpatientPaymentOrderDetailRespVO = new OutpatientPaymentOrderDetailRespVO();
        outpatientPaymentOrderDetailRespVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        outpatientPaymentOrderDetailRespVO.setName(opBusinessOrderEntity.getPatientName());
        outpatientPaymentOrderDetailRespVO.setSex(opBusinessOrderEntity.getPatientGender().toString());
        outpatientPaymentOrderDetailRespVO.setAge(opBusinessOrderEntity.getPatientAge());
        outpatientPaymentOrderDetailRespVO.setCardNo(opBusinessOrderEntity.getCardNo());
        outpatientPaymentOrderDetailRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        outpatientPaymentOrderDetailRespVO.setCreateTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getCreateTime()));
        outpatientPaymentOrderDetailRespVO.setPayTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getPayTime()));
        List payItemResVos = this.buidPayItemResVoList(opBusinessOrderDetailEntitiesList);
        outpatientPaymentOrderDetailRespVO.setPayItemResVoList(payItemResVos);
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        outpatientPaymentOrderDetailRespVO.setAmount(amount.toString());
        outpatientPaymentOrderDetailRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        outpatientPaymentOrderDetailRespVO.setDocName(opBusinessOrderEntity.getDocName());
        outpatientPaymentOrderDetailRespVO.setAdmId(opBusinessOrderEntity.getAdmId());
        outpatientPaymentOrderDetailRespVO.setGuidedInfoList(this.getGuidedInfo(outpatientPaymentOrderDetailReqVO.getOutPatientId()));
        return outpatientPaymentOrderDetailRespVO;
    }

    private List<PayItemResVo> buidPayItemResVoList(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        ArrayList<PayItemResVo> payItemResVoList = new ArrayList<PayItemResVo>();
        PayItemResVo treatmentPayItemResVo = this.buildPayItemResVoForDetail(opBusinessOrderDetailList);
        if (null != treatmentPayItemResVo) {
            payItemResVoList.add(treatmentPayItemResVo);
        }
        return payItemResVoList;
    }

    private PayItemResVo buildPayItemResVoForDetail(List<OpBusinessOrderDetailEntity> payItemList) {
        if (!CollectionUtils.isEmpty(payItemList)) {
            List items = this.buildPayItemResItems(payItemList);
            if (CollectionUtils.isEmpty((Collection)items)) {
                return null;
            }
            BigDecimal amount = BigDecimal.ZERO;
            for (PayItemResItems payItemResItems : items) {
                BigDecimal big2;
                BigDecimal sumPrice;
                BigDecimal bigDecimal = new BigDecimal(payItemResItems.getPrice());
                BigDecimal mulNum1 = bigDecimal.multiply(sumPrice = new BigDecimal(payItemResItems.getQty()));
                if (mulNum1.compareTo(big2 = new BigDecimal(payItemResItems.getSum())) == 0) {
                    amount = amount.add(new BigDecimal(payItemResItems.getSum()));
                    continue;
                }
                amount = amount.add(mulNum1);
            }
            PayItemResVo payItemResVo = new PayItemResVo();
            payItemResVo.setAmount(amount.toString());
            payItemResVo.setItems(items);
            payItemResVo.setItemType(((PayItemResItems)items.get(0)).getItemType());
            return payItemResVo;
        }
        return null;
    }

    private List<PayItemResItems> buildPayItemResItems(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntitiesList) {
        ArrayList<PayItemResItems> payItemResItemsList = new ArrayList<PayItemResItems>();
        if (null == opBusinessOrderDetailEntitiesList || opBusinessOrderDetailEntitiesList.isEmpty()) {
            return payItemResItemsList;
        }
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntitiesList) {
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setId(opBusinessOrderDetailEntity.getItemId());
            payItemResItems.setDesc(opBusinessOrderDetailEntity.getItemName());
            payItemResItems.setUnit(opBusinessOrderDetailEntity.getUnit());
            payItemResItems.setPrice(opBusinessOrderDetailEntity.getPrice().toString());
            payItemResItems.setQty(opBusinessOrderDetailEntity.getQuantity().toString());
            payItemResItems.setSum(opBusinessOrderDetailEntity.getMoney().toString());
            payItemResItems.setItemType(opBusinessOrderDetailEntity.getItemType());
            payItemResItemsList.add(payItemResItems);
        }
        return payItemResItemsList;
    }

    public BaseResponse<String> outpatientPayment(OutpatientPaymentReqVO outpatientPaymentReqVO) throws OutpatientPaymentException {
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0ckey\u4e3a\uff1a{}", (Object)outpatientPaymentReqVO.getOutPatientId());
        String payment = this.jedisCluster.get(outpatientPaymentReqVO.getOutPatientId() + "_pay");
        if (payment != null) {
            return (BaseResponse)JSON.parseObject((String)payment, BaseResponse.class);
        }
        String payItemDatasDTOStr = this.jedisCluster.get(outpatientPaymentReqVO.getOutPatientId());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payItemDatasDTOStr)) {
            throw new OutpatientPaymentException("\u8be5\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u4e0b\u5355\uff01");
        }
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0c\u83b7\u53d6\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)payItemDatasDTOStr);
        PayItemDatasDTO payItemDatasDTO = (PayItemDatasDTO)JSON.parseObject((String)payItemDatasDTOStr, PayItemDatasDTO.class);
        log.info("===\u300bpayItemDatasDTO\uff1a{}", (Object)payItemDatasDTO);
        OpBusinessOrderEntity orderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        if (null != orderEntity) {
            OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(orderEntity, outpatientPaymentReqVO);
            log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
            BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO, orderEntity);
            log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
            return baseResponse;
        }
        OpBusinessOrderEntity opBusinessOrderEntity = this.buildOpBusinessOrderEntity(payItemDatasDTO, outpatientPaymentReqVO);
        this.opBusinessOrderEntityMapper.insertSelective(opBusinessOrderEntity);
        log.info("=====>\u5b58\u8ba2\u5355\u8be6\u60c5\u8868begin");
        List opBusinessOrderDetailEntityList = this.buildOpBusinessOrderDetailEntity(payItemDatasDTO, outpatientPaymentReqVO.getHospitalName());
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntityList) {
            this.opBusinessOrderDetailEntityMapper.insertSelective(opBusinessOrderDetailEntity);
        }
        log.info("======>\u5b58\u8ba2\u5355\u8be6\u60c5\u8868end");
        OpRechargePaymentOrderEntity opRechargePaymentOrder = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(opBusinessOrderEntity, outpatientPaymentReqVO);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
        BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO, orderEntity);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        log.info("=====>businessOrder\u8868\u66f4\u65b0begin");
        opBusinessOrderEntity.setChannelCode(outpatientPaymentReqVO.getChannelCode());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        log.info("=====>businessOrder\u8868\u66f4\u65b0end");
        if (null != opRechargePaymentOrder) {
            return baseResponse;
        }
        log.info("=====>recharge\u65b0\u589ebegin");
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.buildOpRechargePaymentOrderEntity(outpatientPaymentReqVO, opBusinessOrderEntity);
        List opRechargePaymentOrderEntities = this.opRechargePaymentOrderEntityMapper.selectListByOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        if (CollectionUtils.isEmpty((Collection)opRechargePaymentOrderEntities)) {
            this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntity);
        } else {
            log.info("=====>recharge\u5df2\u5b58\u5728\uff0c\u505a\u4fee\u6539");
            opRechargePaymentOrderEntity.setId(((OpRechargePaymentOrderEntity)opRechargePaymentOrderEntities.get(0)).getId());
            this.opRechargePaymentOrderEntityMapper.updateByPrimaryKeySelective(opRechargePaymentOrderEntity);
        }
        log.info("=====>recharge\u65b0\u589eend");
        return baseResponse;
    }

    public FrontRequest<ComfirmPayNewReq> buildComfirmPayNewReq(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setId(opBusinessOrderEntity.getAdmId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setPaychannel("HLWYYWXZF");
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        comfirmPayNewReq.setPatientId(opBusinessOrderEntity.getCardNo());
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setOrderid(opBusinessOrderEntity.getOutPatientId());
        comfirmPayNewReqMsg.setPayment(opRechargePaymentOrderEntity.getDealMoney().toString());
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)opBusinessOrderEntity.getChannelCode()));
        gatewayRequest.setChannel(opBusinessOrderEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public BaseResponse<String> outPatientRefundNew(String outPatientId, String money) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientAndOrderType(outPatientId, String.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue()));
        if (null == opRechargePaymentOrderEntity) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u53ef\u9000\u6b3e\u8ba2\u5355");
        }
        BaseResponse baseResponse = this.outpatientRefundNew(opBusinessOrderEntity, opRechargePaymentOrderEntity, money);
        return baseResponse;
    }

    private BaseResponse<String> outpatientRefundNew(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String money) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        RefundOrderVoReq refundOrderVoReq = new RefundOrderVoReq();
        refundOrderVoReq.setPayChannel(opRechargePaymentOrderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        refundOrderVoReq.setOutTradeNo(String.valueOf(this.snowflakeIdWorker.nextId()));
        refundOrderVoReq.setDealTradeNo(opRechargePaymentOrderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(opBusinessOrderEntity.getMoney());
        refundOrderVoReq.setRefundAmount(new BigDecimal(money));
        refundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        refundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        refundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getOutpatientRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)refundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        refundOrderVoReq.setSign(sign);
        log.info("RefundServiceImpl.refund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("RefundServiceImpl.refund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        if (baseResponse == null) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)baseResponse.getMsg());
        }
        return baseResponse;
    }

    public BaseResponse<String> outPatientRefund(String outPatientId) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientAndOrderType(outPatientId, String.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue()));
        if (null == opRechargePaymentOrderEntity) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u53ef\u9000\u6b3e\u8ba2\u5355");
        }
        if (!PayStatusEnum.HAS_PAY_OR_REFUND.getValue().equals(opRechargePaymentOrderEntity.getPayStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u9000");
        }
        BaseResponse baseResponse = this.outpatientRefund(opBusinessOrderEntity, opRechargePaymentOrderEntity);
        if (!baseResponse.isSuccess()) {
            opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            opBusinessOrderEntity.setRemark(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
            log.error("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
            return BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
        opBusinessOrderEntity.setRemark(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        this.saveOpRechargePaymentOrder(opRechargePaymentOrderEntity);
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    private GatewayRequest<ComfirmPayNewReq> bulidComfirmPayNew(QueryPayStatusReqVo queryPayStatusReqVo, OpBusinessOrderEntity opBusinessOrderEntity) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        GatewayRequest gatewayRequest = new GatewayRequest();
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setPayment(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReqMsg.setOrderid(opBusinessOrderEntity.getOutPatientId());
        comfirmPayNewReqMsg.setAccdate(simpleDateFormat.format(opBusinessOrderEntity.getPayTime()));
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        comfirmPayNewReq.setId(queryPayStatusReqVo.getOutPatientId());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setPaychannel(opBusinessOrderEntity.getChannelCode());
        comfirmPayNewReq.setFlowNo(queryPayStatusReqVo.getOutPatientId());
        comfirmPayNewReq.setPatientId(queryPayStatusReqVo.getCardNo());
        comfirmPayNewReq.setPrescriptionNos(queryPayStatusReqVo.getFlowNo());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)queryPayStatusReqVo.getPayChannel()));
        gatewayRequest.setChannel(queryPayStatusReqVo.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private BaseResponse<String> outpatientRefund(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        RefundOrderVoReq refundOrderVoReq = new RefundOrderVoReq();
        refundOrderVoReq.setPayChannel(opRechargePaymentOrderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        refundOrderVoReq.setOutTradeNo(opRechargePaymentOrderEntity.getOutPatientId());
        refundOrderVoReq.setDealTradeNo(opRechargePaymentOrderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(opBusinessOrderEntity.getMoney());
        refundOrderVoReq.setRefundAmount(opRechargePaymentOrderEntity.getDealMoney());
        refundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        refundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        refundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getOutpatientRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)refundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        refundOrderVoReq.setSign(sign);
        log.info("RefundServiceImpl.refund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("RefundServiceImpl.refund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        if (baseResponse == null) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)baseResponse.getMsg());
        }
        return baseResponse;
    }

    private OutpatientPayReqVO buildOutpatientPayReqVO(OpBusinessOrderEntity opBusinessOrderEntity, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        OutpatientPayReqVO outpatientPayReqVO = new OutpatientPayReqVO();
        outpatientPayReqVO.setMchCode(this.propertiesConstant.getMchCode());
        outpatientPayReqVO.setOutTradeNo(outpatientPaymentReqVO.getOutPatientId());
        outpatientPayReqVO.setPayChannel(outpatientPaymentReqVO.getPayChannel());
        outpatientPayReqVO.setPayType(outpatientPaymentReqVO.getPayType());
        outpatientPayReqVO.setProductInfo("\u95e8\u8bca\u7f34\u8d39");
        outpatientPayReqVO.setServiceCode(ServiceCodeEnum.OUTPATIENT.getValue());
        outpatientPayReqVO.setActuallyAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setTotalAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setUserSign(outpatientPaymentReqVO.getOpenId());
        outpatientPayReqVO.setNonceStr(SignUtil.getNonceStr());
        outpatientPayReqVO.setPayNotifyUrl(this.propertiesConstant.getOutpatientPayNotifyUrl());
        return outpatientPayReqVO;
    }

    private OpRechargePaymentOrderEntity buildOpRechargePaymentOrderEntity(OutpatientPaymentReqVO outpatientPaymentReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = new OpRechargePaymentOrderEntity();
        Date date = new Date();
        opRechargePaymentOrderEntity.setCreateTime(date);
        opRechargePaymentOrderEntity.setUpdateTime(date);
        opRechargePaymentOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opRechargePaymentOrderEntity.setOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        opRechargePaymentOrderEntity.setOrderType(Byte.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue().byteValue()));
        opRechargePaymentOrderEntity.setDealMoney(opBusinessOrderEntity.getMoney());
        opRechargePaymentOrderEntity.setBizSysSeq(ServiceCodeEnum.OUTPATIENT.getValue());
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)0));
        opRechargePaymentOrderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        opRechargePaymentOrderEntity.setPaymentSeq(outpatientPaymentReqVO.getPayChannel());
        opRechargePaymentOrderEntity.setUserId(outpatientPaymentReqVO.getUserId());
        opRechargePaymentOrderEntity.setPaymentTime(new Date());
        return opRechargePaymentOrderEntity;
    }

    private BaseResponse<String> payCreateOrder(OutpatientPayReqVO outpatientPayReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            log.info("\u7f34\u8d39\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)outpatientPayReqVO));
            ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
            if (null == serviceMerchantConfigEntity) {
                return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
            }
            PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
            payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
            payRequestVoReq.setOutTradeNo(outpatientPayReqVO.getOutTradeNo());
            payRequestVoReq.setPayChannel(outpatientPayReqVO.getPayChannel());
            payRequestVoReq.setPayType(outpatientPayReqVO.getPayType());
            payRequestVoReq.setProductInfo("\u95e8\u8bca\u7f34\u8d39");
            payRequestVoReq.setServiceCode(ServiceCodeEnum.OUTPATIENT.getValue());
            payRequestVoReq.setActuallyAmount(outpatientPayReqVO.getTotalAmount());
            payRequestVoReq.setTotalAmount(outpatientPayReqVO.getTotalAmount());
            payRequestVoReq.setUserSign(outpatientPayReqVO.getUserSign());
            payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
            payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            payRequestVoReq.setPayNotifyUrl(this.propertiesConstant.getOutpatientPayNotifyUrl());
            Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
            String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
            payRequestVoReq.setSign(sign);
            baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
            log.info("\u7f34\u8d39\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
            log.info("OutpatientPaymentServiceImpl.payCreateOrder->\u53d1\u8d77\u652f\u4ed8\u8fd4\u56de\u53c2\u6570baseResponse: " + baseResponse);
            this.jedisCluster.set(outpatientPayReqVO.getOutTradeNo() + "_pay", JSON.toJSONString((Object)baseResponse), "NX", "EX", 1800L);
        }
        catch (Exception e) {
            log.error("OutpatientPaymentServiceImpl.payCreateOrder\u95e8\u8bca\u7f34\u8d39\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        return baseResponse;
    }

    public PaySuccessInfoRespVO getPaySuccessInfo(String outPatientId) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        List opBusinessOrderDetailList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity || null == opRechargePaymentOrderEntity || CollectionUtils.isEmpty((Collection)opBusinessOrderDetailList)) {
            throw new OutpatientPaymentException();
        }
        return this.buildPaySuccessInfoRespVO(opBusinessOrderEntity, opRechargePaymentOrderEntity, opBusinessOrderDetailList);
    }

    private PaySuccessInfoRespVO buildPaySuccessInfoRespVO(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        PaySuccessInfoRespVO paySuccessInfoRespVO = new PaySuccessInfoRespVO();
        paySuccessInfoRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        paySuccessInfoRespVO.setDocName(opBusinessOrderEntity.getDocName());
        paySuccessInfoRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        paySuccessInfoRespVO.setAmount(opRechargePaymentOrderEntity.getDealMoney().toString());
        paySuccessInfoRespVO.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        paySuccessInfoRespVO.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        TreeSet<String> itemType = new TreeSet<String>();
        for (OpBusinessOrderDetailEntity opBusinessOrderDetail : opBusinessOrderDetailList) {
            if (StringUtils.isEmpty((Object)opBusinessOrderDetail.getItemType())) continue;
            itemType.add(opBusinessOrderDetail.getItemType());
        }
        if (!CollectionUtils.isEmpty(itemType)) {
            ArrayList<ItemTypeVo> list = new ArrayList<ItemTypeVo>();
            for (String key : itemType) {
                ItemTypeVo itemTypeVo = new ItemTypeVo();
                if (ItemTypeEnum.MEDICAL_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.MEDICAL_PAY.getDisplay());
                }
                if (ItemTypeEnum.DIAGNOSIS_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.DIAGNOSIS_PAY.getDisplay());
                }
                list.add(itemTypeVo);
            }
            paySuccessInfoRespVO.setItemType(list);
        }
        if (opRechargePaymentOrderEntity.getPaymentSeq() != null && "WECHAT".equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u5fae\u4fe1\u652f\u4ed8");
        } else if (opRechargePaymentOrderEntity.getPaymentSeq() != null && "ALIPAY".equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u652f\u4ed8\u5b9d\u652f\u4ed8");
        }
        return paySuccessInfoRespVO;
    }

    public List<OutpatientPaymentOrderRespVO> getOutpatientPaymentOrder(OutpatientPaymentOrderReqVO outpatientPaymentOrderReqVO) throws OutpatientPaymentException {
        ArrayList<OutpatientPaymentOrderRespVO> outpatientPaymentOrderRespVOList = new ArrayList<OutpatientPaymentOrderRespVO>();
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setCardNo(outpatientPaymentOrderReqVO.getCardNo());
        List opBusinessOrderEntities = this.opBusinessOrderEntityMapper.selectByCardNoAndUserId(opBusinessOrderEntity);
        if (null == opBusinessOrderEntities || opBusinessOrderEntities.isEmpty()) {
            return outpatientPaymentOrderRespVOList;
        }
        for (OpBusinessOrderEntity opBusinessOrder : opBusinessOrderEntities) {
            OutpatientPaymentOrderRespVO outpatientPaymentOrderRespVO = new OutpatientPaymentOrderRespVO();
            outpatientPaymentOrderRespVO.setCreateTime(opBusinessOrder.getCreateTime().getTime());
            outpatientPaymentOrderRespVO.setDeptName(opBusinessOrder.getDeptName());
            outpatientPaymentOrderRespVO.setDocName(opBusinessOrder.getDocName());
            outpatientPaymentOrderRespVO.setOutPatientId(opBusinessOrder.getOutPatientId());
            outpatientPaymentOrderRespVO.setPayStatus(opBusinessOrder.getStatus().toString());
            outpatientPaymentOrderRespVO.setAdmDate(opBusinessOrder.getAdmTime());
            outpatientPaymentOrderRespVO.setAmount(opBusinessOrder.getMoney());
            outpatientPaymentOrderRespVOList.add(outpatientPaymentOrderRespVO);
        }
        outpatientPaymentOrderRespVOList.sort(Comparator.comparing(OutpatientPaymentOrderRespVO::getAdmDate).reversed());
        return outpatientPaymentOrderRespVOList;
    }

    private void saveOpRechargePaymentOrder(OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntityNew = new OpRechargePaymentOrderEntity();
        opRechargePaymentOrderEntityNew.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u7ba1\u7406\u7aef\u53d1\u8d77\u9000\u6b3e");
        opRechargePaymentOrderEntityNew.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        opRechargePaymentOrderEntityNew.setDealSeq(opRechargePaymentOrderEntity.getDealSeq());
        opRechargePaymentOrderEntityNew.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        Date now = new Date();
        opRechargePaymentOrderEntityNew.setCreateTime(now);
        opRechargePaymentOrderEntityNew.setUpdateTime(now);
        opRechargePaymentOrderEntityNew.setDealMoney(opRechargePaymentOrderEntity.getDealMoney());
        opRechargePaymentOrderEntityNew.setBizSysSeq(opRechargePaymentOrderEntity.getBizSysSeq());
        opRechargePaymentOrderEntityNew.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        opRechargePaymentOrderEntityNew.setMerchantSeq(opRechargePaymentOrderEntity.getMerchantSeq());
        opRechargePaymentOrderEntityNew.setMerchantId(opRechargePaymentOrderEntity.getMerchantId());
        opRechargePaymentOrderEntityNew.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        opRechargePaymentOrderEntityNew.setUserId(opRechargePaymentOrderEntity.getUserId());
        this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntityNew);
    }

    private BaseResponse<String> refund(RefundOrderVoReq refundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)refundOrderVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u8c03\u7528\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("RefundServiceImpl.refund->\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            return BaseResponse.error((String)"\u8c03\u7528\u5931\u8d25");
        }
    }

    private List<GuidedInfoResVO> getGuidedInfo(String outPatientId) {
        OpGuideEntity opGuideEntity = this.opGuideEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opGuideEntity) {
            return new ArrayList<GuidedInfoResVO>();
        }
        String guideInfo = opGuideEntity.getGuideInfo();
        String[] split = guideInfo.split("\\|\\|");
        ArrayList<GuidedInfoResVO> guidedInfoList = new ArrayList<GuidedInfoResVO>();
        for (int i = 0; i < split.length; ++i) {
            String[] split1 = split[i].split("\\^\\^");
            System.out.println(split1.length);
            GuidedInfoResVO guidedInfoResVO = new GuidedInfoResVO();
            guidedInfoResVO.setGuidedItem(split1[0]);
            guidedInfoResVO.setGuidedDesc(split1[1]);
            guidedInfoList.add(guidedInfoResVO);
        }
        return guidedInfoList;
    }
}

