/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.OrderTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.AppointmentRefundException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutreachException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRefundReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RefundRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.RefundResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.GetRefundRecordRes;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.RefundReq;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.RefundReqVO;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.RefundService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class RefundServiceImpl
implements RefundService {
    private static final Logger log = LoggerFactory.getLogger(RefundServiceImpl.class);
    private static final int HIS = 1;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    private static final String REFUND_FAIL = "\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u6b3e\u8bf7\u6c42body\u4e3a\u7a7a\uff01";
    private static final String REFUND_ORDER_ERROR = "\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01";
    private static final String NO_REFUND = "\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01";
    private static final String BASERESPONSE_NULL = "refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a";
    private static final String NETWORK_EXCEPTION = "\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff01";
    private static final String ERROR_INFO = "refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}";
    private static final String REQ_ERROR_FAIL = "\u53d1\u8d77\u9000\u6b3e\u5931\u8d25";
    private static final String HIS_ERROR_FAIL = "his\u65b9\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7";
    private static final String REFUND_AMOUNT_NULL = "RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a";
    private static final String REFUND_AMOUNTS = "\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a\uff01";
    private static final String REFUND_AMOUNTS_FAIL = "\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d\uff01";
    private static final String PAY_CHANNL_NULL = "RefundServiceImpl.checkParams->\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a";
    private static final String PAY_CHANNL = "\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a\uff01";
    private static final String PAY_CHANNL_MISMATCH = "\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff01";
    private static final String NOT_CONFIG = "\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25";

    public RefundResponse<String> appointmentRefund(RefundRequest<AppointmentRefundReq> refundRequest, int refundChannelCode) throws AppointmentRefundException {
        AppointmentRefundReq body = (AppointmentRefundReq)refundRequest.getBody();
        if (null == body) {
            log.error("RefundServiceImpl.checkParams->\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            throw new AppointmentRefundException(REFUND_FAIL);
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectByReceptId(body.getReceptId());
        if (null == appointmentRecordEntity) {
            log.error("RefundServiceImpl.checkParams->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receptId\u4e3a:{}", (Object)body.getReceptId());
            throw new AppointmentRefundException(REFUND_ORDER_ERROR);
        }
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.getBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        if (null == appointmentPayorderEntity) {
            log.error("RefundServiceImpl.checkParams->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receptId\u4e3a:{}", (Object)body.getReceptId());
            throw new AppointmentRefundException(REFUND_ORDER_ERROR);
        }
        BaseResponse baseResponse = this.appointmentRefund(body.getPayChannel(), appointmentPayorderEntity, appointmentRecordEntity, refundChannelCode);
        return this.buildRefundResponse(refundRequest, baseResponse);
    }

    public OutreachResponse<String> refundforHis(OutreachRequest<RefundReqVO> refundReqVO) throws OutreachException {
        RefundReqVO body = (RefundReqVO)refundReqVO.getBody();
        if (null == body) {
            log.error("refundforHis->\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            throw new OutreachException(REFUND_FAIL);
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(body.getOrderNo());
        if (null == appointmentRecordEntity) {
            log.error("refundforHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u53f7\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException(REFUND_ORDER_ERROR);
        }
        log.info("\u67e5\u8be2\u5230\u6302\u53f7\u8bb0\u5f55\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new OutreachException(NO_REFUND);
        }
        try {
            boolean overdueRefundDate = new Date().after(DateUtils.stringToFullDate((String)(appointmentRecordEntity.getAdmDate() + " 23:59:59")));
            if (overdueRefundDate) {
                throw new OutreachException("\u60a8\u5df2\u7ecf\u8d85\u8fc7\u4e86\u9000\u6b3e\u65f6\u95f4\u9650\u5236\uff0c\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u9000\u6b3e\uff01");
            }
        }
        catch (Exception e) {
            throw new OutreachException("\u5c31\u8bca\u65e5\u671f\u7c7b\u578b\u9519\u8bef\uff0c\u9000\u6b3e\u5931\u8d25\uff01");
        }
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        log.info("\u67e5\u8be2\u5230\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u8bb0\u5f55\uff1a" + JSON.toJSONString((Object)appointmentPayorderEntity));
        if (null == appointmentPayorderEntity) {
            log.error("refundforHis->\u67e5\u8be2\u8d26\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u53f7\u4e3a:{}", (Object)appointmentRecordEntity.getSysAppointmentId());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)appointmentPayorderEntity.getDealSeq())) {
            throw new OutreachException("DealSeq\u4e3a\u7a7a\uff01\u9000\u6b3e\u5931\u8d25");
        }
        this.checkRefundReqParams(body, appointmentPayorderEntity, appointmentRecordEntity);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null == serviceMerchantConfigEntity) {
            throw new OutreachException(NOT_CONFIG);
        }
        BaseResponse baseResponse = this.refund(this.buildRefundReq(appointmentRecordEntity, appointmentPayorderEntity, serviceMerchantConfigEntity));
        if (Objects.isNull(baseResponse)) {
            log.error(BASERESPONSE_NULL);
            return OutreachResponse.error((String)NETWORK_EXCEPTION);
        }
        if (!baseResponse.isSuccess()) {
            log.error(ERROR_INFO, (Object)baseResponse.getMsg());
            return OutreachResponse.error((String)REQ_ERROR_FAIL);
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setRemark(HIS_ERROR_FAIL);
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        appointmentPayorderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)1));
        appointmentPayorderEntity.setRefundRemrak(HIS_ERROR_FAIL);
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        return OutreachResponse.success((Object)body.getRefundFee());
    }

    public OutreachResponse<String> outpatientRefundForHis(OutreachRequest<RefundReqVO> refundReqVO) throws OutreachException {
        RefundReqVO body = (RefundReqVO)refundReqVO.getBody();
        if (null == body) {
            log.error("outpatientRefundForHis->\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            throw new OutreachException(REFUND_FAIL);
        }
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(body.getOrderNo());
        if (null == opBusinessOrderEntity) {
            log.error("outpatientRefundForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException(REFUND_ORDER_ERROR);
        }
        if (!opBusinessOrderEntity.getStatus().equals(BusinessOrderStatusEnum.PAID.getValue())) {
            throw new OutreachException(NO_REFUND);
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(opBusinessOrderEntity.getOutPatientId());
        if (null == opRechargePaymentOrderEntity) {
            log.error("RoutpatientRefundForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException(REFUND_ORDER_ERROR);
        }
        this.checkOutPatientRefundReqParams(body, opBusinessOrderEntity, opRechargePaymentOrderEntity);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            throw new OutreachException(NOT_CONFIG);
        }
        BaseResponse baseResponse = this.outpatientPaymentRefund(opBusinessOrderEntity, opRechargePaymentOrderEntity, serviceMerchantConfigEntity);
        if (null == baseResponse) {
            log.error(BASERESPONSE_NULL);
            return OutreachResponse.error((String)NETWORK_EXCEPTION);
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error(ERROR_INFO, (Object)baseResponse.getMsg());
            return OutreachResponse.error((String)REQ_ERROR_FAIL);
        }
        opRechargePaymentOrderEntity.setRemark("his\u8c03\u7528\u9000\u6b3e\u8ba2\u5355\uff0c\u53d1\u8d77\u9000\u6b3e");
        opRechargePaymentOrderEntity.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setRefundType(Byte.valueOf(RefundChannelCodeEnum.HIS_REFUND.getValue().byteValue()));
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        return OutreachResponse.success((Object)body.getRefundFee());
    }

    public OutreachResponse<String> inHospitalRefundForHis(OutreachRequest<RefundReqVO> refundReqVO) throws OutreachException {
        RefundReqVO body = (RefundReqVO)refundReqVO.getBody();
        if (null == body) {
            log.error("outpatientRefundForHis->\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            throw new OutreachException(REFUND_FAIL);
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(body.getOrderNo());
        if (null == inpatientDepositDetailEntity) {
            log.error("RefundServiceImpl.checkParams->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receiptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u4f4f\u9662\u5145\u503c\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (inpatientDepositDetailEntity.getStatus().intValue() != InpatientDepositDetailStatusEnum.PAID.getValue().intValue()) {
            throw new OutreachException(NO_REFUND);
        }
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
        if (null == inpatientPayorderEntity) {
            log.error("RefundServiceImpl.checkParams->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receiptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u4f4f\u9662\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        this.checkInHospitalRefundRequestParams(body, inpatientDepositDetailEntity, inpatientPayorderEntity);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
        if (null == serviceMerchantConfigEntity) {
            throw new OutreachException(NOT_CONFIG);
        }
        BaseResponse baseResponse = this.inHospitalPaymentRefund(inpatientDepositDetailEntity, inpatientPayorderEntity, serviceMerchantConfigEntity);
        if (null == baseResponse) {
            log.error(BASERESPONSE_NULL);
            return OutreachResponse.error((String)NETWORK_EXCEPTION);
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error(ERROR_INFO, (Object)baseResponse.getMsg());
            return OutreachResponse.error((String)REQ_ERROR_FAIL);
        }
        inpatientPayorderEntity.setRemark("his\u8c03\u7528\u9000\u6b3e\u8ba2\u5355\uff0c\u5f85\u9000\u6b3e");
        inpatientPayorderEntity.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        inpatientPayorderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRefundType(Byte.valueOf(RefundChannelCodeEnum.HIS_REFUND.getValue().byteValue()));
        this.inpatientPayorderEntityMapper.updateByPrimaryKeySelective(inpatientPayorderEntity);
        return OutreachResponse.success((Object)body.getRefundFee());
    }

    public BaseResponse<String> withdrawNumber(RefundReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentPayorderEntity appointmentPayorder = this.appointmentPayOrderMapper.selectByOrderSeq(withdrawNumberVoReq.getSysAppointmentId());
        if (Objects.isNull(appointmentPayorder)) {
            return BaseResponse.error((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u6709\u8bef,\u8bf7\u6838\u5b9e\u540e\u518d\u9000");
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(appointmentPayorder.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)NOT_CONFIG);
        }
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest("his\u8c03\u7528\u539f\u8def\u9000\u8d39");
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7 withdrawNumber";
        businessResultEntity.setErrorCode("");
        businessResultEntity.setErrorMsg("");
        businessResultEntity.setHisResponse("");
        businessResultEntity.setTransationId("");
        businessResultEntity.setStatus(new Byte("0"));
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.CURRENT_SYSTEM_REFUND.getValue().intValue()));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity payorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (payorderEntity == null || payorderEntity.getDealSeq() == null || "".equals(payorderEntity.getDealSeq())) {
            throw new AppointmentException("DealSeq\u4e3a\u7a7a\uff01");
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(String.valueOf(this.snowflakeIdWorker.nextId()));
        requestRefundOrderVoReq.setDealTradeNo(payorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(withdrawNumberVoReq.getRefundMoney()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        log.info("refund method--------> begain");
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        log.info("refund\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundTime(new Date());
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        BusinessResultEntity businessResult = new BusinessResultEntity();
        businessResult.setId(businessResultEntity.getId());
        businessResult.setPlatformResponse(JSON.toJSONString((Object)baseResponse));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResult);
        return baseResponse;
    }

    public BaseResponse<String> outPatientRefund(RefundReq withdrawNumberVoReq) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOrderSeq(withdrawNumberVoReq.getSysAppointmentId());
        if (Objects.isNull(opRechargePaymentOrderEntity)) {
            return BaseResponse.error((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u6709\u8bef,\u8bf7\u6838\u5b9e\u540e\u518d\u9000");
        }
        BaseResponse stringBaseResponse = this.outpatientPaymentService.outPatientRefundNew(opRechargePaymentOrderEntity.getOutPatientId(), withdrawNumberVoReq.getRefundMoney());
        return stringBaseResponse;
    }

    public BaseResponse<String> inHospitalRefund(RefundReq withdrawNumberVoReq, InpatientPayorderEntity inpatientPayorderEntity) throws InHospitalException {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByPrimaryKey(inpatientPayorderEntity.getInpatientDepositId());
        if (null == inpatientDepositDetailEntity) {
            log.error("RefundServiceImpl.checkParams->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receiptId\u4e3a:{}", (Object)withdrawNumberVoReq.getSysAppointmentId());
            return BaseResponse.error((String)"\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u4f4f\u9662\u5145\u503c\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
        if (null == serviceMerchantConfigEntity) {
            throw new InHospitalException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u8d39\u5931\u8d25^n^");
        }
        BaseResponse baseResponse = this.inHospitalPaymentRefundNew(inpatientDepositDetailEntity, inpatientPayorderEntity, serviceMerchantConfigEntity, withdrawNumberVoReq);
        if (null == baseResponse) {
            log.error(BASERESPONSE_NULL);
            return BaseResponse.error((String)NETWORK_EXCEPTION);
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error(ERROR_INFO, (Object)baseResponse.getMsg());
            return BaseResponse.error((String)REQ_ERROR_FAIL);
        }
        inpatientPayorderEntity.setRemark("his\u8c03\u7528\u9000\u6b3e\u8ba2\u5355\uff0c\u5f85\u9000\u6b3e");
        inpatientPayorderEntity.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        inpatientPayorderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRefundType(Byte.valueOf(RefundChannelCodeEnum.HIS_REFUND.getValue().byteValue()));
        this.inpatientPayorderEntityMapper.updateByPrimaryKeySelective(inpatientPayorderEntity);
        return baseResponse;
    }

    public List<GetRefundRecordRes> getRefundRecords(String outPatientId) {
        ArrayList<GetRefundRecordRes> RefundRecords = new ArrayList();
        ServicePayBillEntity payRecords = this.servicePayBillMapper.selectByOutPatientId(outPatientId);
        log.info("\u67e5\u8be2\u5230\u7684\u652f\u4ed8\u8ba2\u5355\u662f\uff1a{}", (Object)payRecords);
        String dealTradeNo = payRecords.getDealTradeNo();
        log.info("\u67e5\u8be2\u5230\u7684\u652f\u4ed8\u8ba2\u5355  deal_trade_no  \u662f\uff1a{}", (Object)dealTradeNo);
        RefundRecords = this.servicePayBillMapper.selectByDealTradeNo(dealTradeNo);
        log.info("\u67e5\u8be2\u5230\u7684\u9000\u6b3e\u8ba2\u5355\u662f\uff1a" + JSONObject.toJSONString(RefundRecords));
        return RefundRecords;
    }

    private RefundResponse<String> buildRefundResponse(RefundRequest<AppointmentRefundReq> refundRequest, BaseResponse<String> baseResponse) {
        RefundResponse refundResponse = new RefundResponse();
        refundResponse.setTransactionId(refundRequest.getTransactionId());
        refundResponse.setTransDate(refundRequest.getTransDate());
        refundResponse.setTransTime(refundRequest.getTransTime());
        if (baseResponse.isSuccess()) {
            refundResponse.setIssucess("1");
            refundResponse.setMessage("\u64cd\u4f5c\u6210\u529f");
            refundResponse.setBody((Object)((AppointmentRefundReq)refundRequest.getBody()).getRegFee());
        } else {
            refundResponse.setIssucess("0");
            refundResponse.setMessage("\u8bf7\u6c42\u9000\u6b3e\u5931\u8d25");
            refundResponse.setBody(null);
        }
        return refundResponse;
    }

    private BaseResponse<String> appointmentRefund(String payChannel, AppointmentPayorderEntity appointmentPayorderEntity, AppointmentRecordEntity appointmentRecordEntity, int refundChannelCode) throws AppointmentRefundException {
        if (appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentRefundException(NO_REFUND);
        }
        try {
            boolean overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            if (!overdueRefundDate) {
                throw new AppointmentRefundException("\u60a8\u5df2\u7ecf\u8d85\u8fc7\u4e86\u9000\u6b3e\u65f6\u95f4\u9650\u5236\uff0c\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u9000\u6b3e\uff01");
            }
        }
        catch (Exception e) {
            throw new AppointmentRefundException("\u5c31\u8bca\u65e5\u671f\u7c7b\u578b\u9519\u8bef\uff0c\u9000\u6b3e\u5931\u8d25\uff01");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)NOT_CONFIG);
        }
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setRemark(HIS_ERROR_FAIL);
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity payorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (payorderEntity == null || payorderEntity.getDealSeq() == null || "".equals(payorderEntity.getDealSeq())) {
            throw new AppointmentRefundException("DealSeq\u4e3a\u7a7a\uff01");
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(payChannel);
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(payorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        log.info("RefundServiceImpl.refund->start,\u53d1\u8d77\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570requestRefundOrderVoReq\u4e3a:{}", (Object)requestRefundOrderVoReq);
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        log.info("RefundServiceImpl.refund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        if (baseResponse == null) {
            log.error("RefundServiceImpl.appointmentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a");
            return baseResponse;
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error("RefundServiceImpl.appointmentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)baseResponse.getMsg());
            return baseResponse;
        }
        AppointmentPayorderEntity appointmentPayorder = new AppointmentPayorderEntity();
        appointmentPayorder.setSysAppointmentId(sysAppointmentId);
        appointmentPayorder.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
        appointmentPayorder.setRefundChannelCode(Byte.valueOf((byte)refundChannelCode));
        appointmentPayorder.setRefundRemrak(HIS_ERROR_FAIL);
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorder);
        return baseResponse;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("RefundServiceImpl.refund->\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    private void checkRefundReqParams(RefundReqVO refundRequest, AppointmentPayorderEntity appointmentPayorderEntity, AppointmentRecordEntity appointmentRecordEntity) throws OutreachException {
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            log.error(REFUND_AMOUNT_NULL);
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u975e\u53ef\u9000\u6b3e\u72b6\u6001\uff01");
        }
        BigDecimal dealMoney = appointmentPayorderEntity.getDealMoney();
        if (StringUtils.isBlank((String)refundRequest.getRefundFee())) {
            log.error(REFUND_AMOUNT_NULL);
            throw new OutreachException(REFUND_AMOUNTS);
        }
        BigDecimal regFee = new BigDecimal(refundRequest.getRefundFee());
        if (dealMoney.compareTo(regFee) < 0) {
            log.error("RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)regFee.toString());
            throw new OutreachException(REFUND_AMOUNTS_FAIL);
        }
        String payChannel = appointmentRecordEntity.getPayChannelCode();
        if (StringUtils.isBlank((String)refundRequest.getPayChannel())) {
            log.error(PAY_CHANNL_NULL);
            throw new OutreachException(PAY_CHANNL);
        }
        if (!refundRequest.getPayChannel().trim().equals(payChannel)) {
            log.error("RefundServiceImpl.checkParams->\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u652f\u4ed8\u6e20\u9053\u53c2\u6570\u4e3a:{}", (Object)refundRequest.getPayChannel());
            throw new OutreachException(PAY_CHANNL_MISMATCH);
        }
    }

    private RequestRefundOrderVoReq buildRefundReq(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity appointmentPayorderEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(appointmentPayorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        return requestRefundOrderVoReq;
    }

    private void checkOutPatientRefundReqParams(RefundReqVO body, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) throws OutreachException {
        BigDecimal dealMoney = opRechargePaymentOrderEntity.getDealMoney();
        if (StringUtils.isBlank((String)body.getRefundFee())) {
            log.error(REFUND_AMOUNT_NULL);
            throw new OutreachException(REFUND_AMOUNTS);
        }
        BigDecimal regFee = BigDecimal.ZERO;
        try {
            regFee = new BigDecimal(body.getRefundFee());
        }
        catch (NumberFormatException e) {
            log.error("RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5!,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)body.getRefundFee());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (dealMoney.compareTo(regFee) < 0) {
            log.error("RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)regFee.toString());
            throw new OutreachException(REFUND_AMOUNTS_FAIL);
        }
        String payChannel = opRechargePaymentOrderEntity.getPaymentSeq();
        if (StringUtils.isBlank((String)body.getPayChannel())) {
            log.error(PAY_CHANNL_NULL);
            throw new OutreachException(PAY_CHANNL);
        }
        if (!body.getPayChannel().trim().equals(payChannel)) {
            log.error("RefundServiceImpl.checkParams->\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u652f\u4ed8\u6e20\u9053\u53c2\u6570\u4e3a:{}", (Object)body.getPayChannel());
            throw new OutreachException(PAY_CHANNL_MISMATCH);
        }
    }

    private BaseResponse<String> outpatientPaymentRefund(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        RequestRefundOrderVoReq refundOrderVoReq = new RequestRefundOrderVoReq();
        refundOrderVoReq.setPayChannel(opRechargePaymentOrderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        refundOrderVoReq.setOutTradeNo(opRechargePaymentOrderEntity.getOutPatientId());
        refundOrderVoReq.setDealTradeNo(opRechargePaymentOrderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(opBusinessOrderEntity.getMoney());
        refundOrderVoReq.setRefundAmount(opRechargePaymentOrderEntity.getDealMoney());
        refundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        refundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        refundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getOutpatientRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)refundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        refundOrderVoReq.setSign(sign);
        log.info("RefundServiceImpl.refund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("RefundServiceImpl.refund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        return baseResponse;
    }

    private void checkInHospitalRefundRequestParams(RefundReqVO body, InpatientDepositDetailEntity inpatientDepositDetailEntity, InpatientPayorderEntity inpatientPayorderEntity) throws OutreachException {
        if (StringUtils.isBlank((String)body.getRefundFee())) {
            log.error(REFUND_AMOUNT_NULL);
            throw new OutreachException(REFUND_AMOUNTS);
        }
        BigDecimal regFee = BigDecimal.ZERO;
        try {
            regFee = new BigDecimal(body.getRefundFee());
        }
        catch (NumberFormatException e) {
            log.error("RefundServiceImpl.checkInHospiatlParams->\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5!,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)body.getRefundFee());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        BigDecimal dealMoney = inpatientPayorderEntity.getDealMoney();
        if (dealMoney.compareTo(regFee) < 0) {
            log.error("RefundServiceImpl.checkInHospitalParams->\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)regFee.toString());
            throw new OutreachException(REFUND_AMOUNTS_FAIL);
        }
        String payChannel = inpatientPayorderEntity.getPaymentSeq();
        if (StringUtils.isBlank((String)body.getPayChannel())) {
            log.error(PAY_CHANNL_NULL);
            throw new OutreachException(PAY_CHANNL);
        }
        if (!body.getPayChannel().trim().equals(payChannel)) {
            log.error("RefundServiceImpl.checkInHospitalParams->\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u652f\u4ed8\u6e20\u9053\u53c2\u6570\u4e3a:{}", (Object)body.getPayChannel());
            throw new OutreachException(PAY_CHANNL_MISMATCH);
        }
    }

    private BaseResponse<String> inHospitalPaymentRefund(InpatientDepositDetailEntity inpatientDepositDetailEntity, InpatientPayorderEntity inpatientPayorderEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        RequestRefundOrderVoReq refundOrderVoReq = new RequestRefundOrderVoReq();
        refundOrderVoReq.setPayChannel(inpatientPayorderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        refundOrderVoReq.setOutTradeNo(String.valueOf(this.snowflakeIdWorker.nextId()));
        refundOrderVoReq.setDealTradeNo(inpatientPayorderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(inpatientDepositDetailEntity.getMoney());
        refundOrderVoReq.setRefundAmount(inpatientPayorderEntity.getDealMoney());
        refundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        refundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        refundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getInHospitalRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)refundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        refundOrderVoReq.setSign(sign);
        log.info("inHospitalPaymentRefund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("inHospitalPaymentRefund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        return baseResponse;
    }

    private BaseResponse<String> inHospitalPaymentRefundNew(InpatientDepositDetailEntity inpatientDepositDetailEntity, InpatientPayorderEntity inpatientPayorderEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity, RefundReq withdrawNumberVoReq) {
        RequestRefundOrderVoReq refundOrderVoReq = new RequestRefundOrderVoReq();
        refundOrderVoReq.setPayChannel(inpatientPayorderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        refundOrderVoReq.setOutTradeNo(String.valueOf(this.snowflakeIdWorker.nextId()));
        refundOrderVoReq.setDealTradeNo(inpatientPayorderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(inpatientDepositDetailEntity.getMoney());
        refundOrderVoReq.setRefundAmount(new BigDecimal(withdrawNumberVoReq.getRefundMoney()));
        refundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        refundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        refundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getInHospitalRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)refundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        refundOrderVoReq.setSign(sign);
        log.info("inHospitalPaymentRefund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("inHospitalPaymentRefund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        return baseResponse;
    }
}

