/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.ebaiyihui.api.ScheduleClient;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.medical.GNAdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.gateway.RouteEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryRelationMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DeptCategoryRelationEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetScheduleDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.DayDoctorScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetNewDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetNewDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RecommendedDoctorInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleStatusResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.TimeArrangeVoReq;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.base.GatewayRequest;
import his.pojo.vo.base.GatewayResponse;
import his.pojo.vo.nucleic.NucleicAcidScheduleRes;
import his.pojo.vo.nucleic.NucleicAcidScheduleVO;
import his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import his.pojo.vo.schedule.GetScheduleReqVO;
import his.pojo.vo.schedule.GetScheduleResVO;
import his.pojo.vo.schedule.TimeArrangeReq;
import his.pojo.vo.schedule.TimeArrangeRes;
import his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import his.pojo.vo.schedule.items.GetScheduleResItems;
import his.pojo.vo.schedule.items.TimeArrangeItems;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private ScheduleClient scheduleClient;
    @Resource
    private DeptCategoryRelationMapper deptCategoryRelationMapper;
    private static final String HIS_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94";
    private static final String HIS_QUERY_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}";
    private static final String HIS_SCHEDULE_QUERY_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38";
    private static final String HIS_SCHEDULE_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f";
    private static final String NOT_SCHEDULE = "\u6682\u65e0\u6392\u73ed\u4fe1\u606f";
    private static final String GET_SCHEDULE = "getSchedule";

    public List<GetScheduleVoRes> getSchedule(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        FrontResponse deptDoctorInfo = null;
        if (getScheduleVoReq.getHl().equals("2")) {
            FrontRequest getDeptDoctorInfoReqVOFrontRequest = this.buildGetDeptDoctorInfoReqVO(getScheduleVoReq);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u533b\u751f\u6392\u73ed\u4fe1\u606f\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)getDeptDoctorInfoReqVOFrontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            deptDoctorInfo = this.scheduleClient.getDeptDoctorInfo(getDeptDoctorInfoReqVOFrontRequest);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u533b\u751f\u6392\u73ed\u4fe1\u606f\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)deptDoctorInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (!"1".equals(deptDoctorInfo.getCode())) {
                log.error("\u83b7\u53d6\u533b\u751f\u6392\u73ed\u4fe1\u606f\u51fa\u9519");
                return new ArrayList<GetScheduleVoRes>();
            }
        }
        FrontRequest getScheduleReqVOFrontRequest = this.buildGetScheduleReqVO(getScheduleVoReq, deptDoctorInfo);
        log.info("\u8bf7\u6c42his\u83b7\u53d6\u533b\u751f\u5206\u65f6\u6bb5\u6392\u73ed\u4fe1\u606f\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)getScheduleReqVOFrontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse schedule = this.scheduleClient.getSchedule(getScheduleReqVOFrontRequest);
        log.info("\u8bf7\u6c42his\u83b7\u53d6\u533b\u751f\u5206\u65f6\u6bb5\u6392\u73ed\u4fe1\u606f\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)schedule, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!"1".equals(schedule.getCode())) {
            log.error("\u83b7\u53d6\u533b\u751f\u5206\u65f6\u6bb5\u6392\u73ed\u4fe1\u606f\u51fa\u9519");
            return new ArrayList<GetScheduleVoRes>();
        }
        List getScheduleVoRes = this.assembleGetScheduleVoResList(schedule, deptDoctorInfo, getScheduleVoReq);
        return getScheduleVoRes;
    }

    private List<GetScheduleVoRes> assembleGetScheduleVoResList(FrontResponse<GetScheduleResVO> schedule, FrontResponse<GetDeptDoctorInfoResVO> deptDoctorInfo, GetScheduleVoReq getScheduleVoReq) {
        ArrayList<GetScheduleVoRes> getScheduleVoResArrayList = new ArrayList<GetScheduleVoRes>();
        ArrayList scheduleBaseInfoVoList = new ArrayList();
        GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
        ((GetScheduleResVO)schedule.getBody()).getItems().forEach(item -> {
            if (null != deptDoctorInfo) {
                List collect = ((GetDeptDoctorInfoResVO)deptDoctorInfo.getBody()).getItems().stream().filter(e -> e.getDeptCode().equals(item.getLocCode())).collect(Collectors.toList());
                getScheduleVoRes.setDocCode(collect.size() == 0 ? null : ((GetDeptDoctorInfoResItems)collect.get(0)).getDoctorCode());
                getScheduleVoRes.setDocName(collect.size() == 0 ? null : ((GetDeptDoctorInfoResItems)collect.get(0)).getDoctorDesc());
            }
            getScheduleVoRes.setLocCode(item.getLocCode());
            getScheduleVoRes.setLocName(item.getLocName());
            getScheduleVoRes.setAdmLocation(item.getAdmLocation());
            getScheduleVoRes.setRegTitleCode(item.getRegTitleCode());
            getScheduleVoRes.setRegTitleName(item.getRegTitleName());
            ScheduleBaseInfoVo gScheduleBaseInfoVo = new ScheduleBaseInfoVo();
            gScheduleBaseInfoVo.setScheduleId(item.getScheduleId());
            gScheduleBaseInfoVo.setScheduleType(item.getScheduleType());
            gScheduleBaseInfoVo.setAdmDate(item.getAdmDate());
            gScheduleBaseInfoVo.setAdmTimeRange(item.getAdmTimeRange());
            gScheduleBaseInfoVo.setRegFee(item.getRegFee());
            gScheduleBaseInfoVo.setDiagFee(item.getDiagFee());
            gScheduleBaseInfoVo.setIsAppend(item.getIsAppend());
            gScheduleBaseInfoVo.setLocTypeCode(getScheduleVoReq.getHl());
            gScheduleBaseInfoVo.setRegAvailable(item.getRegAvailable());
            gScheduleBaseInfoVo.setRegTotal(item.getRegTotal());
            gScheduleBaseInfoVo.setAppStartNo(item.getAppStartNo());
            gScheduleBaseInfoVo.setScheduleStatus(item.getScheduleStatus());
            gScheduleBaseInfoVo.setIsTimeArrange(item.getIsTimeArrange());
            ArrayList timeArrangeItemsList = new ArrayList();
            item.getTimeArrangeItems().forEach(item1 -> {
                TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
                timeArrangeItems.setSessionName(item1.getSessionName());
                timeArrangeItems.setSessionCode(item1.getSessionCode());
                timeArrangeItems.setWeekDay(item1.getWeekDay());
                timeArrangeItems.setEndNo(item1.getEndNo());
                timeArrangeItems.setStartTime(item1.getStartTime());
                timeArrangeItems.setEndTime(item1.getEndTime());
                timeArrangeItems.setTimeRangeSeqNo(item1.getTimeRangeSeqNo());
                timeArrangeItems.setScheduleItemCode(item1.getScheduleItemCode());
                timeArrangeItems.setAvailableTotalNum(item1.getAvailableTotalNum());
                timeArrangeItems.setAvailableLeftNum(item1.getAvailableLeftNum());
                if (getScheduleVoReq.getStartDate().equals(DateUtil.today())) {
                    boolean b = ScheduleServiceImpl.compTime((String)timeArrangeItems.getEndTime(), (String)DateUtil.format((Date)DateUtil.date(), (String)"HH:mm:ss"));
                    if (b) {
                        log.info("\u5165\u53c2\u65f6\u95f4{},\u5f53\u5929\u65f6\u95f4{}", (Object)getScheduleVoReq.getStartDate(), (Object)DateUtil.today());
                        timeArrangeItemsList.add(timeArrangeItems);
                    }
                } else {
                    timeArrangeItemsList.add(timeArrangeItems);
                }
            });
            gScheduleBaseInfoVo.setTimeArrangeItems(timeArrangeItemsList);
            scheduleBaseInfoVoList.add(gScheduleBaseInfoVo);
            getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
        });
        getScheduleVoResArrayList.add(getScheduleVoRes);
        return getScheduleVoResArrayList;
    }

    public static void main(String[] args) {
        boolean b = ScheduleServiceImpl.compTime((String)"15:44:00", (String)DateUtil.format((Date)DateUtil.date(), (String)"HH:mm:ss"));
        System.out.println(b);
    }

    public static boolean compTime(String s1, String s2) {
        try {
            if (s1.indexOf(":") >= 0 && s1.indexOf(":") >= 0) {
                String[] array2;
                int total2;
                String[] array1 = s1.split(":");
                int total1 = Integer.valueOf(array1[0]) * 3600 + Integer.valueOf(array1[1]) * 60 + Integer.valueOf(array1[2]);
                return total1 - (total2 = Integer.valueOf((array2 = s2.split(":"))[0]) * 3600 + Integer.valueOf(array2[1]) * 60 + Integer.valueOf(array2[2])) > 0;
            }
            System.out.println("\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    private FrontRequest<GetScheduleReqVO> buildGetScheduleReqVO(GetScheduleVoReq getScheduleVoReq, FrontResponse<GetDeptDoctorInfoResVO> getDeptDoctorInfoResVO) {
        FrontRequest frontRequest = new FrontRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        if (!BeanUtil.isEmpty(getDeptDoctorInfoResVO, (String[])new String[0])) {
            List collect = ((GetDeptDoctorInfoResVO)getDeptDoctorInfoResVO.getBody()).getItems().stream().filter(e -> e.getDeptCode().equals(getScheduleVoReq.getDeptCode())).collect(Collectors.toList());
            getScheduleReqVO.setDocCode(((GetDeptDoctorInfoResItems)collect.get(0)).getDoctorCode());
        }
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode("01");
        getScheduleReqVO.setTypeId(getScheduleVoReq.getHl());
        getScheduleReqVO.setClinicLabel(getScheduleVoReq.getDeptName());
        getScheduleReqVO.setRequestPage("1");
        getScheduleReqVO.setPageSize("50");
        getScheduleReqVO.setOrderId("1");
        if (DateUtil.today().equals(getScheduleVoReq.getStartDate())) {
            getScheduleReqVO.setOrderId("0");
        }
        getScheduleReqVO.setBgDate(DateUtil.format((Date)DateUtil.parse((CharSequence)getScheduleVoReq.getStartDate()), (String)"yyyyMMdd"));
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)getScheduleReqVO);
        return frontRequest;
    }

    private FrontRequest<GetDeptDoctorInfoReqVO> buildGetDeptDoctorInfoReqVO(GetScheduleVoReq getScheduleVoReq) {
        FrontRequest frontRequest = new FrontRequest();
        GetDeptDoctorInfoReqVO getScheduleVoRes = new GetDeptDoctorInfoReqVO();
        getScheduleVoRes.setDeptCode(getScheduleVoReq.getDeptCode());
        getScheduleVoRes.setSchedulingType("01");
        getScheduleVoRes.setTypeId(getScheduleVoReq.getHl());
        getScheduleVoRes.setRequestPage("1");
        getScheduleVoRes.setPageSize("50");
        getScheduleVoRes.setOrderId("1");
        if (DateUtil.today().equals(getScheduleVoReq.getStartDate())) {
            getScheduleVoRes.setOrderId("0");
        }
        getScheduleVoRes.setSchedulingDate(DateUtil.format((Date)DateUtil.parse((CharSequence)getScheduleVoReq.getStartDate()), (String)"yyyyMMdd"));
        frontRequest.setBody((Object)getScheduleVoRes);
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    public GetDoctorScheduleVoRes getDoctorSchedule(GetDoctorScheduleVoReq getDoctorScheduleVoReq) throws ScheduleException {
        String theDay = DateUtils.getCurrentDateToString();
        List<Object> scheduleResItemsList = new ArrayList();
        for (int i = 0; i < 7; ++i) {
            getDoctorScheduleVoReq.setStartDate(theDay);
            getDoctorScheduleVoReq.setEndDate(theDay);
            GatewayRequest gatewayRequest = this.buildGetDoctorScheduleGatewayReq(getDoctorScheduleVoReq);
            List itemsList = this.getDocSchedule(gatewayRequest);
            theDay = DateUtils.getNextDayToString((String)theDay);
            if (CollectionUtils.isEmpty((Collection)itemsList)) continue;
            scheduleResItemsList.addAll(itemsList);
        }
        if (CollectionUtils.isEmpty(scheduleResItemsList = scheduleResItemsList.stream().map(getScheduleResItems -> {
            getScheduleResItems.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate())));
            return getScheduleResItems;
        }).collect(Collectors.toList()))) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        GetDoctorScheduleVoRes getDoctorScheduleVoRes = new GetDoctorScheduleVoRes();
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
        getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
        getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
        getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
        getDoctorScheduleVoRes.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
        getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleResItems.getAdmDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(GNAdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(GNAdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemsMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getAdmDate));
        ArrayList dayDoctorScheduleVoList = new ArrayList();
        List<String> admDateList = getScheduleResItemsMap.keySet().stream().map(amdDate -> amdDate).collect(Collectors.toList());
        admDateList.sort(Comparator.comparing(admDate -> admDate));
        admDateList.forEach(amdDate -> {
            DayDoctorScheduleVo dayDoctorScheduleVo = new DayDoctorScheduleVo();
            List getScheduleResItems = (List)getScheduleResItemsMap.get(amdDate);
            List scheduleBaseInfoVoList = getScheduleResItems.stream().map(getScheduleRes -> this.buildScheduleBaseInfoVo(getScheduleRes)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            dayDoctorScheduleVo.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            dayDoctorScheduleVoList.add(dayDoctorScheduleVo);
        });
        getDoctorScheduleVoRes.setDayDoctorScheduleVoList(dayDoctorScheduleVoList);
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordByDoctorCodeAndHosCode(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        Long docId = 0L;
        if (null != doctorRecordEntity && StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
            docId = Long.valueOf(doctorRecordEntity.getDoctorId());
        }
        getDoctorScheduleVoRes.setDoctorId(docId);
        DoctorBaseInfoDTO doctorBaseInfoDTO = this.getDoctorInfoUtil.getDoctorInfo(docId, getDoctorScheduleVoReq.getOrganId());
        if (doctorBaseInfoDTO != null) {
            getDoctorScheduleVoRes.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
            getDoctorScheduleVoRes.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
            getDoctorScheduleVoRes.setDoctorIntroduce(doctorBaseInfoDTO.getIntroduction());
            getDoctorScheduleVoRes.setDoctorScore(5.0);
            getDoctorScheduleVoRes.setCommentOfDoctorRes(null);
        }
        Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        getDoctorScheduleVoRes.setAppointmentCount(appointmentCount);
        List scheduleRecordEntityList = this.scheduleRecordMapper.selectRecommendedDoctor(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getDeptCode(), getDoctorScheduleVoReq.getOrganCode());
        if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
            List doctorCodeList = scheduleRecordEntityList.stream().map(ScheduleRecordEntity::getDocCode).collect(Collectors.toList());
            List doctorRecordEntityList = this.doctorService.getDoctorIdList(doctorCodeList, getDoctorScheduleVoReq.getOrganCode());
            List doctorIdList = doctorRecordEntityList.stream().map(doctorRecord -> {
                if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                    return Long.valueOf(doctorRecordEntity.getDoctorId());
                }
                return 0L;
            }).collect(Collectors.toList());
            Map<String, String> doctorMap = doctorRecordEntityList.stream().collect(Collectors.toMap(DoctorRecordEntity::getDocCode, DoctorRecordEntity::getDoctorId));
            List doctorBaseInfoDTOList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), doctorIdList);
            Map<String, DoctorBaseInfoDTO> doctorBaseInfoDTOMap = doctorBaseInfoDTOList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfoDTO.getXId().toString(), doctorBaseInfo -> doctorBaseInfo));
            List doctorIds = doctorBaseInfoDTOList.stream().map(DoctorBaseInfoDTO::getXId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
                List recommendedDoctorInfoVoList = scheduleRecordEntityList.stream().map(scheduleRecordEntity -> {
                    RecommendedDoctorInfoVo recommendedDoctorInfoVo = new RecommendedDoctorInfoVo();
                    recommendedDoctorInfoVo.setDeptCode(scheduleRecordEntity.getDeptCode());
                    recommendedDoctorInfoVo.setDeptName(scheduleRecordEntity.getDeptName());
                    recommendedDoctorInfoVo.setDoctorCode(scheduleRecordEntity.getDocCode());
                    recommendedDoctorInfoVo.setDoctorName(scheduleRecordEntity.getDocName());
                    recommendedDoctorInfoVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
                    String doctorId = (String)doctorMap.get(scheduleRecordEntity.getDocCode());
                    DoctorBaseInfoDTO doctorBaseInfo = (DoctorBaseInfoDTO)doctorBaseInfoDTOMap.get(doctorId);
                    if (doctorBaseInfo != null) {
                        recommendedDoctorInfoVo.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
                        recommendedDoctorInfoVo.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
                        recommendedDoctorInfoVo.setDoctorGender(String.valueOf(doctorBaseInfoDTO.getGender()));
                        recommendedDoctorInfoVo.setDoctorScore(new Double(5.0));
                    }
                    Integer count = this.appointmentRecordMapper.selectDoctorAppointmentCount(scheduleRecordEntity.getDocCode(), scheduleRecordEntity.getHospitalCode());
                    recommendedDoctorInfoVo.setAppointmentCount(count);
                    return recommendedDoctorInfoVo;
                }).collect(Collectors.toList());
                getDoctorScheduleVoRes.setRecommendedDoctorInfoVoList(recommendedDoctorInfoVoList);
            }
        }
        return getDoctorScheduleVoRes;
    }

    public List<ScheduleStatusResVO> getScheduleStatus(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        return null;
    }

    public List<ScheduleStatusResVO> getAcidScheduleStatus(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        return null;
    }

    public List<ScheduleStatusResVO> schduleIsnull() {
        ArrayList<ScheduleStatusResVO> list = new ArrayList<ScheduleStatusResVO>();
        String admDate = DateUtils.getCurrentDateSimpleToString();
        for (int i = 0; i < 7; ++i) {
            ScheduleStatusResVO scheduleStatusResVO = new ScheduleStatusResVO();
            scheduleStatusResVO.setStatus("-1");
            scheduleStatusResVO.setAdmDate(admDate);
            if (admDate.equals(DateUtils.getCurrentDateSimpleToString())) {
                scheduleStatusResVO.setWeek("\u4eca\u5929");
            } else {
                scheduleStatusResVO.setWeek(DateUtils.getWeekSimpleChinese((String)admDate));
            }
            scheduleStatusResVO.setViewDate(admDate.replace("-", ".").substring(5));
            list.add(scheduleStatusResVO);
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
        return list;
    }

    private GetScheduleResVO getSchduleStatusNew(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u83b7\u53d6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        log.info("\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return (GetScheduleResVO)gatewayResponse.getData();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return (GetScheduleResVO)gatewayResponse.getData();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return (GetScheduleResVO)gatewayResponse.getData();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return getScheduleResVO;
        }
        return getScheduleResVO;
    }

    private ScheduleBaseInfoVo buildScheduleBaseInfoVo(GetScheduleResItems scheduleResItem) {
        log.info("\u7ec4\u88c5\u4fe1\u606f----->{}", (Object)scheduleResItem);
        ScheduleBaseInfoVo scheduleBaseInfoVo = new ScheduleBaseInfoVo();
        scheduleBaseInfoVo.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)scheduleResItem.getAdmDate())));
        scheduleBaseInfoVo.setAdmTimeRange(scheduleResItem.getAdmTimeRange());
        scheduleBaseInfoVo.setAppStartNo(scheduleResItem.getAppStartNo());
        scheduleBaseInfoVo.setIsTimeArrange(scheduleResItem.getIsTimeArrange());
        scheduleBaseInfoVo.setLocTypeCode(scheduleResItem.getLocTypeCode());
        scheduleBaseInfoVo.setLocTypeName(scheduleResItem.getLocTypeName());
        scheduleBaseInfoVo.setRegAvailable(scheduleResItem.getRegAvailable());
        scheduleBaseInfoVo.setRegFee(String.valueOf(new BigDecimal(scheduleResItem.getRegFee()).doubleValue()));
        scheduleBaseInfoVo.setDiagFee(scheduleResItem.getDiagFee());
        BigDecimal totalFee = new BigDecimal(scheduleResItem.getRegFee()).add(new BigDecimal(scheduleResItem.getDiagFee()));
        scheduleBaseInfoVo.setTotalFee(String.valueOf(totalFee.doubleValue()));
        scheduleBaseInfoVo.setReplaceScheduleId(scheduleResItem.getReplaceScheduleId());
        scheduleBaseInfoVo.setScheduleId(scheduleResItem.getScheduleId());
        scheduleBaseInfoVo.setScheduleLevelCode(scheduleResItem.getScheduleLevelCode());
        scheduleBaseInfoVo.setScheduleLevelName(scheduleResItem.getRegTitleName());
        scheduleBaseInfoVo.setScheduleStatus(scheduleResItem.getScheduleStatus());
        scheduleBaseInfoVo.setScheduleType(scheduleResItem.getScheduleType());
        String isAppend = scheduleResItem.getIsAppend();
        if (StringUtils.isEmpty((CharSequence)isAppend)) {
            isAppend = "0";
        }
        scheduleBaseInfoVo.setIsAppend(isAppend);
        ArrayList timeArrangeItemsList = scheduleResItem.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            timeArrangeItemsList = new ArrayList();
        }
        scheduleBaseInfoVo.setTimeArrangeItems((List)timeArrangeItemsList);
        return scheduleBaseInfoVo;
    }

    private List<DoctorBaseInfoDTO> getDoctorInfoList(String organId, List<Long> doctorIdList) throws ScheduleException {
        if (CollectionUtils.isEmpty(doctorIdList)) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a" + doctorIdList);
        List doctorBaseInfoDTOList = this.getDoctorInfoUtil.getDoctorInfoList(doctorIdList, organId);
        if (doctorBaseInfoDTOList == null) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        return doctorBaseInfoDTOList;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetDoctorScheduleGatewayReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildDaySchduleReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDaySchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GetScheduleResItems buildGetScheduleResItems(ScheduleRecordEntity scheduleRecordEntity, List<TimeArrangeItems> timeArrangeItemsList) {
        GetScheduleResItems scheduleResItems = new GetScheduleResItems();
        scheduleResItems.setScheduleId(scheduleRecordEntity.getScheduleHisId());
        scheduleResItems.setScheduleType(Integer.valueOf(scheduleRecordEntity.getScheduleType().intValue()));
        scheduleResItems.setAdmDate(DateUtils.dateToString((Date)scheduleRecordEntity.getScheduleDate(), (String)"yyyy-MM-dd"));
        scheduleResItems.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
        scheduleResItems.setHospitalArea(scheduleRecordEntity.getHospitalAreaName());
        scheduleResItems.setHospitalAreaCode(scheduleRecordEntity.getHospitalArea());
        scheduleResItems.setDocCode(scheduleRecordEntity.getDocCode());
        scheduleResItems.setDocName(scheduleRecordEntity.getDocName());
        scheduleResItems.setLocCode(scheduleRecordEntity.getDeptCode());
        scheduleResItems.setLocName(scheduleRecordEntity.getDeptName());
        scheduleResItems.setRegFee(scheduleRecordEntity.getRegFee().toString());
        scheduleResItems.setRegTitleCode(scheduleRecordEntity.getRegTitelCode());
        scheduleResItems.setRegTitleName(scheduleRecordEntity.getRegTitelName());
        scheduleResItems.setScheduleLevelCode(scheduleRecordEntity.getScheduleLevelCode());
        scheduleResItems.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
        scheduleResItems.setLocTypeCode(scheduleRecordEntity.getDeptCategoryCode());
        scheduleResItems.setLocTypeName(scheduleRecordEntity.getDeptCategoryName());
        scheduleResItems.setAdmLocation(scheduleRecordEntity.getAdmLocation());
        scheduleResItems.setRegAvailable(scheduleRecordEntity.getAvailableCount());
        scheduleResItems.setRegTotal(scheduleRecordEntity.getTotalCount());
        scheduleResItems.setAppStartNo(String.valueOf(scheduleRecordEntity.getStartNo()));
        scheduleResItems.setScheduleStatus(scheduleRecordEntity.getStatus().toString());
        scheduleResItems.setReplaceScheduleId(scheduleRecordEntity.getReplaceScheduleHisId());
        scheduleResItems.setIsTimeArrange(Integer.valueOf(scheduleRecordEntity.getIsPrecise().intValue()));
        scheduleResItems.setDiagFee(scheduleRecordEntity.getDiagFee().toString());
        scheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
        return scheduleResItems;
    }

    private List<TimeArrangeItems> buildTimeArrangeItems(List<ScheduleDetailRecordEntity> scheduleDetailRecordList) {
        List<TimeArrangeItems> TimeArrangeItemList = scheduleDetailRecordList.stream().map(scheduleDetailRecordEntity -> {
            TimeArrangeItems getTimeArrangeItems = new TimeArrangeItems();
            getTimeArrangeItems.setEndNo(scheduleDetailRecordEntity.getEndNo());
            getTimeArrangeItems.setStartTime(scheduleDetailRecordEntity.getStartTime());
            getTimeArrangeItems.setEndTime(scheduleDetailRecordEntity.getEndTime());
            return getTimeArrangeItems;
        }).collect(Collectors.toList());
        return TimeArrangeItemList;
    }

    private List<ScheduleRecordEntity> getScheduleByScheduleDTO(GetScheduleDTO getScheduleDTO) {
        return this.scheduleRecordMapper.selectByGetScheduleDTO(getScheduleDTO);
    }

    private List<ScheduleDetailRecordEntity> getScheduleDetailRecord(String hisScheduleId, String organCode) {
        return this.scheduleDetailRecordMapper.selectByHisScheduleId(hisScheduleId, organCode);
    }

    private List<GetScheduleResItems> getScheduleResItemsList(GetScheduleDTO getScheduleDTO) {
        List recordEntityList = this.getScheduleByScheduleDTO(getScheduleDTO);
        List filterRecordEntityList = recordEntityList.stream().filter(scheduleRecordEntity -> scheduleRecordEntity.getRegFee().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        List<GetScheduleResItems> scheduleResItemsList = filterRecordEntityList.stream().map(scheduleRecordEntity -> {
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            List scheduleDetailRecordList = this.getScheduleDetailRecord(scheduleRecordEntity.getScheduleHisId(), scheduleRecordEntity.getHospitalCode());
            List TimeArrangeItems2 = this.buildTimeArrangeItems(scheduleDetailRecordList);
            getScheduleResItems = this.buildGetScheduleResItems(scheduleRecordEntity, TimeArrangeItems2);
            return getScheduleResItems;
        }).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u6392\u73ed\u4fe1\u606f \uff1a{}", (Object)JSON.toJSONString(scheduleResItemsList));
        return scheduleResItemsList;
    }

    private List<GetScheduleResItems> getDocSchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38", (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f", (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDocCode().equals(((GetScheduleReqVO)gatewayRequest.getBody()).getDocCode())).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + getScheduleResItemsList);
        return getScheduleResItemsList;
    }

    private boolean getSchduleStatus(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u83b7\u53d6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        log.info("\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return false;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return false;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return false;
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return false;
        }
        return true;
    }

    public List<GetNewDoctorScheduleVoRes> getNewDoctorSchedule(GetNewDoctorScheduleVoReq getScheduleVoReq) throws ScheduleException, ParseException {
        List deptCategoryRelationEntities = this.deptCategoryRelationMapper.selectDeptCodeByDocId(getScheduleVoReq.getDeptCode());
        ArrayList<GetNewDoctorScheduleVoRes> getScheduleList = new ArrayList<GetNewDoctorScheduleVoRes>();
        ArrayList<GetNewDoctorScheduleVoRes> getScheduleListVO = new ArrayList<GetNewDoctorScheduleVoRes>();
        HashMap<String, GetNewDoctorScheduleVoRes> getNewDoctorScheduleVoResMap = new HashMap<String, GetNewDoctorScheduleVoRes>();
        for (DeptCategoryRelationEntity deptCategoryRelationEntity : deptCategoryRelationEntities) {
            getScheduleVoReq.setDeptCode(deptCategoryRelationEntity.getDeptCode());
            for (int i = 0; i < 7; ++i) {
                Date dateAfter = DateUtils.getAfterCurrentDay((int)i);
                getScheduleVoReq.setStartDate(new SimpleDateFormat("yyyy-MM-dd").format(dateAfter));
                getScheduleVoReq.setEndDate(new SimpleDateFormat("yyyy-MM-dd").format(dateAfter));
                GatewayRequest gatewayRequest = this.buildNewGetScheduleGatewayReq(getScheduleVoReq);
                GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
                if (gatewayResponse == null) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
                    continue;
                }
                if (!"1".equals(gatewayResponse.getCode())) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
                    continue;
                }
                if (gatewayResponse.getData() == null) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
                    continue;
                }
                List scheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
                if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
                    continue;
                }
                if (CollectionUtils.isEmpty(scheduleResItemsList = scheduleResItemsList.stream().map(getScheduleResItems -> {
                    getScheduleResItems.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate())));
                    return getScheduleResItems;
                }).collect(Collectors.toList()))) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
                    continue;
                }
                GetNewDoctorScheduleVoRes getDoctorScheduleVoRes = new GetNewDoctorScheduleVoRes();
                GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
                getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
                getDoctorScheduleVoRes.setDoctorId(getScheduleVoReq.getDoctorCode());
                getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
                getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
                getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
                getDoctorScheduleVoRes.setDeptCode(getScheduleVoReq.getDeptCode());
                getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
                getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
                List scheduleBaseInfoVoList = scheduleResItemsList.stream().map(arg_0 -> this.buildScheduleBaseInfoVo(arg_0)).collect(Collectors.toList());
                getDoctorScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
                getScheduleList.add(getDoctorScheduleVoRes);
            }
        }
        for (GetNewDoctorScheduleVoRes getNewDoctorScheduleVoRes : getScheduleList) {
            if (getNewDoctorScheduleVoResMap.containsKey(getNewDoctorScheduleVoRes.getDocCode())) {
                GetNewDoctorScheduleVoRes getNewDoctorScheduleVoRes1 = (GetNewDoctorScheduleVoRes)getNewDoctorScheduleVoResMap.get(getNewDoctorScheduleVoRes.getDocCode());
                getNewDoctorScheduleVoRes1.getScheduleBaseInfoVoList().addAll(getNewDoctorScheduleVoRes.getScheduleBaseInfoVoList());
                getNewDoctorScheduleVoResMap.put(getNewDoctorScheduleVoRes.getDocCode(), getNewDoctorScheduleVoRes1);
                continue;
            }
            getNewDoctorScheduleVoResMap.put(getNewDoctorScheduleVoRes.getDocCode(), getNewDoctorScheduleVoRes);
        }
        getNewDoctorScheduleVoResMap.forEach((key, value) -> getScheduleListVO.add((GetNewDoctorScheduleVoRes)value));
        return getScheduleListVO;
    }

    private GatewayRequest<GetScheduleReqVO> buildNewGetScheduleGatewayReq(GetNewDoctorScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public TimeArrangeRes getScheduleTimeArrange(TimeArrangeVoReq timeArrangeVoReq) {
        GatewayRequest gatewayRequest = this.buildTimeArrangeVoReqGatewayReq(timeArrangeVoReq);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_TIME_INFO.getValue(), gatewayRequest, TimeArrangeRes.class);
        TimeArrangeRes data = (TimeArrangeRes)gatewayResponse.getData();
        return data;
    }

    public NucleicAcidScheduleRes GetNucleicAcidSchedule(NucleicAcidScheduleVO param) {
        log.info("\u8bf7\u6c42his\u83b7\u53d6\u6838\u9178\u6392\u7248\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        NucleicAcidScheduleRes nucleicAcidScheduleRes = this.scheduleClient.GetNucleicAcidSchedule(param);
        log.info("\u8bf7\u6c42his\u83b7\u53d6\u6838\u9178\u6392\u7248\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)nucleicAcidScheduleRes, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return nucleicAcidScheduleRes;
    }

    private GatewayRequest<TimeArrangeReq> buildTimeArrangeVoReqGatewayReq(TimeArrangeVoReq timeArrangeVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        TimeArrangeReq timeArrangeReq = new TimeArrangeReq();
        timeArrangeReq.setServiceDate(timeArrangeVoReq.getRegDate());
        timeArrangeReq.setScheduleItemCode(timeArrangeVoReq.getScheduleId());
        gatewayRequest.setBody((Object)timeArrangeReq);
        gatewayRequest.setChannelName(timeArrangeVoReq.getChannelName());
        gatewayRequest.setChannel(timeArrangeVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("timeArrangeReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }
}

