/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.task;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.push.enums.MedicalPushOrderStatusEnum;
import com.ebaiyihui.push.pojo.miniapp.AlibabaMedicalPushReqVO;
import com.ebaiyihui.push.pojo.miniapp.RegistrationPushReqVo;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class AppointmentMessagesClosedTask {
    private static final Logger log = LoggerFactory.getLogger(AppointmentMessagesClosedTask.class);
    @Autowired
    AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    ProPropertiesConstant propertiesConstant;

    @Scheduled(cron="0 0 12 * * ?")
    public void orderCloseAm() throws Exception {
        List appointmentRecordEntities = this.appointmentRecordMapper.selectDayOrderByTakeTime(7, 12, DateUtil.today());
        for (AppointmentRecordEntity appointmentRecordEntity : appointmentRecordEntities) {
            appointmentRecordEntity.setScheduleLevelName("7");
            this.appointmentCancelMsgPush(appointmentRecordEntity);
        }
    }

    @Scheduled(cron="0 0 18 * * ?")
    public void orderClosePm() throws Exception {
        List appointmentRecordEntities = this.appointmentRecordMapper.selectDayOrderByTakeTime(13, 18, DateUtil.today());
        for (AppointmentRecordEntity appointmentRecordEntity : appointmentRecordEntities) {
            appointmentRecordEntity.setScheduleLevelName("7");
            this.appointmentCancelMsgPush(appointmentRecordEntity);
        }
    }

    private void appointmentCancelMsgPush(AppointmentRecordEntity appointmentRecordEntity) {
        log.info("appointmentRecordEntity->{}", (Object)JSON.toJSONString((Object)appointmentRecordEntity));
        RegistrationPushReqVo registrationPushReqVo = new RegistrationPushReqVo();
        AlibabaMedicalPushReqVO alibabaMedicalPushReqVO = new AlibabaMedicalPushReqVO();
        alibabaMedicalPushReqVO.setData((Object)registrationPushReqVo);
        alibabaMedicalPushReqVO.setType("1");
        alibabaMedicalPushReqVO.setClientCode("ALI_JCSZXYY");
        alibabaMedicalPushReqVO.setOutBizNo(appointmentRecordEntity.getSysAppointmentId());
        String format1 = DateUtil.format((Date)appointmentRecordEntity.getCreatetime(), (String)"yyyy-MM-dd HH:mm:ss");
        log.info("\u8ba2\u5355\u521b\u5efa\u65f6\u95f4\u683c\u5f0f\u5316\u4e4b\u540e->{}", (Object)format1);
        alibabaMedicalPushReqVO.setOrderCreateTime(format1);
        log.info("\u63a8\u9001\u5bf9\u8c61set\u521b\u5efa\u65f6\u95f4\u4e4b\u540e\u5185\u5bb9->{}", (Object)alibabaMedicalPushReqVO.getOrderCreateTime());
        alibabaMedicalPushReqVO.setOrderModifiedTime(DateUtil.now());
        alibabaMedicalPushReqVO.setAmount("0.00");
        alibabaMedicalPushReqVO.setPayAmount("0.00");
        alibabaMedicalPushReqVO.setTradeNno(null);
        alibabaMedicalPushReqVO.setItemName(appointmentRecordEntity.getDocName());
        alibabaMedicalPushReqVO.setQuantity(1);
        alibabaMedicalPushReqVO.setSkuId(appointmentRecordEntity.getAppointmentId());
        alibabaMedicalPushReqVO.setUnitPrice("0.00");
        alibabaMedicalPushReqVO.setDepartment(appointmentRecordEntity.getDeptName());
        alibabaMedicalPushReqVO.setDeptNum(appointmentRecordEntity.getDeptCode());
        alibabaMedicalPushReqVO.setDeptLoc(appointmentRecordEntity.getDeptName());
        alibabaMedicalPushReqVO.setNavigation("alipays://platformapi/startapp?appId=2021003159636707");
        alibabaMedicalPushReqVO.setDoctor(appointmentRecordEntity.getDocName());
        alibabaMedicalPushReqVO.setDoctorRank(null);
        alibabaMedicalPushReqVO.setDoctorId(appointmentRecordEntity.getDocCode());
        alibabaMedicalPushReqVO.setDoctorAvatar(null);
        alibabaMedicalPushReqVO.setPatient(appointmentRecordEntity.getPatientName());
        String format = DateUtil.format((Date)DateUtil.parse((CharSequence)appointmentRecordEntity.getAdmDate(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        appointmentRecordEntity.setAdmDate(format + " " + (appointmentRecordEntity.getAdmTimeRange().split("-")[1].equals("23:59") ? "23:00" : appointmentRecordEntity.getAdmTimeRange().split("-")[1]));
        alibabaMedicalPushReqVO.setScheduledTime(appointmentRecordEntity.getAdmDate() + ":00");
        alibabaMedicalPushReqVO.setTakeNumUrl(null);
        alibabaMedicalPushReqVO.setTakeNumPassword(null);
        alibabaMedicalPushReqVO.setCallNumUrl(null);
        alibabaMedicalPushReqVO.setMedicalOrderId(appointmentRecordEntity.getSysAppointmentId());
        alibabaMedicalPushReqVO.setMedicalNum(appointmentRecordEntity.getAppointmentNo());
        alibabaMedicalPushReqVO.setMerchantOrderLinkPage("alipays://platformapi/startapp?appId=2021003159636707&page=wisdomTreatment%2Fpages%2Fregister%2FmyRegister%2Findex");
        alibabaMedicalPushReqVO.setMerchantOrderStatus(MedicalPushOrderStatusEnum.getDisplay((Integer)Convert.toInt((Object)appointmentRecordEntity.getScheduleLevelName())));
        log.info("alibabaMedicalPushReqVO->{}", (Object)JSON.toJSONString((Object)alibabaMedicalPushReqVO));
        log.info("\u6302\u53f7\u63a8\u9001\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)alibabaMedicalPushReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String post = HttpUtil.post((String)this.propertiesConstant.getSmartMdicalNewsPushUrl(), (String)JSON.toJSONString((Object)alibabaMedicalPushReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u63a8\u9001\u8fd4\u56de\u503c->{}", (Object)post);
    }
}

