/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.config;

import com.ebaiyihui.wisdommedical.service.ApiCommonService;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.Servlet;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebServicePublishConfig {
    @Resource
    private ApiCommonService apiCommonService;
    @Resource
    @Qualifier(value="cxf")
    private SpringBus bus;

    @Bean
    public ServletRegistrationBean wsServlet() {
        return new ServletRegistrationBean((Servlet)new CXFServlet(), new String[]{"/ws/*"});
    }

    @Bean
    public Endpoint[] endpoint() {
        ArrayList<EndpointImpl> endpointList = new ArrayList<EndpointImpl>();
        EndpointImpl endpoint = new EndpointImpl((Bus)this.bus, (Object)this.apiCommonService);
        String simpleName = this.apiCommonService.getClass().getSimpleName();
        if (simpleName.endsWith("Impl")) {
            simpleName = simpleName.substring(0, simpleName.length() - 4);
        }
        endpoint.publish("/" + simpleName);
        endpointList.add(endpoint);
        return endpointList.toArray(new Endpoint[0]);
    }
}

