/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DowOrderRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DowOutPatientOrderReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutPatientOrderRecordReqVo;
import com.ebaiyihui.wisdommedical.service.OrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ba2\u5355\u4e1a\u52a1api"})
@RequestMapping(value={"/api/v1/order"})
public class OrderRecordController {
    private static final Logger log = LoggerFactory.getLogger(OrderRecordController.class);
    @Autowired
    private OrderService orderService;

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868", notes="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/getAppointmentOrderList"})
    public BaseResponse<OrderRecordPageResult> getAppointmentOrderList(@Valid OrderRecordReqVo orderRecordReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OrderRecordPageResult pageResult = null;
        try {
            pageResult = this.orderService.getAppointmentOrderList(orderRecordReqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)pageResult);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868", notes="\u95e8\u8bca\u7f34\u8d39\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/getOutPatientOrderList"})
    public BaseResponse<OutPatientOrderRecordPageResult> getOutPatientOrderList(@Valid OutPatientOrderRecordReqVo orderRecordReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutPatientOrderRecordPageResult pageResult = null;
        try {
            pageResult = this.orderService.getOutPatientOrderList(orderRecordReqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)pageResult);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u8be6\u60c5\u5217\u8868", notes="\u95e8\u8bca\u7f34\u8d39\u8be6\u60c5\u5217\u8868")
    @GetMapping(value={"/getOutPatientOrderListDetail"})
    public BaseResponse<OutPatientOrderRecordVo> getOutPatientOrderListDetail(@RequestParam String outPatientId) {
        if (null == outPatientId || "".equals(outPatientId)) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutPatientOrderRecordVo outPatientOrderRecordVo = this.orderService.getOutPatientOrderDetail(outPatientId);
        return BaseResponse.success((Object)outPatientOrderRecordVo);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u95e8\u8bca\u7f34\u8d39\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868", notes="\u4e0b\u8f7d\u95e8\u8bca\u7f34\u8d39\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/dowOutPatientOrderList"})
    public void dowOutPatientOrderList(@RequestBody DowOutPatientOrderReqVo dowOutPatientOrderReqVo, HttpServletResponse response) throws IOException {
        this.orderService.dowOutPatientOrderList(dowOutPatientOrderReqVo);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6302\u53f7\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868", notes="\u4e0b\u8f7d\u6302\u53f7\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/dowRegisterOrderList"})
    public void dowRegisterOrderList(@RequestBody DowOrderRecordReqVo dowOrderRecordReqVo) throws IOException {
        this.orderService.dowRegisterOrderList(dowOrderRecordReqVo);
    }
}

