/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleStatusResVO;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.DoctorScheduleService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import his.pojo.vo.nucleic.nucleicAcidAppointmentRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6838\u9178\u9884\u7ea6api"})
@RequestMapping(value={"/api/v1/nucleicacid"})
public class NucleicAcidAppointmenController {
    private static final Logger log = LoggerFactory.getLogger(NucleicAcidAppointmenController.class);
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private DoctorScheduleService doctorScheduleService;
    @Autowired
    private AppointmentService appointmentService;
    private static final String DAY_APPOINT = "4";

    @ApiOperation(value="\u7528\u6237\u7aef\u53f7\u6e90\u6709\u65e0", notes="\u7528\u6237\u7aef\u53f7\u6e90\u6709\u65e0")
    @GetMapping(value={"/getScheduleStatus"})
    public BaseResponse<List<ScheduleStatusResVO>> getScheduleStatus(@Valid GetScheduleVoReq getScheduleVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List scheduleStatusRes = null;
        try {
            scheduleStatusRes = this.scheduleService.getScheduleStatus(getScheduleVoReq);
        }
        catch (ScheduleException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)scheduleStatusRes);
    }

    @ApiOperation(value="\u6838\u9178\u6302\u53f7\u521b\u5efa\u8ba2\u5355", notes="\u6838\u9178\u6302\u53f7\u521b\u5efa\u8ba2\u5355\u53ef\u7528")
    @PostMapping(value={"nucleicAppointmentCreateOrder"})
    public BaseResponse<String> nucleicAppointmentCreateOrder(@Valid @RequestBody DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        String sysAppointmentId = null;
        try {
            sysAppointmentId = this.appointmentService.nucleicAppointmentCreateOrder(dayAppointmentCreateOrderVoReq);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        catch (OutpatientPaymentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)sysAppointmentId);
    }

    @ApiOperation(value="\u6838\u9178\u9884\u7ea6\u6302\u53f7\u652f\u4ed8", notes="\u6838\u9178\u9884\u7ea6\u6302\u53f7\u652f\u4ed8")
    @PostMapping(value={"nucleicAppointmentPay"})
    public BaseResponse<nucleicAcidAppointmentRes> nucleicAppointmentPay(@RequestBody DayAppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        return null;
    }
}

