/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.wisdommedical.common.enums.MedicalAppointment.MedicalAppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.mapper.MedicalAppointmentInfoMapper;
import com.ebaiyihui.wisdommedical.model.MedicalAppointmentInfoEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class MedicalRecordOrderTimeout {
    private static final Logger log = LoggerFactory.getLogger(MedicalRecordOrderTimeout.class);
    private final MedicalAppointmentInfoMapper medicalAppointmentInfoMapper;

    @RabbitListener(queues={"medicalrecordaappointment.pay.compensation"})
    @RabbitHandler
    public void process(String orderNumber) {
        log.info("orderNumber->{}", (Object)orderNumber);
        try {
            if (null != orderNumber) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"orderNumber", (Object)orderNumber);
                MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = (MedicalAppointmentInfoEntity)this.medicalAppointmentInfoMapper.selectOne((Wrapper)queryWrapper);
                if (medicalAppointmentInfoEntity.getOrderStatus().equals(MedicalAppointmentStatusEnum.WAIT_FOR_PAYMENT.getValue().toString())) {
                    medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.CANCELLED.getValue().toString());
                    medicalAppointmentInfoEntity.setOrderClearTime(DateUtil.now());
                    medicalAppointmentInfoEntity.setOrderRemarks("\u8d85\u65f6\u672a\u652f\u4ed8,\u81ea\u52a8\u53d6\u6d88");
                    medicalAppointmentInfoEntity.setRemarks("\u8d85\u65f6\u672a\u652f\u4ed8,\u81ea\u52a8\u53d6\u6d88");
                    int update = this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
                    log.info("\u9884\u7ea6\u8ba2\u5355\u8d85\u65f6\u672a\u652f\u4ed8\u81ea\u52a8\u53d6\u6d88\u8fd4\u56de\u503c\u4e3a========================={}", (Object)update);
                    return;
                }
                log.info("\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355\u5931\u8d25,\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e3a->{}", (Object)MedicalAppointmentStatusEnum.getMsg((Integer)Integer.valueOf(medicalAppointmentInfoEntity.getOrderStatus())));
            } else {
                log.error("\u8ba2\u5355\u53f7\u4e3a\u7a7a \u65e0\u6cd5\u81ea\u52a8\u53d6\u6d88\u75c5\u6848\u8ba2\u5355");
            }
        }
        catch (Exception e) {
            log.error("\u75c5\u6848\u9884\u7ea6mq\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
        }
    }

    public MedicalRecordOrderTimeout(MedicalAppointmentInfoMapper medicalAppointmentInfoMapper) {
        this.medicalAppointmentInfoMapper = medicalAppointmentInfoMapper;
    }
}

