/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.base.dto.OrganIdReq;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.vo.doctor.OrganDeptInfoVO;
import com.ebaiyihui.api.AppointmentClient;
import com.ebaiyihui.api.ScheduleClient;
import com.ebaiyihui.hkdhisfront.appoint.GetDeptScheduleResVO;
import com.ebaiyihui.hkdhisfront.appoint.RegLv;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegDeptVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentServiceImpl.class);
    private static final String POP_DEPT = "\u63a8\u8350\u79d1\u5ba4";
    private static final int ALREADY_VISITING = 1;
    private static final int NOT_VISITING = 0;
    private static final String[] NOT_INCLUDED_DEPT = new String[]{"\u6838\u9178\u68c0\u6d4b\u95e8\u8bca", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca2", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca3", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca4", "\u6838\u9178\u68c0\u6d4b\u95e8\u8bca5"};
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private DeptCategoryMapper deptCategoryMapper;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private ScheduleClient scheduleClient;
    @Resource
    private AppointmentClient appointmentClient;
    private static int RECENT_SEARCH_RECORD_SIZE = 5;

    public List<GetDeptListVoRes> getDeptList() throws Exception {
        List deptCategoryEntities = this.deptCategoryMapper.selectAll();
        if (deptCategoryEntities.size() == 0) {
            return new ArrayList<GetDeptListVoRes>();
        }
        ArrayList<GetDeptListVoRes> list = new ArrayList<GetDeptListVoRes>();
        deptCategoryEntities.forEach(item -> {
            GetDeptListVoRes getDeptListVoRes = new GetDeptListVoRes();
            getDeptListVoRes.setFirstDepId(item.getDeptCategoryCode());
            getDeptListVoRes.setFirstDepName(item.getDeptCategoryName());
            list.add(getDeptListVoRes);
        });
        return list;
    }

    public List<GetDeptListVoRes> getDeptList(String hl, String date) throws Exception {
        return null;
    }

    private List<HospitalDeptVo> getHospitalDeptVo(List<String> visitingDeptCodeList, List<DepartmentEntity> departmentEntityList) {
        return null;
    }

    private List<DepartmentEntity> getPopOrganDept(String organId) throws AppointmentException {
        List departmentEntityList = this.getDoctorInfoUtil.getHotDepartmentList(organId);
        return departmentEntityList;
    }

    private List<OrganDeptInfoVO> getOrganDeptList(String organId, String organCode) throws AppointmentException {
        OrganIdReq organIdReq = new OrganIdReq();
        organIdReq.setOrganId(organId);
        organIdReq.setOrganCode(organCode);
        List organDeptInfoVOList = this.getDoctorInfoUtil.getListOrganDept(organIdReq);
        return organDeptInfoVOList;
    }

    public void saveSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String redisKey = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.add((Object)redisKey, (Object)keyword, (double)System.currentTimeMillis());
        log.info("\u3010redis\u5b58\u50a8\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, value:{}", (Object)redisKey, (Object)keyword);
        Long size = zSetOperations.size((Object)redisKey);
        if (size > (long)RECENT_SEARCH_RECORD_SIZE) {
            zSetOperations.removeRange((Object)redisKey, 0L, size - (long)RECENT_SEARCH_RECORD_SIZE - 1L);
        }
        this.redisTemplate.expire((Object)redisKey, 30L, TimeUnit.DAYS);
    }

    public List<HospitalDeptVo> searchDept(String organCode, String userId, String key) throws AppointmentException {
        this.saveSearchRecord(organCode, userId, key);
        List list = this.deptRecordMapper.selectByNameAndHospitalCode(organCode, key);
        return list;
    }

    public List<String> getRecentSearchDeptList(String organCode, String userId) throws AppointmentException {
        ArrayList<String> list = new ArrayList<String>();
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        Set range = zSetOperations.reverseRangeWithScores((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u83b7\u53d6\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, object:{} ", (Object)key, (Object)JSON.toJSONString((Object)range));
        for (ZSetOperations.TypedTuple tuple : range) {
            list.add((String)tuple.getValue());
        }
        return list;
    }

    public void deleteOneSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.remove((Object)key, new Object[]{keyword});
        log.info("\u3010redis\u5220\u9664\u6307\u5b9a\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}, value:{} ", (Object)key, (Object)keyword);
    }

    public void deleteAllSearchRecords(String organCode, String userId) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.removeRange((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u5220\u9664\u6240\u6709\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}", (Object)key);
    }

    public List<HospitalDeptVo> getHospDeptList(String branchCode, String date) {
        String deptKey = branchCode + "_hospital_dept_" + date;
        String deptListStr = (String)this.redisTemplate.opsForValue().get((Object)deptKey);
        if (StringUtils.isNotBlank((CharSequence)deptListStr)) {
            List hospitalDeptVoList = JSON.parseArray((String)deptListStr, HospitalDeptVo.class);
            return hospitalDeptVoList;
        }
        String regLevelKey = this.propertiesConstant.getOrganCode() + "_reg_level";
        String regLevelIds = (String)this.redisTemplate.opsForValue().get((Object)regLevelKey);
        if (StringUtils.isBlank((CharSequence)regLevelIds)) {
            FrontResponse frontResponse = this.appointmentClient.registerLevel();
            if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
                log.error("\u3010\u83b7\u53d6\u6302\u53f7\u7ea7\u522b\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                return null;
            }
            List regLvList = (List)frontResponse.getBody();
            if (CollectionUtils.isEmpty((Collection)regLvList)) {
                log.error("\u3010\u83b7\u53d6\u6302\u53f7\u7ea7\u522b\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                return null;
            }
            regLevelIds = regLvList.stream().map(RegLv::getId).collect(Collectors.joining(","));
            this.redisTemplate.opsForValue().set((Object)regLevelKey, (Object)regLevelIds, 7L, TimeUnit.DAYS);
        }
        FrontRequest frontRequest = new FrontRequest();
        RequestRegDeptVo requestRegDeptVo = new RequestRegDeptVo();
        requestRegDeptVo.setDeptCode("");
        requestRegDeptVo.setBranchCode(branchCode);
        requestRegDeptVo.setDate(date);
        requestRegDeptVo.setTypeCodeList(regLevelIds);
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)requestRegDeptVo);
        FrontResponse frontResponse = this.scheduleClient.getDept(frontRequest);
        if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
            log.error("\u3010\u83b7\u53d6\u79d1\u5ba4\u6392\u73ed\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return null;
        }
        if (Objects.isNull(frontResponse.getBody()) || CollectionUtils.isEmpty((Collection)((GetDeptScheduleResVO)frontResponse.getBody()).getItems())) {
            log.error("\u3010\u83b7\u53d6\u79d1\u5ba4\u6392\u73ed\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return null;
        }
        List items = ((GetDeptScheduleResVO)frontResponse.getBody()).getItems();
        List<HospitalDeptVo> hospitalDeptVoList = items.stream().map(item -> HospitalDeptVo.builder().hospitalDepName(item.getDeptName()).hospitalDepCode(item.getDeptCode()).build()).collect(Collectors.toList());
        this.redisTemplate.opsForValue().set((Object)deptKey, (Object)JSON.toJSONString(hospitalDeptVoList), 3L, TimeUnit.MINUTES);
        return hospitalDeptVoList;
    }
}

