/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.enums.HospAppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.mapper.HospitalAppointmentMapper;
import com.ebaiyihui.wisdommedical.model.HospitalAppointmentEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.AdminCancelHospitalAppointmentReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.AdminGetHospitalAppointmentListReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.AdminGetHospitalAppointmentListRespVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.AdminNoPassHospitalAppointmentReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.AdminPassHospitalAppointmentReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.ExportExcelHospitalAppointmentRespVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.HospitalAppointmentCreateOrderReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.HospitalAppointmentCreateOrderRespVo;
import com.ebaiyihui.wisdommedical.pojo.vo.hospappoint.HospitalAppointmentDetailRespVo;
import com.ebaiyihui.wisdommedical.service.HospitalAppointmentService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.ExcelUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HospitalAppointmentServiceImpl
implements HospitalAppointmentService {
    private static final Logger log = LoggerFactory.getLogger(HospitalAppointmentServiceImpl.class);
    @Autowired
    private HospitalAppointmentMapper hospitalAppointmentMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;

    public BaseResponse<HospitalAppointmentCreateOrderRespVo> patientApplyHospitalAppointment(HospitalAppointmentCreateOrderReqVo hospitalAppointmentCreateOrderReqVo) {
        log.info("\u60a3\u8005\u7533\u8bf7\u4f4f\u9662\u9884\u7ea6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)hospitalAppointmentCreateOrderReqVo));
        HospitalAppointmentEntity hospitalAppointmentEntity = new HospitalAppointmentEntity();
        BeanUtils.copyProperties((Object)hospitalAppointmentCreateOrderReqVo, (Object)hospitalAppointmentEntity);
        String appointmentId = String.valueOf(this.snowflakeIdWorker.nextId());
        int genderByIdCard = IdcardUtil.getGenderByIdCard((String)hospitalAppointmentCreateOrderReqVo.getPatientIdCard());
        hospitalAppointmentEntity.setPatientSex(Byte.valueOf((byte)genderByIdCard));
        hospitalAppointmentEntity.setStatusCode(HospAppointmentStatusEnum.DSH.getValue());
        hospitalAppointmentEntity.setStatusRemark(HospAppointmentStatusEnum.DSH.getDisplay());
        hospitalAppointmentEntity.setAppointmentId(appointmentId);
        log.info("\u60a3\u8005\u7533\u8bf7\u4f4f\u9662\u9884\u7ea6\u53c2\u6570\u8d4b\u503c\u540e\u7684\u5b9e\u4f53\u7c7b\u4e3a:{}", (Object)JSON.toJSONString((Object)hospitalAppointmentEntity));
        this.hospitalAppointmentMapper.insertSelective(hospitalAppointmentEntity);
        HospitalAppointmentEntity hospitalAppointmentDb = this.hospitalAppointmentMapper.selectByAppointmentId(appointmentId);
        HospitalAppointmentCreateOrderRespVo hospitalAppointmentCreateOrderRespVo = new HospitalAppointmentCreateOrderRespVo();
        hospitalAppointmentCreateOrderRespVo.setPatientName(hospitalAppointmentDb.getPatientName());
        hospitalAppointmentCreateOrderRespVo.setDeptName(hospitalAppointmentDb.getDeptName());
        hospitalAppointmentCreateOrderRespVo.setDeptCode(hospitalAppointmentDb.getDeptCode());
        hospitalAppointmentCreateOrderRespVo.setPatientSex(String.valueOf(hospitalAppointmentDb.getPatientSex()));
        hospitalAppointmentCreateOrderRespVo.setHospitalCode(hospitalAppointmentDb.getHospitalCode());
        hospitalAppointmentCreateOrderRespVo.setHospitalName(hospitalAppointmentDb.getHospitalName());
        hospitalAppointmentCreateOrderRespVo.setAppointmentTime(DateUtils.dateToFullString((Date)hospitalAppointmentDb.getCreateTime()));
        hospitalAppointmentCreateOrderRespVo.setPatientAge(String.valueOf(IdcardUtil.getAgeByIdCard((String)hospitalAppointmentDb.getPatientIdCard())));
        return BaseResponse.success((Object)hospitalAppointmentCreateOrderRespVo);
    }

    public BaseResponse<String> adminPassHospitalAppointment(AdminPassHospitalAppointmentReqVo adminPassHospitalAppointmentReqVo) {
        log.info("\u7ba1\u7406\u5458\u901a\u8fc7\u4f4f\u9662\u9884\u7ea6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)adminPassHospitalAppointmentReqVo));
        HospitalAppointmentEntity hospitalAppointmentEntity = this.hospitalAppointmentMapper.selectByAppointmentId(adminPassHospitalAppointmentReqVo.getAppointmentId());
        if (Objects.isNull(hospitalAppointmentEntity)) {
            return BaseResponse.error((String)"\u8981\u901a\u8fc7\u7684\u4f4f\u9662\u9884\u7ea6\u4e0d\u5b58\u5728");
        }
        hospitalAppointmentEntity.setStatusCode(HospAppointmentStatusEnum.YYCG.getValue());
        hospitalAppointmentEntity.setStatusRemark(HospAppointmentStatusEnum.YYCG.getDisplay());
        hospitalAppointmentEntity.setInHospitalTime(adminPassHospitalAppointmentReqVo.getInHospitalTime());
        hospitalAppointmentEntity.setInHospitalRemark(adminPassHospitalAppointmentReqVo.getRemark());
        hospitalAppointmentEntity.setUpdateTime(null);
        this.hospitalAppointmentMapper.updateByPrimaryKeySelective(hospitalAppointmentEntity);
        this.taskExecutor.execute(() -> this.pushService.hospitalAppointmentSuccess(hospitalAppointmentEntity));
        return BaseResponse.success((Object)"\u5165\u9662\u5ba1\u6838\u7533\u8bf7\u5df2\u901a\u8fc7");
    }

    public BaseResponse<String> adminNoPassHospitalAppointment(AdminNoPassHospitalAppointmentReqVo adminNoPassHospitalAppointmentReqVo) {
        log.info("\u7ba1\u7406\u5458\u4e0d\u901a\u8fc7\u4f4f\u9662\u9884\u7ea6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)adminNoPassHospitalAppointmentReqVo));
        HospitalAppointmentEntity hospitalAppointmentEntity = this.hospitalAppointmentMapper.selectByAppointmentId(adminNoPassHospitalAppointmentReqVo.getAppointmentId());
        if (Objects.isNull(hospitalAppointmentEntity)) {
            return BaseResponse.error((String)"\u8981\u4e0d\u901a\u8fc7\u7684\u4f4f\u9662\u9884\u7ea6\u4e0d\u5b58\u5728");
        }
        hospitalAppointmentEntity.setStatusCode(HospAppointmentStatusEnum.YYSB.getValue());
        hospitalAppointmentEntity.setStatusRemark(HospAppointmentStatusEnum.YYSB.getDisplay());
        hospitalAppointmentEntity.setFailureRemark(adminNoPassHospitalAppointmentReqVo.getRemark());
        hospitalAppointmentEntity.setUpdateTime(null);
        this.hospitalAppointmentMapper.updateByPrimaryKeySelective(hospitalAppointmentEntity);
        this.taskExecutor.execute(() -> this.pushService.hospitalAppointmentFailure(hospitalAppointmentEntity));
        return BaseResponse.success((Object)"\u5165\u9662\u5ba1\u6838\u7533\u8bf7\u672a\u901a\u8fc7");
    }

    public BaseResponse<String> adminCancelHospitalAppointment(AdminCancelHospitalAppointmentReqVo adminCancelHospitalAppointmentReqVo) {
        log.info("\u7ba1\u7406\u5458\u53d6\u6d88\u4f4f\u9662\u9884\u7ea6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)adminCancelHospitalAppointmentReqVo));
        HospitalAppointmentEntity hospitalAppointmentEntity = this.hospitalAppointmentMapper.selectByAppointmentId(adminCancelHospitalAppointmentReqVo.getAppointmentId());
        if (Objects.isNull(hospitalAppointmentEntity)) {
            return BaseResponse.error((String)"\u8981\u53d6\u6d88\u7684\u4f4f\u9662\u9884\u7ea6\u4e0d\u5b58\u5728");
        }
        hospitalAppointmentEntity.setStatusCode(HospAppointmentStatusEnum.QXYY.getValue());
        hospitalAppointmentEntity.setStatusRemark(HospAppointmentStatusEnum.QXYY.getDisplay());
        hospitalAppointmentEntity.setCancelRemark(adminCancelHospitalAppointmentReqVo.getRemark());
        hospitalAppointmentEntity.setUpdateTime(null);
        this.hospitalAppointmentMapper.updateByPrimaryKeySelective(hospitalAppointmentEntity);
        this.taskExecutor.execute(() -> this.pushService.hospitalAppointmentCancel(hospitalAppointmentEntity));
        return BaseResponse.success((Object)"\u5165\u9662\u53d6\u6d88\u9884\u7ea6\u6210\u529f");
    }

    public BaseResponse<HospitalAppointmentDetailRespVo> getHospitalAppointmentDetail(String appointmentId) {
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u7ea6\u8be6\u60c5\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)appointmentId));
        HospitalAppointmentEntity hospitalAppointmentEntity = this.hospitalAppointmentMapper.selectByAppointmentId(appointmentId);
        if (Objects.isNull(hospitalAppointmentEntity)) {
            return BaseResponse.error((String)"\u4f4f\u9662\u9884\u7ea6\u4e0d\u5b58\u5728");
        }
        HospitalAppointmentDetailRespVo hospitalAppointmentDetailRespVo = new HospitalAppointmentDetailRespVo();
        BeanUtils.copyProperties((Object)hospitalAppointmentEntity, (Object)hospitalAppointmentDetailRespVo);
        hospitalAppointmentDetailRespVo.setPatientAge(String.valueOf(IdcardUtil.getAgeByIdCard((String)hospitalAppointmentEntity.getPatientIdCard())));
        return BaseResponse.success((Object)hospitalAppointmentDetailRespVo);
    }

    public BaseResponse<List<HospitalAppointmentEntity>> patientGetHospitalAppointmentList(String patientCardNo, String userId) {
        log.info("\u60a3\u8005\u83b7\u53d6\u4f4f\u9662\u9884\u7ea6\u5217\u8868\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)patientCardNo));
        List hospitalAppointmentEntities = this.hospitalAppointmentMapper.selectByCardNoAndUserId(patientCardNo, userId);
        return BaseResponse.success((Object)hospitalAppointmentEntities);
    }

    public BaseResponse<AdminGetHospitalAppointmentListRespVo> adminGetHospitalAppointmentList(AdminGetHospitalAppointmentListReqVo adminGetHospitalAppointmentListReqVo) {
        log.info("\u7ba1\u7406\u5458\u83b7\u53d6\u4f4f\u9662\u9884\u7ea6\u5217\u8868\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)adminGetHospitalAppointmentListReqVo));
        AdminGetHospitalAppointmentListRespVo pageResult = new AdminGetHospitalAppointmentListRespVo();
        PageHelper.startPage((int)adminGetHospitalAppointmentListReqVo.getPageNum(), (int)adminGetHospitalAppointmentListReqVo.getPageSize());
        Page page = this.hospitalAppointmentMapper.adminSelectList(adminGetHospitalAppointmentListReqVo);
        int totalCount = this.hospitalAppointmentMapper.selectAllCount(adminGetHospitalAppointmentListReqVo.getHospitalCode());
        pageResult.setTotalCount(Integer.valueOf(totalCount));
        List hospitalAppointmentEntityList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)hospitalAppointmentEntityList)) {
            pageResult.setContent(new ArrayList());
            return BaseResponse.success((Object)pageResult);
        }
        int isAppointCount = 0;
        int cancelCount = 0;
        int failCount = 0;
        List appointmentEntityList = this.hospitalAppointmentMapper.exportExcelHospitalAppointment(adminGetHospitalAppointmentListReqVo);
        for (HospitalAppointmentEntity hospitalAppointmentEntity : appointmentEntityList) {
            if (HospAppointmentStatusEnum.YYCG.getValue().equals(hospitalAppointmentEntity.getStatusCode())) {
                ++isAppointCount;
            }
            if (HospAppointmentStatusEnum.QXYY.getValue().equals(hospitalAppointmentEntity.getStatusCode())) {
                ++cancelCount;
            }
            if (!HospAppointmentStatusEnum.YYSB.getValue().equals(hospitalAppointmentEntity.getStatusCode())) continue;
            ++failCount;
        }
        pageResult.setContent(hospitalAppointmentEntityList);
        pageResult.setIsAppointCount(isAppointCount);
        pageResult.setCancelCount(cancelCount);
        pageResult.setFailCount(failCount);
        pageResult.setTotalCount(Integer.valueOf(appointmentEntityList.size()));
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        log.info("\u3010\u7ba1\u7406\u5458\u83b7\u53d6\u4f4f\u9662\u9884\u7ea6\u5217\u8868\u3011\u8fd4\u56de\u53c2\u6570 pageResult: " + JSON.toJSONString((Object)pageResult));
        return BaseResponse.success((Object)pageResult);
    }

    public void adminExportHospitalAppointmentList(AdminGetHospitalAppointmentListReqVo adminGetHospitalAppointmentListReqVo, HttpServletResponse response) {
        log.info("\u5bfc\u51fa\u4f4f\u9662\u9884\u7ea6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)adminGetHospitalAppointmentListReqVo));
        List appointmentEntityList = this.hospitalAppointmentMapper.exportExcelHospitalAppointment(adminGetHospitalAppointmentListReqVo);
        if (appointmentEntityList.size() == 0) {
            return;
        }
        ArrayList<ExportExcelHospitalAppointmentRespVo> exportExcelHospitalAppointmentRespVoList = new ArrayList<ExportExcelHospitalAppointmentRespVo>();
        for (HospitalAppointmentEntity appointmentEntity : appointmentEntityList) {
            ExportExcelHospitalAppointmentRespVo exportExcelHospitalAppointmentRespVo = new ExportExcelHospitalAppointmentRespVo();
            BeanUtils.copyProperties((Object)appointmentEntity, (Object)exportExcelHospitalAppointmentRespVo);
            exportExcelHospitalAppointmentRespVo.setCreateTime(DateUtils.dateToFullString((Date)appointmentEntity.getCreateTime()));
            exportExcelHospitalAppointmentRespVo.setPatientIdCard(appointmentEntity.getPatientIdCard());
            exportExcelHospitalAppointmentRespVoList.add(exportExcelHospitalAppointmentRespVo);
        }
        String fileName = DateUtils.getCurrentDateSimpleNoSpeToString() + "-\u4f4f\u9662\u9884\u7ea6\u8ba2\u5355-\u6d1b\u9633\u5e02\u7b2c\u4e00\u4eba\u6c11\u533b\u9662";
        try {
            ExcelUtil.exportExcel(exportExcelHospitalAppointmentRespVoList, null, null, ExportExcelHospitalAppointmentRespVo.class, (String)fileName, (boolean)true, (HttpServletResponse)response);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u4f4f\u9662\u9884\u7ea6\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
    }
}

