/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.exception.DoctorScheduleException;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetScheduleDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocSchedulePageVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.ManageDocScheduleTimeArrangeItemVo;
import com.ebaiyihui.wisdommedical.service.ManageDocScheduleService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ManageDocScheduleServiceImpl
implements ManageDocScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ManageDocScheduleServiceImpl.class);
    public static final int PAGESIZE = 20;
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;

    public ManageDocScheduleVo getManageDocSchedule(GetScheduleDTO getScheduleDTO) throws DoctorScheduleException {
        ManageDocScheduleVo manageDocScheduleVo = new ManageDocScheduleVo();
        HospitalAreaRecordEntity hospitalAreaRecordEntity = this.hospitalAreaRecordMapper.selectOneByhospitalCode(getScheduleDTO.getOrganCode());
        if (null == hospitalAreaRecordEntity) {
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u9662\u4fe1\u606f\uff1a\u533b\u9662\u7f16\u7801\u4e3a{}", (Object)getScheduleDTO.getOrganCode());
            return null;
        }
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(getScheduleDTO.getOrganCode(), getScheduleDTO.getDoctorCode());
        if (null == doctorRecordEntity) {
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u9662\u8be5\u533b\u751f\u4fe1\u606f\uff1a\u533b\u9662\u7f16\u7801\u4e3a{},\u533b\u751f\u7f16\u7801{}", (Object)getScheduleDTO.getOrganCode(), (Object)getScheduleDTO.getDoctorCode());
            return null;
        }
        List manageDocScheduleVoList = this.scheduleRecordMapper.selectByGetScheduleDTO(getScheduleDTO);
        if (null == manageDocScheduleVoList || manageDocScheduleVoList.isEmpty()) {
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u9662\u8be5\u533b\u751f\u6392\u73ed\u4fe1\u606f\uff1a\u533b\u9662\u7f16\u7801\u4e3a{},\u533b\u751f\u7f16\u7801{}", (Object)getScheduleDTO.getOrganCode(), (Object)getScheduleDTO.getDoctorCode());
            return null;
        }
        manageDocScheduleVo.setDocName(doctorRecordEntity.getDocName());
        manageDocScheduleVo.setDocCode(doctorRecordEntity.getDocCode());
        manageDocScheduleVo.setScheduleLevelName(((ScheduleRecordEntity)manageDocScheduleVoList.get(0)).getScheduleLevel());
        manageDocScheduleVo.setLocCode(((ScheduleRecordEntity)manageDocScheduleVoList.get(0)).getDeptCode());
        manageDocScheduleVo.setRegTitleName(doctorRecordEntity.getRegTitelName());
        manageDocScheduleVo.setLocName(((ScheduleRecordEntity)manageDocScheduleVoList.get(0)).getDeptName());
        manageDocScheduleVo.setHospitalAreaName(hospitalAreaRecordEntity.getHospitalAreaName());
        manageDocScheduleVo.setTimeArrangeItemVoList(this.getTimeArrangeItemList(manageDocScheduleVoList, getScheduleDTO.getOrganCode()));
        return manageDocScheduleVo;
    }

    public PageResult<ManageDocScheduleVo> getPageManageDocScheduleVo(ManageDocSchedulePageVoReq manageDocSchedulePageVoReq) throws DoctorScheduleException {
        PageResult pageResult = new PageResult();
        Integer pageSize = 20;
        if (!"".equals(manageDocSchedulePageVoReq.getPageSize()) && null != manageDocSchedulePageVoReq.getPageSize()) {
            pageSize = manageDocSchedulePageVoReq.getPageSize();
        }
        PageHelper.startPage((int)manageDocSchedulePageVoReq.getPageNum(), (int)pageSize);
        Page page = this.scheduleRecordMapper.selectPageByOrganCode(manageDocSchedulePageVoReq);
        List scheduleRecordEntity = page.getResult();
        if (CollectionUtils.isEmpty((Collection)scheduleRecordEntity)) {
            return pageResult;
        }
        List manageDocScheduleVoList = this.getManageDocScheduleVoList(scheduleRecordEntity);
        pageResult.setContent(manageDocScheduleVoList);
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        return pageResult;
    }

    private List<ManageDocScheduleVo> getManageDocScheduleVoList(List<ScheduleRecordEntity> scheduleRecordEntityList) throws DoctorScheduleException {
        ArrayList<ManageDocScheduleVo> manageDocScheduleVoList = new ArrayList<ManageDocScheduleVo>();
        if (null == scheduleRecordEntityList || scheduleRecordEntityList.isEmpty()) {
            return null;
        }
        HashMap map = new HashMap();
        for (ScheduleRecordEntity scheduleRecordEntity : scheduleRecordEntityList) {
            String key = scheduleRecordEntity.getDocCode() + scheduleRecordEntity.getDeptCode();
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(scheduleRecordEntity);
                continue;
            }
            ArrayList<ScheduleRecordEntity> list = new ArrayList<ScheduleRecordEntity>();
            list.add(scheduleRecordEntity);
            map.put(key, list);
        }
        for (List list : map.values()) {
            ScheduleRecordEntity scheduleRecordEntity = (ScheduleRecordEntity)list.get(0);
            ManageDocScheduleVo manageDocScheduleVo = new ManageDocScheduleVo();
            manageDocScheduleVo.setDocName(scheduleRecordEntity.getDocName());
            manageDocScheduleVo.setDocCode(scheduleRecordEntity.getDocCode());
            manageDocScheduleVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
            manageDocScheduleVo.setHospitalAreaName(scheduleRecordEntity.getHospitalAreaName());
            manageDocScheduleVo.setLocName(scheduleRecordEntity.getDeptName());
            manageDocScheduleVo.setLocCode(scheduleRecordEntity.getDeptCode());
            manageDocScheduleVo.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
            ArrayList<ManageDocScheduleTimeArrangeItemVo> timeArrangeItemVoList = new ArrayList<ManageDocScheduleTimeArrangeItemVo>();
            for (ScheduleRecordEntity scheduleRecord : list) {
                ManageDocScheduleTimeArrangeItemVo timeArrangeItemVo = new ManageDocScheduleTimeArrangeItemVo();
                timeArrangeItemVo.setAdmTimeArrange(scheduleRecord.getScheduleRange().toString());
                timeArrangeItemVoList.add(timeArrangeItemVo);
            }
            manageDocScheduleVo.setTimeArrangeItemVoList(timeArrangeItemVoList);
            manageDocScheduleVoList.add(manageDocScheduleVo);
        }
        return manageDocScheduleVoList;
    }

    private List<ManageDocScheduleTimeArrangeItemVo> getTimeArrangeItemList(List<ScheduleRecordEntity> scheduleRecordEntityList, String organCode) throws DoctorScheduleException {
        ArrayList<ManageDocScheduleTimeArrangeItemVo> timeArrangeItemVoList = new ArrayList<ManageDocScheduleTimeArrangeItemVo>();
        scheduleRecordEntityList.stream().forEach(scheduleRecordEntity -> {
            ManageDocScheduleTimeArrangeItemVo timeArrangeItemVo = new ManageDocScheduleTimeArrangeItemVo();
            timeArrangeItemVo.setAdmTimeArrange(scheduleRecordEntity.getScheduleRange().toString());
            List detailRecordEntityList = this.scheduleDetailRecordMapper.selectByHisScheduleId(scheduleRecordEntity.getScheduleHisId(), organCode);
            Integer available = 0;
            if (null == detailRecordEntityList || detailRecordEntityList.isEmpty()) {
                if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.MORNING.getValue().byteValue()) {
                    timeArrangeItemVo.setStartTime("08:00");
                    timeArrangeItemVo.setEndTime("12:00");
                } else if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.AFTERNOON.getValue().byteValue()) {
                    timeArrangeItemVo.setStartTime("13:00");
                    timeArrangeItemVo.setEndTime("17:00");
                } else if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.ALL_DAY.getValue().byteValue()) {
                    timeArrangeItemVo.setStartTime("08:00");
                    timeArrangeItemVo.setEndTime("17:00");
                } else if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.NIGHT.getValue().byteValue()) {
                    timeArrangeItemVo.setStartTime("18:00");
                    timeArrangeItemVo.setEndTime("21:00");
                }
            } else {
                String startTime = ((ScheduleDetailRecordEntity)detailRecordEntityList.get(0)).getStartTime();
                String endTime = ((ScheduleDetailRecordEntity)detailRecordEntityList.get(detailRecordEntityList.size() - 1)).getEndTime();
                timeArrangeItemVo.setStartTime(startTime);
                timeArrangeItemVo.setEndTime(endTime);
            }
            timeArrangeItemVo.setRegAvailable(scheduleRecordEntity.getAvailableCount());
            timeArrangeItemVo.setTotalCount(scheduleRecordEntity.getTotalCount());
            timeArrangeItemVo.setScheduleId(scheduleRecordEntity.getScheduleHisId());
            timeArrangeItemVoList.add(timeArrangeItemVo);
        });
        return timeArrangeItemVoList;
    }
}

