/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.api.NetReportClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.hkdhisfront.appoint.InHospitalNumByIdCardReq;
import com.ebaiyihui.hkdhisfront.appoint.InHospitalNumByIdCardVo;
import com.ebaiyihui.hkdhisfront.appoint.LisReportDetailReq;
import com.ebaiyihui.hkdhisfront.appoint.LisReportDetailVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.report.GetReportListsReq;
import com.ebaiyihui.hkdhisfront.report.GetReportListsRes;
import com.ebaiyihui.hkdhisfront.report.LisReportDetailRes;
import com.ebaiyihui.hkdhisfront.report.PacsReportDetailRes;
import com.ebaiyihui.hkdhisfront.report.ReportDetailReq;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsReq;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosReq;
import com.ebaiyihui.wisdommedical.pojo.vo.NetReportBaseRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportInfo;
import com.ebaiyihui.wisdommedical.service.NetReportService;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import his.pojo.vo.report.datas.GetReportListsData;
import his.pojo.vo.report.datas.LisReportListResData;
import his.pojo.vo.report.datas.micDatas.LisReportListResMicData;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NetReportServiceImpl
implements NetReportService {
    private static final Logger log = LoggerFactory.getLogger(NetReportServiceImpl.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private NetReportClient reportClient;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;

    public BaseResponse<List<GetReportListsRes>> queryReportHosList(ListReportHosReq param) {
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)GetReportListsReq.builder().reportType(param.getReportType()).cardNo(param.getCardNo()).idNo(param.getIdCard()).beginTime(param.getBeginDate()).endTime(param.getEndDate()).build());
        FrontResponse frontResponse = this.reportClient.getReportList(frontRequest);
        if (Objects.isNull(frontResponse)) {
            log.error("\u8bf7\u6c42his\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return BaseResponse.error((String)"his\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        if (!"1".equals(frontResponse.getCode())) {
            log.error("\u8bf7\u6c42his\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            return BaseResponse.error((String)frontResponse.getMessage());
        }
        if (CollectionUtil.isEmpty((Collection)((Collection)frontResponse.getBody()))) {
            return BaseResponse.success(new ArrayList());
        }
        List reportListsRes = (List)frontResponse.getBody();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/M/d H:mm:ss");
        reportListsRes.sort(Comparator.comparing(e -> LocalDateTime.parse(e.getReportDate(), formatter)).reversed());
        param.setPageSize("1000");
        if (StringUtils.isNotBlank((CharSequence)param.getPageSize()) && StringUtils.isNotBlank((CharSequence)param.getPageNum())) {
            reportListsRes = this.partition(reportListsRes, Convert.toInt((Object)param.getPageSize()).intValue(), Convert.toInt((Object)param.getPageNum()) - 1);
        }
        return BaseResponse.success((Object)reportListsRes);
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailReq param) {
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)ReportDetailReq.builder().reportNo(param.getReportNo()).name(param.getName()).idNo(param.getIdCard()).lisNo(param.getLisNo()).build());
        FrontResponse listFrontResponse = this.reportClient.lisReportDetail(frontRequest);
        if (Objects.isNull(listFrontResponse)) {
            log.error("\u8bf7\u6c42his\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return BaseResponse.error((String)"his\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        if (!"1".equals(listFrontResponse.getCode())) {
            log.error("\u8bf7\u6c42his\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            return BaseResponse.error((String)listFrontResponse.getMessage());
        }
        ReportDetailRes reportDetailRes = new ReportDetailRes();
        List detailResList = (List)listFrontResponse.getBody();
        if (detailResList.isEmpty()) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u6570\u636e");
        }
        ArrayList<ReportDetailData> datas = new ArrayList<ReportDetailData>();
        for (LisReportDetailRes detailRes : detailResList) {
            ReportDetailData reportDetailData = new ReportDetailData();
            BeanUtil.copyProperties((Object)detailRes, (Object)reportDetailData, (String[])new String[0]);
            reportDetailData.setItmCrises(detailRes.getDecision());
            datas.add(reportDetailData);
        }
        reportDetailRes.setDatas(datas);
        try {
            LisReportDetailReq lisReportDetailReq = new LisReportDetailReq();
            lisReportDetailReq.setLis_no(param.getLisNo());
            FrontRequest lisReportDetailReqFrontRequest = new FrontRequest();
            lisReportDetailReqFrontRequest.setBody((Object)lisReportDetailReq);
            FrontResponse frontResponse = this.reportClient.lisReportDetailBase(lisReportDetailReqFrontRequest);
            if (!Objects.isNull(frontResponse) && !"0".equals(frontResponse.getCode())) {
                LisReportDetailVo lisReportDetailVo = (LisReportDetailVo)frontResponse.getBody();
                if (lisReportDetailVo != null) {
                    reportDetailRes.setReportImg(lisReportDetailVo.getBase64file());
                } else {
                    reportDetailRes.setReportImg("");
                }
            } else {
                reportDetailRes.setReportImg("");
            }
        }
        catch (Exception e) {
            reportDetailRes.setReportImg("");
        }
        return BaseResponse.success((Object)reportDetailRes);
    }

    public BaseResponse<CheckReportDetailsRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        String url = "http://192.168.50.243:8080/pacsimage/getpdfreportbycheckserialnum.action?checkserialnum=";
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)ReportDetailReq.builder().reportNo(param.getReportNo()).build());
        FrontResponse frontResponse = this.reportClient.pacsReportDetail(frontRequest);
        if (Objects.isNull(frontResponse)) {
            log.error("\u8bf7\u6c42his\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return BaseResponse.error((String)"his\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        if (!"1".equals(frontResponse.getCode())) {
            log.error("\u8bf7\u6c42his\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            return BaseResponse.error((String)frontResponse.getMessage());
        }
        PacsReportDetailRes reportDetailRes = (PacsReportDetailRes)frontResponse.getBody();
        if (Objects.isNull(reportDetailRes)) {
            log.error("his\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return BaseResponse.error((String)"his\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        CheckReportDetailsRes reportDetail = new CheckReportDetailsRes();
        reportDetail.setReportName(reportDetailRes.getType());
        reportDetail.setCheckResult(reportDetailRes.getReportResult());
        reportDetail.setCheckDesc(reportDetailRes.getReportDescription());
        reportDetail.setCheckDate(reportDetailRes.getExeDate());
        reportDetail.setAuthTime(reportDetailRes.getReportDate());
        reportDetail.setAuthUser(reportDetailRes.getReportDocName());
        reportDetail.setDoctorName(reportDetailRes.getApplyDocName());
        try {
            String reportImg = HttpUtil.get((String)(url + param.getReportNo()));
            reportDetail.setReportImg(reportImg);
        }
        catch (Exception e) {
            reportDetail.setReportImg("");
        }
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<List<InHospitalNumByIdCardVo>> getInHospitalNumByIdCard(InHospitalNumByIdCardReq param) {
        List list;
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)param);
        FrontResponse frontResponse = this.reportClient.getInHospitalNumByIdCard(frontRequest);
        if (Objects.isNull(frontResponse)) {
            log.error("\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u4f4f\u9662\u53f7\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            BaseResponse.error((String)"\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u4f4f\u9662\u53f7\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"1".equals(frontResponse.getCode())) {
            log.error("\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u4f4f\u9662\u53f7\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            BaseResponse.error((String)"\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u4f4f\u9662\u53f7\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(list = (List)frontResponse.getBody())) {
            log.error("\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u4f4f\u9662\u53f7\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            BaseResponse.error((String)"\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u4f4f\u9662\u53f7\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return BaseResponse.success((Object)list);
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> T checkHisResponse(FrontResponse<T> response) {
        if (response == null) {
            log.error("request his  error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(response.getCode())) {
            log.error("request his  error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getBody() == null) {
            log.error("request his  error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        if (response.getCode().equals("0")) {
            log.error(response.getMessage());
            return null;
        }
        return (T)response.getBody();
    }

    private <T> FrontRequest<T> buildFrontRequest(NetReportBaseRequest baseRequest, T body) {
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        log.info("his gateway - transactionId:{}---{}", (Object)transactionId, (Object)JSON.toJSONString((Object)gatewayRequest));
        return gatewayRequest;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private List<?> partition(List<?> list, int pageSize, int pageNum) {
        List partition = Lists.partition(list, (int)pageSize);
        int pages = partition.size();
        pageNum = pageNum <= 0 ? 0 : (pageNum <= pages - 1 ? pageNum : pages - 1);
        return (List)partition.get(pageNum);
    }
}

