/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    public static final long ORDER_TIME_OUT_TIME = Integer.toUnsignedLong(600000);
    public static final long ORDER_PUSH = Integer.toUnsignedLong(60000);

    public static void senderDelayedOrderOutTradeNo(RabbitTemplate rabbitTemplate, String rabbitMqDelayedOrderVoStr) {
        rabbitTemplate.convertAndSend("wisdommedical_appointment_delayed_exchange_jcszxyy_pro", "wisdommedical_appointment_delay_order_routing_key_jcszxyy_pro", (Object)rabbitMqDelayedOrderVoStr, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)ORDER_TIME_OUT_TIME);
            log.info("send message to rabbitmq: " + rabbitMqDelayedOrderVoStr);
            return message;
        });
    }

    public static void senderDelayedOrder(RabbitTemplate rabbitTemplate, String orderEntity, long expireTime) {
        rabbitTemplate.convertAndSend("wisdommedical_appointment_delayed_exchange_jcszxyy_pro", "wisdommedical_appointment_delay_order_routing_key_jcszxyy_pro", (Object)orderEntity, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)expireTime);
            log.info("send message to rabbitmq: " + orderEntity);
            return message;
        });
    }

    public static void senderYbDelayedOrderOutTradeNo(RabbitTemplate rabbitTemplate, String rabbitMqYbPayment) {
        rabbitTemplate.convertAndSend("wisdommedical_appointment_delayed_exchange_jcszxyy1_pro", "wisdommedical_appointment_delay_order_routing_key_jcszxyy1_pro", (Object)rabbitMqYbPayment, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)600000);
            log.info("send message to rabbitmq: " + rabbitMqYbPayment);
            return message;
        });
    }
}

