/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.config;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheConfig
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheConfig.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private String id;
    private RedisTemplate<String, Object> redisTemplate;

    public RedisCacheConfig(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        if (null != key) {
            this.redisTemplate.opsForValue().set((Object)String.valueOf(key), value);
        }
    }

    public Object getObject(Object key) {
        try {
            if (null != key) {
                return this.redisTemplate.opsForValue().get(key);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6----->{}\u7f13\u5b58\u51fa\u9519", key);
        }
        return null;
    }

    public Object removeObject(Object key) {
        if (null != key) {
            return this.redisTemplate.delete((Object)String.valueOf(key));
        }
        return null;
    }

    public void clear() {
        log.debug("\u6e05\u7a7a\u7f13\u5b58");
        Set keys = this.redisTemplate.keys((Object)("*:" + this.id + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public int getSize() {
        Long size = (Long)this.redisTemplate.execute(RedisServerCommands::dbSize);
        if (null != size) {
            return size.intValue();
        }
        return 0;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

