/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.card.RechargeRecordItemResVo;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthRegisteredReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.QueryCardPayStatusReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RechargeCardReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RechargeCardToHosReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateStatusVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WisdomRechargeRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.QueryOutPatientPayStatusReqVO;
import com.ebaiyihui.wisdommedical.service.ICardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iCard"})
@Api(tags={"\u5c31\u8bca\u5361API"})
public class ICardController {
    private static final Logger log = LoggerFactory.getLogger(ICardController.class);
    @Autowired
    private ICardService iCardService;

    @ApiOperation(value="\u9662\u5185\u8d26\u6237\u5145\u503c", notes="\u9662\u5185\u8d26\u6237\u5145\u503c")
    @PostMapping(value={"/recharge"})
    public BaseResponse recharge(@RequestBody @Valid RechargeCardReqVo rechargeCardReqVo) {
        BaseResponse recharge = this.iCardService.recharge(rechargeCardReqVo);
        return recharge;
    }

    @ApiOperation(value="\u9662\u5185\u8d26\u6237\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u533b\u4fdd\u6302\u53f7)", notes="\u9662\u5185\u8d26\u6237\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u533b\u4fdd\u6302\u53f7)")
    @PostMapping(value={"/queryCardPayStatusHealth"})
    @DisableAuthConfig
    public BaseResponse queryCardPayStatus(@RequestBody @Valid HealthRegisteredReqVo healthRegisteredReqVo) {
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.iCardService.queryCardPayStatusHealth(healthRegisteredReqVo);
        }
        catch (InHospitalException e) {
            log.error(e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u9662\u5185\u8d26\u6237\u67e5\u8be2", notes="\u9662\u5185\u8d26\u6237\u67e5\u8be2")
    @PostMapping(value={"/queryCardAccount"})
    public BaseResponse queryCardAccount(@RequestBody @Valid RechargeCardToHosReqVo rechargeCardToHosReqVo) {
        BaseResponse baseResponse = this.iCardService.queryCardAccount(rechargeCardToHosReqVo);
        return baseResponse;
    }

    @ApiOperation(value="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u6302\u53f7)", notes="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u6302\u53f7)")
    @PostMapping(value={"/queryCardPayStatusAppoint"})
    @DisableAuthConfig
    public BaseResponse queryCardPayStatusAppoint(@RequestBody @Valid UpdateStatusVoReq updateStatusVoReq) {
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.iCardService.queryCardPayStatusAppoint(updateStatusVoReq);
        }
        catch (InHospitalException e) {
            log.error(e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u9884\u7ea6\u6302\u53f7)", notes="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u9884\u7ea6\u6302\u53f7)")
    @PostMapping(value={"/queryCardPayStatusSubAppoint"})
    @DisableAuthConfig
    public BaseResponse queryCardPayStatusSubAppoint(@RequestBody @Valid UpdateStatusVoReq updateStatusVoReq) {
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.iCardService.queryCardPayStatusSubAppoint(updateStatusVoReq);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u95e8\u8bca\u7f34\u8d39)", notes="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2(\u95e8\u8bca\u7f34\u8d39)")
    @PostMapping(value={"/queryCardPayStatusOutPatient"})
    @DisableAuthConfig
    public BaseResponse queryCardPayStatusOutPatient(@RequestBody @Valid QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO) {
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.iCardService.queryCardPayStatusOutPatient(queryOutPatientPayStatusReqVO);
        }
        catch (InHospitalException e) {
            log.error(e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2", notes="\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c\u67e5\u8be2")
    @PostMapping(value={"/queryCardPayStatus"})
    @DisableAuthConfig
    public BaseResponse queryCardPayStatus(@RequestBody @Valid QueryCardPayStatusReqVo queryCardPayStatusReqVo) {
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.iCardService.queryCardPayStatus(queryCardPayStatusReqVo);
        }
        catch (InHospitalException e) {
            log.error(e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5c31\u8bca\u5361\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2", notes="\u5c31\u8bca\u5361\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2")
    @PostMapping(value={"/rechargeRecord"})
    public BaseResponse<List<RechargeRecordItemResVo>> rechargeRecord(@RequestBody @Valid WisdomRechargeRecordReqVo wisdomRechargeRecordReqVo) {
        return this.iCardService.rechargeRecord(wisdomRechargeRecordReqVo);
    }

    @ApiOperation(value="\u5c31\u8bca\u5361\u4ea4\u6613\u9000\u6b3e", notes="\u5c31\u8bca\u5361\u4ea4\u6613\u9000\u6b3e")
    @GetMapping(value={"/iCardRefund"})
    @DisableAuthConfig
    public BaseResponse<String> iCardRefund(@RequestParam(value="sysId") String sysId) {
        return this.iCardService.iCardRefund(sysId);
    }
}

