/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckOrderReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckOrderResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutPatientOrderRecordReqVo;
import com.ebaiyihui.wisdommedical.service.OrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ba2\u5355\u4e1a\u52a1api"})
@RequestMapping(value={"/api/v1/order"})
public class OrderRecordController {
    private static final Logger log = LoggerFactory.getLogger(OrderRecordController.class);
    @Autowired
    private OrderService orderService;

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868", notes="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/getAppointmentOrderList"})
    @DisableAuthConfig
    public BaseResponse<OrderRecordPageResult> getAppointmentOrderList(@Valid OrderRecordReqVo orderRecordReqVo) {
        try {
            OrderRecordPageResult pageResult = this.orderService.getAppointmentOrderList(orderRecordReqVo);
            return BaseResponse.success((Object)pageResult);
        }
        catch (Exception e) {
            log.info("getAppointmentOrderList\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u68c0\u67e5\u8ba2\u5355\u662f\u5426\u53ef\u9000\u6b3e", notes="\u68c0\u67e5\u8ba2\u5355\u662f\u5426\u53ef\u9000\u6b3e")
    @GetMapping(value={"/checkOrderWhetherRefund"})
    public BaseResponse<CheckOrderResVo> checkOrderWhetherRefund(@Valid CheckOrderReqVo checkOrderReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        CheckOrderResVo checkOrderResVo = null;
        try {
            checkOrderResVo = this.orderService.checkAppointmentOrderWhetherRefund(checkOrderReqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)checkOrderResVo);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868", notes="\u95e8\u8bca\u7f34\u8d39\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/getOutPatientOrderList"})
    public BaseResponse<OutPatientOrderRecordPageResult> getOutPatientOrderList(@Valid OutPatientOrderRecordReqVo orderRecordReqVo) {
        try {
            OutPatientOrderRecordPageResult pageResult = this.orderService.getOutPatientOrderList(orderRecordReqVo);
            return BaseResponse.success((Object)pageResult);
        }
        catch (Exception e) {
            log.info("getOutPatientOrderList\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u8be6\u60c5\u5217\u8868", notes="\u95e8\u8bca\u7f34\u8d39\u8be6\u60c5\u5217\u8868")
    @GetMapping(value={"/getOutPatientOrderListDetail"})
    public BaseResponse<OutPatientOrderRecordVo> getOutPatientOrderListDetail(@RequestParam String outPatientId) {
        if (null == outPatientId || "".equals(outPatientId)) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutPatientOrderRecordVo outPatientOrderRecordVo = this.orderService.getOutPatientOrderDetail(outPatientId);
        return BaseResponse.success((Object)outPatientOrderRecordVo);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6302\u53f7\u8ba2\u5355\u5217\u8868", notes="\u5bfc\u51fa\u6302\u53f7\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/exportAppointmentRecords"})
    public BaseResponse exportAppointmentRecords(@RequestBody @Valid OrderRecordReqVo orderRecordReqVo, HttpServletResponse response) {
        this.orderService.reportExcelAppointmentOrderList(orderRecordReqVo, response);
        return BaseResponse.success();
    }
}

