/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.OrderBarcodeReq;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.DailyBillDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.DailyBillDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.QueryOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.QueryOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.RefundReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.TotalDailyBillReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.TotalDailyBillResVO;
import com.ebaiyihui.wisdommedical.service.OutreachService;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5916\u8054\u4e1a\u52a1api"})
@RequestMapping(value={"/api/v1/"})
public class OutreachController {
    private static final Logger log = LoggerFactory.getLogger(OutreachController.class);
    @Autowired
    private OutreachService outreachService;
    @Autowired
    private EncryptUtils encryptUtils;
    @Autowired
    private ProPropertiesConstant propertiesConstant;

    @ApiOperation(value="his\u5e73\u53f0\u9000\u6b3e\u4e1a\u52a1", notes="his\u5e73\u53f0\u9000\u6b3e\u4e1a\u52a1")
    @PostMapping(value={"refund"})
    @DisableAuthConfig
    public OutreachResponse<String> refundForHis(@Valid @RequestBody OutreachRequest<RefundReqVO> refundRequest, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return OutreachResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutreachResponse refundResponse = null;
        try {
            refundResponse = this.outreachService.refundForHis(refundRequest);
        }
        catch (Exception e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }

    @ApiOperation(value="his\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3", notes="his\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3")
    @PostMapping(value={"getTotalDailyBill"})
    @DisableAuthConfig
    public OutreachResponse<TotalDailyBillResVO> getTotalDailyBill(@Valid @RequestBody OutreachRequest<TotalDailyBillReqVO> req, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return OutreachResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutreachResponse response = null;
        try {
            response = this.outreachService.getTotalDailyBill(req);
        }
        catch (Exception e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="his\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3", notes="his\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3")
    @PostMapping(value={"getDailyDetailBill"})
    @DisableAuthConfig
    public OutreachResponse<DailyBillDetailResVO> getDailyDetailBill(@Valid @RequestBody OutreachRequest<DailyBillDetailReqVO> req, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return OutreachResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutreachResponse response = null;
        try {
            response = this.outreachService.getDailyDetailBill(req);
        }
        catch (Exception e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="his\u67e5\u8be2\u8ba2\u5355", notes="his\u67e5\u8be2\u8ba2\u5355")
    @PostMapping(value={"queryOrder"})
    @DisableAuthConfig
    public OutreachResponse<QueryOrderResVO> queryOrder(@Valid @RequestBody OutreachRequest<QueryOrderReqVO> req, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return OutreachResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutreachResponse response = null;
        try {
            response = this.outreachService.queryOrder(req);
        }
        catch (Exception e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6d4b\u8bd5", notes="\u6d4b\u8bd5")
    @GetMapping(value={"test"})
    @DisableAuthConfig
    public HisPayRes test(String dealSeq) {
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(Long.parseLong(dealSeq)));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        return hisPayRes;
    }
}

