/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.appoint.HealthBackPayResVo;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthBackReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthRegisteredReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.PayPlatformCallBackVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateStatusVoReq;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u652f\u4ed8\u56de\u8c03api"})
@RequestMapping(value={"/api/v1/payCallBack"})
public class PayCallBackController {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackController.class);
    public static final String SUCCESS = "success";
    @Autowired
    private PayCallBackService payCallBackService;

    @ApiOperation(value="", notes="\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"dayAppointmentCallBack"})
    @DisableAuthConfig
    public BaseResponse dayAppointmentCallBack(@RequestBody ResponseNotifyRestVo responseNotifyRestVo) {
        try {
            this.payCallBackService.dayAppointmentCallBack(responseNotifyRestVo);
        }
        catch (AppointmentException e) {
            e.printStackTrace();
            return BaseResponse.success((Object)SUCCESS);
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @ApiOperation(value="\u5c31\u8bca\u5361\u5145\u503c\u652f\u4ed8\u56de\u8c03", notes="\u5c31\u8bca\u5361\u5145\u503c\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"cardRechargeCallBack"})
    @DisableAuthConfig
    public BaseResponse cardRechargeCallBack(@RequestBody ResponseNotifyRestVo responseNotifyRestVo) {
        try {
            log.info("\u5c31\u8bca\u5361\u5145\u503c\u652f\u4ed8\u56de\u8c03 \u5165\u53c2\uff1a  ResponseNotifyRestVo{}", (Object)JSON.toJSONString((Object)responseNotifyRestVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.payCallBackService.cardRechargeCallBack(responseNotifyRestVo);
        }
        catch (Exception e) {
            log.error(String.valueOf(e));
            return BaseResponse.success((Object)SUCCESS);
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03", notes="\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"appointmentCallBack"})
    @DisableAuthConfig
    public BaseResponse appointmentCallBack(@RequestBody ResponseNotifyRestVo responseNotifyRestVo) {
        try {
            log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03 \u5165\u53c2\uff1a  ResponseNotifyRestVo{}", (Object)JSON.toJSONString((Object)responseNotifyRestVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.payCallBackService.appointmentCallBack(responseNotifyRestVo);
        }
        catch (Exception e) {
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03\u5f02\u5e38->{}", (Throwable)e);
            return BaseResponse.success((Object)SUCCESS);
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @ApiOperation(value="\u652f\u4ed8\u5bf9\u8d26\u5e73\u53f0\u4e13\u7528", notes="\u652f\u4ed8\u5bf9\u8d26\u5e73\u53f0\u4e13\u7528")
    @PostMapping(value={"payPlatformCallBack"})
    public BaseResponse<List<PayPlatformCallBackVoRes>> payPlatformCallBack(@RequestParam(value="posId") String posId, @RequestParam(value="tranDate") String tranDate) {
        log.info("\u5165\u53c2\uff1a{},{}", (Object)posId, (Object)tranDate);
        List orderRecordList = null;
        try {
            orderRecordList = this.payCallBackService.payPlatformCallBack(posId, tranDate);
            log.info("\u51fa\u53c2\uff1a{}", (Object)orderRecordList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseResponse.success((Object)orderRecordList);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u56de\u8c03", notes="\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"outpatientPaymentCallBack"})
    @DisableAuthConfig
    public BaseResponse outpatientPaymentCallBack(@RequestBody ResponseNotifyRestVo responseNotifyRestVo) {
        log.info("PayCallBackController.outpatientPaymentCallBack->\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u56de\u8c03\u5165\u53c2ResponseNotifyRestVo{}", (Object)responseNotifyRestVo.toString());
        try {
            this.payCallBackService.outpatientPaymentCallBack(responseNotifyRestVo);
        }
        catch (Exception e) {
            log.error("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u56de\u8c03\u5f02\u5e38->{}", (Throwable)e);
            return BaseResponse.success((Object)SUCCESS);
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @ApiOperation(value="\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u56de\u8c03", notes="\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"inHospDepositPayCallBack"})
    @DisableAuthConfig
    public BaseResponse inHospDepositPayCallBack(@RequestBody ResponseNotifyRestVo responseNotifyRestVo) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u56de\u8c03\u5165\u53c2 responseNotifyRestVo:{}", (Object)JSON.toJSONString((Object)responseNotifyRestVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        try {
            this.payCallBackService.inHospDepositPayCallBack(responseNotifyRestVo);
        }
        catch (Exception e) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u56de\u8c03\u5931\u8d25->{}", (Throwable)e);
            return BaseResponse.success((Object)SUCCESS);
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @ApiOperation(value="\u652f\u4ed8\u5b8c\u6210\u540e\u66f4\u65b0\u8ba2\u5355\u72b6\u6001(\u4fdd\u5b9a\u4e13\u7528)")
    @PostMapping(value={"updateStatus"})
    @DisableAuthConfig
    public BaseResponse updateStatus(@RequestBody UpdateStatusVoReq updateStatusVoReq) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u56de\u8c03\u5165\u53c2 responseNotifyRestVo:{}", (Object)updateStatusVoReq.toString());
        try {
            this.payCallBackService.updateStatus(updateStatusVoReq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @ApiOperation(value="\u533b\u4fdd\u6302\u53f7(\u4fdd\u5b9a\u4e13\u7528)")
    @PostMapping(value={"/healthRegistered"})
    public BaseResponse healthRegistered(@RequestBody @Valid HealthRegisteredReqVo healthRegisteredReqVo) throws InHospitalException {
        log.info("\u533b\u4fdd\u6302\u53f7\u5165\u53c2 healthRegisteredReqVo:{}", (Object)healthRegisteredReqVo.toString());
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.payCallBackService.healthRegistered(healthRegisteredReqVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baseResponse;
    }

    @ApiOperation(value="\u533b\u4fdd\u9000\u53f7(\u4fdd\u5b9a\u4e13\u7528)")
    @PostMapping(value={"/healthBackPay"})
    public BaseResponse<HealthBackPayResVo> healthBackPay(@RequestBody HealthBackReqVo healthBackReqVo) {
        log.info("\u533b\u4fdd\u9000\u53f7\u5165\u53c2:{}", (Object)healthBackReqVo);
        BaseResponse healthBackPayResVoBaseResponse = this.payCallBackService.healthBackPay(healthBackReqVo);
        return healthBackPayResVoBaseResponse;
    }
}

