/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.model.Examine;
import com.ebaiyihui.wisdommedical.model.Refund;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6302\u53f7api"})
@RequestMapping(value={"/api/v1/appoint"})
public class AppointmentController {
    private static final Logger log = LoggerFactory.getLogger(AppointmentController.class);
    @Autowired
    private AppointmentService appointmentService;

    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u786e\u8ba4", notes="\u5f53\u65e5\uff0c\u9884\u7ea6\u6302\u53f7\u53ef\u7528")
    @PostMapping(value={"confirmAppointment"})
    public BaseResponse<String> confirmAppointment(@RequestBody ConfirmAppointmentVo confirmAppointmentVo) {
        String confirmAppointmentId = null;
        try {
            confirmAppointmentId = this.appointmentService.confirmAppointment(confirmAppointmentVo);
        }
        catch (ScheduleException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)confirmAppointmentId);
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u7ea6\u6302\u53f7\u786e\u8ba4\u4fe1\u606f", notes="\u5f53\u65e5\uff0c\u9884\u7ea6\u6302\u53f7\u53ef\u7528")
    @GetMapping(value={"getConfirmAppointment"})
    public BaseResponse<ConfirmAppointmentVo> getConfirmAppointment(String confirmAppointmentId) {
        ConfirmAppointmentVo confirmAppointmentVo = this.appointmentService.getConfirmAppointment(confirmAppointmentId);
        return BaseResponse.success((Object)confirmAppointmentVo);
    }

    @ApiOperation(value="\u5f53\u65e5\u6302\u53f7\u6302\u53f7\u786e\u8ba4", notes="\u5f53\u65e5\u6302\u53f7\u53ef\u7528")
    @PostMapping(value={"dayAppointmentCreateOrder"})
    public BaseResponse<String> dayAppointmentCreateOrder(@Valid @RequestBody DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        String sysAppointmentId = null;
        try {
            sysAppointmentId = this.appointmentService.dayAppointmentCreateOrder(dayAppointmentCreateOrderVoReq);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)sysAppointmentId);
    }

    @ApiOperation(value="\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u7684\u4fe1\u606f", notes="\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u7684\u4fe1\u606f")
    @GetMapping(value={"getConfirmPayInfo"})
    public BaseResponse<GetConfirmPayInfoVoRes> getConfirmPayInfo(@RequestParam(value="sysAppointmentId") String sysAppointmentId) {
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = this.appointmentService.getConfirmPayInfo(sysAppointmentId);
        return BaseResponse.success((Object)getConfirmPayInfoVoRes);
    }

    @ApiOperation(value="\u5f53\u65e5\u6302\u53f7\u652f\u4ed8", notes="\u5f53\u65e5\u6302\u53f7\u652f\u4ed8")
    @PostMapping(value={"dayAppointmentPay"})
    public BaseResponse<String> dayAppointmentPay(@Valid @RequestBody DayAppointmentPayVoReq dayAppointmentPayVoReq, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.appointmentService.dayAppointmentPay(dayAppointmentPayVoReq, request);
        }
        catch (Exception e) {
            log.error("\u5f53\u65e5\u6302\u53f7\u5f02\u5e38:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u652f\u4ed8", notes="\u9884\u7ea6\u6302\u53f7\u652f\u4ed8")
    @PostMapping(value={"appointmentPay"})
    public BaseResponse<String> appointmentPay(@Valid @RequestBody DayAppointmentPayVoReq dayAppointmentPayVoReq, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.appointmentService.appointmentPay(dayAppointmentPayVoReq, request);
        }
        catch (Exception e) {
            log.error("\u9884\u7ea6\u6302\u53f7\u5f02\u5e38:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u6302\u53f7\u6210\u529f\u4fe1\u606f", notes="\u6302\u53f7")
    @GetMapping(value={"getRegisteredSuccessfullyInfo"})
    public BaseResponse<List<AppointmentRecordVo>> getRegisteredSuccessfullyInfo(String userId, String hospitalCode, String appCode, String channelCode) {
        List appointmentRecordVoList;
        Date start = new Date();
        Date end = DateUtils.getDateAfter((Date)start, (int)7);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String admDateStart = format.format(start);
        String admDateEnd = format.format(end);
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("admDateStart", admDateStart);
        queryMap.put("admDateEnd", admDateEnd);
        queryMap.put("userId", userId);
        queryMap.put("appointStatus", AppointmentStatusEnum.PAY.getValue());
        queryMap.put("now", admDateStart);
        queryMap.put("hospitalCode", hospitalCode);
        try {
            appointmentRecordVoList = this.appointmentService.selectByUserIdAndStatus(queryMap, appCode, channelCode);
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u83b7\u53d6\u6302\u53f7\u6210\u529f\u4fe1\u606f\u6570\u636e\u5f02\u5e38");
        }
        return BaseResponse.success((Object)appointmentRecordVoList);
    }

    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u6302\u53f7\u786e\u8ba4", notes="\u9884\u7ea6\u6302\u53f7\u53ef\u7528")
    @PostMapping(value={"appointmentCreateOrder"})
    public BaseResponse<String> appointmentCreateOrder(@Valid @RequestBody AppointmentCreateOrderVoReq appointmentCreateOrderVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        String sysAppointmentId = null;
        try {
            sysAppointmentId = this.appointmentService.appointmentCreateOrder(appointmentCreateOrderVoReq);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)sysAppointmentId);
    }

    @ApiOperation(value="\u6211\u7684\u6302\u53f7\u5217\u8868", notes="\u6302\u53f7")
    @GetMapping(value={"getMyRegistrationList"})
    public BaseResponse<List<AppointmentRecordVo>> getMyRegistrationList(String userId, String hospitalCode, String cardId) {
        RegisterationQueryParamsDTO registerationQueryParamsDTO = new RegisterationQueryParamsDTO();
        registerationQueryParamsDTO.setUserId(userId);
        registerationQueryParamsDTO.setHospitalCode(hospitalCode);
        registerationQueryParamsDTO.setCardId(cardId);
        List appointmentRecordVoList = null;
        try {
            appointmentRecordVoList = this.appointmentService.getMyRegistrationList(registerationQueryParamsDTO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u83b7\u53d6\u6211\u7684\u6302\u53f7\u8bb0\u5f55\u6570\u636e\u5f02\u5e38");
        }
        return BaseResponse.success((Object)appointmentRecordVoList);
    }

    @ApiOperation(value="\u6211\u7684\u6302\u53f7\u8be6\u60c5", notes="\u6302\u53f7")
    @GetMapping(value={"getMyRegistrationDetail"})
    public BaseResponse<AppointmentRecordDetailVo> getMyRegistrationDetail(String sysAppointmentId) {
        if (StringUtils.isBlank((String)sysAppointmentId)) {
            BaseResponse.error((String)"sysAppointmentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AppointmentRecordDetailVo appointmentRecordDetailVo = null;
        try {
            appointmentRecordDetailVo = this.appointmentService.getMyRegistrationDetail(sysAppointmentId);
        }
        catch (AppointmentException e) {
            BaseResponse.error((String)"\u67e5\u8be2\u6211\u7684\u6302\u53f7\u8be6\u60c5\u5931\u8d25");
        }
        return BaseResponse.success((Object)appointmentRecordDetailVo);
    }

    @ApiOperation(value="\u53d6\u6d88\u9884\u7ea6", notes="\u53d6\u6d88\u9884\u7ea6")
    @PostMapping(value={"cancelAppointment"})
    public BaseResponse<String> cancelAppointment(@Valid @RequestBody CancelAppointmentVoReq cancelAppointmentVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.appointmentService.cancelAppointment(cancelAppointmentVoReq);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7", notes="\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7")
    @PostMapping(value={"withdrawNumber"})
    public BaseResponse<String> withdrawNumber(@Valid @RequestBody WithdrawNumberVoReq withdrawNumberVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.appointmentService.withdrawNumber(withdrawNumberVoReq);
        }
        catch (Exception e) {
            log.error("\u9884\u7ea6\u6302\u53f7\u9000\u6b3e\u5931\u8d25->{}", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u7ba1\u7406\u5458\u7aef\u9000\u6b3e", notes="\u7ba1\u7406\u5458\u7aef\u9000\u6b3e")
    @PostMapping(value={"refund"})
    @DisableAuthConfig
    public BaseResponse<String> refund(@Valid @RequestBody Refund refund) {
        BaseResponse baseResponse = this.appointmentService.appointmentRefund(refund);
        return baseResponse;
    }

    @ApiOperation(value="\u6d41\u8c03\u8c03\u67e5")
    @PostMapping(value={"examine"})
    public BaseResponse<String> examine(@RequestBody Examine examine) {
        BaseResponse baseResponse = this.appointmentService.examine(examine);
        return baseResponse;
    }

    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u53d6\u6d88\u652f\u4ed8")
    @GetMapping(value={"withdrawPay"})
    public void withdrawPay(@RequestParam(value="appointmentId") String appointmentId) {
        this.appointmentService.withdrawPay(appointmentId);
    }

    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u5f85\u652f\u4ed8\u4e13\u7528\u63a5\u53e3")
    @GetMapping(value={"getToBePaidPay"})
    public BaseResponse<String> toBePaidPay(@RequestParam(value="sysAppointmentId") String sysAppointmentId) {
        return this.appointmentService.appointmentRegistrationToBePaid(sysAppointmentId);
    }
}

