/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.doctoruser.api.pojo.base.dto.dept.SynHisDeptReq;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.model.VO.DeptCategoryRecordVO;
import com.ebaiyihui.wisdommedical.model.VO.QueryDeptInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DeptListVoReq;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import com.ebaiyihui.wisdommedical.service.DoctorInformationService;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79d1\u5ba4api"})
@RequestMapping(value={"api/v1/dept"})
public class DepartmentController {
    private static final Logger log = LoggerFactory.getLogger(DepartmentController.class);
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private ProPropertiesConstant proPropertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private DoctorInformationService doctorInformationService;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @ApiOperation(value="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4", notes="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4")
    @GetMapping(value={"/getDeptList"})
    public BaseResponse<List<GetDeptListVoRes>> getDeptList(@RequestParam(value="organCode", required=false) String organCode, @RequestParam(value="userId") String userId, @RequestParam(value="organId") String organId, @RequestParam(value="hospitalAreaCode", required=false) String hospitalAreaCode) {
        List getDeptListVoResList = null;
        try {
            getDeptListVoResList = this.departmentService.getDeptListNew(organCode, userId, hospitalAreaCode);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getDeptListVoResList);
    }

    @ApiOperation(value="\u5220\u9664\u79d1\u5ba4\u7f13\u5b58", notes="\u5220\u9664\u79d1\u5ba4\u7f13\u5b58")
    @DisableAuthConfig
    @GetMapping(value={"/delDeptList"})
    public BaseResponse<String> delDeptList(@RequestParam(value="hospitalAreaCode", required=true) String hospitalAreaCode) {
        try {
            Boolean delete = this.redisTemplate.delete((Object)("deptList_" + hospitalAreaCode));
            assert (delete != null);
            return BaseResponse.success((Object)delete.toString());
        }
        catch (Exception e) {
            log.error("delDeptList\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u540c\u6b65\u79d1\u5ba4\u4fe1\u606f", notes="\u540c\u6b65\u79d1\u5ba4\u4fe1\u606f")
    @GetMapping(value={"/synchronizeHisDeptInfo"})
    public BaseResponse synchronizeHisDeptInfo() {
        List departmentEntityList = this.deptRecordMapper.selectListByHospitalCode(this.proPropertiesConstant.getOrganCode(), "0");
        departmentEntityList.forEach(departmentEntity -> {
            SynHisDeptReq synHisDeptReq = new SynHisDeptReq();
            synHisDeptReq.setDeptCode(departmentEntity.getDeptCode());
            synHisDeptReq.setDeptName(departmentEntity.getDeptName());
            synHisDeptReq.setOrganId(Integer.valueOf(661));
            BaseResponse baseResponse = this.getDoctorInfoUtil.getSynchronizeHisDeptInfo(synHisDeptReq);
            log.error(baseResponse.toString());
        });
        return BaseResponse.success();
    }

    @ApiOperation(value="\u641c\u7d22\u79d1\u5ba4", notes="\u641c\u7d22\u4e8c\u7ea7\u79d1\u5ba4")
    @GetMapping(value={"/searchDept"})
    public BaseResponse<List<HospitalDeptVo>> searchDept(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId, @RequestParam(value="searchKey") String key) {
        List hospitalDeptVoList = null;
        try {
            hospitalDeptVoList = this.departmentService.searchDept(organCode, userId, key);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)hospitalDeptVoList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5386\u53f2\u641c\u7d22\u8bb0\u5f55", notes="\u83b7\u53d6\u5386\u53f2\u641c\u7d22\u8bb0\u5f55")
    @GetMapping(value={"/getRecentSearchDeptList"})
    public BaseResponse<List<String>> getRecentSearchDeptList(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId) {
        List keywordList = null;
        try {
            keywordList = this.departmentService.getRecentSearchDeptList(organCode, userId);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)keywordList);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u5386\u53f2\u8bb0\u5f55", notes="\u5220\u9664\u5355\u4e2a\u5386\u53f2\u8bb0\u5f55")
    @GetMapping(value={"/deleteOneSearchRecord"})
    public BaseResponse deleteOneSearchRecord(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId, @RequestParam(value="keyword") String deptCode) {
        try {
            this.departmentService.deleteOneSearchRecord(organCode, userId, deptCode);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5220\u9664\u5168\u90e8\u5386\u53f2\u8bb0\u5f55", notes="\u5220\u9664\u5168\u90e8\u5386\u53f2\u8bb0\u5f55")
    @GetMapping(value={"/deleteSearchRecord"})
    public BaseResponse deleteAllSearchRecords(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId) {
        try {
            this.departmentService.deleteAllSearchRecords(organCode, userId);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u79d1\u5ba4\u987a\u5e8f", notes="\u4fee\u6539\u79d1\u5ba4\u987a\u5e8f")
    @PostMapping(value={"/updateDepartOrder"})
    public BaseResponse updateDepartOrder(@RequestBody DeptCategoryRecordVO deptCategoryRecordVO) {
        try {
            this.departmentService.updateDepartOrder(deptCategoryRecordVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f", notes="\u4fdd\u5b9a")
    @PostMapping(value={"/queryDeptInfo"})
    public BaseResponse queryDeptInfo(@RequestBody QueryDeptInfoVo queryDeptInfoVo) {
        try {
            return this.departmentService.queryDeptInfo(queryDeptInfoVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4e8c\u7ea7\u79d1\u5ba4", notes="\u7528\u4e8e\u533b\u751f\u6392\u5e8f")
    @GetMapping(value={"/getDeptAllList"})
    public BaseResponse<List<DeptListVoReq>> getDeptAllList() {
        List deptList = this.doctorInformationService.getDeptList();
        if (deptList.size() == 0) {
            return BaseResponse.error((String)"\u6682\u65e0\u79d1\u5ba4\u4fe1\u606f");
        }
        return BaseResponse.success((Object)deptList);
    }
}

