/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import cn.hutool.core.util.StrUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.service.DoctorInformationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u751f\u6392\u5e8f"})
@RequestMapping(value={"/api/v1/doctorSort"})
public class DoctorInformationController {
    private static final Logger log = LoggerFactory.getLogger(DoctorInformationController.class);
    private DoctorInformationService doctorInformationService;

    @Autowired
    public void setDoctorInformationService(DoctorInformationService doctorInformationService) {
        this.doctorInformationService = doctorInformationService;
    }

    @ApiOperation(value="\u6839\u636e\u4e8c\u7ea7\u79d1\u5ba4code  \u83b7\u53d6\u65d7\u4e0b\u6240\u6709\u533b\u751f", notes="\u4fdd\u5b9a")
    @GetMapping(value={"/queryDeptInfo"})
    public BaseResponse getDoctorList(@RequestParam(value="deptCode") String deptCode, @RequestParam(value="docCode") String docCode) {
        try {
            List doctorList = this.doctorInformationService.getDoctorList(deptCode, docCode);
            return BaseResponse.success((Object)doctorList);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u79d1\u5ba4\u51fa\u73b0\u4e25\u91cd\u9519\u8bef \u9519\u8bef\u4fe1\u606f\u4e3a - >{}", (Object)e.getMessage());
            return BaseResponse.error((String)"\u83b7\u53d6\u79d1\u5ba4\u51fa\u9519");
        }
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751f\u4e3b\u952e\u4fee\u6539\u533b\u751f\u6392\u5e8f\u4fe1\u606f", notes="\u4fdd\u5b9a")
    @GetMapping(value={"/updateDoctor"})
    public BaseResponse UpdateDoctorSortByDocCode(@RequestParam(value="id") String id, @RequestParam(value="sort") Integer sort, @RequestParam(value="deptCode") String deptCode) {
        if (StrUtil.isBlankIfStr((Object)id)) {
            return BaseResponse.error((String)"\u533b\u751fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlankIfStr((Object)sort)) {
            return BaseResponse.error((String)"\u6392\u5e8f\u6570\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.doctorInformationService.UpdateDoctorSortByDocCode(id, sort, deptCode);
    }

    @ApiOperation(value="\u6839\u636e\u4e8c\u7ea7\u79d1\u5ba4code \u548c\u9662\u533a \u83b7\u53d6\u65d7\u4e0b\u6240\u6709\u533b\u751f", notes="\u4fdd\u5b9a")
    @GetMapping(value={"/getDoctorByCourtyardCodeList"})
    public BaseResponse<List<GetScheduleVoRes>> getDoctorByCourtyardCodeList(@RequestParam(value="deptCode") String deptCode, @RequestParam(value="courtyardCode") String courtyardCode) {
        try {
            List doctorList = this.doctorInformationService.getDoctorByCourtyardCodeList(deptCode, courtyardCode);
            return BaseResponse.success((Object)doctorList);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u79d1\u5ba4\u51fa\u73b0\u4e25\u91cd\u9519\u8bef \u9519\u8bef\u4fe1\u606f\u4e3a - >{}", (Object)e.getMessage());
            return BaseResponse.error((String)"\u83b7\u53d6\u79d1\u5ba4\u51fa\u9519");
        }
    }
}

