/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.doc;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.model.DoctorInformationEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.DelectDocReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DoctorUrlReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDocListReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDocListResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UploadDocExcelReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UploadDocReqVo;
import com.ebaiyihui.wisdommedical.service.DocManageService;
import com.ebaiyihui.wisdommedical.util.ExcelUtil;
import com.ebaiyihui.wisdommedical.util.UnZipUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u533b\u751f\u7ba1\u7406api"})
@RequestMapping(value={"/api/v1/doc/"})
public class DoctorManageController {
    private static final Logger log = LoggerFactory.getLogger(DoctorManageController.class);
    @Autowired
    private DocManageService docManageService;

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u533b\u751f\u5217\u8868", notes="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u533b\u751f\u5217\u8868")
    @PostMapping(value={"/getDocList"})
    @DisableAuthConfig
    public BaseResponse<GetDocListResVo> getDocList(@Valid @RequestBody GetDocListReqVo getDocListReqVo) {
        try {
            BaseResponse pageResult = this.docManageService.getDocList(getDocListReqVo);
            return pageResult;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u533b\u751f", notes="\u6279\u91cf\u5220\u9664\u533b\u751f")
    @PostMapping(value={"/delectDocs"})
    @DisableAuthConfig
    public BaseResponse<String> delectDocs(@Valid @RequestBody DelectDocReqVo delectDocReqVo) {
        try {
            BaseResponse delectDocs = this.docManageService.delectDocs(delectDocReqVo);
            return delectDocs;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u6dfb\u52a0\u533b\u751f\u4fe1\u606f", notes="\u4e0a\u4f20\u6dfb\u52a0\u533b\u751f\u4fe1\u606f")
    @PostMapping(value={"/uploadDoc"})
    @DisableAuthConfig
    public BaseResponse<String> uploadDoc(@Valid @RequestBody UploadDocReqVo uploadDocReqVo) {
        try {
            BaseResponse uploadDocRes = this.docManageService.uploadDoc(uploadDocReqVo);
            return uploadDocRes;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u533b\u751f\u4fe1\u606f", notes="\u66f4\u65b0\u533b\u751f\u4fe1\u606f")
    @PostMapping(value={"/updateDocInfo"})
    @DisableAuthConfig
    public BaseResponse<String> updateDocInfo(@RequestBody DoctorInformationEntity uploadDocReqVo) {
        try {
            BaseResponse uploadDocRes = this.docManageService.updateDocInfo(uploadDocReqVo);
            return uploadDocRes;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u8be6\u60c5", notes="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u533b\u751f\u5217\u8868")
    @GetMapping(value={"/selectDocInfo"})
    @DisableAuthConfig
    public BaseResponse<UploadDocReqVo> selectDocInfo(@RequestParam(value="id") Integer id) {
        try {
            BaseResponse selectDocInfoRes = this.docManageService.selectDocInfo(id);
            return selectDocInfoRes;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @PostMapping(value={"/importWesternFileUpload"})
    @ApiOperation(value="\u6587\u4ef6\u5bfc\u5165", notes="\u6587\u4ef6\u5bfc\u5165")
    public BaseResponse<Object> importWesternFileUpload(@RequestParam MultipartFile file) throws IOException {
        List uploadDocList = ExcelUtil.importExcel((MultipartFile)file, UploadDocExcelReqVo.class);
        if (uploadDocList.size() > 100) {
            return BaseResponse.error((String)"\u5355\u6b21\u5bfc\u5165\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e00\u767e\u6761");
        }
        return this.docManageService.importWestern(uploadDocList);
    }

    @GetMapping(value={"/downloadImportDrugTemplate"})
    @ApiOperation(value="\u5bfc\u51fa\u6a21\u677f", notes="\u5bfc\u51fa\u6a21\u677f")
    public void downloadImportDrugTemplate(HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        ExcelUtil.exportExcel(list, null, (String)"sheet1", UploadDocExcelReqVo.class, (String)"\u533b\u751f\u5bfc\u5165\u8868\u5934", (HttpServletResponse)response);
    }

    @PostMapping(value={"/Object"})
    @ApiOperation(value="\u6279\u91cf\u63d2\u5165\u5934\u50cf", notes="\u6279\u91cf\u63d2\u5165\u5934\u50cf")
    public BaseResponse<Object> insertdoctorPortraiturl(@RequestParam(value="file") MultipartFile file) {
        try {
            BaseResponse ObjectRes = this.docManageService.insertdoctorPortraiturl(file);
            return ObjectRes;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @PostMapping(value={"/uploadOss"})
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20\u81f3oss", notes="\u6587\u4ef6\u4e0a\u4f20\u81f3oss")
    public BaseResponse<String> uploadOss(@RequestParam(value="file") MultipartFile file, @RequestParam(value="path") String path) {
        try {
            BaseResponse ObjectRes = this.docManageService.uploadOss(file, path);
            return ObjectRes;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @PostMapping(value={"/import"})
    public List<String> importTest(@RequestParam(value="file") MultipartFile file) throws Exception {
        ArrayList<String> ss = new ArrayList<String>();
        List multipartFiles = UnZipUtils.unZip((MultipartFile)file);
        String docUrl = "";
        for (MultipartFile multipartFile : multipartFiles) {
            docUrl = multipartFile.getName();
            if (!docUrl.contains("jpg") && !docUrl.contains("png") && !docUrl.contains("jpeg")) continue;
            ss.add(docUrl);
            log.info("doctorSignUrl" + ss);
        }
        DoctorUrlReqVo doctorUrlReqVo = new DoctorUrlReqVo();
        doctorUrlReqVo.setUrls(ss);
        return ss;
    }
}

