/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.medical;

import cn.hutool.core.util.StrUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.model.MedicalAppointment.MedicalAppointmentInfoReq;
import com.ebaiyihui.wisdommedical.model.MedicalAppointment.MedicalRecordReviewReq;
import com.ebaiyihui.wisdommedical.model.MedicalAppointment.res.MedicalAppointmentInfoRes;
import com.ebaiyihui.wisdommedical.model.MedicalAppointmentInfoEntity;
import com.ebaiyihui.wisdommedical.model.MedicalRecordPackageEntity;
import com.ebaiyihui.wisdommedical.service.MedicalAppointmentInfoService;
import com.ebaiyihui.wisdommedical.service.RefundCallBackService;
import com.ebaiyihui.wisdommedical.util.PushInfoManagerUtils;
import com.ebaiyihui.wisdommedical.vo.PayCallbackVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u75c5\u6848\u590d\u5370\u63a5\u53e3"})
@RequestMapping(value={"/api/v1/medicalAppointment"})
public class MedicalAppointmentController {
    private static final Logger log = LoggerFactory.getLogger(MedicalAppointmentController.class);
    private final MedicalAppointmentInfoService medicalAppointmentInfoService;
    @Autowired
    private PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private RefundCallBackService refundCallBackService;
    public static final String SUCCESS = "success";

    @ApiOperation(value="\u6309\u6761\u4ef6\u67e5\u8be2\u8ba2\u5355\u5217\u8868", notes="\u6309\u6761\u4ef6\u67e5\u8be2\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/getOrderList"})
    public BaseResponse<MedicalAppointmentInfoRes> getOrderList(@RequestBody MedicalAppointmentInfoReq medicalAppointmentInfoReq) {
        try {
            MedicalAppointmentInfoRes order = this.medicalAppointmentInfoService.getOrderList(medicalAppointmentInfoReq);
            return BaseResponse.success((Object)order);
        }
        catch (Exception e) {
            log.error("getOrder\u63a5\u53e3\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8ba2\u5355\u7f16\u53f7\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5", notes="\u6839\u636e\u8ba2\u5355\u7f16\u53f7\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/getOrderDetails"})
    public BaseResponse<MedicalAppointmentInfoEntity> getOrderDetails(@RequestParam(value="orderNumber") String orderNumber) {
        try {
            MedicalAppointmentInfoEntity orderDetails = this.medicalAppointmentInfoService.getOrderDetails(orderNumber);
            return BaseResponse.success((Object)orderDetails);
        }
        catch (Exception e) {
            log.error("getOrderDetails\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u75c5\u6848\u5ba1\u6838\u63a5\u53e3", notes="\u75c5\u6848\u5ba1\u6838\u63a5\u53e3")
    @PostMapping(value={"/medicalRecordReview"})
    public BaseResponse<String> medicalRecordReview(@RequestBody MedicalRecordReviewReq medicalRecordReviewReq) {
        try {
            int i = this.medicalAppointmentInfoService.medicalRecordReview(medicalRecordReviewReq);
            if (0 == i) {
                return BaseResponse.error((String)"\u5ba1\u6838\u5931\u8d25");
            }
            return BaseResponse.success((Object)"\u5ba1\u6838\u6210\u529f");
        }
        catch (Exception e) {
            log.error("MedicalRecordReview\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u7269\u6d41\u53d1\u8d27\u63a5\u53e3", notes="\u7269\u6d41\u53d1\u8d27\u63a5\u53e3")
    @GetMapping(value={"/medicalRecordsSent"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="express", value="\u5feb\u9012\u540d\u79f0", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="expressNumber", value="\u5feb\u9012\u5355\u53f7", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="orderNumber", value="\u5f53\u524d\u8ba2\u5355\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    public BaseResponse<String> medicalRecordsSent(@RequestParam(value="express") String express, @RequestParam(value="expressNumber") String expressNumber, @RequestParam(value="orderNumber") String orderNumber) {
        try {
            int i = this.medicalAppointmentInfoService.medicalRecordsSent(express, expressNumber, orderNumber);
            if (0 == i) {
                return BaseResponse.error((String)"\u75c5\u6848\u53d1\u8d27\u5931\u8d25");
            }
            return BaseResponse.success((Object)"\u75c5\u6848\u5df2\u53d1\u8d27");
        }
        catch (Exception e) {
            log.error("MedicalRecordsSent\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u53d6\u4ef6\u63a5\u53e3", notes="\u786e\u8ba4\u53d6\u4ef6\u63a5\u53e3")
    @GetMapping(value={"/confirmPickup"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNumber", value="\u5f53\u524d\u8ba2\u5355\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    public BaseResponse<String> confirmPickup(@RequestParam(value="orderNumber") String orderNumber) {
        try {
            int i = this.medicalAppointmentInfoService.confirmPickup(orderNumber);
            if (0 == i) {
                return BaseResponse.error((String)"\u53d6\u4ef6\u5931\u8d25");
            }
            return BaseResponse.success((Object)"\u53d6\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            log.error("ConfirmPickup\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u75c5\u6848\u5957\u9910\u63a5\u53e3", notes="\u83b7\u53d6\u6240\u6709\u75c5\u6848\u5957\u9910\u63a5\u53e3")
    @GetMapping(value={"/getAllMedicalRecordPackage"})
    public BaseResponse<List<MedicalRecordPackageEntity>> getAllMedicalRecordPackage() {
        try {
            List list = this.medicalAppointmentInfoService.getAllMedicalRecordPackage();
            return BaseResponse.success((Object)list);
        }
        catch (Exception e) {
            log.error("getAllMedicalRecordPackage\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u6839\u636e\u72b6\u6001\u83b7\u53d6\u75c5\u6848\u5957\u9910", notes="\u6839\u636e\u72b6\u6001\u83b7\u53d6\u75c5\u6848\u5957\u9910")
    @GetMapping(value={"/getAllMedicalRecordPackageStatus"})
    public BaseResponse<List<MedicalRecordPackageEntity>> getAllMedicalRecordPackageStatus(@RequestParam(value="packageStatus") String packageStatus) {
        try {
            List list = this.medicalAppointmentInfoService.getAllMedicalRecordPackageStatus(packageStatus);
            return BaseResponse.success((Object)list);
        }
        catch (Exception e) {
            log.error("getAllMedicalRecordPackageStatus\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u75c5\u6848\u5957\u9910\u72b6\u6001", notes="\u4fee\u6539\u75c5\u6848\u5957\u9910\u72b6\u6001")
    @GetMapping(value={"/medicalRecordsPackageStatus"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="status", value="\u72b6\u6001 \u4e0a\u7ebf1 \u4e0b\u7ebf2 \u5220\u96640", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="packageNo", value="\u5957\u9910\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    public BaseResponse<String> medicalRecordsPackageStatus(@RequestParam(value="status") String status, @RequestParam(value="packageNo") String packageNo) {
        try {
            int i = this.medicalAppointmentInfoService.medicalRecordsPackageStatus(status, packageNo);
            if (0 == i) {
                if (status.equals("0")) {
                    return BaseResponse.success((Object)"\u5957\u9910\u5220\u9664\u5931\u8d25");
                }
                return BaseResponse.error((String)(status.equals("1") ? "\u75c5\u6848\u5957\u9910\u5df2\u4e0a\u7ebf\u5931\u8d25" : "\u75c5\u6848\u5957\u9910\u5df2\u4e0b\u7ebf\u5931\u8d25"));
            }
            if (888888 == i) {
                return BaseResponse.error((String)"\u8be5\u75c5\u6848\u5957\u9910\u6709\u5f85\u5ba1\u6838\u9884\u7ea6\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5904\u7406");
            }
            if (status.equals("0")) {
                return BaseResponse.success((Object)"\u75c5\u6848\u5957\u9910\u5df2\u5220\u9664");
            }
            return BaseResponse.success((Object)(status.equals("1") ? "\u75c5\u6848\u5957\u9910\u5df2\u4e0a\u7ebf" : "\u75c5\u6848\u5957\u9910\u5df2\u4e0b\u7ebf"));
        }
        catch (Exception e) {
            log.error("medicalRecordsPackageStatus\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u75c5\u6848\u5957\u9910", notes="\u65b0\u589e\u75c5\u6848\u5957\u9910")
    @PostMapping(value={"/instMedicalRecordPackage"})
    BaseResponse<String> instMedicalRecordPackage(@RequestBody MedicalRecordPackageEntity medicalRecordPackageEntity) {
        try {
            int i = this.medicalAppointmentInfoService.instMedicalRecordPackage(medicalRecordPackageEntity);
            if (0 == i) {
                return BaseResponse.error((String)"\u65b0\u589e\u75c5\u6848\u5957\u9910\u5931\u8d25");
            }
            if (888888 == i) {
                return BaseResponse.error((String)"\u75c5\u6848\u5957\u9910\u5df2\u5b58\u5728\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            return BaseResponse.success((Object)"\u65b0\u589e\u75c5\u6848\u5957\u9910\u6210\u529f");
        }
        catch (Exception e) {
            log.error("instMedicalRecordPackage\u51fa\u73b0\u9a8c\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)"\u65b0\u589e\u75c5\u6848\u5957\u9910\u5931\u8d25,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u91cd\u590d\u6216\u6709\u8bef");
        }
    }

    @ApiOperation(value="\u521b\u5efa\u75c5\u6848\u9884\u7ea6 \u521b\u5efa\u8ba2\u5355", notes="\u521b\u5efa\u8ba2\u5355")
    @PostMapping(value={"/createMedicalAppointment"})
    BaseResponse<String> createMedicalAppointment(@RequestBody MedicalAppointmentInfoEntity medicalAppointmentInfoEntity) {
        try {
            String orderNumber = this.medicalAppointmentInfoService.createMedicalAppointment(medicalAppointmentInfoEntity);
            if (StrUtil.isBlank((CharSequence)orderNumber)) {
                return BaseResponse.error((String)"\u521b\u5efa\u8ba2\u5355\u5931\u8d25!\u8bf7\u91cd\u8bd5");
            }
            if ("8888888".equals(orderNumber)) {
                return BaseResponse.error((String)"\u5f53\u524d\u75c5\u6848\u5957\u9910\u7f16\u53f7\u6709\u8bef,\u8bf7\u68c0\u67e5\u5f53\u524d\u5957\u9910\u662f\u5426\u5b58\u5728");
            }
            return BaseResponse.success((Object)orderNumber);
        }
        catch (Exception e) {
            log.error("createMedicalAppointment\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u75c5\u6848\u9884\u7ea6\u652f\u4ed8", notes="\u75c5\u6848\u9884\u7ea6\u652f\u4ed8")
    @PostMapping(value={"/payMedicalAppointment"})
    BaseResponse<String> payMedicalAppointment(@RequestParam(value="orderNumber") String orderNumber) {
        try {
            return this.medicalAppointmentInfoService.payMedicalAppointment(orderNumber);
        }
        catch (Exception e) {
            log.error("payMedicalAppointment\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u75c5\u6848\u9884\u7ea6\u652f\u4ed8\u56de\u8c03", notes="\u75c5\u6848\u9884\u7ea6\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/payMedicalAppointment/payNotifyUrl"})
    BaseResponse<String> payNotifyUrl(@RequestBody PayCallbackVo payCallbackVo) {
        log.info("RefundCallBackController.outpatientRefundCallBack->\u75c5\u6848\u590d\u5370\u652f\u4ed8\u56de\u8c03\u5165\u53c2PayCallbackVo{}", (Object)payCallbackVo.toString());
        try {
            this.refundCallBackService.baRefundCallBack(payCallbackVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.success((Object)SUCCESS);
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @ApiOperation(value="\u53d6\u6d88\u8ba2\u5355", notes="\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"/cancelOrder"})
    BaseResponse<String> cancelOrder(@RequestParam(value="orderNumber") String orderNumber) {
        try {
            return this.medicalAppointmentInfoService.cancelOrder(orderNumber);
        }
        catch (Exception e) {
            log.error("cancelOrder\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    public MedicalAppointmentController(MedicalAppointmentInfoService medicalAppointmentInfoService) {
        this.medicalAppointmentInfoService = medicalAppointmentInfoService;
    }
}

