/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.CardPayOrderMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.MedicalAppointmentInfoMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.CardPayOrderEntity;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.MedicalAppointmentInfoEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OrderBarcodeReq;
import com.ebaiyihui.wisdommedical.model.PayOrder;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateStatusVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.QueryOutPatientPayStatusReqVO;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.ICardService;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.MedicalAppointmentInfoService;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.OrderMqUtils;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(AppointmentRecordReceiver.class);
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    EncryptUtils encryptUtils;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    private CardPayOrderMapper cardPayOrderMapper;
    @Autowired
    private ICardService iCardService;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private MedicalAppointmentInfoMapper medicalAppointmentInfoMapper;
    @Autowired
    private MedicalAppointmentInfoService medicalAppointmentInfoService;

    @RabbitListener(queues={"wisdommedical.pay.compensation"})
    @RabbitHandler
    public void process(String data) {
        log.info("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001rabbit mq:{}", JSON.toJSON((Object)data));
        if (StringUtils.isNotBlank((CharSequence)data)) {
            PayOrder payOrder = (PayOrder)JSON.parseObject((String)data, PayOrder.class);
            int type = payOrder.getType();
            String id = payOrder.getId();
            if (1 == type) {
                boolean bool;
                CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(id);
                AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cardPayOrderEntity.getAppointmentId());
                if (Objects.isNull(appointmentRecordEntity)) {
                    log.error("mq\u5904\u7406\u6302\u53f7\u5f02\u5e38:{}", (Object)cardPayOrderEntity);
                    return;
                }
                if (Objects.equals(appointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue()) && (bool = this.queryOrderStatus(appointmentRecordEntity.getPayTransationId(), payOrder))) {
                    UpdateStatusVoReq updateStatusVoReq = new UpdateStatusVoReq();
                    updateStatusVoReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                    updateStatusVoReq.setSysId(id);
                    updateStatusVoReq.setBool(Boolean.valueOf(bool));
                    try {
                        this.iCardService.queryCardPayStatusAppoint(updateStatusVoReq);
                    }
                    catch (InHospitalException e) {
                        log.error("mq\u5904\u7406\u6302\u53f7\u5f02\u5e38", (Throwable)e);
                    }
                }
            } else if (2 == type) {
                boolean bool;
                AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(payOrder.getId());
                if (Objects.isNull(appointmentRecordEntity)) {
                    log.error("mq\u5904\u7406\u6302\u53f7\u5f02\u5e38:{}", (Object)appointmentRecordEntity);
                    return;
                }
                if (Objects.equals(appointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue()) && (bool = this.queryOrderStatus(appointmentRecordEntity.getPayTransationId(), payOrder))) {
                    UpdateStatusVoReq updateStatusVoReq = new UpdateStatusVoReq();
                    updateStatusVoReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                    updateStatusVoReq.setSysId(id);
                    updateStatusVoReq.setBool(Boolean.valueOf(bool));
                    try {
                        try {
                            this.iCardService.queryCardPayStatusSubAppoint(updateStatusVoReq);
                        }
                        catch (AppointmentException e) {
                            log.info("mq\u4e09\u53d6\u6d88\u9501\u53f7\u5f02\u5e38");
                        }
                    }
                    catch (InHospitalException e) {
                        log.error("mq\u5904\u7406\u6302\u53f7\u5f02\u5e38", (Throwable)e);
                    }
                }
            } else if (3 == type) {
                boolean bool;
                CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(id);
                OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(cardPayOrderEntity.getOutpatientId());
                if (Objects.isNull(opBusinessOrderEntity)) {
                    log.error("mq\u5904\u7406\u95e8\u8bca\u7f34\u8d39\u5f02\u5e38:{}", (Object)cardPayOrderEntity);
                    return;
                }
                if (Objects.equals(opBusinessOrderEntity.getStatus(), BusinessOrderStatusEnum.NOT_PAY.getValue()) && (bool = this.queryOrderStatus(cardPayOrderEntity.getDealSeq(), payOrder))) {
                    QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO = (QueryOutPatientPayStatusReqVO)JSONObject.parseObject((String)payOrder.getData(), QueryOutPatientPayStatusReqVO.class);
                    queryOutPatientPayStatusReqVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
                    queryOutPatientPayStatusReqVO.setHospitalName(opBusinessOrderEntity.getOrganName());
                    queryOutPatientPayStatusReqVO.setClinicNo(opBusinessOrderEntity.getAdmId());
                    queryOutPatientPayStatusReqVO.setSysId(id);
                    try {
                        this.iCardService.queryCardPayStatusOutPatient(queryOutPatientPayStatusReqVO);
                    }
                    catch (Exception e) {
                        log.error("mq\u5904\u7406\u95e8\u8bca\u7f34\u8d39\u5f02\u5e38", (Throwable)e);
                    }
                }
            } else if (4 == type) {
                log.info("mq\u6d88\u8d39\u5904\u7406\u4f4f\u9662\u5145\u503c");
                InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(id);
                InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
                log.info("mq\u6d88\u8d39\u5904\u7406\u4f4f\u9662\u83b7\u53d6\u7684\u4f4f\u9662\u5b9e\u4f53\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)inpatientDepositDetailEntity));
                if (Objects.equals(inpatientDepositDetailEntity.getStatus(), BusinessOrderStatusEnum.NOT_PAY.getValue())) {
                    boolean bool = this.queryOrderStatus(inpatientPayorderEntity.getDealSeq(), payOrder);
                    log.info("mq\u5904\u7406\u4f4f\u9662\u5145\u503c\u83b7\u53d6\u652f\u4ed8\u7ed3\u679c:{}", (Object)bool);
                    if (bool) {
                        this.inHospitalService.inHospDepositPaySuccess(inpatientDepositDetailEntity, inpatientPayorderEntity);
                    }
                }
            } else if (7 == type) {
                try {
                    log.info("\u5f53\u524d\u4e3a\u7b2c\u51e0\u6b21\u67e5\u8be2->{}", (Object)payOrder.getNumber());
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"orderNumber", (Object)id);
                    MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = (MedicalAppointmentInfoEntity)this.medicalAppointmentInfoMapper.selectOne((Wrapper)queryWrapper);
                    log.info("\u75c5\u6848\u590d\u5370\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355->{}", (Object)JSON.toJSONString((Object)medicalAppointmentInfoEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    if (null != medicalAppointmentInfoEntity) {
                        boolean b = this.queryOrderStatus(medicalAppointmentInfoEntity.getTransactionId(), payOrder);
                        if (b) {
                            this.medicalAppointmentInfoService.medicalRecordsPaidSuccessfully(id, medicalAppointmentInfoEntity.getAppointmentMethod());
                        }
                    } else {
                        log.error("\u5f53\u524d\u5ef6\u65f6mq\u6d88\u606f\u5185 \u75c5\u6848\u9884\u7ea6\u652f\u4ed8 \u8ba2\u5355\u67e5\u8be2\u672a\u7a7aorderNumber->{}", (Object)id);
                    }
                }
                catch (Exception e) {
                    log.error("\u75c5\u6848\u590d\u5370mq\u67e5\u8be2\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
                    return;
                }
            }
        }
    }

    public boolean queryOrderStatus(String outTradeNo, PayOrder payOrder) {
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(Long.parseLong(outTradeNo)));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = null;
        try {
            hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
        log.info("hisPayRes:{}", (Object)JSON.toJSONString(hisPayRes));
        if (Objects.equals(hisPayRes.getResultCode(), "0")) {
            return true;
        }
        int number = payOrder.getNumber() + 1;
        Long display = NumberTimeEnum.getDisplay((Integer)number);
        if (Objects.nonNull(display)) {
            payOrder.setNumber(number);
            OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)display);
        }
        return false;
    }
}

