/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedAppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedAppointmentRecordReceiver.class);
    public static final int NO_PAY_AUTO_CANCEL_APPOINTMENT = 2;
    @Autowired
    private AppointmentService appointmentService;

    @RabbitListener(queues={"wisdommedical.appointment.delayed.order"})
    @RabbitHandler
    public void process(String rabbitMqDelayedOrderVoStr) {
        block4: {
            try {
                log.info("Fetch appointment info from rabbit mq\uff1a " + rabbitMqDelayedOrderVoStr);
                RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = (RabbitMqDelayedOrderVo)JSON.parseObject((String)rabbitMqDelayedOrderVoStr, RabbitMqDelayedOrderVo.class);
                log.info("rabbitMqDelayedOrderVo:{}" + rabbitMqDelayedOrderVo);
                String sysAppointmentId = rabbitMqDelayedOrderVo.getSysAppointmentId();
                AppointmentRecordEntity appointmentRecordEntity = this.appointmentService.getAppointmentRecordBySysAppointmentId(sysAppointmentId);
                log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\uff1a " + JSON.toJSONString((Object)appointmentRecordEntity));
                if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) break block4;
                try {
                    CancelAppointmentVoReq cancelAppointmentVoReq = new CancelAppointmentVoReq();
                    cancelAppointmentVoReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                    cancelAppointmentVoReq.setBeginTime(appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
                    cancelAppointmentVoReq.setEndTime(appointmentRecordEntity.getAdmTimeRange().substring(6, 11));
                    this.appointmentService.cancelAppointment(cancelAppointmentVoReq);
                }
                catch (Exception e) {
                    log.info("mq\u8d85\u65f6\u672a\u4ed8\u6b3e2\u53d6\u6d88\u9501\u53f7\u5931\u8d25 - >{}", (Object)e.getMessage());
                }
                log.info("\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88 -> " + sysAppointmentId);
                UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo = new UpdateDelayAppointmentRecordVoReq();
                updateDelayAppointmentRecordVo.setCancelChannelCode(rabbitMqDelayedOrderVo.getChannelCode());
                updateDelayAppointmentRecordVo.setCancelReason("\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88");
                updateDelayAppointmentRecordVo.setCancelTime(new Date());
                updateDelayAppointmentRecordVo.setCancelType(Integer.valueOf(2));
                updateDelayAppointmentRecordVo.setSysAppointmentId(sysAppointmentId);
                updateDelayAppointmentRecordVo.setAppointStatus(AppointmentStatusEnum.AUTO_CANCEL.getValue());
                updateDelayAppointmentRecordVo.setRemark("\u8d85\u65f6\u672a\u4ed8\u6b3e\uff0c\u5df2\u81ea\u52a8\u53d6\u6d88");
                this.appointmentService.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
            }
            catch (Exception e) {
                log.error("\u8d85\u65f6\u53d6\u6d88\u652f\u4ed8mq\u62a5\u9519->{}", (Throwable)e);
                return;
            }
        }
    }
}

