/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String DELAYED_QUEUE_NAME = "wisdommedical.appointment.delayed.order";
    public static final String EXCHANGE_NAME = "wisdommedical_appointment_delayed_exchange";
    public static final String DELAY_ORDER_ROUTING_KEY = "wisdommedical_appointment_delay_order_routing_key";
    public static final String QUEUE_NAME = "wisdommedical.appointment.order";
    public static final String ORDER_ROUTING_KEY = "wisdommedical_appointment_order_routing_key";
    public static final String REFUND_QUEUE_NAME = "wisdommedical.appointment.refund";
    public static final String REFUND_ROUTING_KEY = "wisdommedical_appointment_refund_routing_key";
    public static final String PAY_COMPENSATION_ROUTING_KEY = "wisdommedical_pay_compensation_routing_key";
    public static final String PAY_COMPENSATION_EXCHANGE_NAME = "wisdommedical_pay_compensation_exchange";
    public static final String PAY_COMPENSATION_QUEUE_NAME = "wisdommedical.pay.compensation";
    public static final String PAY_MEDICAL_RECORD_APPOINTMENT_KEY = "medical_record_appointment_key";
    public static final String PAY_MEDICAL_RECORD_APPOINTMENT_NAME = "medical_record_appointment_exchange";
    public static final String PAY_MEDICAL_RECORD_APPOINTMENT_QUEUE_NAME = "medicalrecordaappointment.pay.compensation";

    @Bean
    public Queue queue() {
        return new Queue(DELAYED_QUEUE_NAME);
    }

    @Bean
    public Queue newQueue() {
        return new Queue(QUEUE_NAME);
    }

    @Bean
    public Queue refundQueue() {
        return new Queue(REFUND_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to((Exchange)this.customExchange()).with(DELAY_ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding newBinding() {
        return BindingBuilder.bind((Queue)this.newQueue()).to((Exchange)this.customExchange()).with(ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding refundBinding() {
        return BindingBuilder.bind((Queue)this.refundQueue()).to((Exchange)this.customExchange()).with(REFUND_ROUTING_KEY).noargs();
    }

    @Bean
    public Queue queue1() {
        return new Queue(PAY_COMPENSATION_QUEUE_NAME);
    }

    @Bean
    public Queue queue2() {
        return new Queue(PAY_MEDICAL_RECORD_APPOINTMENT_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange1() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(PAY_COMPENSATION_EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    CustomExchange customExchange2() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(PAY_MEDICAL_RECORD_APPOINTMENT_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding binding1() {
        return BindingBuilder.bind((Queue)this.queue1()).to((Exchange)this.customExchange1()).with(PAY_COMPENSATION_ROUTING_KEY).noargs();
    }

    @Bean
    Binding binding2() {
        return BindingBuilder.bind((Queue)this.queue2()).to((Exchange)this.customExchange2()).with(PAY_MEDICAL_RECORD_APPOINTMENT_KEY).noargs();
    }
}

