/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.RefundReq;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.RefundMqUtils;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RefundAppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(RefundAppointmentRecordReceiver.class);
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    EncryptUtils encryptUtils;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private final String REFUND_QUERY_TIMES = "ORDER_QUERY_TIMES:";

    @RabbitListener(queues={"wisdommedical.appointment.refund"})
    @RabbitHandler
    public void process(String rabbitMqDelayedOrderVoStr) {
        log.info("Fetch appointment info from rabbit mq\uff1a " + rabbitMqDelayedOrderVoStr);
        if (StringUtils.isNotBlank((CharSequence)rabbitMqDelayedOrderVoStr)) {
            RefundReq refundReq = new RefundReq();
            refundReq.setTrace(rabbitMqDelayedOrderVoStr);
            log.info("\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
            HashMap<String, RefundReq> map = new HashMap<String, RefundReq>();
            map.put("refundReq", refundReq);
            HisPayRes res = (HisPayRes)this.encryptUtils.queryPolymer("005", map, this.propertiesConstant.getRefundQuery(), HisPayRes.class);
            Long increment = this.redisTemplate.opsForValue().increment((Object)"ORDER_QUERY_TIMES:".concat(rabbitMqDelayedOrderVoStr), 1L);
            if (Objects.equals(res.getResultCode(), "0")) {
                this.appointmentRecordMapper.updatePayStatus(rabbitMqDelayedOrderVoStr);
            } else if (increment < 20L) {
                RefundMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)rabbitMqDelayedOrderVoStr);
            } else {
                this.redisTemplate.delete((Object)"ORDER_QUERY_TIMES:".concat(rabbitMqDelayedOrderVoStr));
            }
        }
    }
}

