/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryAccountInfoResVo;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ExamineEnum;
import com.ebaiyihui.wisdommedical.common.enums.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.ExamineMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.Examine;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.HospitalConfigEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.PayOrder;
import com.ebaiyihui.wisdommedical.model.PolymerizationReq;
import com.ebaiyihui.wisdommedical.model.PolymerizationRes;
import com.ebaiyihui.wisdommedical.model.Refund;
import com.ebaiyihui.wisdommedical.model.RefundReq;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DoDayAppointmentDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.UpdateScheduleDetailDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthRegisteredResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RechargeCardToHosReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateStatusVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ReservationLockNumberRes;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PayRequestVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.ReservationLockNumberReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.ICardService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.IdCardUtils;
import com.ebaiyihui.wisdommedical.util.OrderMqUtils;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class AppointmentServiceImpl
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final int CURRENT_DAY_APPOINTMENT = 2;
    public static final int NOT_CURRENT_DAY_APPOINTMENT = 1;
    public static final String YES_TOPAY = "1";
    public static final String NOT_TOPAY = "0";
    public static final String SUCCESS = "Y";
    public static final int HAVE_TIME_ARRANGE_FLAG = 1;
    public static final String HIS_MORNING = "0";
    public static final String HIS_AFTERNOON = "1";
    @Autowired
    ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    private static final String REFUND_FAIL = "\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u6b3e\u8bf7\u6c42body\u4e3a\u7a7a\uff01";
    private static final String REFUND_ORDER_ERROR = "\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01";
    private static final String NO_REFUND = "\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01";
    private static final String BASERESPONSE_NULL = "refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a";
    private static final String NETWORK_EXCEPTION = "\u8ba2\u5355\u5f02\u5e38\uff0c\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff01";
    private static final String ERROR_INFO = "refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}";
    private static final String REQ_ERROR_FAIL = "\u53d1\u8d77\u9000\u6b3e\u5931\u8d25";
    private static final int HIS = 1;
    private static final String HIS_ERROR_FAIL = "his\u65b9\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7";
    private static final String REFUND_AMOUNT_NULL = "RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a";
    private static final String REFUND_AMOUNTS = "\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a\uff01";
    private static final String REFUND_AMOUNTS_FAIL = "\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d\uff01";
    private static final String PAY_CHANNL_NULL = "RefundServiceImpl.checkParams->\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a";
    private static final String PAY_CHANNL = "\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a\uff01";
    private static final String PAY_CHANNL_MISMATCH = "\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff01";
    private static final String NOT_CONFIG = "\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25";
    @Autowired
    PayUtil payUtil;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PushService pushService;
    @Autowired
    private RedisTemplate redisTemplate;
    public static final List<Integer> WAIT_CONFIRMED = Arrays.asList(11, 15, 16, 17, 18);
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private ExamineMapper examineMapper;
    @Autowired
    EncryptUtils encryptUtils;
    @Autowired
    private ICardService iCardService;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    private final String REDIS_PAY_LOCK = "HBBD-YYGH-SH-";
    private final String REDIS_PAYMENT_PARAMETERS = "HBBD-ZFCS-";
    @Value(value="${hisFontUrl}")
    private String hisFontUrl;

    public String confirmAppointment(ConfirmAppointmentVo confirmAppointmentVo) throws ScheduleException {
        List timeArrangeItems;
        String admDate = confirmAppointmentVo.getAdmDate();
        List getScheduleResItemsList = this.getHisDaySchedule(confirmAppointmentVo);
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            throw new ScheduleException("\u5b9e\u65f6\u67e5\u8be2\u533b\u751f\u6392\u73ed\u6570\u636e\u5f02\u5e38,\u8bf7\u91cd\u8bd5");
        }
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)getScheduleResItemsList.get(0);
        confirmAppointmentVo = this.buildConfirmAppointmentVo(getScheduleResItems, confirmAppointmentVo);
        if (Objects.equals(String.valueOf(LocalDate.now()), admDate) && Objects.equals(confirmAppointmentVo.getIsTimeArrange(), 1) && !CollectionUtils.isEmpty((Collection)(timeArrangeItems = confirmAppointmentVo.getTimeArrangeItems()))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            timeArrangeItems.stream().filter(timeArrangeItem -> {
                LocalDateTime localDateTime = LocalDateTime.now();
                String admDteTimeStr = admDate + " " + timeArrangeItem.getStartTime();
                String nowDateTimeStr = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm"));
                try {
                    Long admDteTime = sdf.parse(admDteTimeStr).getTime();
                    Long nowDateTime = sdf.parse(nowDateTimeStr).getTime();
                    return admDteTime <= nowDateTime;
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u65e5\u671f\u5f02\u5e38:" + e);
                    return false;
                }
            }).collect(Collectors.toList());
        }
        String confirmAppointmentId = String.valueOf(this.snowflakeIdWorker.nextId());
        confirmAppointmentVo.setWhetherToPay("1");
        String confirmAppointmentVoStr = JSON.toJSONString((Object)confirmAppointmentVo);
        this.jedisCluster.set(confirmAppointmentId, confirmAppointmentVoStr);
        this.jedisCluster.expire(confirmAppointmentId, 7200);
        return confirmAppointmentId;
    }

    public String dayAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException, NoSuchMethodException {
        String idNo = createOrderVoReq.getIdNo();
        String gender = IdCardUtils.judgeGender((String)idNo);
        int age = IdCardUtils.countAge((String)idNo);
        if ("1014".equals(createOrderVoReq.getDeptCode()) && age > 18) {
            return "\u513f\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb818\u5468\u5c81\u53ca\u4ee5\u4e0b\u6302\u53f7";
        }
        if ("9023".equals(createOrderVoReq.getDeptCode()) && "2".equals(gender)) {
            return "\u7537\u79d1\u95e8\u8bca\uff08\u4e0d\u5b55\u4e0d\u80b2\u4e13\u79d1\uff09\uff0c\u53ea\u5141\u8bb8\u7537\u6027\u6302\u53f7";
        }
        if ("1013".equals(createOrderVoReq.getDeptCode()) && "1".equals(gender)) {
            return "\u5987\uff08\u4ea7\uff09\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb8\u5973\u6027\u6302\u53f7 ";
        }
        List recordEntity = this.appointmentRecordMapper.selectByTime(createOrderVoReq.getAdmDate(), createOrderVoReq.getCardId(), createOrderVoReq.getDeptCode(), String.valueOf(2));
        if (recordEntity.size() > 0) {
            return "\u6302\u53f7\u5931\u8d25\uff0c\u8be5\u5c31\u8bca\u4eba\u5df2\u6709\u672c\u79d1\u5ba4\u6302\u53f7\u5355,\u8bf7\u9009\u62e9\u5176\u4ed6\u65e5\u671f\u6216\u5176\u4ed6\u79d1\u5ba4";
        }
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6392\u73ed\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDocCode().equals(createOrderVoReq.getDocCode())).collect(Collectors.toList());
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u533b\u751fcode\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(createOrderVoReq.getAdmTimeRange())).collect(Collectors.toList());
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u5348\u522b\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        if (CollectionUtils.isEmpty(scheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return null;
        }
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        Object appointmentRecordEntity = null;
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        String returnSysAppointmentId = this.dayLock(sysAppointmentId, createOrderVoReq, gatewayResponse, getScheduleResItem);
        log.info("AuthCode == ->{}", (Object)createOrderVoReq.getAuthCode());
        if (!StrUtil.isBlank((CharSequence)createOrderVoReq.getAuthCode())) {
            this.jedisCluster.set(sysAppointmentId + "_authCode", createOrderVoReq.getAuthCode(), "NX", "EX", 43200L);
        }
        this.jedisCluster.set(sysAppointmentId + "_time", DateUtil.format((Date)DateUtil.offsetMinute((Date)DateUtil.date(), (int)30), (String)"yyyy-MM-dd HH:mm:ss"), "NX", "EX", 43200L);
        return String.valueOf(returnSysAppointmentId);
    }

    public String dayLock(long sysAppointmentId, DayAppointmentCreateOrderVoReq createOrderVoReq, GatewayResponse<GetScheduleResVO> gatewayResponse, GetScheduleResItems getScheduleResItem) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = null;
        DayRegisterRes dayRegisterRes = new DayRegisterRes();
        appointmentRecordEntity = this.buildLockSourceAppointmentRecordEntity(sysAppointmentId, dayRegisterRes, getScheduleResItem, createOrderVoReq);
        String key = "DRGH_XDBC_ " + createOrderVoReq.getCardId() + "_" + createOrderVoReq.getDeptCode() + "_" + createOrderVoReq.getAdmDate();
        boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)(key + "_" + this.snowflakeIdWorker.nextId()), 600L, TimeUnit.SECONDS);
        List dzfRecordEntity = this.appointmentRecordMapper.selectDzfByTime(createOrderVoReq.getAdmDate(), createOrderVoReq.getCardId(), createOrderVoReq.getDeptCode(), String.valueOf(2));
        if (locked) {
            if (CollectionUtils.isEmpty((Collection)dzfRecordEntity)) {
                this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
            } else {
                appointmentRecordEntity = this.buildLockSourceAppointmentRecordEntity(Long.valueOf(((AppointmentRecordEntity)dzfRecordEntity.get(0)).getSysAppointmentId()).longValue(), dayRegisterRes, getScheduleResItem, createOrderVoReq);
                appointmentRecordEntity.setId(((AppointmentRecordEntity)dzfRecordEntity.get(0)).getId());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            }
        }
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        if (CollectionUtils.isEmpty((Collection)dzfRecordEntity)) {
            RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo));
        }
        this.redisTemplate.opsForValue().getOperations().delete((Object)key);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    public AppointmentRecordEntity buildSuccessNoPayAppointmentRecordEntity(long sysAppointmentId, ConfirmRegisterRes confirmRegisterRes, AppointmentCreateOrderVoReq createOrderVoReq, GetScheduleResItems getScheduleResItems) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(confirmRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmAddress(getScheduleResItems.getAdmLocation());
        appointmentRecordEntity.setTakeAddress(getScheduleResItems.getAdmLocation());
        appointmentRecordEntity.setTakeTime(confirmRegisterRes.getTakeTime().replace("/", "-"));
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getTimeArrange());
        if (Objects.nonNull(createOrderVoReq.getAdmDate())) {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        } else {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getStartTime() + "-" + createOrderVoReq.getEndTime());
        }
        appointmentRecordEntity.setAppointmentNo(confirmRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.APPOINT_SUCCESS.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getOrganPmi());
        }
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItems.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6210\u529f");
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity buildLockSourceAppointmentRecordEntity(long sysAppointmentId, DayRegisterRes dayRegisterRes, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAppointmentId(getScheduleResItem.getRegTitleCode());
        appointmentRecordEntity.setAdmAddress(getScheduleResItem.getAdmLocation());
        if (Objects.nonNull(createOrderVoReq.getAdmDate())) {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        } else {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getStartTime() + "-" + createOrderVoReq.getEndTime());
        }
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setHospitalAreaCode(createOrderVoReq.getHospitalAreaCode());
        appointmentRecordEntity.setAppointmentTime(DateUtils.stringToSimpleDate((String)getScheduleResItem.getAdmDate()));
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getStartTime() + "-" + createOrderVoReq.getEndTime());
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getOrganPmi());
        }
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setPatientIndex(getScheduleResItem.getScheduleLevelCode());
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleLevelCode(appointmentRecordEntity.getPatientIndex());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        log.info("\u5f53\u524d\u8ba2\u5355\u662f\u65f6\u6bb5\u5165\u53c2 - > {}", (Object)getScheduleResItem.getAdmTimeRange());
        appointmentRecordEntity.setAdmRange(Convert.toInt((Object)getScheduleResItem.getAdmTimeRange()).intValue());
        log.info("\u5f53\u524d\u8ba2\u5355\u662f\u65f6\u6bb5\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)appointmentRecordEntity.getAdmRange()));
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6210\u529f\uff0c\u672a\u652f\u4ed8");
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity buildAppointmentRecordEntity(long sysAppointmentId, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAdmAddress(StringUtils.isEmpty((String)getScheduleResItem.getAdmLocation()) ? "null" : getScheduleResItem.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getPatientId());
        }
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        return appointmentRecordEntity;
    }

    public ConfirmAppointmentVo getConfirmAppointment(String confirmAppointmentId) {
        String confirmAppointmentVoStr = this.jedisCluster.get(confirmAppointmentId);
        ConfirmAppointmentVo confirmAppointmentVo = (ConfirmAppointmentVo)JSON.parseObject((String)confirmAppointmentVoStr, ConfirmAppointmentVo.class);
        List timeArrangeItemsList = null;
        if (null != confirmAppointmentVo && !CollectionUtils.isEmpty((Collection)confirmAppointmentVo.getTimeArrangeItems())) {
            timeArrangeItemsList = confirmAppointmentVo.getTimeArrangeItems();
            timeArrangeItemsList.sort(Comparator.comparing(TimeArrangeItems::getStartTime));
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public GetConfirmPayInfoVoRes getConfirmPayInfo(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = new GetConfirmPayInfoVoRes();
        getConfirmPayInfoVoRes.setCreateTime(appointmentRecordEntity.getCreatetime());
        getConfirmPayInfoVoRes.setPayAccount(appointmentRecordEntity.getPayAmount());
        getConfirmPayInfoVoRes.setSysAppointmentId(sysAppointmentId);
        getConfirmPayInfoVoRes.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        getConfirmPayInfoVoRes.setPatientName(appointmentRecordEntity.getPatientName());
        return getConfirmPayInfoVoRes;
    }

    public List<AppointmentRecordVo> selectByUserIdAndStatus(Map<String, Object> queryMap, String appCode, String channelCode) throws AppointmentException {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId((String)queryMap.get("userId"));
        reqVo.setOrganCode((String)queryMap.get("hospitalCode"));
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        List appointmentRecordEntityList = null;
        if (cardIdList.size() < 1) {
            return new ArrayList<AppointmentRecordVo>();
        }
        queryMap.put("cardIdList", cardIdList);
        log.info("queryMap------>{}", queryMap);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(dayAppointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(dayAppointmentCreateOrderVoReq.getDocCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayAppointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public List<AppointmentRecordVo> getAppointRecordByCardList(String userId, String hospitalCode, String appCode, String channelCode) throws AppointmentException {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId(userId);
        reqVo.setOrganCode(hospitalCode);
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        if (CollectionUtils.isEmpty((Collection)cardIdList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        List appointmentRecordEntityList = null;
        Date startDate = DateUtils.getCurrentDate();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("admDateStart", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("admDateEnd", DateUtils.dateToSimpleString((Date)DateUtils.getDateAfter((Date)startDate, (int)7)));
        queryMap.put("userId", userId);
        ArrayList<Integer> appointStatusList = new ArrayList<Integer>();
        appointStatusList.add(AppointmentStatusEnum.PAY.getValue());
        appointStatusList.add(AppointmentStatusEnum.WAIT_PAY.getValue());
        queryMap.put("appointStatus", appointStatusList);
        queryMap.put("now", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("hospitalCode", hospitalCode);
        queryMap.put("cardIdList", cardIdList);
        try {
            appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        appointmentRecordEntityList = appointmentRecordEntityList.stream().filter(appointmentRecordEntity -> appointmentRecordEntity.getAppointmentType() != AppointmentTypeEnums.DAY_APPOINTMENT.getValue().intValue() || !appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.WAIT_PAY.getValue())).collect(Collectors.toList());
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private List<String> getCardIdList(UcCardListReqVO reqVo) throws AppointmentException {
        ArrayList<String> cardIdList = new ArrayList<String>();
        log.error("getCardIdList start-------reqVo:{}", (Object)reqVo);
        BaseResponse resp = this.getCardInfoUtil.getUserCardList(reqVo);
        List UserPatientListRespVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), UserPatientListRespVO.class);
        for (UserPatientListRespVO userPatientListRespVO : UserPatientListRespVOList) {
            List userCardListRespVOList = userPatientListRespVO.getUserCardListRespVOS();
            if (userCardListRespVOList == null && userCardListRespVOList.size() <= 0) continue;
            for (UserCardListRespVO userCardListRespVO : userCardListRespVOList) {
                if (userCardListRespVO == null || userCardListRespVO.getCardId() == null || "".equals(userCardListRespVO.getCardId())) continue;
                cardIdList.add(userCardListRespVO.getCardId());
            }
        }
        return cardIdList;
    }

    public List<AppointmentRecordVo> getMyRegistrationList(RegisterationQueryParamsDTO registerationQueryParamsDTO) throws Exception {
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u5165\u53c2\uff1a" + JSON.toJSONString((Object)registerationQueryParamsDTO));
        String hospitalCode = registerationQueryParamsDTO.getHospitalCode();
        List appointmentRecordEntityList = this.appointmentRecordMapper.getMyRegistrationList(registerationQueryParamsDTO);
        List appointmentRecordVoList = this.buildAppointmentRecordVo(appointmentRecordEntityList);
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        for (int i = 0; i < appointmentRecordVoList.size(); ++i) {
            AppointmentRecordVo appointmentRecordVo = (AppointmentRecordVo)appointmentRecordVoList.get(i);
            if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
                int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
                appointmentRecordVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
                appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
                continue;
            }
            appointmentRecordVo.setExpiredtime(300L);
            appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + appointmentRecordVo.getExpiredtime() * 1000L);
        }
        return appointmentRecordVoList;
    }

    private List<AppointmentRecordVo> buildAppointmentRecordVo(List<AppointmentRecordEntity> appointmentRecordEntityList) {
        if (CollectionUtils.isEmpty(appointmentRecordEntityList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        ArrayList<AppointmentRecordVo> appointmentRecordVoList = new ArrayList<AppointmentRecordVo>();
        for (int i = 0; i < appointmentRecordEntityList.size(); ++i) {
            AppointmentRecordEntity appointmentRecordEntity = appointmentRecordEntityList.get(i);
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getPayAmount()) || (appointmentRecordEntity.getAppointmentType() == 2 || appointmentRecordEntity.getAppointmentType() == 3) && appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.WAIT_PAY.getValue())) continue;
            AppointmentRecordVo appointmentRecordVo = new AppointmentRecordVo();
            appointmentRecordVo.setAdmDate(appointmentRecordEntity.getAdmDate());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange().equals("null-null") ? "" : appointmentRecordEntity.getAdmTimeRange());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (WAIT_CONFIRMED.contains(appointStatus)) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            appointmentRecordVo.setDeptCode(appointmentRecordEntity.getDeptCode());
            appointmentRecordVo.setAppointStatus(appointStatus);
            appointmentRecordVo.setDeptName(appointmentRecordEntity.getDeptName());
            appointmentRecordVo.setDocName(appointmentRecordEntity.getDocName());
            appointmentRecordVo.setPatientIdCard(appointmentRecordEntity.getCardId());
            appointmentRecordVo.setUserId(appointmentRecordEntity.getUserId());
            appointmentRecordVo.setPatientName(appointmentRecordEntity.getPatientName());
            appointmentRecordVo.setAdmRange(appointmentRecordEntity.getAdmRange());
            appointmentRecordVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            appointmentRecordVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            appointmentRecordVo.setClinicNumber(appointmentRecordEntity.getPatientId());
            if (appointmentRecordEntity.getCreatetime() != null) {
                long createtime = appointmentRecordEntity.getCreatetime().getTime();
                appointmentRecordVo.setCreatetime(createtime);
            }
            long daysRemaining = 0L;
            try {
                daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            }
            catch (Exception e) {
                log.error("-------\u8ba1\u7b97\u8ddd\u79bb\u5c31\u8bca\u65e5\u5931\u8d25-------");
            }
            appointmentRecordVo.setDaysRemaining(daysRemaining);
            boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            appointmentRecordVo.setIsTheDay(flag ? 1L : 2L);
            appointmentRecordVoList.add(appointmentRecordVo);
        }
        return appointmentRecordVoList;
    }

    public AppointmentRecordDetailVo getMyRegistrationDetail(String sysAppointmentId) throws AppointmentException {
        log.info("AppointmentServiceImpl.getMyRegistrationDetail->\u8bf7\u6c42\u53c2\u6570sysAppointmentId:{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            log.error("AppointmentServiceImpl.getMyRegistrationDetail->\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570sysAppointmentId\u4e3a:{}", (Object)sysAppointmentId);
            throw new AppointmentException();
        }
        String hospitalCode = appointmentRecordEntity.getHospitalCode();
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        AppointmentRecordDetailVo appointmentRecordDetailVo = new AppointmentRecordDetailVo();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
            appointmentRecordDetailVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            int age = 0;
            try {
                age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
            }
            catch (ParseException e) {
                throw new AppointmentException("\u5e74\u9f84\u8f6c\u5316\u5f02\u5e38\uff01");
            }
            appointmentRecordDetailVo.setPatientAge(Integer.valueOf(age));
            appointmentRecordDetailVo.setPatientSex(Integer.valueOf(cardDetailsInfoRespVO.getGender().intValue()));
        }
        appointmentRecordDetailVo.setHospitalAreaCode(appointmentRecordEntity.getHospitalAreaCode());
        this.buildAppointmentRecordDetailVo(appointmentRecordDetailVo, appointmentRecordEntity, hospitalCode);
        return appointmentRecordDetailVo;
    }

    private void buildAppointmentRecordDetailVo(AppointmentRecordDetailVo appointmentRecordDetailVo, AppointmentRecordEntity appointmentRecordEntity, String hospitalCode) {
        boolean flag;
        appointmentRecordDetailVo.setId(appointmentRecordEntity.getId());
        appointmentRecordDetailVo.setPatientName(appointmentRecordEntity.getPatientName());
        appointmentRecordDetailVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        Date admDate = DateUtils.stringToSimpleDate((String)appointmentRecordEntity.getAdmDate());
        appointmentRecordDetailVo.setAdmDate(DateUtils.dateToYMDString((Date)admDate));
        appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        appointmentRecordDetailVo.setWeekday(DateUtils.getWeekZhou((String)appointmentRecordEntity.getAdmDate()));
        appointmentRecordDetailVo.setEleStr(appointmentRecordEntity.getEleStr());
        if (StringUtils.isNotBlank((String)appointmentRecordEntity.getAdmId())) {
            appointmentRecordDetailVo.setAdmId(appointmentRecordEntity.getAdmId());
        }
        appointmentRecordDetailVo.setDeptCode(appointmentRecordEntity.getDeptCode());
        appointmentRecordDetailVo.setDocName(appointmentRecordEntity.getDocName());
        appointmentRecordDetailVo.setDeptName(appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getHospitalName() + " " + appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setPatientCardNo(appointmentRecordEntity.getPatientCardNo());
        appointmentRecordDetailVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
            int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
            appointmentRecordDetailVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordDetailVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
        } else {
            appointmentRecordDetailVo.setExpiredtime(1800L);
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 1740000L);
        }
        appointmentRecordDetailVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        appointmentRecordDetailVo.setAdmRange(appointmentRecordEntity.getAdmRange());
        appointmentRecordDetailVo.setRegTitleName(appointmentRecordEntity.getRegTitleName());
        appointmentRecordDetailVo.setTakeTime(appointmentRecordEntity.getTakeTime());
        appointmentRecordDetailVo.setTakeAddress(appointmentRecordEntity.getTakeAddress());
        appointmentRecordDetailVo.setScheduleLevelName(appointmentRecordEntity.getScheduleLevelName());
        appointmentRecordDetailVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentRecordDetailVo.setAppointmentNo(appointmentRecordEntity.getAppointmentNo());
        appointmentRecordDetailVo.setPayAccdate(appointmentRecordEntity.getPayAccdate());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (WAIT_CONFIRMED.contains(appointStatus)) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        }
        appointmentRecordDetailVo.setIsTheDay((flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()))) ? 1L : 2L);
        try {
            long daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            appointmentRecordDetailVo.setDaysRemaining(daysRemaining);
        }
        catch (Exception e) {
            log.error("======\u8ba1\u7b97\u8ddd\u8bca\u65ad\u65e5\u8fd8\u5269\u4e0b\u5929\u6570\u5931\u8d25=====");
        }
        appointmentRecordDetailVo.setPatientIdCard(appointmentRecordEntity.getPatientIdCard());
        appointmentRecordDetailVo.setAppointStatus(appointStatus.intValue());
        appointmentRecordDetailVo.setRefundMoney(appointmentRecordEntity.getReturnAmount());
        appointmentRecordDetailVo.setRefundTime(appointmentRecordEntity.getReturnAccdate());
        appointmentRecordDetailVo.setCancelType(Integer.valueOf(appointmentRecordEntity.getCancleType()));
        appointmentRecordDetailVo.setClinicNumber(appointmentRecordEntity.getPatientId());
    }

    public void cancelAppointment(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        log.info("\u53d6\u6d88\u9884\u7ea6\u6302\u53f7-------------:{}", (Object)appointmentRecordEntity);
        List<Integer> cancelAble = Arrays.asList(2, 20);
        if (null == appointmentRecordEntity || !cancelAble.contains(appointmentRecordEntity.getAppointStatus())) {
            throw new AppointmentException("\u6b64\u8ba2\u5355\u4e0d\u53ef\u53d6\u6d88\uff01");
        }
        if (AppointmentStatusEnum.APPOINT_SUCCESS.getValue().equals(appointmentRecordEntity.getAppointStatus()) || AppointmentStatusEnum.WAIT_PAY.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
            GatewayRequest gatewayRequest = this.buildCancelRegisterGatewayReq(cancelAppointmentVoReq, appointmentRecordEntity);
            BusinessResultEntity businessResultEntity = new BusinessResultEntity();
            businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
            businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
            businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
            this.businessResultMapper.insertSelective(businessResultEntity);
            log.info("\u53d6\u6d88\u9884\u7ea6IN:{}", (Object)gatewayRequest);
            GatewayResponse gatewayResponse = this.invokeHisCancelRegister(gatewayRequest, "");
            log.info("\u53d6\u6d88\u9884\u7ea6Out:{}", (Object)gatewayResponse);
            businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
            businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
            businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
            businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
            businessResultEntity.setStatus(new Byte("0"));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
            this.makeAppointmentCancelLockNumber(appointmentRecordEntity);
            log.info("redis\u89e3\u9501key\u4e3a{}", (Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
            Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
            log.info("\u53f7\u6e90\u89e3\u9501\u540e \u9700\u8981\u540c\u6b65\u5220\u9664redis key \u5f53\u524d\u5220\u9664redis key\u7ed3\u679c - > {}", (Object)delete);
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        log.info("\u53d6\u6d88\u9884\u7ea6\u6302\u53f7************:{}", (Object)appointmentRecordEntity);
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        int i = this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        log.info("\u4fee\u6539\u7cfb\u7edf\u8868\u4e2d\u7684\u72b6\u6001************:{}", (Object)String.valueOf(i));
    }

    public BaseResponse<String> withdrawNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws Exception {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        log.info("redis\u89e3\u9501key\u4e3a{}", (Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
        Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
        log.info("\u53f7\u6e90\u89e3\u9501\u540e \u9700\u8981\u540c\u6b65\u5220\u9664redis key \u5f53\u524d\u5220\u9664redis key\u7ed3\u679c - > {}", (Object)delete);
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (appointmentRecordEntity.getAppointmentType() == 2) {
            log.info("\u533b\u4fdd\u9000\u53f7\u7684\u8ba2\u5355\u4e3a\u9884\u7ea6\u53f7");
            return BaseResponse.error((String)"\u8be5\u6302\u53f7\u4e3a\u5f53\u65e5\u53f7,\u4e0d\u53ef\u8fdb\u884c\u9884\u7ea6\u53f7\u9000\u53f7\u6d41\u7a0b");
        }
        log.info("\u5f53\u524d\u9000\u6b3e\u652f\u4ed8\u65b9\u5f0f\u4e3a->{}", (Object)withdrawNumberVoReq.getPayChannel());
        if (null != withdrawNumberVoReq.getPayChannel() && withdrawNumberVoReq.getPayChannel().equals("ALIPAY")) {
            ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
            AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            log.info("\u67e5\u8be2\u5230\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u8bb0\u5f55\uff1a" + JSON.toJSONString((Object)appointmentPayorderEntity));
            if (null == appointmentPayorderEntity) {
                log.error("refundforHis->\u67e5\u8be2\u8d26\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u53f7\u4e3a:{}", (Object)appointmentRecordEntity.getSysAppointmentId());
                throw new AppointmentException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u8d26F\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((String)appointmentPayorderEntity.getDealSeq())) {
                throw new AppointmentException("DealSeq\u4e3a\u7a7a\uff01\u9000\u6b3e\u5931\u8d25");
            }
            GatewayRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity);
            BusinessResultEntity businessResultEntity = new BusinessResultEntity();
            businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
            businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
            businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
            this.businessResultMapper.insertSelective(businessResultEntity);
            GatewayResponse gatewayResponse = this.invokeHisReturnRegister(gatewayRequest, null);
            if (Objects.isNull(gatewayResponse)) {
                return BaseResponse.error((String)"his\u9884\u7ea6\u9000\u53f7\u8bf7\u6c42\u5f02\u5e38");
            }
            if (!"1".equals(gatewayResponse.getCode())) {
                return BaseResponse.error((String)gatewayResponse.getMsg());
            }
            BaseResponse baseResponse = this.refund(this.buildRefundReq(appointmentRecordEntity, appointmentPayorderEntity, serviceMerchantConfigEntity));
            if (Objects.isNull(baseResponse)) {
                log.error(BASERESPONSE_NULL);
                return BaseResponse.error((String)NETWORK_EXCEPTION);
            }
            if (!baseResponse.isSuccess()) {
                log.error(ERROR_INFO, (Object)baseResponse.getMsg());
                return BaseResponse.error((String)REQ_ERROR_FAIL);
            }
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setCancleTime(new Date());
            appointmentRecordEntity.setRemark("\u7528\u6237\u53d1\u8d77\u9000\u6b3e");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            appointmentPayorderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
            appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)1));
            appointmentPayorderEntity.setRefundRemrak("\u7528\u6237\u53d1\u8d77\u9000\u6b3e");
            this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
            return baseResponse;
        }
        GatewayRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7 withdrawNumber";
        GatewayResponse gatewayResponse = this.invokeHisReturnRegister(gatewayRequest, message);
        if (Objects.isNull(gatewayResponse)) {
            return BaseResponse.error((String)"his\u9884\u7ea6\u9000\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            return BaseResponse.error((String)gatewayResponse.getMsg());
        }
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.CURRENT_SYSTEM_REFUND.getValue().intValue()));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        if ("0".equals(appointmentRecordEntity.getPayAmount())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
        }
        appointmentRecordEntity.setCancleTime(new Date());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity payorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if ((payorderEntity == null || payorderEntity.getDealSeq() == null || "".equals(payorderEntity.getDealSeq())) && !"0".equals(appointmentRecordEntity.getPayAmount())) {
            throw new AppointmentException("DealSeq\u4e3a\u7a7a\uff01");
        }
        if (payorderEntity != null) {
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity);
            log.info("refund method--------> begain");
            log.info("refund\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
            appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUNDS_AWAITING_CONFIRMATION.getValue().intValue()));
            this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
            businessResultEntity.setPlatformResponse(JSON.toJSONString((Object)baseResponse));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
            return baseResponse;
        }
        return null;
    }

    private RequestRefundOrderVoReq buildRefundReq(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity appointmentPayorderEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillMapper.queryDealNoByOutNo(appointmentRecordEntity.getSysAppointmentId());
        if (null == servicePayBillEntity) {
            return new RequestRefundOrderVoReq();
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannel());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(servicePayBillEntity.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        return requestRefundOrderVoReq;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            log.info("\u9884\u7ea6\u9000\u53f7\u9000\u6b3e\u8bf7\u6c42\u5730\u5740\u4e3a->{},\u5165\u53c2\u4e3a->{}", (Object)this.propertiesConstant.getRefundUrl(), (Object)JSON.toJSONString((Object)requestRefundOrderVoReq, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            log.info("\u9884\u7ea6\u9000\u53f7\u9000\u6b3e\u51fa\u53c2\u4e3a->{}", (Object)JSON.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        log.info("\u6302\u53f7\u786e\u8ba4==============");
        GatewayRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity, responseNotifyRestVo);
        log.info("gatewayRequest=============={}", (Object)gatewayRequest);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u5165\u53c2 PayRegistrationReq{}", gatewayRequest.getBody());
        GatewayResponse gatewayResponse = this.appointApi.confirmRegister(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u51fa\u53c2 PayRegistrationRes{}", (Object)JSON.toJSONString((Object)gatewayResponse));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (gatewayResponse == null) {
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            if (gatewayResponse.getMsg().contains("\u5145\u503c\u5931\u8d25")) {
                BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity);
                if ("1".equals(baseResponse.getCode())) {
                    appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                    appointmentRecordEntity.setRemark(gatewayResponse.getMsg());
                } else {
                    appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                    appointmentRecordEntity.setRemark(baseResponse.getMsg() + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
                }
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
                log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            }
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        ConfirmRegisterRes payRegistrationRes = (ConfirmRegisterRes)gatewayResponse.getData();
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        updatePayAppointment.setPayPostId(appointmentRecordEntity.getPayTransationId());
        updatePayAppointment.setPayTransationId(appointmentRecordEntity.getPayTransationId());
        updatePayAppointment.setPayChannel(PayChannelEnum.getDisplay((String)"WECHAT"));
        updatePayAppointment.setAppointNo(payRegistrationRes.getBookingNo());
        updatePayAppointment.setAdmAdress(payRegistrationRes.getAdmitAddress());
        if (null != payRegistrationRes) {
            updatePayAppointment.setAppointNo(payRegistrationRes.getBookingNo());
            updatePayAppointment.setReceptId(payRegistrationRes.getAppointId());
        }
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private BaseResponse<String> appointRefund(AppointmentRecordEntity appointmentRecordEntity) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        RefundReq refundReq = new RefundReq();
        refundReq.setMachineNo("wechat");
        refundReq.setTrace(String.valueOf(this.snowflakeIdWorker.nextId()));
        refundReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(appointmentRecordEntity.getRegFee().multiply(bigDecimal).intValue());
        refundReq.setTotalFee(totalfee);
        refundReq.setOutTradeNo(appointmentRecordEntity.getPayTransationId());
        log.info("\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
        HashMap<String, RefundReq> map = new HashMap<String, RefundReq>();
        map.put("refundReq", refundReq);
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.encrypt("004", map, this.propertiesConstant.getRefund(), HisPayRes.class);
        log.info("\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u4e3ahisPayRes:{}", (Object)JSON.toJSONString((Object)hisPayRes));
        if (Objects.equals(hisPayRes.getResultCode(), "0")) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)hisPayRes.getResultMsg());
    }

    private BaseResponse<String> newAppointRefund(String id, String cardNo, BigDecimal regFee, String outTradeNo) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        RefundReq refundReq = new RefundReq();
        refundReq.setMachineNo("wechat");
        refundReq.setTrace(String.valueOf(this.snowflakeIdWorker.nextId()));
        refundReq.setCardNo(cardNo);
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(regFee.multiply(bigDecimal).intValue());
        refundReq.setTotalFee(totalfee);
        refundReq.setOutTradeNo(outTradeNo);
        log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
        HashMap<String, RefundReq> map = new HashMap<String, RefundReq>();
        map.put("refundReq", refundReq);
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.encrypt("004", map, this.propertiesConstant.getRefund(), HisPayRes.class);
        log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u4e3ahisPayRes:{}", (Object)JSON.toJSONString((Object)hisPayRes));
        if (Objects.equals(hisPayRes.getResultCode(), "0")) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)hisPayRes.getResultMsg());
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelRegister(GatewayRequest<CancelRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = this.appointApi.cancelRegister(gatewayRequest);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error(message + " -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayResponse<CancelRegisterRes> invokeHisReturnRegister(GatewayRequest<CancelRegisterReq> gatewayRequest, String message) throws AppointmentException {
        log.info("\u8bf7\u6c42his\u9884\u7ea6\u9000\u53f7\u5165\u53c2->{}", (Object)JSON.toJSONString(gatewayRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        GatewayResponse gatewayResponse = this.appointApi.cancelRegister(gatewayRequest);
        log.info("\u8bf7\u6c42his\u9884\u7ea6\u9000\u53f7\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)gatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (gatewayResponse == null) {
            log.error("his\u8bf7\u6c42\u9884\u7ea6\u9000\u53f7\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(" -> his\u9000\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayRequest<CancelRegisterReq> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
        cancelRegisterReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        cancelRegisterReq.setAppointId(appointmentRecordEntity.getReceptId());
        cancelRegisterReq.setBookingNo(appointmentRecordEntity.getSeeNo());
        cancelRegisterReq.setBeginTime(cancelAppointmentVoReq.getBeginTime());
        cancelRegisterReq.setEndTime(cancelAppointmentVoReq.getEndTime());
        gatewayRequest.setBody((Object)cancelRegisterReq);
        gatewayRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setChannel(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<CancelRegisterReq> buildWithdrawNumberGatewayReq(AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        CancelRegisterReq returnRegisterReq = new CancelRegisterReq();
        returnRegisterReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        returnRegisterReq.setBookingNo(appointmentRecordEntity.getPayChannelCode());
        String[] split = appointmentRecordEntity.getAdmTimeRange().split("-");
        returnRegisterReq.setBeginTime(split[0]);
        returnRegisterReq.setEndTime(split[1]);
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    @Transactional(rollbackFor={Exception.class})
    public String appointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        String idNo = createOrderVoReq.getIdNo();
        String gender = IdCardUtils.judgeGender((String)idNo);
        int age = IdCardUtils.countAge((String)idNo);
        if ("1014".equals(createOrderVoReq.getDeptCode()) && age > 18) {
            return "\u513f\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb818\u5468\u5c81\u53ca\u4ee5\u4e0b\u6302\u53f7";
        }
        if ("9023".equals(createOrderVoReq.getDeptCode()) && "2".equals(gender)) {
            return "\u7537\u79d1\u95e8\u8bca\uff08\u4e0d\u5b55\u4e0d\u80b2\u4e13\u79d1\uff09\uff0c\u53ea\u5141\u8bb8\u7537\u6027\u6302\u53f7";
        }
        if ("1013".equals(createOrderVoReq.getDeptCode()) && "1".equals(gender)) {
            return "\u5987\uff08\u4ea7\uff09\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb8\u5973\u6027\u6302\u53f7 ";
        }
        List recordEntity = this.appointmentRecordMapper.selectByTime(createOrderVoReq.getAdmDate(), createOrderVoReq.getCardId(), createOrderVoReq.getDeptCode(), String.valueOf(1));
        if (recordEntity.size() > 0) {
            return "\u6302\u53f7\u5931\u8d25\uff0c\u8be5\u5c31\u8bca\u4eba\u5df2\u6709\u672c\u79d1\u5ba4\u6302\u53f7\u5355,\u8bf7\u9009\u62e9\u5176\u4ed6\u65e5\u671f\u6216\u5176\u4ed6\u79d1\u5ba4";
        }
        long sysAppointmnetId = this.snowflakeIdWorker.nextId();
        GetScheduleResItems getScheduleResItems = this.isHasAppointmentInfo(createOrderVoReq);
        if (null == getScheduleResItems) {
            throw new AppointmentException("\u6b64\u53f7\u6bb5\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u7528\u53ef\u7528\u53f7\u6bb5\uff01");
        }
        AppointmentRecordEntity appointmentRecordEntity = null;
        AppointmentRecordEntity appointmentRecordEntitysh = new AppointmentRecordEntity();
        appointmentRecordEntitysh.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntitysh.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntitysh.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntitysh.setAdmRange(Convert.toInt((Object)createOrderVoReq.getAdmTimeRange()).intValue());
        appointmentRecordEntitysh.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntitysh.setAdmTimeRange(createOrderVoReq.getStartTime());
        appointmentRecordEntitysh.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        String seeNo = this.reservationRegistrationLock(appointmentRecordEntitysh);
        if (null == seeNo) {
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25 \u65e0\u6cd5\u83b7\u53d6\u5c31\u8bca\u5e8f\u53f7");
        }
        appointmentRecordEntity = this.newBuildSuccessAppointmentRecordEntity(sysAppointmnetId, null, createOrderVoReq, getScheduleResItems, seeNo);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo));
        if (!StrUtil.isBlank((CharSequence)createOrderVoReq.getAuthCode())) {
            this.jedisCluster.set(appointmentRecordEntity.getSysAppointmentId() + "_authCode", createOrderVoReq.getAuthCode(), "NX", "EX", 43200L);
        }
        return appointmentRecordEntity.getSysAppointmentId();
    }

    public ConfirmRegisterRes appointmentCreateOrderLock(AppointmentCreateOrderVoReq createOrderVoReq, GatewayRequest<ConfirmRegisterReq> gatewayRequest) throws AppointmentException {
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(createOrderVoReq.getChannelName());
        businessResultEntity.setBusinessType(Byte.valueOf(BusinessTypeEnums.APPOINTMENT.getValue().byteValue()));
        businessResultEntity.setHisRequest(JSON.toJSONString(gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1agatewayRequest:{}", gatewayRequest);
        return null;
    }

    private GetScheduleResItems isHasAppointmentInfo(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildScheduleGetwayRequest(appointmentCreateOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO.getItems() == null || getScheduleResVO.getItems().isEmpty()) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(appointmentCreateOrderVoReq.getAdmTimeRange())).collect(Collectors.toList());
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u5348\u522b\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        if (CollectionUtils.isEmpty(scheduleResItemsList)) {
            return null;
        }
        return (GetScheduleResItems)scheduleResItemsList.get(0);
    }

    private GatewayRequest<GetScheduleReqVO> buildScheduleGetwayRequest(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(appointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(appointmentCreateOrderVoReq.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("appointmentCreateOrder");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private GatewayRequest<ConfirmRegisterReq> buildConfirmRegisterReq(long sysAppointmentId, AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ConfirmRegisterReq confirmRegisterReq = new ConfirmRegisterReq();
        confirmRegisterReq.setCardNo(appointmentCreateOrderVoReq.getPatientCardNo());
        confirmRegisterReq.setSchemaId(appointmentCreateOrderVoReq.getScheduleHisId());
        confirmRegisterReq.setIdNo(appointmentCreateOrderVoReq.getIdNo());
        confirmRegisterReq.setPatientName(appointmentCreateOrderVoReq.getPatientName());
        confirmRegisterReq.setOrderNumber(appointmentCreateOrderVoReq.getOrderNumber());
        confirmRegisterReq.setBeginTime(appointmentCreateOrderVoReq.getStartTime());
        confirmRegisterReq.setEndTime(appointmentCreateOrderVoReq.getEndTime());
        confirmRegisterReq.setIsFirst(appointmentCreateOrderVoReq.getIsFirst());
        confirmRegisterReq.setRealCost(appointmentCreateOrderVoReq.getRealCost());
        confirmRegisterReq.setRbasId(appointmentCreateOrderVoReq.getScheduleHisId());
        confirmRegisterReq.setClinicDate(appointmentCreateOrderVoReq.getAdmDate());
        confirmRegisterReq.setClinicTime(appointmentCreateOrderVoReq.getTimeArrange());
        confirmRegisterReq.setTimeArrangeId(appointmentCreateOrderVoReq.getTimeArrangeId());
        if (appointmentCreateOrderVoReq.getAdmTimeRange().equals(AdmTimeRangeEnum.MORNING.getValue())) {
            confirmRegisterReq.setTimeFlag("0");
        } else if (appointmentCreateOrderVoReq.getAdmTimeRange().equals(AdmTimeRangeEnum.AFTERNOON.getValue())) {
            confirmRegisterReq.setTimeFlag("1");
        }
        confirmRegisterReq.setFlowNo(String.valueOf(sysAppointmentId));
        gatewayRequest.setBody((Object)confirmRegisterReq);
        gatewayRequest.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("appointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<ConfirmRegisterReq> buildDayConfirmRegisterReq(long sysAppointmentId, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ConfirmRegisterReq dayRegisterReq = new ConfirmRegisterReq();
        dayRegisterReq.setCardNo(createOrderVoReq.getPatientCardNo());
        dayRegisterReq.setRbasId(createOrderVoReq.getScheduleHisId());
        dayRegisterReq.setClinicDate(createOrderVoReq.getAdmDate());
        dayRegisterReq.setClinicTime(createOrderVoReq.getTimeArrange());
        dayRegisterReq.setTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        gatewayRequest.setBody((Object)dayRegisterReq);
        gatewayRequest.setChannelName(createOrderVoReq.getChannelName());
        gatewayRequest.setChannel(createOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayConfirmRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<DayRegisterReq> buildNewDayConfirmRegisterReq(long sysAppointmentId, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DayRegisterReq dayRegisterReq = new DayRegisterReq();
        dayRegisterReq.setCardNo(createOrderVoReq.getPatientCardNo());
        dayRegisterReq.setName(createOrderVoReq.getPatientName());
        dayRegisterReq.setSex(createOrderVoReq.getSex());
        dayRegisterReq.setPactCode("01");
        dayRegisterReq.setDeptNo(createOrderVoReq.getDeptCode());
        dayRegisterReq.setDeptName(createOrderVoReq.getLocName());
        dayRegisterReq.setDoctName(createOrderVoReq.getDocName());
        dayRegisterReq.setDoctorNo(createOrderVoReq.getDocCode());
        dayRegisterReq.setRegLeveName(createOrderVoReq.getRegLeveName());
        dayRegisterReq.setRegLeve(createOrderVoReq.getRegLeve());
        dayRegisterReq.setRbasId(createOrderVoReq.getScheduleHisId());
        dayRegisterReq.setNoonID(createOrderVoReq.getNoonID());
        dayRegisterReq.setTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        gatewayRequest.setBody((Object)dayRegisterReq);
        gatewayRequest.setChannelName(createOrderVoReq.getChannelName());
        gatewayRequest.setChannel(createOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayConfirmRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public AppointmentRecordEntity buildSuccessAppointmentRecordEntity(long sysAppointmentId, PayRegistrationRes payRegistrationRes, AppointmentCreateOrderVoReq createOrderVoReq, GetScheduleResItems getScheduleResItems) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(payRegistrationRes.getNo());
        appointmentRecordEntity.setAdmAddress(getScheduleResItems.getAdmLocation());
        appointmentRecordEntity.setTakeAddress("");
        appointmentRecordEntity.setTakeTime("");
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getTimeArrange());
        appointmentRecordEntity.setReceptId(payRegistrationRes.getReceiptId());
        appointmentRecordEntity.setAppointmentNo(payRegistrationRes.getNo());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate()));
        appointmentRecordEntity.setAppointmentType(1);
        if (Objects.nonNull(createOrderVoReq.getAdmDate())) {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        } else {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getStartTime() + "-" + createOrderVoReq.getEndTime());
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6210\u529f,\u5f85\u652f\u4ed8");
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItems.getRegFee()));
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getOrganPmi());
        }
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity newBuildSuccessAppointmentRecordEntity(long sysAppointmentId, ConfirmRegisterRes confirmRegisterResult, AppointmentCreateOrderVoReq createOrderVoReq, GetScheduleResItems getScheduleResItems, String seeNo) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setHospitalAreaCode(createOrderVoReq.getHospitalAreaCode());
        appointmentRecordEntity.setAdmAddress(getScheduleResItems.getAdmLocation());
        appointmentRecordEntity.setTakeAddress("");
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getStartTime() + "-" + createOrderVoReq.getEndTime());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate()));
        appointmentRecordEntity.setAppointmentType(1);
        if (Objects.nonNull(createOrderVoReq.getAdmDate())) {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        } else {
            appointmentRecordEntity.setAdmDate(createOrderVoReq.getStartTime() + "-" + createOrderVoReq.getEndTime());
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6210\u529f,\u5f85\u652f\u4ed8");
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItems.getRegFee()));
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getOrganPmi());
        }
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setSeeNo(seeNo);
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity getAppointmentRecordBySysAppointmentId(String sysAppointmentId) {
        return this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
    }

    public void autoCancelDelayAppointment(UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo) {
        this.appointmentRecordMapper.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private void updateDoDayRegisterRes(DoDayAppointmentDTO doDayAppointmentDTO) {
        this.appointmentRecordMapper.updateDoDayAppointmentRecord(doDayAppointmentDTO);
    }

    public BaseResponse dayAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq, HttpServletRequest request) throws InHospitalException {
        List recordEntity = this.appointmentRecordMapper.selectByTime(dayAppointmentPayVoReq.getAdmDate(), dayAppointmentPayVoReq.getCardId(), dayAppointmentPayVoReq.getDeptCode(), String.valueOf(2));
        if (recordEntity.size() > 0) {
            return BaseResponse.error((String)"\u6302\u53f7\u5931\u8d25\uff0c\u8be5\u5c31\u8bca\u4eba\u5df2\u6709\u672c\u79d1\u5ba4\u6302\u53f7\u5355,\u8bf7\u9009\u62e9\u5176\u4ed6\u65e5\u671f\u6216\u5176\u4ed6\u79d1\u5ba4");
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        String openId = dayAppointmentPayVoReq.getOpenId();
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(appointmentRecordEntity.getRegFee().multiply(bigDecimal).intValue());
        RechargeCardToHosReqVo rechargeCardToHosReqVo = new RechargeCardToHosReqVo();
        rechargeCardToHosReqVo.setCardNo(appointmentRecordEntity.getPatientCardNo());
        rechargeCardToHosReqVo.setChannelCode(dayAppointmentPayVoReq.getChannelCode());
        rechargeCardToHosReqVo.setHosCode(appointmentRecordEntity.getHospitalCode());
        BaseResponse queryAccountInfoResVoBaseResponse = this.iCardService.queryCardAccount(rechargeCardToHosReqVo);
        if (!"1".equals(queryAccountInfoResVoBaseResponse.getCode())) {
            return BaseResponse.error((String)queryAccountInfoResVoBaseResponse.getMsg());
        }
        QueryAccountInfoResVo queryAccountInfoResVo = (QueryAccountInfoResVo)queryAccountInfoResVoBaseResponse.getData();
        BigDecimal multiply = new BigDecimal(queryAccountInfoResVo.getVacancy()).multiply(bigDecimal);
        int flag = multiply.compareTo(new BigDecimal(totalfee));
        if (flag < 0) {
            BigDecimal subtract = new BigDecimal(totalfee).subtract(multiply);
            String sub = subtract.divide(bigDecimal).toString();
            HealthRegisteredResVo healthRegisteredResVo = new HealthRegisteredResVo();
            healthRegisteredResVo.setMessage("\u4f59\u989d\u4e0d\u8db3,\u8bf7\u5145\u503c!\u5361\u4f59\u989d:" + queryAccountInfoResVo.getVacancy().toString() + ",\u5e94\u8865\u7f34:" + sub);
            healthRegisteredResVo.setSumMoney(sub);
            return BaseResponse.success((Object)healthRegisteredResVo);
        }
        UpdateStatusVoReq updateStatusVoReq = new UpdateStatusVoReq();
        updateStatusVoReq.setSysAppointmentId(dayAppointmentPayVoReq.getSysAppointmentId());
        try {
            this.payCallBackService.updateStatus(updateStatusVoReq);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        String authCode = this.jedisCluster.get(dayAppointmentPayVoReq.getSysAppointmentId() + "_authCode");
        this.taskExecutor.execute(() -> {
            try {
                this.pushService.alipayAppointmentSuccessMsgPush(String.valueOf(dayAppointmentPayVoReq.getSysAppointmentId()), "1", authCode);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u5931\u8d25", (Throwable)e);
            }
        });
        return BaseResponse.success();
    }

    public static String handle(String param) {
        String s = param.substring(param.lastIndexOf("[") + 1, param.indexOf("]"));
        return s;
    }

    public BaseResponse appointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq, HttpServletRequest request) throws InHospitalException, AppointmentException {
        log.info("*******************getAdmDate:{}----getUserId:{}--------getDeptCode:{}", new Object[]{dayAppointmentPayVoReq.getAdmDate(), dayAppointmentPayVoReq.getCardId(), dayAppointmentPayVoReq.getDeptCode()});
        List recordEntity = this.appointmentRecordMapper.selectByTime(dayAppointmentPayVoReq.getAdmDate(), dayAppointmentPayVoReq.getCardId(), dayAppointmentPayVoReq.getDeptCode(), String.valueOf(1));
        if (recordEntity.size() > 0) {
            return BaseResponse.error((String)"\u6302\u53f7\u5931\u8d25\uff0c\u8be5\u5c31\u8bca\u4eba\u5df2\u6709\u672c\u79d1\u5ba4\u6302\u53f7\u5355,\u8bf7\u9009\u62e9\u5176\u4ed6\u65e5\u671f\u6216\u5176\u4ed6\u79d1\u5ba4");
        }
        Object payStr = this.redisTemplate.opsForValue().get((Object)("HBBD-ZFCS-" + dayAppointmentPayVoReq.getSysAppointmentId()));
        if (null != payStr) {
            return BaseResponse.success((Object)payStr.toString());
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        String openId = dayAppointmentPayVoReq.getOpenId();
        log.info("\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u4e3a->{}", (Object)dayAppointmentPayVoReq.getPayChannel());
        if (null != dayAppointmentPayVoReq.getPayChannel() && dayAppointmentPayVoReq.getPayChannel().equals("ALIPAY")) {
            PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
            payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
            payRequestVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
            payRequestVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
            payRequestVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
            payRequestVoReq.setProductInfo(appointmentRecordEntity.getPatientName() + "HLWYY_\u9884\u7ea6\u6302\u53f7\u7f34\u8d39");
            payRequestVoReq.setServiceCode(ServiceCodeEnum.DAY_APPOINTMENT.getValue());
            payRequestVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            payRequestVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            payRequestVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
            payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
            payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            payRequestVoReq.setPayNotifyUrl(this.propertiesConstant.getPayNotifyUrl());
            Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
            String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
            payRequestVoReq.setSign(sign);
            BaseResponse baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
            if (baseResponse.getCode().equals("0")) {
                return BaseResponse.error((String)"\u62c9\u8d77\u652f\u4ed8\u5931\u8d25");
            }
            this.redisTemplate.opsForValue().set((Object)("HBBD-ZFCS-" + appointmentRecordEntity.getSysAppointmentId()), baseResponse.getData(), 310L, TimeUnit.SECONDS);
            log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        HashMap<String, PolymerizationReq> map = new HashMap<String, PolymerizationReq>();
        PolymerizationReq polymerizationReq = new PolymerizationReq();
        polymerizationReq.setBody(appointmentRecordEntity.getPatientName() + "HLWYY_\u9884\u7ea6\u6302\u53f7\u7f34\u8d39");
        polymerizationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        polymerizationReq.setMachineNo("wechat");
        polymerizationReq.setMethod("8");
        polymerizationReq.setType("2");
        polymerizationReq.setShowUrl("showUrl");
        polymerizationReq.setSubAppid(this.propertiesConstant.getSubAppid());
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(appointmentRecordEntity.getRegFee().multiply(bigDecimal).intValue());
        polymerizationReq.setTotalFee(totalfee);
        polymerizationReq.setSubject(appointmentRecordEntity.getPatientName() + "HLWYY_\u9884\u7ea6\u6302\u53f7\u7f34\u8d39");
        polymerizationReq.setReturnUrl("ReturnUrl");
        polymerizationReq.setOpenid(dayAppointmentPayVoReq.getOpenId());
        polymerizationReq.setPatientName(appointmentRecordEntity.getPatientName());
        map.put("polymerizationReq", polymerizationReq);
        PolymerizationRes encrypt = (PolymerizationRes)this.encryptUtils.encrypt("001", map, this.propertiesConstant.getPolymerization(), PolymerizationRes.class);
        String resultCode = encrypt.getResultCode();
        BaseResponse baseResponse = new BaseResponse();
        if (Objects.equals(encrypt.getResultCode(), "0")) {
            String payUrl = encrypt.getPayUrl();
            String outTradeNo = encrypt.getOutTradeNo();
            this.appointmentRecordMapper.updatePayTransationIdBysysId(appointmentRecordEntity.getSysAppointmentId(), outTradeNo);
            PayOrder payOrder = new PayOrder();
            payOrder.setNumber(1);
            payOrder.setType(2);
            payOrder.setId(appointmentRecordEntity.getSysAppointmentId());
            OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
            this.redisTemplate.opsForValue().set((Object)("HBBD-ZFCS-" + appointmentRecordEntity.getSysAppointmentId()), (Object)payUrl, 310L, TimeUnit.SECONDS);
            return BaseResponse.success((Object)payUrl);
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    public BaseResponse<String> appointmentRegistrationToBePaid(String sysAppointmentId) {
        log.info("\u9884\u7ea6\u6302\u53f7\u5f85\u652f\u4ed8\u5165\u53c2 - >{}", (Object)sysAppointmentId);
        Object objectPayUrl = this.redisTemplate.opsForValue().get((Object)("HBBD-ZFCS-" + sysAppointmentId));
        String payUrl = Convert.toStr((Object)objectPayUrl);
        log.info("redis\u51fa\u53c2 - >{}", (Object)payUrl);
        if (null == objectPayUrl || null == payUrl) {
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u8fc7\u671f \u8bf7\u91cd\u65b0\u9884\u7ea6");
        }
        return BaseResponse.success((Object)payUrl);
    }

    public String reservationRegistrationLock(AppointmentRecordEntity appointmentRecordEntitysh) throws AppointmentException {
        log.info("redis\u9501\u53f7key\u4e3a{}", (Object)("HBBD-YYGH-SH-" + appointmentRecordEntitysh.getPatientCardNo() + "-" + appointmentRecordEntitysh.getDeptCode() + "-" + appointmentRecordEntitysh.getDocCode() + appointmentRecordEntitysh.getAdmDate()));
        boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)("HBBD-YYGH-SH-" + appointmentRecordEntitysh.getPatientCardNo() + "-" + appointmentRecordEntitysh.getDeptCode() + "-" + appointmentRecordEntitysh.getDocCode() + appointmentRecordEntitysh.getAdmDate()), (Object)Convert.toStr((Object)this.snowflakeIdWorker.nextId()), 300L, TimeUnit.SECONDS);
        if (!locked) {
            throw new AppointmentException("\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u5f85\u652f\u4ed8\u8ba2\u5355");
        }
        ReservationLockNumberRes reservationLockNumberRes = this.appointmentLockNumber(appointmentRecordEntitysh);
        return reservationLockNumberRes.getMark();
    }

    private ReservationLockNumberRes appointmentLockNumber(AppointmentRecordEntity appointmentRecordEntity) throws AppointmentException {
        try {
            log.info("his\u9501\u53f7\u65b9\u6cd5\u5165\u53c2 AppointmentLockNumber - > {}", (Object)JSON.toJSONString((Object)appointmentRecordEntity));
            ReservationLockNumberReq reservationLockNumberReq = new ReservationLockNumberReq();
            reservationLockNumberReq.setDeptCode(appointmentRecordEntity.getDeptCode());
            reservationLockNumberReq.setDoctCode(appointmentRecordEntity.getDocCode());
            reservationLockNumberReq.setNoonId(Convert.toStr((Object)appointmentRecordEntity.getAdmRange()));
            reservationLockNumberReq.setDate(appointmentRecordEntity.getAdmDate());
            reservationLockNumberReq.setTimePoint(appointmentRecordEntity.getAdmTimeRange());
            reservationLockNumberReq.setScheamID(appointmentRecordEntity.getScheduleHisId());
            reservationLockNumberReq.setType("1");
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
            frontRequest.setBody((Object)reservationLockNumberReq);
            frontRequest.setChannelName("appointmentRegistrationLock");
            log.info("\u8bf7\u6c42his\u9501\u53f7\u63a5\u53e3\u5165\u53c2 - > {} \u8bf7\u6c42\u5730\u5740 - >{}", JSON.toJSON((Object)frontRequest), (Object)(this.hisFontUrl + "/appoint/appointmentRegistrationLock"));
            String post = HttpUtil.post((String)(this.hisFontUrl + "/appoint/appointmentRegistrationLock"), (String)JSON.toJSONString((Object)frontRequest));
            log.info("\u8bf7\u6c42his\u9501\u53f7\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)post));
            ReservationLockNumberRes reservationLockNumberRes = (ReservationLockNumberRes)JSON.parseObject((String)post, ReservationLockNumberRes.class);
            log.info("\u8bf7\u6c42his\u9501\u53f7\u51fa\u53c2\u8f6c\u5bf9\u8c61\u540e - > {}", (Object)JSON.toJSONString((Object)reservationLockNumberRes));
            if (null == reservationLockNumberRes) {
                Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
                throw new AppointmentException("\u9501\u53f7\u5931\u8d25 \u8bf7\u8fd4\u56de\u91cd\u8bd5");
            }
            if (reservationLockNumberRes.getResult().equals("-1")) {
                Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
                throw new AppointmentException(reservationLockNumberRes.getErr());
            }
            if (null == reservationLockNumberRes.getMark()) {
                Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
                throw new AppointmentException("\u9501\u53f7\u5931\u8d25 \u8bf7\u8fd4\u56de\u91cd\u8bd5 \u4fe1\u606f\u4fe1\u606f:" + reservationLockNumberRes.getErr());
            }
            return reservationLockNumberRes;
        }
        catch (Exception e) {
            log.info("\u9501\u53f7\u51fa\u73b0\u5f02\u5e38{}", (Object)e.getMessage());
            Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
            throw new AppointmentException("\u9501\u53f7\u5f02\u5e38" + e.getMessage());
        }
    }

    public ReservationLockNumberRes makeAppointmentCancelLockNumber(AppointmentRecordEntity appointmentRecordEntity) throws AppointmentException {
        ReservationLockNumberReq reservationLockNumberReq = new ReservationLockNumberReq();
        reservationLockNumberReq.setDeptCode(appointmentRecordEntity.getDeptCode());
        reservationLockNumberReq.setDoctCode(appointmentRecordEntity.getDocCode());
        reservationLockNumberReq.setNoonId(Convert.toStr((Object)appointmentRecordEntity.getAdmRange()));
        reservationLockNumberReq.setDate(appointmentRecordEntity.getAdmDate());
        reservationLockNumberReq.setTimePoint(this.dealWithadmTimeRange(appointmentRecordEntity.getAdmTimeRange()));
        reservationLockNumberReq.setScheamID(appointmentRecordEntity.getScheduleHisId());
        reservationLockNumberReq.setType("2");
        reservationLockNumberReq.setSeeNo(appointmentRecordEntity.getSeeNo());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)reservationLockNumberReq);
        frontRequest.setChannelName("appointmentRegistrationLock");
        log.info("\u8bf7\u6c42his\u53d6\u6d88\u9501\u53f7\u63a5\u53e3\u5165\u53c2 - > {}", JSON.toJSON((Object)frontRequest));
        String post = null;
        try {
            post = HttpUtil.post((String)(this.hisFontUrl + "/appoint/appointmentRegistrationLock"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (Exception e) {
            log.info("\u53d6\u6d88\u9501\u53f7\u51fa\u73b0\u5f02\u5e38{}", (Object)e.getMessage());
            throw new AppointmentException("\u53d6\u6d88\u9501\u53f7\u5f02\u5e38 \u8bf7\u8fd4\u56de\u91cd\u8bd5 \u8be6\u7ec6\u4fe1\u606f:" + e.getMessage());
        }
        log.info("\u8bf7\u6c42his\u53d6\u6d88\u9501\u53f7\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)post));
        ReservationLockNumberRes reservationLockNumberRes = (ReservationLockNumberRes)JSON.parseObject((String)post, ReservationLockNumberRes.class);
        Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
        log.info("\u53f7\u6e90\u89e3\u9501\u540e \u9700\u8981\u540c\u6b65\u5220\u9664redis key \u5f53\u524d\u5220\u9664redis key\u7ed3\u679c - > {}", (Object)delete);
        if (null == reservationLockNumberRes) {
            this.appointmentRecordMapper.updateCancelPayStatus(appointmentRecordEntity.getSysAppointmentId(), Convert.toStr((Object)AppointmentStatusEnum.CANCEL.getValue()), reservationLockNumberRes.getErr());
            throw new AppointmentException("\u53d6\u6d88\u9501\u53f7\u5931\u8d25 \u8bf7\u8fd4\u56de\u91cd\u8bd5");
        }
        if (reservationLockNumberRes.getResult().equals("-1")) {
            this.appointmentRecordMapper.updateCancelPayStatus(appointmentRecordEntity.getSysAppointmentId(), Convert.toStr((Object)AppointmentStatusEnum.CANCEL.getValue()), reservationLockNumberRes.getErr());
            throw new AppointmentException("\u53d6\u6d88\u9501\u53f7\u5931\u8d25 \u8bf7\u8fd4\u56de\u91cd\u8bd5 \u8be6\u7ec6\u4fe1\u606f:" + reservationLockNumberRes.getErr());
        }
        return reservationLockNumberRes;
    }

    private String dealWithadmTimeRange(String admTimeRange) throws AppointmentException {
        try {
            String[] split = admTimeRange.split("-");
            if (split.length == 0) {
                throw new AppointmentException("\u8bf7\u9009\u62e9\u5c31\u8bca\u65f6\u6bb5");
            }
            return split[0];
        }
        catch (Exception e) {
            throw new AppointmentException("\u8bf7\u9009\u62e9\u5c31\u8bca\u65f6\u6bb5");
        }
    }

    private BaseResponse<String> payCreateOrder(AppointmentPayVoReq appointmentPayVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)appointmentPayVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            this.taskExecutor.execute(() -> {
                String data = (String)baseResponse.getData();
                String prepayId = data.substring(data.indexOf("prepay_id=") + 10, data.indexOf("\",\"paySign"));
                log.info("prepayId: " + prepayId);
                String sysAppointmentId = appointmentPayVoReq.getOutTradeNo();
                this.jedisCluster.set(sysAppointmentId, prepayId);
                this.jedisCluster.expire(sysAppointmentId, 518400);
            });
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private GatewayRequest<ConfirmRegisterReq> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ConfirmRegisterReq payRegistrationReq = new ConfirmRegisterReq();
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        log.info("\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u4e3a->{}", (Object)responseNotifyRestVo.getPayChannel());
        if (null != responseNotifyRestVo.getPayChannel() && responseNotifyRestVo.getPayChannel().equals("ALIPAY")) {
            payRegistrationReq.setPayChannel(responseNotifyRestVo.getPayChannel());
            payRegistrationReq.setFlowNo(responseNotifyRestVo.getTradeNo());
            payRegistrationReq.setOrderNumber(responseNotifyRestVo.getOutTradeNo());
            payRegistrationReq.setTransNo(responseNotifyRestVo.getTradeNo());
            payRegistrationMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        } else {
            payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayTransationId());
            payRegistrationReq.setFlowNo(appointmentRecordEntity.getPayTransationId());
            payRegistrationReq.setOrderNumber(responseNotifyRestVo.getOrderNo());
            payRegistrationReq.setTransNo(responseNotifyRestVo.getOrderNo());
            payRegistrationMsg.setOrderid(responseNotifyRestVo.getOrderNo());
        }
        payRegistrationReq.setPatientName(appointmentRecordEntity.getPatientName());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getRegFee().toString());
        payRegistrationReq.setRelaPhone(appointmentRecordEntity.getPatientPhone());
        payRegistrationReq.setIdNo(appointmentRecordEntity.getPatientIdCard());
        payRegistrationReq.setSchemaId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setSortId(appointmentRecordEntity.getTakeTime());
        payRegistrationReq.setIsFirst("1");
        String admTimeRange = appointmentRecordEntity.getAdmTimeRange();
        String[] split = admTimeRange.split("-");
        payRegistrationReq.setBeginTime(split[0]);
        payRegistrationReq.setEndTime(split[1]);
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("PayRegistrationReq");
        gatewayRequest.setTransactionId(String.valueOf(System.currentTimeMillis()));
        return gatewayRequest;
    }

    private void updateScheduleSourceNo(GetScheduleResItems getScheduleResItems, AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        UpdateScheduleDetailDTO updateScheduleDetailDTO = new UpdateScheduleDetailDTO();
        ArrayList<String> timeArrangeIdList = new ArrayList<String>();
        updateScheduleDetailDTO.setHospitalCode(appointmentCreateOrderVoReq.getHospitalCode());
        updateScheduleDetailDTO.setScheduleId(getScheduleResItems.getScheduleId());
        for (TimeArrangeItems timeArrangeItems : getScheduleResItems.getTimeArrangeItems()) {
            timeArrangeIdList.add(timeArrangeItems.getTimeArrangeId());
        }
        String timeArrangeId = "'" + StringUtils.join(timeArrangeIdList, (String)"','") + "'";
        updateScheduleDetailDTO.setTimeArrangeId(timeArrangeId);
        this.scheduleDetailRecordMapper.updateByGetScheduleResItems(updateScheduleDetailDTO);
    }

    private void updateScheduleByDayAppointmentCreateOrderVoReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        this.scheduleRecordMapper.updateScheduleByDayAppointmentCreateOrderVoReq(dayAppointmentCreateOrderVoReq);
    }

    private GatewayRequest<GetScheduleReqVO> buildConfirmScheduleGetwayRequest(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setEdDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setLocCode(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setDocCode(confirmAppointmentVo.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("confirmAppointmentVo");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private List<GetScheduleResItems> getHisDaySchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDocCode().equals(confirmAppointmentVo.getDocCode())).collect(Collectors.toList());
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private List<GetScheduleResItems> getHisSchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private ConfirmAppointmentVo buildConfirmAppointmentVo(GetScheduleResItems getScheduleResItems, ConfirmAppointmentVo confirmAppointVo) {
        ConfirmAppointmentVo confirmAppointmentVo = new ConfirmAppointmentVo();
        confirmAppointmentVo.setDoctorHeadPortrait(confirmAppointVo.getDoctorHeadPortrait());
        confirmAppointmentVo.setAdmDate(confirmAppointVo.getAdmDate());
        confirmAppointmentVo.setAdmTimeRange(confirmAppointVo.getAdmTimeRange());
        confirmAppointmentVo.setDocCode(confirmAppointVo.getDocCode());
        confirmAppointmentVo.setDocName(confirmAppointVo.getDocName());
        confirmAppointmentVo.setHospitalName(confirmAppointVo.getHospitalName());
        confirmAppointmentVo.setIsAppend(confirmAppointVo.getIsAppend());
        confirmAppointmentVo.setIsTimeArrange(confirmAppointVo.getIsTimeArrange());
        confirmAppointmentVo.setLocCode(confirmAppointVo.getLocCode());
        confirmAppointmentVo.setLocName(confirmAppointVo.getLocName());
        confirmAppointmentVo.setRegFee(confirmAppointVo.getRegFee());
        confirmAppointmentVo.setDiagFee(confirmAppointVo.getDiagFee());
        confirmAppointmentVo.setTotalFee(confirmAppointVo.getTotalFee());
        confirmAppointmentVo.setRegTitleCode(confirmAppointVo.getRegTitleCode());
        confirmAppointmentVo.setRegTitleName(confirmAppointVo.getRegTitleName());
        confirmAppointmentVo.setScheduleHisId(confirmAppointVo.getScheduleHisId());
        confirmAppointmentVo.setScheduleLevelName(confirmAppointVo.getScheduleLevelName());
        confirmAppointmentVo.setAppointmentType(confirmAppointVo.getAppointmentType());
        List timeArrangeItemsList = getScheduleResItems.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            confirmAppointmentVo.setTimeArrangeItems(new ArrayList());
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public BaseResponse<String> appointmentRefund(Refund refund) {
        log.info("\u7ba1\u7406\u7aef\u9000\u8d39\u8bf7\u6c42\u5165\u53c2refund:{}", (Object)JSON.toJSONString((Object)refund));
        String type = refund.getType();
        String id = refund.getId();
        if (Objects.equals(type, "1")) {
            AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(id);
            log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u6302\u53f7\u8ba2\u5355appointmentRecordEntity:{}", (Object)JSON.toJSONString((Object)appointmentRecordEntity));
            if (Objects.isNull(appointmentRecordEntity)) {
                return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (Objects.equals(appointmentRecordEntity.getAppointStatus(), "7")) {
                return BaseResponse.error((String)"\u8ba2\u5355\u6b63\u5e38\uff0c\u65e0\u6cd5\u9000\u8d39");
            }
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity);
            if ("1".equals(baseResponse.getCode())) {
                AppointmentRecordEntity newAppointmentRecordEntity = new AppointmentRecordEntity();
                newAppointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
                newAppointmentRecordEntity.setRemark(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getDisplay());
                newAppointmentRecordEntity.setId(appointmentRecordEntity.getId());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(newAppointmentRecordEntity);
                return BaseResponse.success();
            }
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        if (Objects.equals(type, "2")) {
            OpBusinessOrderEntity orderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(id);
            log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u95e8\u8bca\u8ba2\u5355orderEntityy:{}", (Object)JSON.toJSONString((Object)orderEntity));
            if (Objects.isNull(orderEntity)) {
                return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (Objects.equals(orderEntity.getStatus(), "2")) {
                return BaseResponse.error((String)"\u8ba2\u5355\u6b63\u5e38\uff0c\u65e0\u6cd5\u9000\u8d39");
            }
            BaseResponse baseResponse = this.newAppointRefund(orderEntity.getOutPatientId(), orderEntity.getCardNo(), orderEntity.getMoney(), orderEntity.getReceiptId());
            if ("1".equals(baseResponse.getCode())) {
                OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
                opBusinessOrderEntity.setStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
                opBusinessOrderEntity.setRemark(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getDisplay());
                opBusinessOrderEntity.setId(orderEntity.getId());
                this.opBusinessOrderEntityMapper.updateByPrimaryKeySelective(opBusinessOrderEntity);
                return BaseResponse.success();
            }
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        if (Objects.equals(type, "3")) {
            InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(id);
            InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
            log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u4f4f\u9662\u8ba2\u5355orderEntityy:{}", (Object)JSON.toJSONString((Object)inpatientDepositDetailEntity));
            log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u4f4f\u9662\u8ba2\u5355orderPayEntityy:{}", (Object)JSON.toJSONString((Object)inpatientPayorderEntity));
            if (Objects.isNull(inpatientDepositDetailEntity)) {
                return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            BaseResponse baseResponse = this.newAppointRefund(inpatientDepositDetailEntity.getOrderSeq(), inpatientDepositDetailEntity.getCardNo(), inpatientDepositDetailEntity.getMoney(), inpatientPayorderEntity.getDealSeq());
            if ("1".equals(baseResponse.getCode())) {
                InpatientDepositDetailEntity newInpatientDepositDetailEntity = new InpatientDepositDetailEntity();
                newInpatientDepositDetailEntity.setId(inpatientDepositDetailEntity.getId());
                newInpatientDepositDetailEntity.setStatus(Byte.valueOf((byte)AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue().intValue()));
                newInpatientDepositDetailEntity.setRemark(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getDisplay());
                this.inpatientDepositDetailEntityMapper.updateByPrimaryKeySelective(newInpatientDepositDetailEntity);
                return BaseResponse.success();
            }
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        return BaseResponse.error((String)"\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
    }

    public void unLock(ConfirmRegisterReq confirmRegisterReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)confirmRegisterReq);
        gatewayRequest.setKeyWord("unLockRegister");
        gatewayRequest.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8bf7\u6c42\u53c2\u6570 gatewayRequest: " + JSON.toJSONString((Object)gatewayRequest));
    }

    public BaseResponse<String> examine(Examine examine) {
        String newExamine = examine.getExamine();
        int length = newExamine.length();
        int type = 1;
        String reason = "";
        for (int i = 0; i < length; ++i) {
            String s = String.valueOf(newExamine.charAt(i));
            if (s.equals("1")) continue;
            type = 0;
            String newReason = ExamineEnum.getDisplay((String)String.valueOf(i + 1));
            reason = reason + "-" + newReason;
        }
        examine.setReason(reason);
        examine.setType(type);
        this.examineMapper.insert(examine);
        if (type == 1) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"");
    }

    public void withdrawPay(String appointmentId) {
        try {
            AppointmentRecordEntity appointmentRecord = this.appointmentRecordMapper.selectBySysAppointId(appointmentId);
            if (Objects.nonNull(appointmentRecord)) {
                appointmentRecord.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
                appointmentRecord.setRemark(AppointmentStatusEnum.WAIT_PAY.getDisplay());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecord);
            }
        }
        catch (Exception e) {
            log.error("\u9884\u7ea6\u6302\u53f7\u53d6\u6d88\u652f\u4ed8");
        }
    }

    public PayRegistrationRes hisSameDayRegistration(AppointmentRecordEntity appointmentRecordEntity, String type) throws Exception {
        log.info("his\u5f53\u65e5\u6302\u53f7\u65b9\u6cd5\u5165\u53c2 - > {}", (Object)JSON.toJSONString((Object)appointmentRecordEntity));
        PayRegistrationReq payRegistrationReq = this.NewBuildPayRegistrationReq(appointmentRecordEntity, "0");
        FrontResponse payRegistrationResFrontResponse = null;
        FrontRequest reqFrontResponse = new FrontRequest();
        reqFrontResponse.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        reqFrontResponse.setBody((Object)payRegistrationReq);
        try {
            log.info("\u8bf7\u6c42his\u5f53\u65e5\u6302\u53f7\u5165\u53c2 - > {}", (Object)JSON.toJSONString((Object)reqFrontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            String post = HttpUtil.post((String)(this.hisFontUrl + "appoint/pay/dayRegistration"), (String)JSON.toJSONString((Object)reqFrontResponse));
            log.info("\u8bf7\u6c42his\u5f53\u65e5\u6302\u53f7\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)post, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            payRegistrationResFrontResponse = (FrontResponse)JSON.parseObject((String)post, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            log.info("\u5f53\u65e5\u6302\u53f7his\u51fa\u53c2\u8f6c\u5b9e\u4f53\u540e\u6253\u5370 - >{}", (Object)JSON.toJSONString((Object)payRegistrationResFrontResponse));
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42his\u5f53\u65e5\u6302\u53f7\u51fa\u73b0\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\u4e3a - >{}", (Object)e.getMessage());
            throw new AppointmentException("\u8bf7\u6c42his\u6302\u53f7\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (payRegistrationResFrontResponse.getCode().equals("0")) {
            log.error("\u8ba2\u5355\u53f7\u4e3a - > {} \u7684\u60a3\u8005\u6302\u53f7\u5931\u8d25,\u5931\u8d25\u539f\u56e0 - > {}", (Object)appointmentRecordEntity.getSysAppointmentId(), (Object)payRegistrationResFrontResponse.getMessage());
            throw new AppointmentException("\u6302\u53f7\u5931\u8d25" + payRegistrationResFrontResponse.getMessage());
        }
        if (null == payRegistrationResFrontResponse.getBody()) {
            log.error("\u8ba2\u5355\u53f7\u4e3a - > {} \u7684\u60a3\u8005\u6302\u53f7\u5931\u8d25,\u5931\u8d25\u539f\u56e0 - > {}", (Object)appointmentRecordEntity.getSysAppointmentId(), (Object)payRegistrationResFrontResponse.getMessage());
            this.cancelRegisteredOrder(appointmentRecordEntity.getSysAppointmentId(), "\u5c31\u8bca\u5361\u5df2\u5145\u503c\u5230\u8d26\u6237\uff0c\u8bf7\u60a8\u518d\u6b21\u6302\u53f7");
            throw new AppointmentException("\u6302\u53f7\u5931\u8d25" + payRegistrationResFrontResponse.getMessage());
        }
        this.taskExecutor.execute(() -> {
            AppointmentRecordEntity appointmentRecordEntity1 = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
            this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity1);
        });
        return (PayRegistrationRes)payRegistrationResFrontResponse.getBody();
    }

    public void cancelRegisteredOrder(String sysAppointmentId, String remark) {
        try {
            AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
            appointmentRecordEntity.setRemark(remark);
            appointmentRecordEntity.setSysAppointmentId(sysAppointmentId);
            this.appointmentRecordMapper.updateCancelPayStatus(sysAppointmentId, String.valueOf(appointmentRecordEntity.getAppointStatus()), remark);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u8ba2\u5355\u51fa\u73b0\u5f02\u5e38 \u5f53\u524d\u8ba2\u5355\u53f7\u4e3a - > {},\u53d6\u6d88\u8ba2\u5355\u539f\u56e0\u4e3a - > {},\u5f02\u5e38\u4fe1\u606f\u4e3a - > {}", new Object[]{sysAppointmentId, remark, e});
        }
    }

    public PayRegistrationReq NewBuildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity, String type) throws Exception {
        try {
            log.info("\u5f53\u65e5\u6302\u53f7\u6784\u5efahis\u53c2\u6570\u65b9\u6cd5\u5165\u53c2 appointmentRecordEntity- > {},type - >{}", (Object)JSON.toJSONString((Object)appointmentRecordEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (Object)type);
            PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
            payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
            payRegistrationReq.setName(appointmentRecordEntity.getPatientName());
            DateTime birthDate = IdcardUtil.getBirthDate((String)appointmentRecordEntity.getPatientIdCard());
            payRegistrationReq.setBirthDay(DateUtil.format((Date)birthDate, (String)"yyyy/MM/dd"));
            payRegistrationReq.setSex(IdcardUtil.getGenderByIdCard((String)appointmentRecordEntity.getPatientIdCard()) == 1 ? "M" : "F");
            payRegistrationReq.setIdNo(appointmentRecordEntity.getPatientIdCard());
            if (type.equals("1")) {
                payRegistrationReq.setPactCode("02");
            } else {
                payRegistrationReq.setPactCode("01");
            }
            payRegistrationReq.setRegLeve(appointmentRecordEntity.getPatientIndex());
            payRegistrationReq.setDeptCode(appointmentRecordEntity.getDeptCode());
            payRegistrationReq.setDeptName(appointmentRecordEntity.getDeptName());
            payRegistrationReq.setDoctCode(appointmentRecordEntity.getDocCode());
            payRegistrationReq.setDoctName(appointmentRecordEntity.getDocName());
            payRegistrationReq.setRegLeveName(appointmentRecordEntity.getScheduleLevelName());
            payRegistrationReq.setSchemaID(appointmentRecordEntity.getScheduleHisId());
            payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
            payRegistrationReq.setNoonID(Convert.toStr((Object)appointmentRecordEntity.getAdmRange()));
            payRegistrationReq.setRegType("0");
            payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayChannel());
            log.info("\u6784\u5efahis\u5f53\u65e5\u9884\u7ea6\u53c2\u6570\u51fa\u53c2  -> {}", (Object)JSON.toJSONString((Object)payRegistrationReq, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return payRegistrationReq;
        }
        catch (Exception e) {
            log.info("\u6784\u5efahis\u5f53\u65e5\u6302\u53f7 \u81ea\u8d39\u652f\u4ed8\u51fa\u73b0\u5f02\u5e38 \u5f53\u524d\u60a3\u8005\u8ba2\u5355\u53f7 - > {}", (Object)appointmentRecordEntity.getSysAppointmentId());
            throw new AppointmentException("\u6784\u5efahis\u5f53\u65e5\u6302\u53f7(\u81ea\u8d39\u652f\u4ed8)\u51fa\u73b0\u5f02\u5e38");
        }
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

