/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.mapper.DoctorInformationMapper;
import com.ebaiyihui.wisdommedical.model.DoctorInformationEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.DelectDocReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DoctorUrlReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDocListReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDocListResItem;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDocListResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UploadDocExcelReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UploadDocReqVo;
import com.ebaiyihui.wisdommedical.service.DocManageService;
import com.ebaiyihui.wisdommedical.util.OSSClientUtil;
import com.ebaiyihui.wisdommedical.util.RemoveBlank;
import com.ebaiyihui.wisdommedical.util.UnZipUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DocManageServiceImpl
extends ServiceImpl<DoctorInformationMapper, DoctorInformationEntity>
implements DocManageService {
    private static final Logger log = LoggerFactory.getLogger(DocManageServiceImpl.class);
    private DoctorInformationMapper doctorInformationMapper;

    @Autowired
    public void setDoctorInformationMapper(DoctorInformationMapper doctorInformationMapper) {
        this.doctorInformationMapper = doctorInformationMapper;
    }

    public BaseResponse<GetDocListResVo> getDocList(GetDocListReqVo getDocListReqVo) {
        GetDocListResVo pageResult = new GetDocListResVo();
        try {
            PageHelper.startPage((int)getDocListReqVo.getPageNum(), (int)getDocListReqVo.getPageSize());
            Page page = this.doctorInformationMapper.selectDocPageByReqVo(getDocListReqVo);
            if (page.size() <= 0) {
                return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55-.-");
            }
            ArrayList<GetDocListResItem> items = new ArrayList<GetDocListResItem>();
            for (DoctorInformationEntity doctorInformationEntity : page) {
                GetDocListResItem getDocListResItem = new GetDocListResItem();
                BeanUtils.copyProperties((Object)doctorInformationEntity, (Object)getDocListResItem);
                items.add(getDocListResItem);
            }
            pageResult.setContent(items);
            Long total = page.getTotal();
            log.info("total: " + JSON.toJSONString((Object)total));
            double totalPages = (double)page.getTotal() / (double)page.getPageSize();
            pageResult.setPageSize(page.getPageSize());
            pageResult.setTotal(total.intValue());
            pageResult.setPageNum(page.getPageNum());
            pageResult.setTotalPages((int)Math.ceil(totalPages));
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<String> uploadDoc(UploadDocReqVo uploadDocReqVo) {
        try {
            RemoveBlank.beanAttributeValueTrim((Object)uploadDocReqVo);
            DoctorInformationEntity doctorInformationEntity = new DoctorInformationEntity();
            BeanUtils.copyProperties((Object)uploadDocReqVo, (Object)doctorInformationEntity);
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"dept_code", (Object)uploadDocReqVo.getDeptCode())).eq((Object)"doc_code", (Object)uploadDocReqVo.getDocCode())).eq((Object)"affiliated_hospital", (Object)uploadDocReqVo.getAffiliatedHospital());
            List doctorInformationEntities = this.doctorInformationMapper.selectList((Wrapper)queryWrapper);
            if (doctorInformationEntities.size() > 0) {
                return BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u63d2\u5165\u8be5\u533b\u751f");
            }
            doctorInformationEntity.setStatus("1");
            doctorInformationEntity.setHospitalCode("651");
            doctorInformationEntity.setCreatetime(new Date());
            doctorInformationEntity.setUpdatetime(new Date());
            this.doctorInformationMapper.insert((Object)doctorInformationEntity);
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u63d2\u5165\u533b\u751f\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return BaseResponse.success((Object)"\u63d2\u5165\u533b\u751f\u4fe1\u606f\u6210\u529f");
    }

    public BaseResponse<String> updateDocInfo(DoctorInformationEntity uploadDocReqVo) {
        try {
            RemoveBlank.beanAttributeValueTrim((Object)uploadDocReqVo);
            DoctorInformationEntity doctorInformationEntitie = (DoctorInformationEntity)this.doctorInformationMapper.selectById((Serializable)Long.valueOf(uploadDocReqVo.getId()));
            if (null == doctorInformationEntitie) {
                return BaseResponse.error((String)"\u672a\u627e\u5230\u8be5\u533b\u751f");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"dept_code", (Object)uploadDocReqVo.getDeptCode())).eq((Object)"doc_code", (Object)uploadDocReqVo.getDocCode())).eq((Object)"affiliated_hospital", (Object)uploadDocReqVo.getAffiliatedHospital());
            List doctorInformationEntities = this.doctorInformationMapper.selectList((Wrapper)queryWrapper);
            if (doctorInformationEntities.size() > 0 && uploadDocReqVo.getId() != ((DoctorInformationEntity)doctorInformationEntities.get(0)).getId()) {
                return BaseResponse.error((String)("\u8bf7\u52ff\u5728" + uploadDocReqVo.getAffiliatedHospital() + "-" + uploadDocReqVo.getDeptName() + "\u91cd\u590d\u63d2\u5165\u8be5\u533b\u751f"));
            }
            this.doctorInformationMapper.updateById((Object)uploadDocReqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u66f4\u65b0\u533b\u751f\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return BaseResponse.success((Object)"\u66f4\u65b0\u533b\u751f\u4fe1\u606f\u6210\u529f");
    }

    public BaseResponse<UploadDocReqVo> selectDocInfo(Integer id) {
        UploadDocReqVo uploadDocReqVo = new UploadDocReqVo();
        try {
            DoctorInformationEntity doctorInformationEntity = (DoctorInformationEntity)this.doctorInformationMapper.selectById((Serializable)id);
            BeanUtils.copyProperties((Object)doctorInformationEntity, (Object)uploadDocReqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return BaseResponse.success((Object)uploadDocReqVo);
    }

    public BaseResponse<Object> importWestern(List<UploadDocExcelReqVo> uploadDocList) {
        for (UploadDocExcelReqVo uploadDoc : uploadDocList) {
            RemoveBlank.beanAttributeValueTrim((Object)uploadDoc);
            if (uploadDoc.getDocName().length() > 6) {
                return BaseResponse.error((String)(uploadDoc.getDocName() + " \u533b\u751f\u540d\u5b57\u8fc7\u957f"));
            }
            if (uploadDoc.getDoctorTitleName().length() > 20) {
                return BaseResponse.error((String)(uploadDoc.getDocName() + " \u533b\u751f\u804c\u79f0\u8fc7\u957f"));
            }
            if (uploadDoc.getDeptName().length() > 25) {
                return BaseResponse.error((String)(uploadDoc.getDocName() + " \u79d1\u5ba4\u540d\u79f0\u8fc7\u957f"));
            }
            if (uploadDoc.getDocCode().length() > 16) {
                return BaseResponse.error((String)(uploadDoc.getDocName() + " \u533b\u751f\u5de5\u53f7\u8fc7\u957f"));
            }
            if (uploadDoc.getDoctorTitleCode().length() > 16) {
                return BaseResponse.error((String)(uploadDoc.getDocName() + " \u804c\u79f0\u7f16\u7801\u8fc7\u957f"));
            }
            if (uploadDoc.getDeptCode().length() > 16) {
                return BaseResponse.error((String)(uploadDoc.getDocName() + " \u79d1\u5ba4\u7f16\u7801\u8fc7\u957f"));
            }
            if (uploadDoc.getAffiliatedHospital().equals("\u83b2\u6c60\u9662\u533a") || uploadDoc.getAffiliatedHospital().equals("\u7ade\u79c0\u9662\u533a")) {
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"dept_code", (Object)uploadDoc.getDeptCode())).eq((Object)"doc_code", (Object)uploadDoc.getDocCode())).eq((Object)"affiliated_hospital", (Object)uploadDoc.getAffiliatedHospital());
                List doctorInformationEntities = this.doctorInformationMapper.selectList((Wrapper)queryWrapper);
                if (doctorInformationEntities.size() <= 0) continue;
                return BaseResponse.error((String)(uploadDoc.getAffiliatedHospital() + "-" + uploadDoc.getDeptName() + "-" + uploadDoc.getDocName() + "\u533b\u751f\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u63d2\u5165\u8be5\u533b\u751f"));
            }
            return BaseResponse.error((String)(uploadDoc.getAffiliatedHospital() + " -\u9662\u533a\u4fe1\u606f\u6709\u8bef\uff01"));
        }
        for (UploadDocExcelReqVo uploadDoc : uploadDocList) {
            DoctorInformationEntity doctorInformationEntity = new DoctorInformationEntity();
            doctorInformationEntity.setStatus("1");
            doctorInformationEntity.setHospitalCode("651");
            doctorInformationEntity.setCreatetime(new Date());
            doctorInformationEntity.setUpdatetime(new Date());
            BeanUtils.copyProperties((Object)uploadDoc, (Object)doctorInformationEntity);
            this.doctorInformationMapper.insert((Object)doctorInformationEntity);
        }
        return BaseResponse.success((Object)"\u5bfc\u5165\u6210\u529f");
    }

    public BaseResponse<Object> insertdoctorPortraiturl(MultipartFile file) {
        try {
            ArrayList<String> ss = new ArrayList<String>();
            List multipartFiles = UnZipUtils.unZip((MultipartFile)file);
            String docUrlStr = "";
            for (MultipartFile multipartFile : multipartFiles) {
                docUrlStr = multipartFile.getName();
                if (!docUrlStr.contains("jpg") && !docUrlStr.contains("png") && !docUrlStr.contains("jpeg") || docUrlStr.contains("/._")) continue;
                String replace = docUrlStr.replace(".jpg", "").replace(".png", "").replace(".jpeg", "");
                String docCode = replace.substring(replace.lastIndexOf("/") + 1, replace.length());
                String doctorFileName = OSSClientUtil.uploadImg2OssNew((MultipartFile)multipartFile, (String)docCode);
                String doctorSignUrl = OSSClientUtil.getUrl((String)doctorFileName);
                ss.add(doctorSignUrl);
                log.info("doctorSignUrl" + ss);
            }
            DoctorUrlReqVo doctorUrlReqVo = new DoctorUrlReqVo();
            doctorUrlReqVo.setUrls(ss);
            StringBuilder msg = new StringBuilder();
            msg.append("\u4e0d\u5b58\u5728\u533b\u751f\u7f16\u7801\u4e3a");
            Boolean flag = true;
            for (String docUrl : doctorUrlReqVo.getUrls()) {
                String replace = docUrl.replace(".jpg", "").replace(".png", "").replace("bdDocInfo", "").replace(".jpeg", "");
                String docCode = replace.substring(replace.lastIndexOf("/") + 1, replace.length());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"doc_code", (Object)docCode);
                List doctorInformationEntities = this.doctorInformationMapper.selectList((Wrapper)queryWrapper);
                if (doctorInformationEntities.size() <= 0) {
                    msg.append(docCode + "|");
                    flag = false;
                    continue;
                }
                for (DoctorInformationEntity doc : doctorInformationEntities) {
                    doc.setDoctorPortraitAddress(docUrl);
                    this.doctorInformationMapper.updateById((Object)doc);
                }
            }
            msg.append("\u7684\u533b\u751f,\u5176\u4ed6\u6b63\u5e38\u63d2\u5165");
            if (flag.booleanValue()) {
                return BaseResponse.success((Object)"\u63d2\u5165\u6210\u529f");
            }
            return BaseResponse.success((Object)msg.toString());
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u6279\u91cf\u63d2\u5165\u5934\u50cf\u5f02\u5e38" + e.getMessage()));
        }
    }

    public BaseResponse<String> uploadOss(MultipartFile file, String path) throws Exception {
        String doctorSignUrl = "";
        try {
            String doctorFileName = OSSClientUtil.uploadImg2OssNew((MultipartFile)file, (String)path);
            doctorSignUrl = OSSClientUtil.getUrl((String)doctorFileName);
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u4e0a\u4f20\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return BaseResponse.success((Object)doctorSignUrl);
    }

    public static void main(String[] args) {
        String s = "12345";
        System.out.println(s.length());
    }

    public BaseResponse<String> delectDocs(DelectDocReqVo delectDocReqVo) {
        try {
            int i = this.doctorInformationMapper.deleteBatchIds((Collection)delectDocReqVo.getIds());
            if (i <= 0) {
                return BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
    }
}

