/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorInformationMapper;
import com.ebaiyihui.wisdommedical.model.DoctorInformationEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DeptListVoReq;
import com.ebaiyihui.wisdommedical.service.DoctorInformationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorInformationServiceImpl
extends ServiceImpl<DoctorInformationMapper, DoctorInformationEntity>
implements DoctorInformationService {
    private static final Logger log = LoggerFactory.getLogger(DoctorInformationServiceImpl.class);
    private DeptRecordMapper deptRecordMapper;
    private DoctorInformationMapper doctorInformationMapper;

    @Autowired
    public void setDeptRecordMapper(DeptRecordMapper deptRecordMapper) {
        this.deptRecordMapper = deptRecordMapper;
    }

    @Autowired
    public void setDoctorInformationMapper(DoctorInformationMapper doctorInformationMapper) {
        this.doctorInformationMapper = doctorInformationMapper;
    }

    public List<DeptListVoReq> getDeptList() {
        List deptRecordEntities = this.deptRecordMapper.selectList("651");
        List deptListVoReqs = BeanUtil.copyToList((Collection)deptRecordEntities, DeptListVoReq.class);
        return deptListVoReqs;
    }

    public List<DoctorInformationEntity> getDoctorList(String deptCode, String docCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dept_code", (Object)deptCode);
        List doctorInformationEntities = this.doctorInformationMapper.selectList((Wrapper)queryWrapper);
        log.info("\u5f53\u524d\u79d1\u5ba4\u4e0b\u7684\u6240\u6709\u533b\u751f\u4fe1\u606f - >{}\uff0c", (Object)JSON.toJSONString((Object)doctorInformationEntities, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!StrUtil.isBlankIfStr((Object)docCode)) {
            List<DoctorInformationEntity> collect = doctorInformationEntities.stream().filter(d -> d.getDocCode().equals(docCode)).collect(Collectors.toList());
            Collections.sort(collect);
            log.info("\u7b5b\u9009\u540e\u7684\u533b\u751f\u4fe1\u606f - > {}", (Object)JSON.toJSONString(collect, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return collect;
        }
        List<DoctorInformationEntity> collect = doctorInformationEntities.stream().map(item -> {
            if (item.getSort() == 0) {
                item.setSort(Integer.valueOf(100));
            }
            return item;
        }).collect(Collectors.toList());
        Collections.sort(collect);
        return collect;
    }

    public List<GetScheduleVoRes> getDoctorByCourtyardCodeList(String deptCode, String courtyardCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dept_code", (Object)deptCode);
        queryWrapper.eq((Object)"affiliated_hospital", (Object)courtyardCode);
        List doctorInformationEntities = this.doctorInformationMapper.selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)doctorInformationEntities)) {
            return new ArrayList<GetScheduleVoRes>();
        }
        ArrayList<GetScheduleVoRes> getScheduleVoResList = new ArrayList<GetScheduleVoRes>();
        for (DoctorInformationEntity doctorInformationEntity : doctorInformationEntities) {
            GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
            getScheduleVoRes.setHospitalArea("\u4fdd\u5b9a\u5e02\u7b2c\u4e00\u4e2d\u533b\u9662");
            if (doctorInformationEntity.getAffiliatedHospital().equals("\u83b2\u6c60\u9662\u533a")) {
                getScheduleVoRes.setHospitalAreaCode("1000");
            } else {
                getScheduleVoRes.setHospitalAreaCode("1001");
            }
            getScheduleVoRes.setDocCode(doctorInformationEntity.getDocCode());
            getScheduleVoRes.setDocName(doctorInformationEntity.getDocName());
            getScheduleVoRes.setLocCode(doctorInformationEntity.getDeptCode());
            getScheduleVoRes.setLocName(doctorInformationEntity.getDeptName());
            getScheduleVoRes.setRegTitleCode(doctorInformationEntity.getDoctorTitleCode());
            getScheduleVoRes.setRegTitleName(doctorInformationEntity.getDoctorTitleName());
            getScheduleVoRes.setDoctorHeadPortrait(doctorInformationEntity.getDoctorPortraitAddress());
            getScheduleVoRes.setDoctorSpeciality(doctorInformationEntity.getAreasExpertise());
            getScheduleVoRes.setProfile(doctorInformationEntity.getDoctorProfile());
            getScheduleVoRes.setSort(doctorInformationEntity.getSort());
            getScheduleVoResList.add(getScheduleVoRes);
        }
        Collections.sort(getScheduleVoResList);
        return getScheduleVoResList;
    }

    public BaseResponse UpdateDoctorSortByDocCode(String id, Integer sort, String deptCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dept_code", (Object)deptCode);
        queryWrapper.eq((Object)"sort", (Object)sort);
        List doctorInformationEntities = this.doctorInformationMapper.selectList((Wrapper)queryWrapper);
        if (doctorInformationEntities.size() != 0) {
            return BaseResponse.error((String)"\u6392\u5e8f\u53f7\u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u6392\u5e8f");
        }
        DoctorInformationEntity doctorInformationEntity = new DoctorInformationEntity();
        doctorInformationEntity.setSort(sort);
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"id", (Object)id);
        int update = this.doctorInformationMapper.update((Object)doctorInformationEntity, (Wrapper)queryWrapper1);
        if (update == 0) {
            return BaseResponse.error((String)"\u4fee\u6539\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
    }
}

