/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.enums.HospAppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.mapper.HospitalAppointmentMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalDeptMapper;
import com.ebaiyihui.wisdommedical.model.HospitalDeptEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.AddHospitalDeptReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DeleteHospitalDeptReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpOrDownDeptReqVo;
import com.ebaiyihui.wisdommedical.service.HospitalDeptService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HospitalDeptServiceImpl
implements HospitalDeptService {
    private static final Logger log = LoggerFactory.getLogger(HospitalDeptServiceImpl.class);
    @Autowired
    private HospitalDeptMapper hospitalDeptMapper;
    @Autowired
    private HospitalAppointmentMapper hospitalAppointmentMapper;
    public static final String UP_STATUS = "1";
    public static final String DOWN_STATUS = "0";

    public BaseResponse<String> addDept(AddHospitalDeptReqVo addHospitalDeptReqVo) {
        log.info("\u65b0\u589e\u4f4f\u9662\u9884\u7ea6\u79d1\u5ba4\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)addHospitalDeptReqVo));
        List hospitalDeptEntities = this.hospitalDeptMapper.selectByDeptCodeOrName(addHospitalDeptReqVo.getDeptCode(), addHospitalDeptReqVo.getDeptName());
        if (!CollectionUtils.isEmpty((Collection)hospitalDeptEntities)) {
            log.info("\u65b0\u589e\u4f4f\u9662\u9884\u7ea6\u79d1\u5ba4\u67e5\u8be2\u662f\u5426\u6709\u91cd\u590d\u79d1\u5ba4:{}", (Object)JSON.toJSONString((Object)hospitalDeptEntities));
            boolean code = false;
            boolean name = false;
            for (HospitalDeptEntity hospitalDeptEntity : hospitalDeptEntities) {
                if (hospitalDeptEntity.getDeptName().equals(addHospitalDeptReqVo.getDeptName())) {
                    name = true;
                }
                if (!hospitalDeptEntity.getDeptCode().equals(addHospitalDeptReqVo.getDeptCode())) continue;
                code = true;
            }
            if (code && name) {
                return BaseResponse.error((String)"\u8be5\u79d1\u5ba4\u7f16\u7801\u548c\u79d1\u5ba4\u540d\u5b57\u5df2\u7ef4\u62a4,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            if (code) {
                return BaseResponse.error((String)"\u8be5\u79d1\u5ba4\u7f16\u7801\u5df2\u7ef4\u62a4,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            if (name) {
                return BaseResponse.error((String)"\u8be5\u79d1\u5ba4\u540d\u5b57\u5df2\u7ef4\u62a4,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
        }
        HospitalDeptEntity hospitalDeptEntity = new HospitalDeptEntity();
        hospitalDeptEntity.setDeptName(addHospitalDeptReqVo.getDeptName());
        hospitalDeptEntity.setDeptCode(addHospitalDeptReqVo.getDeptCode());
        hospitalDeptEntity.setStatus(new Byte(UP_STATUS));
        hospitalDeptEntity.setUpStatus(new Byte(DOWN_STATUS));
        hospitalDeptEntity.setSort(new Byte(DOWN_STATUS));
        this.hospitalDeptMapper.insertSelective(hospitalDeptEntity);
        return BaseResponse.success((Object)"\u65b0\u589e\u79d1\u5ba4\u6210\u529f");
    }

    public BaseResponse<String> deleteDept(DeleteHospitalDeptReqVo DeleteHospitalDeptReqVo2) {
        log.info("\u5220\u9664\u4f4f\u9662\u9884\u7ea6\u79d1\u5ba4\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)DeleteHospitalDeptReqVo2));
        HospitalDeptEntity hospitalDeptEntity = this.hospitalDeptMapper.selectByDeptCode(DeleteHospitalDeptReqVo2.getDeptCode());
        if (Objects.isNull(hospitalDeptEntity)) {
            return BaseResponse.error((String)"\u8981\u5220\u9664\u7684\u79d1\u5ba4\u4e0d\u5b58\u5728");
        }
        if (UP_STATUS.equals(hospitalDeptEntity.getUpStatus().toString())) {
            return BaseResponse.error((String)"\u8be5\u79d1\u5ba4\u4e3a\u4e0a\u7ebf\u72b6\u6001,\u4e0d\u53ef\u5220\u9664");
        }
        List hospitalAppointmentEntities = this.hospitalAppointmentMapper.selectByStatusAndDeptCode(HospAppointmentStatusEnum.DSH.getValue(), DeleteHospitalDeptReqVo2.getDeptCode());
        if (!CollectionUtils.isEmpty((Collection)hospitalAppointmentEntities)) {
            return BaseResponse.error((String)"\u8be5\u79d1\u5ba4\u6709\u5f85\u5ba1\u6838\u9884\u7ea6,\u4e0d\u80fd\u5220\u9664,\u8bf7\u5148\u8fdb\u884c\u5ba1\u6838");
        }
        this.hospitalDeptMapper.deleteDept(DeleteHospitalDeptReqVo2.getDeptCode());
        return BaseResponse.success((Object)"\u79d1\u5ba4\u5df2\u5220\u9664");
    }

    public BaseResponse<String> upAndDownDept(UpOrDownDeptReqVo upOrDownDeptReqVo) {
        log.info("\u4e0a\u7ebf\u6216\u4e0b\u7ebf\u4f4f\u9662\u9884\u7ea6\u79d1\u5ba4\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)upOrDownDeptReqVo));
        if (DOWN_STATUS.equals(upOrDownDeptReqVo.getUpStatus())) {
            this.hospitalDeptMapper.updateUpStatus(upOrDownDeptReqVo.getDeptCode(), upOrDownDeptReqVo.getUpStatus());
            return BaseResponse.success((Object)"\u79d1\u5ba4\u5df2\u4e0b\u7ebf");
        }
        this.hospitalDeptMapper.updateUpStatus(upOrDownDeptReqVo.getDeptCode(), upOrDownDeptReqVo.getUpStatus());
        return BaseResponse.success((Object)"\u79d1\u5ba4\u5df2\u4e0a\u7ebf");
    }

    public BaseResponse<List<HospitalDeptEntity>> selectDeptListToAdmin() {
        List hospitalDeptEntities = this.hospitalDeptMapper.selectDeptToAdmin();
        return BaseResponse.success((Object)hospitalDeptEntities);
    }

    public BaseResponse<List<HospitalDeptEntity>> selectDeptListToPatient() {
        List hospitalDeptEntities = this.hospitalDeptMapper.selectDeptToPatient();
        return BaseResponse.success((Object)hospitalDeptEntities);
    }
}

