/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.MedicalCardApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryAccountInfoResVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeRecordItemResVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeRecordReqVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeRecordResVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeReqVo;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.CardPayOrderMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.CardPayOrderEntity;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.OrderBarcodeReq;
import com.ebaiyihui.wisdommedical.model.PayOrder;
import com.ebaiyihui.wisdommedical.model.PolymerizationReq;
import com.ebaiyihui.wisdommedical.model.PolymerizationRes;
import com.ebaiyihui.wisdommedical.model.RefundReq;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.CardRechargeResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthRegisteredReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.QueryCardPayStatusReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RechargeCardReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RechargeCardToHosReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateStatusVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WisdomRechargeRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PayRequestVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.QueryOutPatientPayStatusReqVO;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.ICardService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.OrderMqUtils;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class ICardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(ICardServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final int HEALTH_APPOINTMENT = 3;
    @Autowired
    private MedicalCardApi medicalCardApi;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private EncryptUtils encryptUtils;
    @Autowired
    private CardPayOrderMapper cardPayOrderMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RedissonClient redisson;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private AppointmentService appointmentService;

    public BaseResponse recharge(RechargeCardReqVo rechargeCardReqVo) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        if (null != rechargeCardReqVo.getQueryOutPatientPayStatusReqVO() && null != rechargeCardReqVo.getQueryOutPatientPayStatusReqVO().getPayChannel() && rechargeCardReqVo.getQueryOutPatientPayStatusReqVO().getPayChannel().equals("ALIPAY")) {
            if (rechargeCardReqVo.getPayType().equals("3")) {
                rechargeCardReqVo.setAppointmentId(String.valueOf(this.snowflakeIdWorker.nextId()));
            }
            log.info("\u5f53\u524d\u6302\u53f7\u8ba2\u5355\u53f7\u4e3a->{}", (Object)JSON.toJSONString((Object)rechargeCardReqVo.getAppointmentId()));
            log.info("\u5f53\u524d\u7f34\u8d39\u8ba2\u5355\u53f7\u4e3a->{}", (Object)JSON.toJSONString((Object)rechargeCardReqVo.getOutPatientId()));
            log.info("\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u4e3a->{}", (Object)rechargeCardReqVo.getQueryOutPatientPayStatusReqVO().getPayChannel());
            log.info("\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684\u652f\u4ed8\u4fe1\u606fkey\u4e3a->{}", (Object)(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() + "_pay" : rechargeCardReqVo.getAppointmentId() + "_pay"));
            String payment = this.jedisCluster.get(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() + "_pay" : rechargeCardReqVo.getAppointmentId() + "_pay");
            log.info("\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684\u652f\u4ed8\u4fe1\u606f\u4e3a->{}", (Object)payment);
            if (!StrUtil.isBlank((CharSequence)payment)) {
                return (BaseResponse)JSON.parseObject((String)payment, BaseResponse.class);
            }
            PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
            payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
            payRequestVoReq.setOutTradeNo(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() : rechargeCardReqVo.getAppointmentId());
            payRequestVoReq.setPayChannel(rechargeCardReqVo.getQueryOutPatientPayStatusReqVO().getPayChannel());
            payRequestVoReq.setPayType(rechargeCardReqVo.getQueryOutPatientPayStatusReqVO().getPayType());
            payRequestVoReq.setActuallyAmount(new BigDecimal(rechargeCardReqVo.getMoney()));
            payRequestVoReq.setTotalAmount(new BigDecimal(rechargeCardReqVo.getMoney()));
            payRequestVoReq.setUserSign(rechargeCardReqVo.getOpenId());
            payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
            payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            payRequestVoReq.setProductInfo(rechargeCardReqVo.getPatientName() + "HLWYY_\u5c31\u8bca\u5361\u5145\u503c");
            String serviceCode = null;
            String payNotifyUrl = null;
            if (rechargeCardReqVo.getPayType().equals("1")) {
                serviceCode = ServiceCodeEnum.DAY_APPOINTMENT.getValue();
                payNotifyUrl = this.propertiesConstant.getDayPayNotifyUrl();
            }
            if (rechargeCardReqVo.getPayType().equals("2")) {
                serviceCode = ServiceCodeEnum.OUTPATIENT.getValue();
                payNotifyUrl = this.propertiesConstant.getJfPayNotifyUrl();
                log.info("\u4fdd\u5b58\u7f34\u8d39\u4fe1\u606fkey\u4e3a->{}", (Object)(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() : rechargeCardReqVo.getAppointmentId()));
                this.redisTemplate.opsForValue().set((Object)(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() : rechargeCardReqVo.getAppointmentId()), (Object)JSONObject.toJSONString((Object)rechargeCardReqVo.getQueryOutPatientPayStatusReqVO()));
            }
            if (rechargeCardReqVo.getPayType().equals("3")) {
                serviceCode = ServiceCodeEnum.CARD_RECHARGE.getValue();
                payNotifyUrl = "https://testapi.chinachdu.com/zhjy/BDDYZYY/api/v1/payCallBack/cardRechargeCallBack";
            }
            payRequestVoReq.setServiceCode(serviceCode);
            payRequestVoReq.setPayNotifyUrl(payNotifyUrl);
            Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
            String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
            payRequestVoReq.setSign(sign);
            BaseResponse baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
            if (baseResponse.getCode().equals("0")) {
                return null;
            }
            CardPayOrderEntity cardPayOrderEntity = new CardPayOrderEntity();
            cardPayOrderEntity.setSysId(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() : rechargeCardReqVo.getAppointmentId());
            cardPayOrderEntity.setDealMoney(new BigDecimal(rechargeCardReqVo.getMoney()));
            cardPayOrderEntity.setPatientName(rechargeCardReqVo.getPatientName());
            cardPayOrderEntity.setPaymentTime((Date)DateUtil.date());
            cardPayOrderEntity.setAppointmentId(rechargeCardReqVo.getAppointmentId());
            cardPayOrderEntity.setOutpatientId(rechargeCardReqVo.getOutPatientId());
            cardPayOrderEntity.setPatientCardNo(rechargeCardReqVo.getCardNo());
            this.cardPayOrderMapper.insertSelective(cardPayOrderEntity);
            log.info("\u4fdd\u5b58\u652f\u4ed8\u4fe1\u606fkey\u4e3a->{}", (Object)(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() + "_pay" : rechargeCardReqVo.getAppointmentId() + "_pay"));
            this.jedisCluster.set(StrUtil.isBlank((CharSequence)rechargeCardReqVo.getAppointmentId()) ? rechargeCardReqVo.getOutPatientId() + "_pay" : rechargeCardReqVo.getAppointmentId() + "_pay", JSON.toJSONString((Object)baseResponse), "NX", "EX", 1800L);
            return baseResponse;
        }
        HashMap<String, PolymerizationReq> map = new HashMap<String, PolymerizationReq>();
        PolymerizationReq polymerizationReq = new PolymerizationReq();
        polymerizationReq.setBody(rechargeCardReqVo.getPatientName() + "HLWYY_\u5c31\u8bca\u5361\u5145\u503c");
        polymerizationReq.setCardNo(rechargeCardReqVo.getCardNo());
        polymerizationReq.setMachineNo("wechat");
        polymerizationReq.setMethod("8");
        polymerizationReq.setType("0");
        polymerizationReq.setShowUrl("showUrl");
        polymerizationReq.setSubAppid(this.propertiesConstant.getSubAppid());
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(new BigDecimal(rechargeCardReqVo.getMoney()).multiply(bigDecimal).intValue());
        polymerizationReq.setTotalFee(totalfee);
        polymerizationReq.setSubject(rechargeCardReqVo.getPatientName() + "HLWYY_\u5c31\u8bca\u5361\u5145\u503c");
        polymerizationReq.setReturnUrl("ReturnUrl");
        polymerizationReq.setOpenid(rechargeCardReqVo.getOpenId());
        polymerizationReq.setPatientName(rechargeCardReqVo.getPatientName());
        map.put("polymerizationReq", polymerizationReq);
        PolymerizationRes encrypt = (PolymerizationRes)this.encryptUtils.encrypt("001", map, this.propertiesConstant.getPolymerization(), PolymerizationRes.class);
        BaseResponse baseResponse = new BaseResponse();
        if (Objects.equals(encrypt.getResultCode(), "0")) {
            String payUrl = encrypt.getPayUrl();
            String outTradeNo = encrypt.getOutTradeNo();
            String sysId = String.valueOf(this.snowflakeIdWorker.nextId());
            CardPayOrderEntity cardPayOrderEntity = new CardPayOrderEntity();
            cardPayOrderEntity.setSysId(sysId);
            cardPayOrderEntity.setDealSeq(outTradeNo);
            cardPayOrderEntity.setDealMoney(new BigDecimal(rechargeCardReqVo.getMoney()));
            cardPayOrderEntity.setPatientName(rechargeCardReqVo.getPatientName());
            cardPayOrderEntity.setPaymentTime(new Date());
            cardPayOrderEntity.setAppointmentId(rechargeCardReqVo.getAppointmentId());
            cardPayOrderEntity.setOutpatientId(rechargeCardReqVo.getOutPatientId());
            cardPayOrderEntity.setPatientCardNo(rechargeCardReqVo.getCardNo());
            this.cardPayOrderMapper.insertSelective(cardPayOrderEntity);
            PayOrder payOrder = new PayOrder();
            payOrder.setNumber(1);
            payOrder.setId(sysId);
            CardRechargeResVo cardRechargeResVo = new CardRechargeResVo();
            cardRechargeResVo.setPayUrl(payUrl);
            cardRechargeResVo.setSysId(sysId);
            if (StringUtils.isNotBlank((String)rechargeCardReqVo.getAppointmentId())) {
                this.appointmentRecordMapper.updatePayTransationIdBysysId(rechargeCardReqVo.getAppointmentId(), encrypt.getOutTradeNo());
                AppointmentRecordEntity appointmentRecord = this.appointmentRecordMapper.selectBySysAppointId(rechargeCardReqVo.getAppointmentId());
                if (3 == appointmentRecord.getAppointmentType()) {
                    return BaseResponse.success((Object)cardRechargeResVo);
                }
                if (Objects.equals(appointmentRecord.getAdmDate(), DateUtils.getCurrentDateSimpleToString())) {
                    payOrder.setType(1);
                    OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
                    return BaseResponse.success((Object)cardRechargeResVo);
                }
                payOrder.setType(2);
                OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
                return BaseResponse.success((Object)cardRechargeResVo);
            }
            if (StringUtils.isNotBlank((String)rechargeCardReqVo.getOutPatientId())) {
                OpRechargePaymentOrderEntity paymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(rechargeCardReqVo.getOutPatientId());
                this.opBusinessOrderEntityMapper.updateReceiptIdByOutPatientId(rechargeCardReqVo.getOutPatientId(), encrypt.getOutTradeNo());
                if (!Objects.isNull(paymentOrderEntity)) {
                    OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = new OpRechargePaymentOrderEntity();
                    opRechargePaymentOrderEntity.setId(paymentOrderEntity.getId());
                    opRechargePaymentOrderEntity.setDealSeq(encrypt.getOutTradeNo());
                    this.opRechargePaymentOrderEntityMapper.updateByPrimaryKeySelective(opRechargePaymentOrderEntity);
                }
                String jsonString = JSON.toJSONString((Object)rechargeCardReqVo.getQueryOutPatientPayStatusReqVO());
                this.jedisCluster.set(sysId, jsonString);
                this.jedisCluster.expire(sysId, 7200);
                payOrder.setData(JSONObject.toJSONString((Object)rechargeCardReqVo.getQueryOutPatientPayStatusReqVO()));
                payOrder.setType(3);
                OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
                return BaseResponse.success((Object)cardRechargeResVo);
            }
            OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
            return BaseResponse.success((Object)cardRechargeResVo);
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    public BaseResponse queryCardPayStatusHealth(HealthRegisteredReqVo healthRegisteredReqVo) throws InHospitalException {
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(healthRegisteredReqVo.getSysId());
        if (Objects.isNull(cardPayOrderEntity)) {
            return BaseResponse.error((String)"\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(Long.parseLong(cardPayOrderEntity.getDealSeq())));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        if (!Objects.isNull(hisPayRes)) {
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(healthRegisteredReqVo.getSysAppointmentId());
                String key = "YBGH_ZFBC_ " + appointmentRecordEntity.getSysAppointmentId();
                boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)(key + "_" + this.snowflakeIdWorker.nextId()), 600L, TimeUnit.SECONDS);
                if (locked) {
                    AppointmentRecordEntity appointmentRecordEntityDb = this.appointmentRecordMapper.selectBySysAppointId(healthRegisteredReqVo.getSysAppointmentId());
                    if (!Objects.equals(appointmentRecordEntityDb.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) {
                        log.info("\u533b\u4fdd\u6302\u53f7\u652f\u4ed8\u8865\u507f\u673a\u5236\u8ba2\u5355\u5df2\u6210\u529f\u652f\u4ed8");
                        return BaseResponse.success((Object)"\u533b\u4fdd\u6302\u53f7\u6210\u529f");
                    }
                    CardPayOrderEntity payOrderEntity = this.cardPayOrderMapper.selectByDealSeqAndStatus(cardPayOrderEntity.getDealSeq(), "1");
                    if (Objects.nonNull(payOrderEntity)) {
                        return BaseResponse.error((String)"");
                    }
                    GatewayRequest gatewayRequest = this.healthBuildRecharge(appointmentRecordEntity, healthRegisteredReqVo.getSysId());
                    GatewayResponse recharge = this.medicalCardApi.recharge(gatewayRequest);
                    log.info("\u533b\u4fdd\u6302\u53f7\u9662\u5185\u8d26\u6237\u5145\u503c\u8fd4\u56de\u503c\u4e3a:{}", (Object)recharge);
                    if (Objects.isNull(recharge)) {
                        return BaseResponse.error((String)"\u9662\u5185\u8d26\u6237\u5145\u503c\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                    }
                    if (!"1".equals(recharge.getCode())) {
                        return BaseResponse.error((String)recharge.getMsg());
                    }
                    CardPayOrderEntity cardPayOrderEntityDb = new CardPayOrderEntity();
                    cardPayOrderEntityDb.setId(cardPayOrderEntity.getId());
                    cardPayOrderEntityDb.setOrderStatus(Integer.valueOf(1));
                    this.cardPayOrderMapper.updateByPrimaryKeySelective(cardPayOrderEntityDb);
                    BaseResponse baseResponse = this.payCallBackService.healthRegistered(healthRegisteredReqVo);
                    this.redisTemplate.opsForValue().getOperations().delete((Object)key);
                    return baseResponse;
                }
            }
            return BaseResponse.error((String)hisPayRes.getResultMsg());
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public BaseResponse<QueryAccountInfoResVo> queryCardAccount(RechargeCardToHosReqVo rechargeCardToHosReqVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RegisteredCardReqVO registeredCardReqVO = new RegisteredCardReqVO();
        registeredCardReqVO.setCardNo(rechargeCardToHosReqVo.getCardNo());
        gatewayRequest.setBody((Object)registeredCardReqVO);
        gatewayRequest.setChannel(rechargeCardToHosReqVo.getChannelCode());
        gatewayRequest.setOrganCode(rechargeCardToHosReqVo.getHosCode());
        gatewayRequest.setKeyWord("queryAccountInfo");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        GatewayResponse queryAccountInfoResVoGatewayResponse = this.medicalCardApi.queryAccountInfo(gatewayRequest);
        if (Objects.isNull(queryAccountInfoResVoGatewayResponse)) {
            return BaseResponse.error((String)"his\u67e5\u8be2\u9662\u5185\u8d26\u6237\u5f02\u5e38");
        }
        if (!"1".equals(queryAccountInfoResVoGatewayResponse.getCode())) {
            return BaseResponse.error((String)queryAccountInfoResVoGatewayResponse.getMsg());
        }
        return BaseResponse.success((Object)queryAccountInfoResVoGatewayResponse.getData());
    }

    public BaseResponse queryCardPayStatusAppoint(UpdateStatusVoReq updateStatusVoReq) throws InHospitalException {
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(updateStatusVoReq.getSysId());
        if (Objects.isNull(cardPayOrderEntity)) {
            return BaseResponse.error((String)"\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(Long.parseLong(cardPayOrderEntity.getDealSeq())));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        if (!Objects.isNull(hisPayRes)) {
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(updateStatusVoReq.getSysAppointmentId());
                String key = "DRGH_ZFBC_ " + appointmentRecordEntity.getSysAppointmentId();
                boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)(key + "_" + this.snowflakeIdWorker.nextId()), 600L, TimeUnit.SECONDS);
                if (locked) {
                    AppointmentRecordEntity appointmentRecordEntityDb = this.appointmentRecordMapper.selectBySysAppointId(updateStatusVoReq.getSysAppointmentId());
                    if (!Objects.equals(appointmentRecordEntityDb.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) {
                        log.info("\u6302\u53f7\u652f\u4ed8\u8865\u507f\u673a\u5236\u8ba2\u5355\u5df2\u6210\u529f\u652f\u4ed8");
                        return BaseResponse.success((Object)"\u6302\u53f7\u6210\u529f");
                    }
                    CardPayOrderEntity payOrderEntity = this.cardPayOrderMapper.selectByDealSeqAndStatus(cardPayOrderEntity.getDealSeq(), "1");
                    if (Objects.nonNull(payOrderEntity)) {
                        return BaseResponse.error((String)"");
                    }
                    try {
                        GatewayRequest gatewayRequest = this.healthBuildRecharge(appointmentRecordEntity, updateStatusVoReq.getSysId());
                        log.info("\u6302\u53f7\u9662\u5185\u8d26\u6237\u5145\u503c\u53c2\u6570\u4e3a:{}", (Object)gatewayRequest);
                        GatewayResponse recharge = this.medicalCardApi.recharge(gatewayRequest);
                        log.info("\u6302\u53f7\u9662\u5185\u8d26\u6237\u5145\u503c\u8fd4\u56de\u503c\u4e3a:{}", (Object)recharge);
                        if (Objects.isNull(recharge)) {
                            return BaseResponse.error((String)"\u9662\u5185\u8d26\u6237\u5145\u503c\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                        }
                        if (!"1".equals(recharge.getCode())) {
                            return BaseResponse.error((String)recharge.getMsg());
                        }
                        CardPayOrderEntity cardPayOrderEntityDb = new CardPayOrderEntity();
                        cardPayOrderEntityDb.setId(cardPayOrderEntity.getId());
                        cardPayOrderEntityDb.setOrderStatus(Integer.valueOf(1));
                        this.cardPayOrderMapper.updateByPrimaryKeySelective(cardPayOrderEntityDb);
                        this.payCallBackService.updateStatus(updateStatusVoReq);
                        this.redisTemplate.opsForValue().getOperations().delete((Object)key);
                        return BaseResponse.success((Object)"\u6302\u53f7\u6210\u529f");
                    }
                    catch (AppointmentException e) {
                        return BaseResponse.error((String)e.getMessage());
                    }
                }
            }
            return BaseResponse.error((String)hisPayRes.getResultMsg());
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public BaseResponse queryCardPayStatusSubAppoint(UpdateStatusVoReq updateStatusVoReq) throws InHospitalException, AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(updateStatusVoReq.getSysAppointmentId());
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(Long.parseLong(appointmentRecordEntity.getPayTransationId())));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        if (!Objects.isNull(hisPayRes)) {
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                String key = "YYGH_ZFBC_ " + appointmentRecordEntity.getSysAppointmentId();
                boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)(key + "_" + this.snowflakeIdWorker.nextId()), 600L, TimeUnit.SECONDS);
                if (locked) {
                    AppointmentRecordEntity appointmentRecordEntityDb = this.appointmentRecordMapper.selectBySysAppointId(updateStatusVoReq.getSysAppointmentId());
                    if (!Objects.equals(appointmentRecordEntityDb.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) {
                        log.info("\u6302\u53f7\u652f\u4ed8\u8865\u507f\u673a\u5236\u8ba2\u5355\u5df2\u6210\u529f\u652f\u4ed8");
                        return BaseResponse.success((Object)"\u6302\u53f7\u6210\u529f");
                    }
                    try {
                        this.payCallBackService.updateStatus(updateStatusVoReq);
                        this.redisTemplate.opsForValue().getOperations().delete((Object)key);
                        return BaseResponse.success((Object)"\u6302\u53f7\u6210\u529f");
                    }
                    catch (AppointmentException e) {
                        return BaseResponse.error((String)e.getMessage());
                    }
                }
            } else {
                try {
                    CancelAppointmentVoReq cancelAppointmentVoReq = new CancelAppointmentVoReq();
                    cancelAppointmentVoReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                    cancelAppointmentVoReq.setBeginTime(appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
                    cancelAppointmentVoReq.setEndTime(appointmentRecordEntity.getAdmTimeRange().substring(6, 11));
                    this.appointmentService.cancelAppointment(cancelAppointmentVoReq);
                }
                catch (Exception e) {
                    log.info("queryCardPayStatusSubAppoint\u53d6\u6d88\u9501\u53f7\u5f02\u5e38 - >{}", (Object)e.getMessage());
                }
            }
            return BaseResponse.error((String)hisPayRes.getResultMsg());
        }
        try {
            CancelAppointmentVoReq cancelAppointmentVoReq = new CancelAppointmentVoReq();
            cancelAppointmentVoReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            cancelAppointmentVoReq.setBeginTime(appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
            cancelAppointmentVoReq.setEndTime(appointmentRecordEntity.getAdmTimeRange().substring(6, 11));
            this.appointmentService.cancelAppointment(cancelAppointmentVoReq);
        }
        catch (AppointmentException e) {
            log.info("queryCardPayStatusSubAppoint2\u53d6\u6d88\u9501\u53f7\u5f02\u5e38 - >{}", (Object)e.getMessage());
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public BaseResponse queryCardPayStatusOutPatient(QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO) throws InHospitalException {
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(queryOutPatientPayStatusReqVO.getSysId());
        if (Objects.isNull(cardPayOrderEntity)) {
            return BaseResponse.error((String)"\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(Long.parseLong(cardPayOrderEntity.getDealSeq())));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        log.info("\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u7684\u8fd4\u56de\u503c\u4e3a:{}", (Object)hisPayRes);
        if (!Objects.isNull(hisPayRes)) {
            log.info("\u5f00\u59cb\u67e5\u652f\u4ed8\u7ed3\u679c\u540e\u95e8\u8bca\u7f34\u8d39:{}", (Object)hisPayRes);
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                log.info("\u5f00\u59cb");
                OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(queryOutPatientPayStatusReqVO.getOutPatientId());
                log.info("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u4e3a:{}", (Object)opBusinessOrderEntity);
                String key = "MZ_ZFBC_ " + opBusinessOrderEntity.getOutPatientId();
                boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)(key + "_" + this.snowflakeIdWorker.nextId()), 600L, TimeUnit.SECONDS);
                log.info("\u83b7\u53d6\u9501\u7684\u7ed3\u679c\u4e3a:{}", (Object)locked);
                if (locked) {
                    OpBusinessOrderEntity opBusinessOrderEntityDb = this.opBusinessOrderEntityMapper.selectByOutPatientId(queryOutPatientPayStatusReqVO.getOutPatientId());
                    if (!Objects.equals(opBusinessOrderEntityDb.getStatus(), BusinessOrderStatusEnum.NOT_PAY.getValue())) {
                        log.info("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u8865\u507f\u673a\u5236\u8ba2\u5355\u5df2\u6210\u529f\u652f\u4ed8");
                        return BaseResponse.success((Object)"\u7f34\u8d39\u6210\u529f");
                    }
                    CardPayOrderEntity payOrderEntity = this.cardPayOrderMapper.selectByDealSeqAndStatus(cardPayOrderEntity.getDealSeq(), "1");
                    if (Objects.nonNull(payOrderEntity)) {
                        return BaseResponse.error((String)"");
                    }
                    try {
                        GatewayRequest gatewayRequest = this.outPatientBuildRecharge(opBusinessOrderEntity, queryOutPatientPayStatusReqVO.getSysId());
                        log.info("\u95e8\u8bca\u7f34\u8d39\u9662\u5185\u8d26\u6237\u5145\u503c\u53c2\u6570\u4e3a:{}", (Object)gatewayRequest);
                        GatewayResponse recharge = this.medicalCardApi.recharge(gatewayRequest);
                        log.info("\u95e8\u8bca\u7f34\u8d39\u9662\u5185\u8d26\u6237\u5145\u503c\u8fd4\u56de\u503c\u4e3a:{}", (Object)recharge);
                        if (Objects.isNull(recharge)) {
                            return BaseResponse.error((String)"\u9662\u5185\u8d26\u6237\u5145\u503c\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                        }
                        if (!"1".equals(recharge.getCode())) {
                            return BaseResponse.error((String)recharge.getMsg());
                        }
                        CardPayOrderEntity cardPayOrderEntityDb = new CardPayOrderEntity();
                        cardPayOrderEntityDb.setId(cardPayOrderEntity.getId());
                        cardPayOrderEntityDb.setOrderStatus(Integer.valueOf(1));
                        this.cardPayOrderMapper.updateByPrimaryKeySelective(cardPayOrderEntityDb);
                        BaseResponse stringBaseResponse = null;
                        stringBaseResponse = this.outpatientPaymentService.queryOutPatientPayStatus(queryOutPatientPayStatusReqVO);
                        this.redisTemplate.opsForValue().getOperations().delete((Object)key);
                        if (!"1".equals(stringBaseResponse.getCode())) {
                            return stringBaseResponse;
                        }
                        return BaseResponse.success();
                    }
                    catch (Exception e) {
                        log.error("\u95e8\u8bca\u7f34\u8d39\u5f02\u5e38:{}", (Object)e.getMessage());
                        return BaseResponse.error((String)"\u95e8\u8bca\u7f34\u8d39\u5f02\u5e38");
                    }
                }
            }
            return BaseResponse.error((String)hisPayRes.getResultMsg());
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public BaseResponse queryCardPayStatus(QueryCardPayStatusReqVo queryCardPayStatusReqVo) throws InHospitalException {
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(queryCardPayStatusReqVo.getSysId());
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(Long.parseLong(cardPayOrderEntity.getDealSeq())));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        if (!Objects.isNull(hisPayRes)) {
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                GatewayRequest gatewayRequest = new GatewayRequest();
                RechargeReqVo rechargeReqVo = new RechargeReqVo();
                rechargeReqVo.setCardNO(cardPayOrderEntity.getPatientCardNo());
                rechargeReqVo.setName(cardPayOrderEntity.getPatientName());
                rechargeReqVo.setCost(cardPayOrderEntity.getDealMoney().toString());
                rechargeReqVo.setOrderNO(cardPayOrderEntity.getDealSeq());
                rechargeReqVo.setTransNO(cardPayOrderEntity.getDealSeq());
                rechargeReqVo.setPayType("CP");
                gatewayRequest.setBody((Object)rechargeReqVo);
                gatewayRequest.setChannel(queryCardPayStatusReqVo.getChannelCode());
                gatewayRequest.setChannelName(queryCardPayStatusReqVo.getChannelCode());
                gatewayRequest.setOrganCode(queryCardPayStatusReqVo.getHosCode());
                gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
                log.info("\u9662\u5185\u8d26\u6237\u5145\u503c\u53c2\u6570\u4e3a:{}", (Object)gatewayRequest);
                GatewayResponse recharge = this.medicalCardApi.recharge(gatewayRequest);
                log.info("\u9662\u5185\u8d26\u6237\u5145\u503c\u8fd4\u56de\u503c\u4e3a:{}", (Object)recharge);
                CardPayOrderEntity cardPayOrderEntityDb = new CardPayOrderEntity();
                cardPayOrderEntityDb.setId(cardPayOrderEntity.getId());
                cardPayOrderEntityDb.setOrderStatus(Integer.valueOf(1));
                this.cardPayOrderMapper.updateByPrimaryKeySelective(cardPayOrderEntityDb);
                if (Objects.isNull(recharge)) {
                    return BaseResponse.error((String)"\u9662\u5185\u8d26\u6237\u5145\u503c\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                }
                if (!"1".equals(recharge.getCode())) {
                    return BaseResponse.error((String)recharge.getMsg());
                }
                return BaseResponse.success((Object)"\u5145\u503c\u6210\u529f");
            }
            return BaseResponse.error((String)hisPayRes.getResultMsg());
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public BaseResponse<List<RechargeRecordItemResVo>> rechargeRecord(WisdomRechargeRecordReqVo wisdomRechargeRecordReqVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RechargeRecordReqVo rechargeRecordReqVo = new RechargeRecordReqVo();
        rechargeRecordReqVo.setCardNo(wisdomRechargeRecordReqVo.getCardNo());
        rechargeRecordReqVo.setStartDate(wisdomRechargeRecordReqVo.getStartDate());
        rechargeRecordReqVo.setEndDate(wisdomRechargeRecordReqVo.getEndDate());
        gatewayRequest.setBody((Object)rechargeRecordReqVo);
        gatewayRequest.setChannel(wisdomRechargeRecordReqVo.getChannelCode());
        gatewayRequest.setChannelName(wisdomRechargeRecordReqVo.getChannelCode());
        gatewayRequest.setOrganCode(wisdomRechargeRecordReqVo.getHosCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u9662\u5185\u8d26\u6237\u5145\u503c\u8bb0\u5f55\u67e5\u8be2\u53c2\u6570\u4e3a:{}", (Object)gatewayRequest);
        GatewayResponse rechargeRecordResVoGatewayResponse = this.medicalCardApi.rechargeRecord(gatewayRequest);
        log.info("\u9662\u5185\u8d26\u6237\u5145\u503c\u8bb0\u5f55\u67e5\u8be2\u8fd4\u56de\u503c\u4e3a:{}", (Object)rechargeRecordResVoGatewayResponse);
        if (Objects.isNull(rechargeRecordResVoGatewayResponse)) {
            return BaseResponse.error((String)"\u9662\u5185\u8d26\u6237\u5145\u503c\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
        }
        if (!"1".equals(rechargeRecordResVoGatewayResponse.getCode())) {
            return BaseResponse.success();
        }
        if (CollectionUtils.isEmpty((Collection)((RechargeRecordResVo)rechargeRecordResVoGatewayResponse.getData()).getRechargeRecordItemResVoList())) {
            return BaseResponse.success();
        }
        for (RechargeRecordItemResVo rechargeRecordItemResVo : ((RechargeRecordResVo)rechargeRecordResVoGatewayResponse.getData()).getRechargeRecordItemResVoList()) {
            String date = DateUtils.simpleStringToSimpleString((String)rechargeRecordItemResVo.getRechargeTime());
            rechargeRecordItemResVo.setRechargeTime(date);
        }
        List collect = ((RechargeRecordResVo)rechargeRecordResVoGatewayResponse.getData()).getRechargeRecordItemResVoList().stream().sorted(Comparator.comparing(RechargeRecordItemResVo::getRechargeTime).reversed()).collect(Collectors.toList());
        return BaseResponse.success(collect);
    }

    public BaseResponse<String> iCardRefund(String sysId) {
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(sysId);
        if (Objects.isNull(cardPayOrderEntity)) {
            return BaseResponse.error((String)"\u8ba2\u5355\u53f7\u6709\u8bef");
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        RefundReq refundReq = new RefundReq();
        refundReq.setMachineNo("wechat");
        refundReq.setTrace(String.valueOf(this.snowflakeIdWorker.nextId()));
        refundReq.setCardNo(cardPayOrderEntity.getPatientCardNo());
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(cardPayOrderEntity.getDealMoney().multiply(bigDecimal).intValue());
        refundReq.setTotalFee(totalfee);
        refundReq.setOutTradeNo(cardPayOrderEntity.getDealSeq());
        log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
        HashMap<String, RefundReq> map = new HashMap<String, RefundReq>();
        map.put("refundReq", refundReq);
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.encrypt("004", map, this.propertiesConstant.getRefund(), HisPayRes.class);
        log.info("\u7ba1\u7406\u5458\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u4e3ahisPayRes:{}", (Object)JSON.toJSONString((Object)hisPayRes));
        if (Objects.equals(hisPayRes.getResultCode(), "0")) {
            if (StringUtils.isNotBlank((String)cardPayOrderEntity.getAppointmentId())) {
                AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cardPayOrderEntity.getAppointmentId());
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
                appointmentRecordEntity.setRemark(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getDisplay());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            }
            if (StringUtils.isNotBlank((String)cardPayOrderEntity.getOutpatientId())) {
                OpBusinessOrderEntity orderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(cardPayOrderEntity.getOutpatientId());
                orderEntity.setStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
                orderEntity.setRemark(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getDisplay());
                this.opBusinessOrderEntityMapper.updateByPrimaryKeySelective(orderEntity);
            }
            CardPayOrderEntity cardPayOrderEntityDb = new CardPayOrderEntity();
            cardPayOrderEntityDb.setId(cardPayOrderEntity.getId());
            cardPayOrderEntityDb.setOrderStatus(Integer.valueOf(2));
            this.cardPayOrderMapper.updateByPrimaryKeySelective(cardPayOrderEntityDb);
            return BaseResponse.success();
        }
        return BaseResponse.error((String)hisPayRes.getResultMsg());
    }

    private GatewayRequest<RechargeReqVo> healthBuildRecharge(AppointmentRecordEntity appointmentRecordEntity, String sysId) {
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(sysId);
        GatewayRequest gatewayRequest = new GatewayRequest();
        RechargeReqVo rechargeReqVo = new RechargeReqVo();
        rechargeReqVo.setCardNO(appointmentRecordEntity.getPatientCardNo());
        rechargeReqVo.setName(appointmentRecordEntity.getPatientName());
        rechargeReqVo.setCost(cardPayOrderEntity.getDealMoney().toString());
        rechargeReqVo.setOrderNO(cardPayOrderEntity.getDealSeq());
        rechargeReqVo.setTransNO(cardPayOrderEntity.getDealSeq());
        rechargeReqVo.setPayType("CP");
        gatewayRequest.setBody((Object)rechargeReqVo);
        gatewayRequest.setChannel(appointmentRecordEntity.getPayChannel());
        gatewayRequest.setChannelName(appointmentRecordEntity.getPayChannel());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<RechargeReqVo> outPatientBuildRecharge(OpBusinessOrderEntity opBusinessOrderEntity, String sysId) {
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(sysId);
        GatewayRequest gatewayRequest = new GatewayRequest();
        RechargeReqVo rechargeReqVo = new RechargeReqVo();
        rechargeReqVo.setCardNO(opBusinessOrderEntity.getCardNo());
        rechargeReqVo.setName(opBusinessOrderEntity.getPatientName());
        rechargeReqVo.setCost(cardPayOrderEntity.getDealMoney().toString());
        rechargeReqVo.setOrderNO(cardPayOrderEntity.getDealSeq());
        rechargeReqVo.setTransNO(cardPayOrderEntity.getDealSeq());
        rechargeReqVo.setPayType("CP");
        gatewayRequest.setBody((Object)rechargeReqVo);
        gatewayRequest.setChannel(opBusinessOrderEntity.getChannelCode());
        gatewayRequest.setChannelName(opBusinessOrderEntity.getChannelCode());
        gatewayRequest.setOrganCode(opBusinessOrderEntity.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }
}

