/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.HospitalizationApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceBillTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServicePayBillStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.mapper.DepositSetEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.OrderBarcodeReq;
import com.ebaiyihui.wisdommedical.model.PayOrder;
import com.ebaiyihui.wisdommedical.model.PolymerizationReq;
import com.ebaiyihui.wisdommedical.model.PolymerizationRes;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.InHospDepostPayCallDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IhHospitalOrderFreeTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospitalRechargeDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PayRequestVoReq;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.OrderMqUtils;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InHospitalServiceImpl
implements InHospitalService {
    private static final Logger log = LoggerFactory.getLogger(InHospitalServiceImpl.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    JedisCluster jedisCluster;
    @Autowired
    private HospitalizationApi hospitalizationApi;
    @Autowired
    private DepositSetEntityMapper depositSetEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private EncryptUtils encryptUtils;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    PayUtil payUtil;
    @Autowired
    private RedisTemplate redisTemplate;

    public List<GetInpAdmissionResItems> getInpAdmissionItems(GetInpAdmissionReqVO getInpAdmissionReqVO) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            return new ArrayList<GetInpAdmissionResItems>();
        }
        if (getInpAdmissionResItemsList.size() > 1) {
            return null;
        }
        return getInpAdmissionResItemsList;
    }

    public InHospitalRechargeDetailResVO getRechargeDetail(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) throws InHospitalException, ParseException {
        InHospitalRechargeDetailResVO inHospitalRechargeDetailResVO = new InHospitalRechargeDetailResVO();
        BigDecimal detailTotalMoney = new BigDecimal("0");
        GatewayRequest gatewayRequest = this.buildGetRechargeDetailReq(inHospitalRechargeDetailReqVO);
        List rechargeDetailList = this.getRechargeDetail(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)rechargeDetailList)) {
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u9884\u4ea4\u91d1\u5145\u503c\u660e\u7ec6\u8bb0\u5f55");
        }
        for (GetIPDepositRecordsItems items : rechargeDetailList) {
            detailTotalMoney = detailTotalMoney.add(new BigDecimal(items.getAmout()));
        }
        InHospitalServiceImpl.conversionTime((List)rechargeDetailList);
        rechargeDetailList.sort(Comparator.comparing(GetIPDepositRecordsItems::getPrePayDateTime).reversed());
        inHospitalRechargeDetailResVO.setDetailTotalMoney(String.valueOf(detailTotalMoney));
        inHospitalRechargeDetailResVO.setDetailRechargeList(rechargeDetailList);
        return inHospitalRechargeDetailResVO;
    }

    public GetIhHospitalOrderItemsResVo getIhHospitalOrderItems(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) throws InHospitalException {
        GatewayRequest getOrdItemsReqGatewayRequest = this.buildGetInHospitalOrderItemDetailReq(getHospitalOrderItemsReqVo);
        GetOrdItemsRes getOrdItemsRes = this.getInHospFeeDetail(getOrdItemsReqGatewayRequest);
        if (null == getOrdItemsRes) {
            new GetOrdItemsRes();
        }
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = new GetIhHospitalOrderItemsResVo();
        BeanUtils.copyProperties((Object)getOrdItemsRes, (Object)getIhHospitalOrderItemsResVo);
        List getOrdItemsResItemsList = getOrdItemsRes.getOrdItem();
        if (CollectionUtils.isEmpty((Collection)getOrdItemsResItemsList)) {
            return getIhHospitalOrderItemsResVo;
        }
        if (StringUtils.isBlank((CharSequence)getHospitalOrderItemsReqVo.getFreeDate())) {
            String lastFreeDate = ((GetOrdItemsResItems)getOrdItemsResItemsList.stream().sorted(Comparator.comparing(GetOrdItemsResItems::getFeeDate).reversed()).collect(Collectors.toList()).get(0)).getFeeDate();
            getOrdItemsResItemsList = getOrdItemsResItemsList.stream().filter(getOrdItemsResItem -> getOrdItemsResItem.getFeeDate().split(" ")[0].equals(lastFreeDate.split(" ")[0])).collect(Collectors.toList());
        } else {
            getOrdItemsResItemsList = getOrdItemsResItemsList.stream().filter(getOrdItemsResItem -> getOrdItemsResItem.getFeeDate().split(" ")[0].equals(getHospitalOrderItemsReqVo.getFreeDate())).collect(Collectors.toList());
        }
        List amountList = getOrdItemsResItemsList.stream().map(getOrdItemsResItems -> new BigDecimal(getOrdItemsResItems.getAmount())).collect(Collectors.toList());
        BigDecimal totalMoney = new BigDecimal("0");
        for (BigDecimal amount : amountList) {
            totalMoney = totalMoney.add(amount);
        }
        Map<String, List<GetOrdItemsResItems>> getOrdItemsResItemsMap = getOrdItemsResItemsList.stream().collect(Collectors.groupingBy(GetOrdItemsResItems::getFeeType));
        ArrayList ihHospitalOrderFreeTypeVoList = new ArrayList();
        getOrdItemsResItemsMap.keySet().forEach(freeType -> {
            IhHospitalOrderFreeTypeVo ihHospitalOrderFreeTypeVo = new IhHospitalOrderFreeTypeVo();
            ihHospitalOrderFreeTypeVo.setFreeType(freeType);
            ihHospitalOrderFreeTypeVo.setGetOrdItemsResItemsList((List)getOrdItemsResItemsMap.get(freeType));
            ihHospitalOrderFreeTypeVoList.add(ihHospitalOrderFreeTypeVo);
        });
        getIhHospitalOrderItemsResVo.setTotalMoney(totalMoney);
        getIhHospitalOrderItemsResVo.setIhHospitalOrderFreeTypeVoList(ihHospitalOrderFreeTypeVoList);
        return getIhHospitalOrderItemsResVo;
    }

    public InHospDepositCreateOrderResVO inHospDepositCreateOrder(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) throws InHospitalException {
        GetInpAdmissionReqVO getInpAdmissionReqVO = new GetInpAdmissionReqVO();
        getInpAdmissionReqVO.setOrganCode(this.propertiesConstant.getOrganCode());
        getInpAdmissionReqVO.setChannelCode(inHospDepositCreateOrderReqVO.getChannelCode());
        getInpAdmissionReqVO.setHospitalCode(inHospDepositCreateOrderReqVO.getHospitalCode());
        getInpAdmissionReqVO.setInHospNo(inHospDepositCreateOrderReqVO.getInHospNo());
        getInpAdmissionReqVO.setCardNo(inHospDepositCreateOrderReqVO.getInHospNo());
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            throw new InHospitalException("\u901a\u8fc7\u4f4f\u9662\u53f7\u672a\u83b7\u53d6\u5230\u4f4f\u9662\u4fe1\u606f,\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.buildInpatientDepositDetailEntity((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0), inHospDepositCreateOrderReqVO);
        try {
            this.inpatientDepositDetailEntityMapper.insertSelective(inpatientDepositDetailEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientPayorderEntity inpatientPayorderEntity = this.buildInpatientPayorderEntity(inHospDepositCreateOrderReqVO, inpatientDepositDetailEntity.getId());
        try {
            this.inpatientPayorderEntityMapper.insertSelective(inpatientPayorderEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("pay\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        inHospDepositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        inHospDepositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        inHospDepositCreateOrderResVO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        inHospDepositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        return inHospDepositCreateOrderResVO;
    }

    public BaseResponse<String> InHospDepositPay(InHospDepositPayReqVO inHospDepositPayReqVO) throws InHospitalException {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inHospDepositPayReqVO.getOrderSeq());
        GetInpAdmissionReqVO getInpAdmissionReqVO = new GetInpAdmissionReqVO();
        getInpAdmissionReqVO.setCardNo(inpatientDepositDetailEntity.getCardNo());
        getInpAdmissionReqVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        getInpAdmissionReqVO.setChannelCode(inHospDepositPayReqVO.getChannelCode());
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        GetInpAdmissionResItems getInpAdmissionResItems = (GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0);
        DepositPayReqVO depositPayReqVO = new DepositPayReqVO();
        depositPayReqVO.setActuallyAmount(inpatientDepositDetailEntity.getMoney());
        depositPayReqVO.setMchCode(this.propertiesConstant.getMchCode());
        depositPayReqVO.setOutTradeNo(inHospDepositPayReqVO.getOrderSeq());
        depositPayReqVO.setPayChannel(inHospDepositPayReqVO.getPayChannel());
        depositPayReqVO.setPayType(inHospDepositPayReqVO.getPayType());
        depositPayReqVO.setProductInfo("\u4f4f\u9662\u9884\u4ea4\u91d1");
        depositPayReqVO.setServiceCode(ServiceCodeEnum.DEPOSITPAY.getValue());
        depositPayReqVO.setTotalAmount(inpatientDepositDetailEntity.getMoney());
        depositPayReqVO.setUserSign(inHospDepositPayReqVO.getOpenId());
        depositPayReqVO.setNonceStr(SignUtil.getNonceStr());
        depositPayReqVO.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        depositPayReqVO.setPayNotifyUrl(this.propertiesConstant.getZyPayNotifyUrl());
        depositPayReqVO.setCardNo(getInpAdmissionResItems.getInHospNo());
        depositPayReqVO.setOpenId(inHospDepositPayReqVO.getOpenId());
        depositPayReqVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositPayReqVO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        Map map = SignUtil.getKeyAndValue((Object)depositPayReqVO);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        depositPayReqVO.setSign(sign);
        return this.payCreateOrder(depositPayReqVO, inpatientDepositDetailEntity);
    }

    public DepositRes InHospDeposit(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildDepositReqGetWay(inpatientDepositDetailEntity, responseNotifyRestVo);
        return this.getDepositRes(gatewayRequest);
    }

    public List<String> getMoneyList(String hospitalCode) {
        List depositSetEntityList = null;
        depositSetEntityList = this.depositSetEntityMapper.selectByOrganCode(hospitalCode);
        if (null == depositSetEntityList || depositSetEntityList.size() < 1) {
            return new ArrayList<String>();
        }
        List<String> moneysList = depositSetEntityList.stream().map(a -> a.getMoneys()).collect(Collectors.toList());
        return moneysList;
    }

    public InHospDepositCreateOrderResVO getInHospDepositCreateOrderRes(String orderSeq) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderSeq);
        InHospDepositCreateOrderResVO depositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        depositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositCreateOrderResVO.setOrderSeq(orderSeq);
        depositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        depositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        depositCreateOrderResVO.setStatus(String.valueOf(inpatientDepositDetailEntity.getStatus()));
        depositCreateOrderResVO.setInpatientDate(inpatientDepositDetailEntity.getInpatientDate());
        depositCreateOrderResVO.setPayTime(inpatientDepositDetailEntity.getPayTime());
        return depositCreateOrderResVO;
    }

    public BaseResponse<String> queryInHospDepositPayStatus(InHospDepositPayReqVO inHospDepositPayReqVO) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inHospDepositPayReqVO.getOrderSeq());
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
        OrderBarcodeReq orderBarcodeReq = new OrderBarcodeReq();
        orderBarcodeReq.setOutTradeNo(Long.valueOf(inpatientPayorderEntity.getDealSeq()));
        log.info("orderBarcodeReq:{}", (Object)String.valueOf(orderBarcodeReq));
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("map:{}", (Object)String.valueOf(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("003", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        boolean flag = false;
        if (Objects.nonNull(hisPayRes) && Objects.equals(hisPayRes.getResultCode(), "0")) {
            flag = this.inHospDepositPaySuccess(inpatientDepositDetailEntity, inpatientPayorderEntity);
        }
        return BaseResponse.success((Object)("\u83b7\u53d6\u652f\u4ed8\u72b6\u6001\uff1a" + String.valueOf(flag)));
    }

    public boolean inHospDepositPaySuccess(InpatientDepositDetailEntity inpatientDepositDetailEntity, InpatientPayorderEntity inpatientPayorderEntity) {
        log.info("=========\u4f4f\u9662\u652f\u4ed8\u7ed3\u679c\u83b7\u53d6\u6210\u529f======\uff1a\u8ba2\u5355\u53f7{}", (Object)inpatientDepositDetailEntity.getOrderSeq());
        String key = "ZY_ZFBC_ " + inpatientDepositDetailEntity.getOrderSeq();
        boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)(key + "_" + this.snowflakeIdWorker.nextId()), 600L, TimeUnit.SECONDS);
        log.info("\u4f4f\u9662\u5145\u503c\u83b7\u53d6\u9501\u7684\u7ed3\u679c\u4e3a:{}", (Object)locked);
        if (locked) {
            InpatientDepositDetailEntity inpatientDepositDetailEntityDb = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
            if (Objects.equals(inpatientDepositDetailEntityDb.getStatus(), BusinessOrderStatusEnum.PAID.getValue().byteValue())) {
                log.info("\u4f4f\u9662\u5145\u503c\u8865\u507f\u673a\u5236\u8ba2\u5355\u5df2\u6210\u529f\u652f\u4ed8");
                return true;
            }
            try {
                ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                responseNotifyRestVo.setPayChannel("WX");
                GatewayRequest gatewayRequest = this.buildDepositReqGetWay(inpatientDepositDetailEntity, responseNotifyRestVo);
                log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
                GatewayResponse gatewayResponse = this.hospitalizationApi.deposit(gatewayRequest);
                if (Objects.isNull(gatewayResponse)) {
                    log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c deposit -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
                    return false;
                }
                if (!"1".equals(gatewayResponse.getCode())) {
                    log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c deposit -> his\u5145\u503c\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
                    return false;
                }
                ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
                InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
                inHospDepostPayCallDTO.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
                inHospDepostPayCallDTO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
                inHospDepostPayCallDTO.setUpdateTime(new Date());
                inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
                inHospDepostPayCallDTO.setInpatientIepositId(String.valueOf(inpatientDepositDetailEntity.getId()));
                inHospDepostPayCallDTO.setBankTradeNo("");
                inHospDepostPayCallDTO.setMerchantId(inpatientPayorderEntity.getMerchantId());
                inHospDepostPayCallDTO.setPaymentSeq(inpatientPayorderEntity.getPaymentSeq());
                inHospDepostPayCallDTO.setPayBillNo(inpatientPayorderEntity.getPayBillNo());
                inHospDepostPayCallDTO.setDealSeq(inpatientPayorderEntity.getDealSeq());
                this.inpatientDepositDetailEntityMapper.updateByOrderSeq(inHospDepostPayCallDTO);
                this.inpatientPayorderEntityMapper.updateByInpatientDepositId(inHospDepostPayCallDTO);
                inHospDepostPayCallDTO.setReceiptId(((DepositRes)gatewayResponse.getData()).getReceiptId());
                inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
                inHospDepostPayCallDTO.setUpdateTime(new Date());
                inHospDepostPayCallDTO.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
                this.inpatientDepositDetailEntityMapper.updateByOrderSeqToHisPaid(inHospDepostPayCallDTO);
                ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
                servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
                servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
                servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
                servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
                servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
                servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
                servicePayBillEntity.setPayChannel(inpatientPayorderEntity.getPaymentSeq());
                servicePayBillEntity.setTradeTime(inpatientPayorderEntity.getPaymentTime());
                servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
                servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
                servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
                servicePayBillEntity.setOrderAmount(Double.valueOf(inpatientPayorderEntity.getDealMoney().doubleValue()));
                servicePayBillEntity.setDealAmount(Double.valueOf(inpatientPayorderEntity.getDealMoney().doubleValue()));
                servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
                servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
                this.servicePayBillMapper.insertSelective(servicePayBillEntity);
                this.redisTemplate.opsForValue().getOperations().delete((Object)key);
                return true;
            }
            catch (Exception e) {
                log.error("\u4f4f\u9662\u5145\u503c\u5f02\u5e38:{}", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    private GatewayRequest<GetInpAdmissionReq> buildGetInpAdmissionReq(GetInpAdmissionReqVO getInpAdmissionReqVO) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetInpAdmissionReq getInpAdmissionReq = new GetInpAdmissionReq();
        getInpAdmissionReq.setCardNo(getInpAdmissionReqVO.getCardNo());
        getInpAdmissionReq.setInHospNo(getInpAdmissionReqVO.getInHospNo());
        gatewayRequest.setBody((Object)getInpAdmissionReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getInpAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getInpAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInpAdmissionItems");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetIPDepositRecordsReq> buildGetRechargeDetailReq(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetIPDepositRecordsReq getIPDepositRecordsReq = new GetIPDepositRecordsReq();
        getIPDepositRecordsReq.setInHospNo(inHospitalRechargeDetailReqVO.getInHospNo());
        getIPDepositRecordsReq.setStartDate(inHospitalRechargeDetailReqVO.getStartDate());
        getIPDepositRecordsReq.setEndDate(inHospitalRechargeDetailReqVO.getEndDate());
        gatewayRequest.setBody((Object)getIPDepositRecordsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inHospitalRechargeDetailReqVO.getChannelCode()));
        gatewayRequest.setChannel(inHospitalRechargeDetailReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetRechargeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetOrdItemsReq> buildGetInHospitalOrderItemDetailReq(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetOrdItemsReq getOrdItemsReq = new GetOrdItemsReq();
        getOrdItemsReq.setInHospNo(getHospitalOrderItemsReqVo.getInHospNo());
        if (StringUtils.isBlank((CharSequence)getHospitalOrderItemsReqVo.getFreeDate())) {
            getOrdItemsReq.setStartDate(DateUtils.dateToSimpleString((Date)DateUtils.getSubtractMonth((Date)new Date(), (int)1)));
            getOrdItemsReq.setEndDate(DateUtils.dateToSimpleString((Date)new Date()));
        } else {
            getOrdItemsReq.setStartDate(getHospitalOrderItemsReqVo.getFreeDate());
        }
        gatewayRequest.setBody((Object)getOrdItemsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getHospitalOrderItemsReqVo.getChannelCode()));
        gatewayRequest.setChannel(getHospitalOrderItemsReqVo.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInHospFeeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<DepositReq> buildDepositReqGetWay(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DepositReq depositReq = new DepositReq();
        depositReq.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        depositReq.setPayChannel("CP");
        depositReq.setFlowNo(inpatientDepositDetailEntity.getOrderSeq());
        depositReq.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositReq.setBankTransNO(inpatientDepositDetailEntity.getReceiptId());
        DepositRespmsg depositRespmsg = new DepositRespmsg();
        depositRespmsg.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositRespmsg.setOrderid(responseNotifyRestVo.getTradeNo());
        depositRespmsg.setPayment(String.valueOf(responseNotifyRestVo.getTotalAmount()));
        depositRespmsg.setAccDate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        gatewayRequest.setBody((Object)depositReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inpatientDepositDetailEntity.getChannel()));
        gatewayRequest.setChannel(inpatientDepositDetailEntity.getChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("InHospDeposit");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private List<GetInpAdmissionResItems> getInpAdmission(GatewayRequest<GetInpAdmissionReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getInpAdmission(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        GetInpAdmissionRes getInpAdmissionRes = (GetInpAdmissionRes)gatewayResponse.getData();
        if (null == getInpAdmissionRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionRes.getItems())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u65e0\u4f4f\u9662\u8bb0\u5f55\u4fe1\u606f\u4fe1\u606f");
            return null;
        }
        return getInpAdmissionRes.getItems();
    }

    private List<GetIPDepositRecordsItems> getRechargeDetail(GatewayRequest<GetIPDepositRecordsReq> gatewayRequest) {
        ArrayList rechargeDetailList = null;
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getIPDepositRecords(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        GetIPDepositRecordsRes getIPDepositRecordsRes = (GetIPDepositRecordsRes)gatewayResponse.getData();
        if (null == getIPDepositRecordsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        rechargeDetailList = getIPDepositRecordsRes.getItems();
        if (null == rechargeDetailList || rechargeDetailList.isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u65e0\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8fd4\u56dehis\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868 Items:{}", (Object)getIPDepositRecordsRes.getItems());
        return rechargeDetailList;
    }

    private GetOrdItemsRes getInHospFeeDetail(GatewayRequest<GetOrdItemsReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getOrdItems(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        GetOrdItemsRes getOrdItemsRes = (GetOrdItemsRes)gatewayResponse.getData();
        if (null == getOrdItemsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (null == getOrdItemsRes.getOrdItem() || getOrdItemsRes.getOrdItem().isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
            throw new InHospitalException("\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8fd4\u56dehis\u4f4f\u9662\u8d39\u7528\u6e05\u5355 OrdItems:{}", (Object)getOrdItemsRes);
        return getOrdItemsRes;
    }

    private DepositRes getDepositRes(GatewayRequest<DepositReq> gatewayRequest) throws InHospitalException {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.deposit(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        DepositRes depositRes = (DepositRes)gatewayResponse.getData();
        if (null == depositRes) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8fd4\u56dehis\u5145\u503c\u6210\u529f\u51ed\u8bc1 depositRes:{}", (Object)depositRes);
        return depositRes;
    }

    private InpatientDepositDetailEntity buildInpatientDepositDetailEntity(GetInpAdmissionResItems getInpAdmissionResItems, InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) {
        InpatientDepositDetailEntity depositDetailEntity = new InpatientDepositDetailEntity();
        depositDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        depositDetailEntity.setOrganName(inHospDepositCreateOrderReqVO.getHospitalName());
        depositDetailEntity.setAdmissionNo(inHospDepositCreateOrderReqVO.getInHospNo());
        depositDetailEntity.setInpatientDate(DateUtils.stringToSimpleDate((String)getInpAdmissionResItems.getStartDate()));
        depositDetailEntity.setOrderSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        depositDetailEntity.setPatientId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientOrganId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientName(getInpAdmissionResItems.getPatientName());
        depositDetailEntity.setCardId(inHospDepositCreateOrderReqVO.getCardId());
        depositDetailEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        depositDetailEntity.setCardNo(getInpAdmissionResItems.getCardNo());
        depositDetailEntity.setStatus(new Byte("0"));
        depositDetailEntity.setMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        depositDetailEntity.setChannel(inHospDepositCreateOrderReqVO.getChannelCode());
        depositDetailEntity.setCreateTime(new Date());
        depositDetailEntity.setUpdateTime(new Date());
        depositDetailEntity.setInHospitalProduceMoney(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyTotalMoney(new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0"));
        BigDecimal preMoneyBalance = new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0").subtract(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyBalance(preMoneyBalance);
        depositDetailEntity.setRemark("\u521b\u5efa\u8ba2\u5355\u6210\u529f\uff0c\u672a\u652f\u4ed8");
        return depositDetailEntity;
    }

    private InpatientPayorderEntity buildInpatientPayorderEntity(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, Long id) {
        InpatientPayorderEntity inpatientPayorderEntity = new InpatientPayorderEntity();
        inpatientPayorderEntity.setInpatientDepositId(id);
        inpatientPayorderEntity.setOrderType(new Byte("1"));
        inpatientPayorderEntity.setDealMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        inpatientPayorderEntity.setBizSysSeq(ServiceCodeEnum.DEPOSITPAY.getValue());
        inpatientPayorderEntity.setPayStatus(new Byte("0"));
        inpatientPayorderEntity.setDealSeq("");
        inpatientPayorderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        inpatientPayorderEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        inpatientPayorderEntity.setCreateTime(new Date());
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRemark("\u521b\u5efapay\u8ba2\u5355\uff0c\u7b49\u5f85\u652f\u4ed8");
        return inpatientPayorderEntity;
    }

    private BaseResponse<String> payCreateOrder(DepositPayReqVO depositPayReqVO, InpatientDepositDetailEntity inpatientDepositDetailEntity1) {
        try {
            log.info("\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u4e3a->{}", (Object)depositPayReqVO.getPayChannel());
            if (null != depositPayReqVO.getPayChannel() && depositPayReqVO.getPayChannel().equals("ALIPAY")) {
                BaseResponse baseResponse = new BaseResponse();
                ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
                if (null == serviceMerchantConfigEntity) {
                    return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
                }
                String payment = this.jedisCluster.get(depositPayReqVO.getOutTradeNo() + "_pay");
                if (payment != null) {
                    return (BaseResponse)JSON.parseObject((String)payment, BaseResponse.class);
                }
                PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
                payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
                payRequestVoReq.setOutTradeNo(depositPayReqVO.getOutTradeNo());
                payRequestVoReq.setPayChannel(depositPayReqVO.getPayChannel());
                payRequestVoReq.setPayType(depositPayReqVO.getPayType());
                payRequestVoReq.setProductInfo(depositPayReqVO.getPatientName() + "HLWYY_\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c");
                payRequestVoReq.setServiceCode(ServiceCodeEnum.DEPOSITPAY.getValue());
                payRequestVoReq.setActuallyAmount(depositPayReqVO.getTotalAmount());
                payRequestVoReq.setTotalAmount(depositPayReqVO.getTotalAmount());
                payRequestVoReq.setUserSign(depositPayReqVO.getUserSign());
                payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
                payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
                payRequestVoReq.setPayNotifyUrl(depositPayReqVO.getPayNotifyUrl());
                Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
                String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
                payRequestVoReq.setSign(sign);
                baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
                log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
                log.info("\u4f4f\u9662\u9884\u4ea4\u91d1.payCreateOrder->\u53d1\u8d77\u652f\u4ed8\u8fd4\u56de\u53c2\u6570baseResponse: " + baseResponse);
                InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(depositPayReqVO.getOrderSeq());
                InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
                inHospDepostPayCallDTO.setInpatientIepositId(inpatientDepositDetailEntity.getId().toString());
                inHospDepostPayCallDTO.setUpdateTime(new Date());
                inHospDepostPayCallDTO.setDealSeq(depositPayReqVO.getOutTradeNo());
                this.inpatientPayorderEntityMapper.updateByInpatientDepositIdToHisPaid(inHospDepostPayCallDTO);
                this.jedisCluster.set(depositPayReqVO.getOutTradeNo() + "_pay", JSON.toJSONString((Object)baseResponse), "NX", "EX", 1800L);
                return baseResponse;
            }
            HashMap<String, PolymerizationReq> map = new HashMap<String, PolymerizationReq>();
            PolymerizationReq polymerizationReq = new PolymerizationReq();
            polymerizationReq.setBody(depositPayReqVO.getPatientName() + "HLWYY_\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c");
            polymerizationReq.setCardNo(depositPayReqVO.getCardNo());
            polymerizationReq.setMachineNo("wechat");
            polymerizationReq.setMethod("8");
            polymerizationReq.setType("3");
            polymerizationReq.setShowUrl("showUrl");
            polymerizationReq.setSubAppid(this.propertiesConstant.getSubAppid());
            BigDecimal bigDecimal = new BigDecimal("100");
            String totalfee = String.valueOf(depositPayReqVO.getActuallyAmount().multiply(bigDecimal).intValue());
            polymerizationReq.setTotalFee(totalfee);
            polymerizationReq.setSubject(depositPayReqVO.getPatientName() + "HLWYY_\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c");
            polymerizationReq.setReturnUrl("ReturnUrl");
            polymerizationReq.setOpenid(depositPayReqVO.getOpenId());
            polymerizationReq.setPatientName(depositPayReqVO.getPatientName());
            map.put("polymerizationReq", polymerizationReq);
            PolymerizationRes encrypt = (PolymerizationRes)this.encryptUtils.encrypt("001", map, this.propertiesConstant.getPolymerization(), PolymerizationRes.class);
            String resultCode = encrypt.getResultCode();
            if (!Objects.equals(encrypt.getResultCode(), "0")) {
                return BaseResponse.error((String)encrypt.getResultMsg());
            }
            if (Objects.equals(encrypt.getResultCode(), "0")) {
                String payUrl = encrypt.getPayUrl();
                String outTradeNo = encrypt.getOutTradeNo();
                InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(depositPayReqVO.getOrderSeq());
                InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
                inHospDepostPayCallDTO.setInpatientIepositId(inpatientDepositDetailEntity.getId().toString());
                inHospDepostPayCallDTO.setDealSeq(encrypt.getOutTradeNo());
                inHospDepostPayCallDTO.setUpdateTime(new Date());
                this.inpatientPayorderEntityMapper.updateByInpatientDepositIdToHisPaid(inHospDepostPayCallDTO);
                this.inpatientDepositDetailEntityMapper.updateReceiptIdByOrderSeq(depositPayReqVO.getOrderSeq(), encrypt.getOutTradeNo());
                PayOrder payOrder = new PayOrder();
                payOrder.setNumber(1);
                payOrder.setType(4);
                payOrder.setId(inpatientDepositDetailEntity.getOrderSeq());
                OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
                return BaseResponse.success((Object)payUrl);
            }
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        catch (Exception e) {
            log.error("InHospitalServiceImpl.payCreateOrder\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u652f\u4ed8\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e);
            return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private static List<GetIPDepositRecordsItems> conversionTime(List<GetIPDepositRecordsItems> ipDepositRecordsItemsList) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        for (GetIPDepositRecordsItems getIPDepositRecordsItems : ipDepositRecordsItemsList) {
            String format = simpleDateFormat.format(simpleDateFormat1.parse(getIPDepositRecordsItems.getPrePayDateTime()));
            getIPDepositRecordsItems.setPrePayDateTime(format);
        }
        return ipDepositRecordsItemsList;
    }
}

