/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.MedicalAppointment.MedicalAppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.mapper.MedicalAppointmentInfoMapper;
import com.ebaiyihui.wisdommedical.mapper.MedicalRecordPackageMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.MedicalAppointment.MedicalAppointmentInfoReq;
import com.ebaiyihui.wisdommedical.model.MedicalAppointment.MedicalRecordReviewReq;
import com.ebaiyihui.wisdommedical.model.MedicalAppointment.res.MedicalAppointmentInfoListRes;
import com.ebaiyihui.wisdommedical.model.MedicalAppointment.res.MedicalAppointmentInfoRes;
import com.ebaiyihui.wisdommedical.model.MedicalAppointmentInfoEntity;
import com.ebaiyihui.wisdommedical.model.MedicalRecordPackageEntity;
import com.ebaiyihui.wisdommedical.model.PayOrder;
import com.ebaiyihui.wisdommedical.model.PolymerizationReq;
import com.ebaiyihui.wisdommedical.model.PolymerizationRes;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.service.MedicalAppointmentInfoService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.MedicalRecordAppointmentMqUtil;
import com.ebaiyihui.wisdommedical.util.OrderMqUtils;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.ebaiyihui.wisdommedical.util.UniqueKeyUtil;
import com.ebaiyihui.wisdommedical.util.pinyinUtil;
import com.ebaiyihui.wisdommedical.vo.MedicalAppointmentInfoVoReq;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class MedicalAppointmentInfoServiceImpl
extends ServiceImpl<MedicalAppointmentInfoMapper, MedicalAppointmentInfoEntity>
implements MedicalAppointmentInfoService {
    private static final Logger log = LoggerFactory.getLogger(MedicalAppointmentInfoServiceImpl.class);
    private final MedicalAppointmentInfoMapper medicalAppointmentInfoMapper;
    private final MedicalRecordPackageMapper medicalRecordPackageMapper;
    private final SnowflakeIdWorker snowflakeIdWorker;
    private final ProPropertiesConstant propertiesConstant;
    private final EncryptUtils encryptUtils;
    private final JedisCluster jedisCluster;
    private final RabbitTemplate rabbitTemplate;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Resource
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    private final MedicalRecordAppointmentMqUtil medicalRecordAppointmentMqUtil;

    public MedicalAppointmentInfoRes getOrderList(MedicalAppointmentInfoReq medicalAppointmentInfoReq) {
        log.info("getOrderList->{}", (Object)JSON.toJSONString((Object)medicalAppointmentInfoReq));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.notLike(StrUtil.isNotBlank((CharSequence)medicalAppointmentInfoReq.getOtherOrders()), (Object)"orderStatus", (Object)medicalAppointmentInfoReq.getOtherOrders());
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)medicalAppointmentInfoReq.getOrderStatus()), (Object)"orderStatus", (Object)medicalAppointmentInfoReq.getOrderStatus());
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)medicalAppointmentInfoReq.getOpenId()), (Object)"openId", (Object)medicalAppointmentInfoReq.getOpenId());
        queryWrapper.and(StrUtil.isNotBlank((CharSequence)medicalAppointmentInfoReq.getSearch()), wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"patientName", (Object)medicalAppointmentInfoReq.getSearch())).or()).like((Object)"orderNumber", (Object)medicalAppointmentInfoReq.getSearch())).or()).like((Object)"inpatientNo", (Object)medicalAppointmentInfoReq.getSearch())).or()).like((Object)"openId", (Object)medicalAppointmentInfoReq.getSearch())).or()).like((Object)"hospital", (Object)medicalAppointmentInfoReq.getSearch());
        });
        if (medicalAppointmentInfoReq.getStartingTime().length() != 0) {
            queryWrapper.between(StrUtil.isNotBlank((CharSequence)medicalAppointmentInfoReq.getStartingTime()), (Object)"createtime", (Object)DateUtil.beginOfDay((Date)DateUtil.parseDate((CharSequence)medicalAppointmentInfoReq.getStartingTime())), (Object)DateUtil.endOfDay((Date)DateUtil.parseDate((CharSequence)medicalAppointmentInfoReq.getEndTime())));
        }
        queryWrapper.orderByDesc((Object)"createtime");
        Page medicalAppointmentInfoEntityPage = new Page(medicalAppointmentInfoReq.getPageNumber().longValue(), medicalAppointmentInfoReq.getPageSize().longValue());
        Page medicalAppointmentInfoEntityPage1 = (Page)this.medicalAppointmentInfoMapper.selectPage((IPage)medicalAppointmentInfoEntityPage, (Wrapper)queryWrapper);
        if (medicalAppointmentInfoEntityPage1.getRecords().size() == 0) {
            return new MedicalAppointmentInfoRes();
        }
        MedicalAppointmentInfoRes medicalAppointmentInfoRes = new MedicalAppointmentInfoRes();
        List medicalAppointmentInfoListRes = BeanUtil.copyToList((Collection)medicalAppointmentInfoEntityPage1.getRecords(), MedicalAppointmentInfoListRes.class);
        List collect = medicalAppointmentInfoListRes.stream().map(medicalAppointmentInfoListRes1 -> {
            if (!StrUtil.isBlank((CharSequence)medicalAppointmentInfoListRes1.getOrderPayTime())) {
                medicalAppointmentInfoListRes1.setOrderExpirationTime(this.dateToStamp(DateUtil.format((Date)DateUtil.offset((Date)DateUtil.parseDateTime((CharSequence)medicalAppointmentInfoListRes1.getOrderPayTime()), (DateField)DateField.MINUTE, (int)30), (String)"yyyy-MM-dd HH:mm:ss")));
            }
            return medicalAppointmentInfoListRes1;
        }).collect(Collectors.toList());
        medicalAppointmentInfoRes.setResList(collect);
        List list = this.getOrderPayPayAmountTotal();
        if (list.size() == 0) {
            medicalAppointmentInfoRes.setPrintPayPayAmountTotal("0");
            medicalAppointmentInfoRes.setPrintTotal("0");
        } else {
            BigDecimal printPayPayAmountTotal = list.stream().filter(item -> null != item.getOrderPayAmount()).map(MedicalAppointmentInfoEntity::getOrderPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            medicalAppointmentInfoRes.setPrintPayPayAmountTotal(printPayPayAmountTotal.toString());
            medicalAppointmentInfoRes.setPrintTotal(String.valueOf(this.getOrderPayPayAmountTotal().size()));
        }
        medicalAppointmentInfoRes.setTotal(medicalAppointmentInfoEntityPage1.getTotal());
        medicalAppointmentInfoRes.setCurrent(medicalAppointmentInfoEntityPage1.getCurrent());
        medicalAppointmentInfoRes.setSize(medicalAppointmentInfoEntityPage1.getSize());
        medicalAppointmentInfoRes.setPages(medicalAppointmentInfoEntityPage1.getPages());
        return medicalAppointmentInfoRes;
    }

    private String dateToStamp(String s) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(s);
            long ts = date.getTime();
            String res = String.valueOf(ts);
            return res;
        }
        catch (ParseException e) {
            return String.valueOf(System.currentTimeMillis());
        }
    }

    public MedicalAppointmentInfoEntity getOrderDetails(String orderNumber) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)orderNumber);
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = (MedicalAppointmentInfoEntity)this.medicalAppointmentInfoMapper.selectOne((Wrapper)queryWrapper);
        if (!StrUtil.isBlank((CharSequence)medicalAppointmentInfoEntity.getOrderPayTime())) {
            medicalAppointmentInfoEntity.setOrderExpirationTime(this.dateToStamp(DateUtil.format((Date)DateUtil.offset((Date)DateUtil.parseDateTime((CharSequence)medicalAppointmentInfoEntity.getOrderPayTime()), (DateField)DateField.MINUTE, (int)30), (String)"yyyy-MM-dd HH:mm:ss")));
        }
        try {
            medicalAppointmentInfoEntity.setAge(String.valueOf(IdcardUtil.getAgeByIdCard((String)medicalAppointmentInfoEntity.getPatientIdCard())));
            medicalAppointmentInfoEntity.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)medicalAppointmentInfoEntity.getPatientIdCard())));
        }
        catch (Exception e) {
            medicalAppointmentInfoEntity.setAge("0");
            medicalAppointmentInfoEntity.setSex("0");
        }
        return medicalAppointmentInfoEntity;
    }

    public int medicalRecordReview(MedicalRecordReviewReq medicalRecordReviewReq) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)medicalRecordReviewReq.getOrderNumber());
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = new MedicalAppointmentInfoEntity();
        medicalAppointmentInfoEntity.setOrderNumber(medicalRecordReviewReq.getOrderNumber());
        if (medicalRecordReviewReq.getAuditResults().equals("1")) {
            medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.WAIT_FOR_PAYMENT.getValue().toString());
            medicalAppointmentInfoEntity.setOrderPayAmount(new BigDecimal(medicalRecordReviewReq.getPrintingFee()));
            medicalAppointmentInfoEntity.setOrderPayTime(DateUtil.now());
            medicalAppointmentInfoEntity.setOrderRemarks("\u8bf7\u572830:00\u5185\u5b8c\u6210\u652f\u4ed8,\u8d85\u65f6\u81ea\u52a8\u53d6\u6d88");
            medicalAppointmentInfoEntity.setRemarks("\u8bf7\u572830:00\u5185\u5b8c\u6210\u652f\u4ed8,\u8d85\u65f6\u81ea\u52a8\u53d6\u6d88");
            int update = this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
            this.medicalRecordAppointmentMqUtil.senderDelayedOrderNumber(this.rabbitTemplate, medicalRecordReviewReq.getOrderNumber());
            this.taskExecutor.execute(() -> this.pushService.medicalRecordPaymentPush(medicalRecordReviewReq.getOrderNumber()));
            return update;
        }
        medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.AUDIT_FAILED.getValue().toString());
        medicalAppointmentInfoEntity.setReviewRemarks(medicalRecordReviewReq.getFailureReason());
        medicalAppointmentInfoEntity.setOrderRemarks(medicalRecordReviewReq.getFailureReason());
        medicalAppointmentInfoEntity.setOrderRemarks("\u975e\u5e38\u62b1\u6b49,\u60a8\u7684\u5ba1\u6838\u672a\u901a\u8fc7");
        medicalAppointmentInfoEntity.setRemarks("\u975e\u5e38\u62b1\u6b49,\u60a8\u7684\u5ba1\u6838\u672a\u901a\u8fc7");
        int update = this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
        this.taskExecutor.execute(() -> this.pushService.medicalRecordFailedPush(medicalRecordReviewReq.getOrderNumber()));
        return update;
    }

    public int medicalRecordsSent(String express, String expressNumber, String orderNumber) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)orderNumber);
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = new MedicalAppointmentInfoEntity();
        medicalAppointmentInfoEntity.setOrderNumber(orderNumber);
        medicalAppointmentInfoEntity.setExpress(express);
        medicalAppointmentInfoEntity.setExpressNumber(expressNumber);
        medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.COMPLETED.getValue().toString());
        medicalAppointmentInfoEntity.setRemarks("\u60a8\u7684\u75c5\u6848\u5df2\u53d1\u8d27,\u8bf7\u6ce8\u610f\u67e5\u6536");
        medicalAppointmentInfoEntity.setOrderRemarks("\u60a8\u7684\u75c5\u6848\u5df2\u53d1\u8d27,\u8bf7\u6ce8\u610f\u67e5\u6536");
        int update = this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
        this.taskExecutor.execute(() -> this.pushService.medicalRecordDeliveryPush(orderNumber));
        return update;
    }

    public int confirmPickup(String orderNumber) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)orderNumber);
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = new MedicalAppointmentInfoEntity();
        medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.COMPLETED.getValue().toString());
        medicalAppointmentInfoEntity.setRemarks("\u60a8\u7684\u75c5\u6848\u5df2\u5b8c\u6210\u81ea\u63d0,\u8bf7\u59a5\u5584\u4fdd\u7ba1");
        medicalAppointmentInfoEntity.setOrderRemarks("\u60a8\u7684\u75c5\u6848\u5df2\u5b8c\u6210\u81ea\u63d0,\u8bf7\u59a5\u5584\u4fdd\u7ba1");
        int update = this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
        return update;
    }

    public List<MedicalRecordPackageEntity> getAllMedicalRecordPackage() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"deletePackage", (Object)1);
        queryWrapper.orderByDesc((Object)"createtime");
        List medicalRecordPackageEntities = this.medicalRecordPackageMapper.selectList((Wrapper)queryWrapper);
        return medicalRecordPackageEntities;
    }

    public List<MedicalRecordPackageEntity> getAllMedicalRecordPackageStatus(String packageStatus) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"packageStatus", (Object)packageStatus);
        queryWrapper.eq((Object)"deletePackage", (Object)1);
        queryWrapper.orderByDesc((Object)"createtime");
        List medicalRecordPackageEntities = this.medicalRecordPackageMapper.selectList((Wrapper)queryWrapper);
        List<MedicalRecordPackageEntity> collect = medicalRecordPackageEntities.stream().map(medicalRecordPackageEntity -> {
            String[] split = medicalRecordPackageEntity.getPackageContent().split(",");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < split.length; ++i) {
                StringBuffer stringBuffer1 = new StringBuffer();
                stringBuffer1.append(split[i]);
                stringBuffer1.insert(0, i + 1 + ".");
                if (split.length != i) {
                    stringBuffer1.insert(stringBuffer1.length(), " ");
                }
                stringBuffer.append(stringBuffer1);
            }
            medicalRecordPackageEntity.setPackageContent1(stringBuffer.toString());
            return medicalRecordPackageEntity;
        }).collect(Collectors.toList());
        return collect;
    }

    public int medicalRecordsPackageStatus(String status, String packageNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"packageNo", (Object)packageNo);
        MedicalRecordPackageEntity medicalRecordPackageEntity = new MedicalRecordPackageEntity();
        if ("1".equals(status)) {
            medicalRecordPackageEntity.setPackageStatus("1");
            medicalRecordPackageEntity.setDeletePackage("1");
            medicalRecordPackageEntity.setPackageNo(packageNo);
            return this.medicalRecordPackageMapper.update((Object)medicalRecordPackageEntity, (Wrapper)queryWrapper);
        }
        if ("2".equals(status)) {
            medicalRecordPackageEntity.setPackageStatus("2");
            medicalRecordPackageEntity.setDeletePackage("1");
            medicalRecordPackageEntity.setPackageNo(packageNo);
            return this.medicalRecordPackageMapper.update((Object)medicalRecordPackageEntity, (Wrapper)queryWrapper);
        }
        if (this.checkOrderPackage(packageNo)) {
            if (StrUtil.isBlank((CharSequence)packageNo)) {
                return 888888;
            }
            return this.medicalRecordPackageMapper.delete((Wrapper)queryWrapper);
        }
        return 888888;
    }

    public int instMedicalRecordPackage(MedicalRecordPackageEntity medicalRecordPackageEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"packageName", (Object)medicalRecordPackageEntity.getPackageName());
        queryWrapper.eq((Object)"packageContent", (Object)medicalRecordPackageEntity.getPackageContent());
        queryWrapper.eq((Object)"deletePackage", (Object)"1");
        List list = this.medicalRecordPackageMapper.selectList((Wrapper)queryWrapper);
        if (0 != list.size()) {
            return 888888;
        }
        medicalRecordPackageEntity.setDeletePackage("1");
        medicalRecordPackageEntity.setPackageNo(String.valueOf(this.snowflakeIdWorker.nextId()));
        medicalRecordPackageEntity.setPackageStatus("2");
        int insert = this.medicalRecordPackageMapper.insert((Object)medicalRecordPackageEntity);
        return insert;
    }

    public String createMedicalAppointment(MedicalAppointmentInfoEntity medicalAppointmentInfoEntity) {
        medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.Moderated.getValue().toString());
        medicalAppointmentInfoEntity.setOrderRemarks("\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85,\u901a\u8fc7\u540e\u53ef\u652f\u4ed8\u590d\u5370\u8d39\u7528");
        medicalAppointmentInfoEntity.setRemarks("\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85,\u901a\u8fc7\u540e\u53ef\u652f\u4ed8\u590d\u5370\u8d39\u7528");
        medicalAppointmentInfoEntity.setOrderNumber(String.valueOf(this.snowflakeIdWorker.nextId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"packageNo", (Object)medicalAppointmentInfoEntity.getHandlingPackageId());
        MedicalRecordPackageEntity medicalRecordPackageEntity = (MedicalRecordPackageEntity)this.medicalRecordPackageMapper.selectOne((Wrapper)queryWrapper);
        if (BeanUtil.isEmpty((Object)medicalRecordPackageEntity, (String[])new String[0])) {
            return "8888888";
        }
        medicalAppointmentInfoEntity.setPackageContent(medicalRecordPackageEntity.getPackageName() + "\u3010" + medicalRecordPackageEntity.getPackageContent() + "\u3011/" + medicalAppointmentInfoEntity.getPrintNumber() + "\u4efd");
        medicalAppointmentInfoEntity.setCreateTime(new Date());
        medicalAppointmentInfoEntity.setUpdateTime(new Date());
        this.medicalAppointmentInfoMapper.insert((Object)medicalAppointmentInfoEntity);
        return medicalAppointmentInfoEntity.getOrderNumber();
    }

    public BaseResponse<String> payMedicalAppointment(String orderNumber) {
        String s = this.jedisCluster.get(orderNumber + "_pay");
        if (null != s) {
            return BaseResponse.success((Object)s);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)orderNumber);
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = (MedicalAppointmentInfoEntity)this.medicalAppointmentInfoMapper.selectOne((Wrapper)queryWrapper);
        if (BeanUtil.isEmpty((Object)medicalAppointmentInfoEntity, (String[])new String[0])) {
            return BaseResponse.error((String)"\u6682\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355 \u91cd\u91cd\u65b0\u9884\u7ea6!");
        }
        if (!MedicalAppointmentStatusEnum.WAIT_FOR_PAYMENT.getValue().toString().equals(medicalAppointmentInfoEntity.getOrderStatus())) {
            return BaseResponse.error((String)"\u6682\u672a\u5b8c\u6210\u5ba1\u6838 \u65e0\u6cd5\u652f\u4ed8");
        }
        String paymentInfo = this.getPaymentInfo(medicalAppointmentInfoEntity);
        if ("8888888".equals(paymentInfo)) {
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25,\u8bf7\u91cd\u8bd5");
        }
        this.jedisCluster.set(medicalAppointmentInfoEntity.getOrderNumber() + "_pay", paymentInfo, "NX", "EX", 1800L);
        return BaseResponse.success((Object)paymentInfo);
    }

    public void medicalRecordsPaidSuccessfully(String orderNumber, String appointmentMethod) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)orderNumber);
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = new MedicalAppointmentInfoEntity();
        if (appointmentMethod.equals("\u90ae\u5bc4")) {
            medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.WAIT_FOR_DELIVERY.getValue().toString());
            medicalAppointmentInfoEntity.setRemarks("\u590d\u5370\u5b8c\u6210\u5373\u5c06\u53d1\u8d27,\u8bf7\u60a8\u6ce8\u610f\u6d88\u606f\u901a\u77e5");
            medicalAppointmentInfoEntity.setOrderRemarks("\u590d\u5370\u5b8c\u6210\u5373\u5c06\u53d1\u8d27,\u8bf7\u60a8\u6ce8\u610f\u6d88\u606f\u901a\u77e5");
        } else {
            medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.WAITING_FOR_PICK_UP.getValue().toString());
            medicalAppointmentInfoEntity.setRemarks("\u8bf7\u60a8\u5c3d\u5feb\u53bb\u533b\u9662\u75c5\u6848\u5ba4\u9886\u53d6\u75c5\u6848");
            medicalAppointmentInfoEntity.setOrderRemarks("\u8bf7\u60a8\u5c3d\u5feb\u53bb\u533b\u9662\u75c5\u6848\u5ba4\u9886\u53d6\u75c5\u6848");
            medicalAppointmentInfoEntity.setReviewRemarks("\u81ea\u63d0\u5730\u70b9:\u88d5\u534e\u897f\u8def530\u53f7,\u897f\u95e8\u75c5\u6848\u5ba4(\u95e8\u536b\u5ba4\u508d\u8fb9)\n\u81ea\u63d0\u65f6\u95f4:\u4e0a\u5348:8:00-12:00 \u4e0b\u534814:00-17:00");
        }
        this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
    }

    public BaseResponse<String> cancelOrder(String orderNumber) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)orderNumber);
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = (MedicalAppointmentInfoEntity)this.medicalAppointmentInfoMapper.selectOne((Wrapper)queryWrapper);
        if (BeanUtil.isEmpty((Object)medicalAppointmentInfoEntity, (String[])new String[0])) {
            return BaseResponse.error((String)"\u8ba2\u5355\u67e5\u8be2\u4e3a\u7a7a,\u65e0\u6cd5\u53d6\u6d88");
        }
        if (!MedicalAppointmentStatusEnum.WAIT_FOR_PAYMENT.getValue().toString().equals(medicalAppointmentInfoEntity.getOrderStatus())) {
            return BaseResponse.error((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e,\u65e0\u6cd5\u53d6\u6d88");
        }
        medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.CANCELLED.getValue().toString());
        medicalAppointmentInfoEntity.setOrderRemarks("\u60a8\u5df2\u53d6\u6d88\u672c\u6b21\u9884\u7ea6");
        medicalAppointmentInfoEntity.setRemarks("\u60a8\u5df2\u53d6\u6d88\u672c\u6b21\u9884\u7ea6");
        this.medicalAppointmentInfoMapper.updateById((Object)medicalAppointmentInfoEntity);
        return BaseResponse.success((Object)"\u8ba2\u5355\u53d6\u6d88\u6210\u529f");
    }

    private String getPaymentInfo(MedicalAppointmentInfoEntity medicalAppointmentInfoEntity) {
        String outTradeNo = String.valueOf(UniqueKeyUtil.generateViewId());
        MedicalAppointmentInfoVoReq medicalAppointmentInfoVoReq = new MedicalAppointmentInfoVoReq();
        medicalAppointmentInfoVoReq.setActuallyAmount(medicalAppointmentInfoEntity.getOrderPayAmount());
        medicalAppointmentInfoVoReq.setMchCode(this.propertiesConstant.getMchCode());
        medicalAppointmentInfoVoReq.setOutTradeNo(outTradeNo);
        medicalAppointmentInfoVoReq.setPayChannel("WECHAT");
        medicalAppointmentInfoVoReq.setPayType("JSAPI");
        medicalAppointmentInfoVoReq.setProductInfo("\u75c5\u6848\u590d\u5370");
        medicalAppointmentInfoVoReq.setServiceCode(this.propertiesConstant.getAppCode());
        medicalAppointmentInfoVoReq.setTotalAmount(medicalAppointmentInfoEntity.getOrderPayAmount());
        medicalAppointmentInfoVoReq.setUserSign(medicalAppointmentInfoEntity.getOpenId());
        medicalAppointmentInfoVoReq.setAuthCode("");
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null == serviceMerchantConfigEntity) {
            return "88888888";
        }
        medicalAppointmentInfoVoReq.setNonceStr(pinyinUtil.getRandomString((int)32));
        medicalAppointmentInfoVoReq.setApplyCode(serviceMerchantConfigEntity.getAppCode());
        medicalAppointmentInfoVoReq.setPayNotifyUrl(this.propertiesConstant.getPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)medicalAppointmentInfoVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        medicalAppointmentInfoVoReq.setSign(sign);
        BaseResponse baseResponse = this.payCreateOrder(medicalAppointmentInfoVoReq);
        if (baseResponse.getCode().equals("1")) {
            medicalAppointmentInfoEntity.setTransactionId(outTradeNo);
            medicalAppointmentInfoEntity.setOrderPayTime(DateUtil.now());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"orderNumber", (Object)medicalAppointmentInfoEntity.getOrderNumber());
            int update = this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
            PayOrder payOrder = new PayOrder();
            payOrder.setNumber(1);
            payOrder.setType(7);
            payOrder.setId(medicalAppointmentInfoEntity.getOrderNumber());
            OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
            return (String)baseResponse.getData();
        }
        return "8888888";
    }

    private BaseResponse<String> payCreateOrder(MedicalAppointmentInfoVoReq medicalAppointmentInfoVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)medicalAppointmentInfoVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private String getPaymentInfo1(MedicalAppointmentInfoEntity medicalAppointmentInfoEntity) {
        HashMap map = this.buildPayParameter(medicalAppointmentInfoEntity);
        PolymerizationRes encrypt = (PolymerizationRes)this.encryptUtils.encrypt("001", (Map)map, this.propertiesConstant.getPolymerization(), PolymerizationRes.class);
        if (Objects.equals(encrypt.getResultCode(), "0")) {
            String payUrl = encrypt.getPayUrl();
            String outTradeNo = encrypt.getOutTradeNo();
            medicalAppointmentInfoEntity.setTransactionId(outTradeNo);
            medicalAppointmentInfoEntity.setOrderPayTime(DateUtil.now());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"orderNumber", (Object)medicalAppointmentInfoEntity.getOrderNumber());
            int update = this.medicalAppointmentInfoMapper.update((Object)medicalAppointmentInfoEntity, (Wrapper)queryWrapper);
            PayOrder payOrder = new PayOrder();
            payOrder.setNumber(1);
            payOrder.setType(7);
            payOrder.setId(medicalAppointmentInfoEntity.getOrderNumber());
            OrderMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
            return payUrl;
        }
        return "8888888";
    }

    private HashMap<String, Object> buildPayParameter(MedicalAppointmentInfoEntity medicalAppointmentInfoEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PolymerizationReq polymerizationReq = new PolymerizationReq();
        polymerizationReq.setBody(medicalAppointmentInfoEntity.getPatientName() + "HLWYY_\u75c5\u6848\u590d\u5370");
        polymerizationReq.setCardNo(medicalAppointmentInfoEntity.getPatientIdCard());
        polymerizationReq.setMachineNo("wechat");
        polymerizationReq.setMethod("8");
        polymerizationReq.setType("21");
        polymerizationReq.setShowUrl("showUrl");
        polymerizationReq.setSubAppid(this.propertiesConstant.getSubAppid());
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(medicalAppointmentInfoEntity.getOrderPayAmount().multiply(bigDecimal).intValue());
        polymerizationReq.setTotalFee(totalfee);
        polymerizationReq.setSubject(medicalAppointmentInfoEntity.getPatientName() + "HLWYY_\u75c5\u6848\u590d\u5370");
        polymerizationReq.setReturnUrl("ReturnUrl");
        polymerizationReq.setOpenid(medicalAppointmentInfoEntity.getOpenId());
        polymerizationReq.setPatientName(medicalAppointmentInfoEntity.getPatientName());
        map.put("polymerizationReq", polymerizationReq);
        return map;
    }

    private boolean checkOrderPackage(String packageNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderStatus", (Object)MedicalAppointmentStatusEnum.Moderated.getValue());
        queryWrapper.eq((Object)"handlingPackageId", (Object)packageNo);
        List medicalAppointmentInfoEntities = this.medicalAppointmentInfoMapper.selectList((Wrapper)queryWrapper);
        return 0 == medicalAppointmentInfoEntities.size();
    }

    private List<MedicalAppointmentInfoEntity> getOrderPayPayAmountTotal() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderStatus", (Object)MedicalAppointmentStatusEnum.COMPLETED.getValue());
        List medicalAppointmentInfoEntities = this.medicalAppointmentInfoMapper.selectList((Wrapper)queryWrapper);
        return medicalAppointmentInfoEntities;
    }

    public MedicalAppointmentInfoServiceImpl(MedicalAppointmentInfoMapper medicalAppointmentInfoMapper, MedicalRecordPackageMapper medicalRecordPackageMapper, SnowflakeIdWorker snowflakeIdWorker, ProPropertiesConstant propertiesConstant, EncryptUtils encryptUtils, JedisCluster jedisCluster, RabbitTemplate rabbitTemplate, MedicalRecordAppointmentMqUtil medicalRecordAppointmentMqUtil) {
        this.medicalAppointmentInfoMapper = medicalAppointmentInfoMapper;
        this.medicalRecordPackageMapper = medicalRecordPackageMapper;
        this.snowflakeIdWorker = snowflakeIdWorker;
        this.propertiesConstant = propertiesConstant;
        this.encryptUtils = encryptUtils;
        this.jedisCluster = jedisCluster;
        this.rabbitTemplate = rabbitTemplate;
        this.medicalRecordAppointmentMqUtil = medicalRecordAppointmentMqUtil;
    }
}

