/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.ElectronicReportApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.report.CheckInspectionGroupDetailsListRes;
import com.ebaiyihui.his.pojo.vo.report.CheckInspectionGroupDetailsRes;
import com.ebaiyihui.his.pojo.vo.report.GetAppointOrOutPatientHistoryListReq;
import com.ebaiyihui.his.pojo.vo.report.GetAppointmentHistoryDateRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetAppointmentHistoryListRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetEleInvoiceListReq;
import com.ebaiyihui.his.pojo.vo.report.GetEleInvoiceListRes;
import com.ebaiyihui.his.pojo.vo.report.GetHistoryOutPatientDataRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetHistoryOutPatientListRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.pojo.vo.report.datas.micDatas.LisReportListResMicData;
import com.ebaiyihui.wisdommedical.mapper.CheckInfoMapper;
import com.ebaiyihui.wisdommedical.mapper.InspectionInfoMapper;
import com.ebaiyihui.wisdommedical.mapper.TReportListMapper;
import com.ebaiyihui.wisdommedical.model.CheckInfo;
import com.ebaiyihui.wisdommedical.model.InspectionInfo;
import com.ebaiyihui.wisdommedical.model.TReportList;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsReq;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetEleInvoiceListReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetHistoryOutPatientRespVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetHistoryReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosRes;
import com.ebaiyihui.wisdommedical.pojo.vo.NetReportBaseRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportInfo;
import com.ebaiyihui.wisdommedical.service.NetReportService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NetReportServiceImpl
implements NetReportService {
    @Resource
    private ElectronicReportApi electronicReportClient;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    TReportListMapper tReportListMapper;
    @Resource
    CheckInfoMapper checkInfoMapper;
    @Resource
    InspectionInfoMapper inspectionInfoMapper;
    @Resource
    SnowflakeIdWorker snowflakeIdWorker;
    private static final String OUTPATIENT_PAYMENT = "1";

    public BaseResponse<CheckInspectionGroupDetailsListRes> queryReportHosList(ListReportHosReq param) throws ParseException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        LisReportListReq lisReportListReq = new LisReportListReq();
        lisReportListReq.setCardNO(param.getCardNo());
        lisReportListReq.setPatientType(OUTPATIENT_PAYMENT);
        lisReportListReq.setDtBegin(param.getBeginDate());
        lisReportListReq.setDtEnd(DateUtils.dateToString((Date)DateUtils.getDateAfter((Date)DateUtils.parseDate((String)param.getEndDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
        gatewayRequest.setBody((Object)lisReportListReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setOrganCode(param.getOrganCode());
        this.logger.info("\u8bf7\u6c42his\u524d\u7f6e\u673a\u5165\u53c2{}", (Object)JSON.toJSONString((Object)lisReportListReq));
        GatewayResponse checkInspectionGroupDetailsListResGatewayResponse = this.electronicReportClient.lisReportList(gatewayRequest);
        this.logger.info("his\u524d\u7f6e\u673a\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)checkInspectionGroupDetailsListResGatewayResponse));
        if (Objects.isNull(checkInspectionGroupDetailsListResGatewayResponse)) {
            return BaseResponse.error((String)"\u6682\u65e0\u62a5\u544a");
        }
        if (!OUTPATIENT_PAYMENT.equals(checkInspectionGroupDetailsListResGatewayResponse.getCode())) {
            return BaseResponse.error((String)"\u6682\u65e0\u62a5\u544a");
        }
        if (((CheckInspectionGroupDetailsListRes)checkInspectionGroupDetailsListResGatewayResponse.getData()).getCheckInspectionGroupDetailsResList().size() == 0) {
            return BaseResponse.error((String)"\u6682\u65e0\u62a5\u544a");
        }
        for (CheckInspectionGroupDetailsRes checkInspectionGroupDetailsRes : ((CheckInspectionGroupDetailsListRes)checkInspectionGroupDetailsListResGatewayResponse.getData()).getCheckInspectionGroupDetailsResList()) {
            checkInspectionGroupDetailsRes.setCheckDate(DateUtils.stringToString((String)checkInspectionGroupDetailsRes.getCheckDate()));
        }
        List collect = ((CheckInspectionGroupDetailsListRes)checkInspectionGroupDetailsListResGatewayResponse.getData()).getCheckInspectionGroupDetailsResList().stream().sorted(Comparator.comparing(CheckInspectionGroupDetailsRes::getCheckDate).reversed()).collect(Collectors.toList());
        CheckInspectionGroupDetailsListRes checkInspectionGroupDetailsListRes = new CheckInspectionGroupDetailsListRes();
        checkInspectionGroupDetailsListRes.setCheckInspectionGroupDetailsResList(collect);
        checkInspectionGroupDetailsListResGatewayResponse.setData((Object)checkInspectionGroupDetailsListRes);
        return BaseResponse.success((Object)checkInspectionGroupDetailsListResGatewayResponse.getData());
    }

    @Async
    public void insertList(ListReportHosReq param, GetReportListsRes gateWayData, ListReportHosRes data, List<ReportInfo> reportInfoList) {
        String patientName = gateWayData.getPatientName();
        String patientID = gateWayData.getPatientID();
        String patientNo = gateWayData.getPatientNo();
        ArrayList<TReportList> tReportLists = new ArrayList<TReportList>();
        for (ReportInfo reportInfo : reportInfoList) {
            TReportList tReportList = TReportList.builder().reportType(param.getReportType()).patientName(patientName).reportName(reportInfo.getReportName()).patientId(patientID).patientNo(Integer.valueOf(patientNo)).authTimet(reportInfo.getReportDate()).tsName(reportInfo.getTsName()).tsCode(reportInfo.getTsCode()).reportNo(reportInfo.getReportNo()).reportDate(reportInfo.getReportDate()).build();
            tReportLists.add(tReportList);
        }
        for (TReportList tReportList : tReportLists) {
            this.tReportListMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(TReportList::getReportNo, (Object)tReportList.getReportNo()));
            this.tReportListMapper.insert((Object)tReportList);
        }
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(ReportDetailReq param) {
        return BaseResponse.error((String)"\u9519\u8bef\u4ee5\u5f03\u7528\u4fe1\u606f");
    }

    @Async
    public void insertInspectionInfo(ReportDetailReq param, LisReportListRes gateWayData) {
        InspectionInfo inspectionInfo = InspectionInfo.builder().patientName(gateWayData.getPatientName()).reportName(gateWayData.getReportName()).reportNo(gateWayData.getReportNo()).patientNo(gateWayData.getPatientNo()).sex(gateWayData.getSex()).age(gateWayData.getAge()).deptName(gateWayData.getDeptName()).doctorName(gateWayData.getDoctorName()).wardName(gateWayData.getWardName()).bed(gateWayData.getBed()).room(gateWayData.getRoom()).specName(gateWayData.getSpecName()).recTime(gateWayData.getRecTime()).recUser(gateWayData.getRecUser()).authTime(gateWayData.getAuthTime()).authUser(gateWayData.getAuthUser()).colTime(gateWayData.getColTime()).print(gateWayData.getPrint()).patientDOB(gateWayData.getPatientDOB()).admType(gateWayData.getAdmType()).diagnosis(gateWayData.getDiagnosis()).build();
        List datas = gateWayData.getDatas();
        this.inspectionInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(InspectionInfo::getReportNo, (Object)param.getReportNo()));
        if (Objects.nonNull(datas) && !datas.isEmpty()) {
            for (LisReportListResData reportListResData : datas) {
                inspectionInfo.setItmCode(reportListResData.getItmCode());
                inspectionInfo.setItmEng(reportListResData.getItmEng());
                inspectionInfo.setItmName(reportListResData.getItmName());
                inspectionInfo.setItmType(reportListResData.getItmType());
                inspectionInfo.setItmRes(reportListResData.getItmRes());
                inspectionInfo.setItmUnit(reportListResData.getItmUnit());
                inspectionInfo.setItmRanges(reportListResData.getItmRanges());
                inspectionInfo.setItmCrises(reportListResData.getItmCrises());
                List micDatas = reportListResData.getMicDatas();
                if (Objects.nonNull(micDatas) && !micDatas.isEmpty()) {
                    for (LisReportListResMicData micData : micDatas) {
                        inspectionInfo.setAntCode(micData.getAntCode());
                        inspectionInfo.setAntName(micData.getAntName());
                        inspectionInfo.setMic(micData.getMic());
                        inspectionInfo.setSense(micData.getSense());
                        this.inspectionInfoMapper.insert((Object)inspectionInfo);
                    }
                    continue;
                }
                this.inspectionInfoMapper.insert((Object)inspectionInfo);
            }
        } else {
            this.inspectionInfoMapper.insert((Object)inspectionInfo);
        }
    }

    public BaseResponse<CheckReportDetailsRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        PacsReportListReq pacsReportListReq = new PacsReportListReq();
        pacsReportListReq.setReportNo(param.getReportNo());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)pacsReportListReq);
        GatewayResponse response = this.electronicReportClient.pacsReportList(gatewayRequest);
        PacsReportListRes gateWayData = (PacsReportListRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        CheckReportDetailsRes reportDetail = new CheckReportDetailsRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reportDetail.getAge()})) {
            reportDetail.setAge(reportDetail.getAge().replace("\u5c81", ""));
        }
        reportDetail.setCheckImages(gateWayData.getCheckImages());
        this.insertCheckInfo(param, gateWayData);
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<GetEleInvoiceListRes> eleInvoiceList(GetEleInvoiceListReqVo param) {
        GetEleInvoiceListReq getEleInvoiceListReq = new GetEleInvoiceListReq();
        BeanUtils.copyProperties((Object)param, (Object)getEleInvoiceListReq);
        GatewayRequest gateWayParam = this.getGateWayParam((NetReportBaseRequest)param, (Object)getEleInvoiceListReq);
        GatewayResponse gatewayResponse = this.electronicReportClient.eleInvoiceList(gateWayParam);
        GetEleInvoiceListRes getEleInvoiceListRes = (GetEleInvoiceListRes)this.checkHisResponse((BaseResponse)gatewayResponse);
        if (getEleInvoiceListRes == null) {
            return BaseResponse.success();
        }
        return BaseResponse.success((Object)getEleInvoiceListRes);
    }

    public BaseResponse<GetAppointmentHistoryListRespVo> getHistoryAppointment(GetHistoryReqVo getHistoryReqVo) throws ParseException {
        getHistoryReqVo.setEndTime(DateUtils.dateToString((Date)DateUtils.getDateAfter((Date)DateUtils.parseDate((String)getHistoryReqVo.getEndTime(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
        GetAppointOrOutPatientHistoryListReq getAppointOrOutPatientHistoryListReq = new GetAppointOrOutPatientHistoryListReq();
        BeanUtils.copyProperties((Object)getHistoryReqVo, (Object)getAppointOrOutPatientHistoryListReq);
        GatewayRequest gateWayParam = this.getGateWayParam((NetReportBaseRequest)getHistoryReqVo, (Object)getAppointOrOutPatientHistoryListReq);
        GatewayResponse gatewayResponse = this.electronicReportClient.getHistoryAppointment(gateWayParam);
        GetAppointmentHistoryListRespVo getAppointmentHistoryListRespVo = (GetAppointmentHistoryListRespVo)this.checkHisResponse((BaseResponse)gatewayResponse);
        if (getAppointmentHistoryListRespVo == null) {
            return BaseResponse.success();
        }
        List getAppointmentHistoryDateRespVoList = getAppointmentHistoryListRespVo.getGetAppointmentHistoryDateRespVoList();
        if (CollectionUtils.isEmpty((Collection)getAppointmentHistoryDateRespVoList)) {
            return BaseResponse.success();
        }
        getAppointmentHistoryDateRespVoList.sort(Comparator.comparing(GetAppointmentHistoryDateRespVo::getFeeDate, Comparator.reverseOrder()));
        for (GetAppointmentHistoryDateRespVo getAppointmentHistoryDateRespVo : getAppointmentHistoryDateRespVoList) {
            getAppointmentHistoryDateRespVo.setFeeDate(DateUtils.stringToString((String)getAppointmentHistoryDateRespVo.getFeeDate()));
            getAppointmentHistoryDateRespVo.setRegDate(DateUtils.stringToString((String)getAppointmentHistoryDateRespVo.getRegDate()));
        }
        return BaseResponse.success((Object)getAppointmentHistoryListRespVo);
    }

    public BaseResponse<List<GetHistoryOutPatientRespVo>> getHistoryOutPatient(GetHistoryReqVo getHistoryReqVo) throws ParseException {
        getHistoryReqVo.setEndTime(DateUtils.dateToString((Date)DateUtils.getDateAfter((Date)DateUtils.parseDate((String)getHistoryReqVo.getEndTime(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
        ArrayList getHistoryOutPatientRespVoList = new ArrayList();
        GetAppointOrOutPatientHistoryListReq getAppointOrOutPatientHistoryListReq = new GetAppointOrOutPatientHistoryListReq();
        BeanUtils.copyProperties((Object)getHistoryReqVo, (Object)getAppointOrOutPatientHistoryListReq);
        GatewayRequest gateWayParam = this.getGateWayParam((NetReportBaseRequest)getHistoryReqVo, (Object)getAppointOrOutPatientHistoryListReq);
        GatewayResponse gatewayResponse = this.electronicReportClient.getHistoryOutPatient(gateWayParam);
        GetHistoryOutPatientListRespVo getHistoryOutPatientListRespVo = (GetHistoryOutPatientListRespVo)this.checkHisResponse((BaseResponse)gatewayResponse);
        if (getHistoryOutPatientListRespVo == null) {
            return BaseResponse.success();
        }
        List getHistoryOutPatientDataRespVoList = getHistoryOutPatientListRespVo.getGetHistoryOutPatientDataRespVoList();
        if (CollectionUtils.isEmpty((Collection)getHistoryOutPatientDataRespVoList)) {
            return BaseResponse.success();
        }
        getHistoryOutPatientDataRespVoList.sort(Comparator.comparing(GetHistoryOutPatientDataRespVo::getFeeDate, Comparator.reverseOrder()));
        LinkedHashMap collect = getHistoryOutPatientDataRespVoList.stream().collect(Collectors.groupingBy(GetHistoryOutPatientDataRespVo::getRecipeNO, LinkedHashMap::new, Collectors.toList()));
        collect.keySet().forEach(recipe -> {
            GetHistoryOutPatientRespVo getHistoryOutPatientRespVo = new GetHistoryOutPatientRespVo();
            GetHistoryOutPatientDataRespVo getHistoryOutPatientDataRespVo = (GetHistoryOutPatientDataRespVo)((List)collect.get(recipe)).get(0);
            getHistoryOutPatientRespVo.setDeptName(getHistoryOutPatientDataRespVo.getExecDept());
            getHistoryOutPatientRespVo.setDocName(getHistoryOutPatientDataRespVo.getDoctName());
            getHistoryOutPatientRespVo.setFeeDate(getHistoryOutPatientDataRespVo.getFeeDate().replace("T", " "));
            getHistoryOutPatientRespVo.setGetHistoryOutPatientDataRespVoList((List)collect.get(recipe));
            BigDecimal cost = new BigDecimal("0");
            for (GetHistoryOutPatientDataRespVo historyOutPatientDataRespVo : (List)collect.get(recipe)) {
                cost = cost.add(new BigDecimal(historyOutPatientDataRespVo.getCost()));
                historyOutPatientDataRespVo.setFeeDate(historyOutPatientDataRespVo.getFeeDate().replace("T", " "));
            }
            getHistoryOutPatientRespVo.setCost(cost);
            getHistoryOutPatientRespVoList.add(getHistoryOutPatientRespVo);
        });
        return BaseResponse.success(getHistoryOutPatientRespVoList);
    }

    @Async
    public void insertCheckInfo(CheckReportDetailsReq param, PacsReportListRes gateWayData) {
        List checkImages = gateWayData.getCheckImages();
        String images = checkImages.stream().map(String::valueOf).collect(Collectors.joining(";"));
        CheckInfo checkInfo = CheckInfo.builder().patientName(gateWayData.getPatientName()).reportName(gateWayData.getReportName()).reportNo(param.getReportNo()).patientNo(gateWayData.getPatientNo()).sex(gateWayData.getSex()).age(gateWayData.getAge()).deptName(gateWayData.getDeptName()).doctorName(gateWayData.getDoctorName()).wardName(gateWayData.getWardName()).bed(gateWayData.getBed()).room(gateWayData.getRoom()).authTime(gateWayData.getAuthTime()).authUser(gateWayData.getAuthUser()).print(gateWayData.getPrint()).patientDOB(gateWayData.getPatientDOB()).admType(gateWayData.getAdmType()).checkDesc(gateWayData.getCheckDesc()).checkResult(gateWayData.getCheckResult()).checkImages(images).build();
        this.checkInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(CheckInfo::getReportNo, (Object)param.getReportNo()));
        this.checkInfoMapper.insert((Object)checkInfo);
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> T checkHisResponse(BaseResponse<T> response) {
        if (response == null) {
            this.logger.error("request his gateway error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!response.isSuccess()) {
            this.logger.error("request his gateway error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getData() == null) {
            this.logger.error("request his gateway error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        return (T)response.getData();
    }

    private <T> GatewayRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setOrganCode(baseRequest.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}", (Object)transactionId);
        return gatewayRequest;
    }
}

