/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoResItem;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillReqVo;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.exception.BillException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.excel.AppointmentOrderExcelEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckOrderReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckOrderResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutPatientOrderRecordResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutPatientOrderRecordReqVo;
import com.ebaiyihui.wisdommedical.service.OrderService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.ExcelUtils;
import com.ebaiyihui.wisdommedical.util.IdCardUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    public static final String GET_REAL_TIME_HIS_BILL_INFO = "getRealTimeHisBillInfo";
    public static final String REFUND_FLAG = "1";
    public static final String NOT_REFUND_FLAG = "0";
    public static final List<String> APPOINT_ORDER_STATUS_LIST = Arrays.asList("11", "15", "17", "18");
    public static final List<String> WAIT_STATUS_LIST = Arrays.asList("11", "3");
    public static final List<String> CANCEL_STATUS_LIST = Arrays.asList("4", "5");
    public static final List<String> WAIT_REFUND_CONFIRM_STATUS_LIST = Arrays.asList("6", "8");
    public static final List<String> OUTPATIENT_ORDER_STATUS_LIST = Arrays.asList("1", "3", "8", "9", "10", "11", "12");
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper depositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper payorderEntityMapper;

    public OrderRecordPageResult getAppointmentOrderList(OrderRecordReqVo orderRecordReqVo) {
        OrderRecordPageResult pageResult = new OrderRecordPageResult();
        String orderStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)APPOINT_ORDER_STATUS_LIST, (String)"','") + "'" : (AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)WAIT_STATUS_LIST, (String)"','") + "'" : (AppointmentStatusEnum.CANCEL.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)CANCEL_STATUS_LIST, (String)"','") + "'" : (AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)WAIT_REFUND_CONFIRM_STATUS_LIST, (String)"','") + "'" : orderRecordReqVo.getOrderStatus())));
        orderRecordReqVo.setOrderStatus(orderStatus);
        log.info("\u3010\u7ba1\u7406\u7aef\u67e5\u8be2\u6302\u53f7\u8ba2\u5355\u5217\u8868\u3011\u5165\u53c2\u53c2\u6570 orderStatus: " + JSON.toJSONString((Object)orderStatus));
        log.info("\u3010\u7ba1\u7406\u7aef\u67e5\u8be2\u6302\u53f7\u8ba2\u5355\u5217\u8868\u3011\u5165\u53c2\u53c2\u6570 orderRecordReqVo: " + JSON.toJSONString((Object)orderRecordReqVo));
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        Page page = this.appointmentRecordMapper.selectPageByOrderRecordReqVo(orderRecordReqVo);
        int totalCount = this.appointmentRecordMapper.getOrderRecordTotalCount(orderRecordReqVo.getHospitalCode());
        int cancelCount = this.appointmentRecordMapper.getOrderRecordCancel(orderRecordReqVo.getHospitalCode());
        int returnCount = this.appointmentRecordMapper.getOrderRecordReturn(orderRecordReqVo.getHospitalCode());
        pageResult.setTotalCount(Integer.valueOf(totalCount));
        pageResult.setCancelCount(Integer.valueOf(cancelCount));
        pageResult.setReturnCount(Integer.valueOf(returnCount));
        List appointmentRecordEntityList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)appointmentRecordEntityList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        List orderRecordResVoList = this.getOrderRecordResVoList(appointmentRecordEntityList);
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
        } else {
            pageResult.setContent(orderRecordResVoList);
        }
        Long total = page.getTotal();
        log.info("total: " + JSON.toJSONString((Object)total));
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        return pageResult;
    }

    public CheckOrderResVo checkAppointmentOrderWhetherRefund(CheckOrderReqVo checkOrderReqVo) throws BillException {
        CheckOrderResVo checkOrderResVo = new CheckOrderResVo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(checkOrderReqVo.getSysAppointmentId());
        if (null == appointmentRecordEntity) {
            throw new BillException("\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        checkOrderResVo.setPatientName(appointmentRecordEntity.getPatientName());
        checkOrderResVo.setReceiptId(appointmentRecordEntity.getReceptId());
        checkOrderResVo.setPatientIdCard(appointmentRecordEntity.getPatientIdCard());
        checkOrderResVo.setPayBillNo(appointmentRecordEntity.getPayTransationId());
        checkOrderResVo.setRemark(appointmentRecordEntity.getRemark());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (APPOINT_ORDER_STATUS_LIST.contains(String.valueOf(appointStatus))) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        } else {
            checkOrderResVo.setAppointStatus(appointStatus);
        }
        List items = this.buildGetRealTimeHisBillReq(checkOrderReqVo);
        if (CollectionUtils.isEmpty((Collection)items)) {
            checkOrderResVo.setRefundFlag(REFUND_FLAG);
            return checkOrderResVo;
        }
        checkOrderResVo.setRefundFlag(NOT_REFUND_FLAG);
        if (items.size() > 1) {
            checkOrderResVo.setRechargeMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
            checkOrderResVo.setDeductMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
        }
        checkOrderResVo.setRechargeMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
        return checkOrderResVo;
    }

    public OutPatientOrderRecordPageResult getOutPatientOrderList(OutPatientOrderRecordReqVo orderRecordReqVo) {
        OutPatientOrderRecordPageResult pageResult = new OutPatientOrderRecordPageResult();
        String orderStatusReq = REFUND_FLAG.equals(orderRecordReqVo.getOrderStatus()) ? "'" + StringUtils.join((Collection)OUTPATIENT_ORDER_STATUS_LIST, (String)"','") + "'" : orderRecordReqVo.getOrderStatus();
        orderRecordReqVo.setOrderStatus(orderStatusReq);
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u5217\u8868\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderRecordReqVo));
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        Page page = this.opBusinessOrderEntityMapper.selectByOrderRecordReqVo(orderRecordReqVo);
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u5217\u8868\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)page));
        int totalCount = this.opBusinessOrderEntityMapper.getOrderRecordCount(orderRecordReqVo.getHospitalCode());
        pageResult.setTotalCount(Integer.valueOf(totalCount));
        List orderRecordResVoList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        for (OutPatientOrderRecordResVo orderRecordResVo : orderRecordResVoList) {
            String orderStatus = String.valueOf(orderRecordResVo.getOrderStatus());
            if (OUTPATIENT_ORDER_STATUS_LIST.contains(orderStatus)) {
                orderStatus = REFUND_FLAG;
            }
            orderRecordResVo.setOrderStatus(Integer.valueOf(Integer.parseInt(orderStatus)));
        }
        pageResult.setContent(orderRecordResVoList);
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        return pageResult;
    }

    public OutPatientOrderRecordVo getOutPatientOrderDetail(String outPatientId) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        List list = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity || CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        OutPatientOrderRecordVo outPatientOrderRecordVo = new OutPatientOrderRecordVo();
        outPatientOrderRecordVo.setPatientName(opBusinessOrderEntity.getPatientName());
        outPatientOrderRecordVo.setSex(opBusinessOrderEntity.getPatientGender());
        outPatientOrderRecordVo.setAge(Integer.valueOf(opBusinessOrderEntity.getPatientAge()));
        outPatientOrderRecordVo.setDeptName(opBusinessOrderEntity.getDeptName());
        outPatientOrderRecordVo.setDocName(opBusinessOrderEntity.getDocName());
        outPatientOrderRecordVo.setAdmDate(opBusinessOrderEntity.getAdmTime());
        outPatientOrderRecordVo.setOutPatientId(outPatientId);
        outPatientOrderRecordVo.setCreateTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getCreateTime()));
        if (null != opBusinessOrderEntity.getPayTime() && !"".equals(opBusinessOrderEntity.getPayTime())) {
            outPatientOrderRecordVo.setPayTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getPayTime()));
        }
        outPatientOrderRecordVo.setAmount(String.valueOf(opBusinessOrderEntity.getMoney()));
        ArrayList<OutPatientOrderRecordDetailVo> orderRecordDetailVoList = new ArrayList<OutPatientOrderRecordDetailVo>();
        for (OpBusinessOrderDetailEntity entity : list) {
            OutPatientOrderRecordDetailVo outPatientOrderRecordDetailVo = new OutPatientOrderRecordDetailVo();
            outPatientOrderRecordDetailVo.setItemType(entity.getItemType());
            outPatientOrderRecordDetailVo.setItemName(entity.getItemName());
            outPatientOrderRecordDetailVo.setNum(Integer.valueOf(entity.getQuantity().intValue()));
            outPatientOrderRecordDetailVo.setPrice(entity.getPrice());
            outPatientOrderRecordDetailVo.setAmount(entity.getMoney());
            orderRecordDetailVoList.add(outPatientOrderRecordDetailVo);
        }
        outPatientOrderRecordVo.setOutPatientOrderRecordDetailVoList(orderRecordDetailVoList);
        return outPatientOrderRecordVo;
    }

    public CheckOrderResVo checkOutPatientOrderWhetherRefund(CheckOrderReqVo checkOrderReqVo) throws BillException {
        CheckOrderResVo checkOrderResVo = new CheckOrderResVo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(checkOrderReqVo.getOutPatientId());
        if (null == opBusinessOrderEntity) {
            throw new BillException("\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        checkOrderResVo.setPatientName(opBusinessOrderEntity.getPatientName());
        checkOrderResVo.setReceiptId(opBusinessOrderEntity.getReceiptId());
        checkOrderResVo.setPatientIdCard(opBusinessOrderEntity.getIdCard());
        checkOrderResVo.setPayBillNo(checkOrderReqVo.getPayBillNo());
        checkOrderResVo.setRemark(opBusinessOrderEntity.getRemark());
        Integer orderStatus = opBusinessOrderEntity.getStatus();
        if (OUTPATIENT_ORDER_STATUS_LIST.contains(orderStatus)) {
            orderStatus = 1;
        }
        checkOrderResVo.setOrderStatus(orderStatus);
        List items = this.buildGetRealTimeHisBillReq(checkOrderReqVo);
        if (CollectionUtils.isEmpty((Collection)items)) {
            checkOrderResVo.setRefundFlag(REFUND_FLAG);
            return checkOrderResVo;
        }
        if (items.size() > 1) {
            checkOrderResVo.setRechargeMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
            checkOrderResVo.setDeductMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
        }
        checkOrderResVo.setRefundFlag(NOT_REFUND_FLAG);
        checkOrderResVo.setRechargeMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
        return checkOrderResVo;
    }

    public void reportExcelAppointmentOrderList(OrderRecordReqVo orderRecordReqVo, HttpServletResponse response) {
        String orderStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)APPOINT_ORDER_STATUS_LIST, (String)"','") + "'" : (AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)WAIT_STATUS_LIST, (String)"','") + "'" : (AppointmentStatusEnum.CANCEL.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)CANCEL_STATUS_LIST, (String)"','") + "'" : (AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)WAIT_REFUND_CONFIRM_STATUS_LIST, (String)"','") + "'" : orderRecordReqVo.getOrderStatus())));
        orderRecordReqVo.setOrderStatus(orderStatus);
        List appointmentRecordEntityList = this.appointmentRecordMapper.selectReportExcelByOrderRecordReqVo(orderRecordReqVo);
        if (CollectionUtils.isEmpty((Collection)appointmentRecordEntityList)) {
            return;
        }
        List orderRecordResVoList = this.getOrderRecordResVoList(appointmentRecordEntityList);
        List appointmentOrderExcelEntityList = BeanUtil.copyToList((Collection)orderRecordResVoList, AppointmentOrderExcelEntity.class);
        for (AppointmentOrderExcelEntity appointmentOrderExcelEntity : appointmentOrderExcelEntityList) {
            Integer status = appointmentOrderExcelEntity.getOrderStatus();
            Integer appointType = appointmentOrderExcelEntity.getAppointType();
            if (appointmentOrderExcelEntity.getOrderStatus() == 2) {
                appointmentOrderExcelEntity.setStatusRemark("\u5f85\u652f\u4ed8");
            } else if (appointmentOrderExcelEntity.getOrderStatus() == 5 || appointmentOrderExcelEntity.getOrderStatus() == 4) {
                appointmentOrderExcelEntity.setStatusRemark("\u5df2\u53d6\u6d88");
            } else if (appointmentOrderExcelEntity.getOrderStatus() == 6 || appointmentOrderExcelEntity.getOrderStatus() == 8) {
                appointmentOrderExcelEntity.setStatusRemark("\u5df2\u9000\u53f7");
            } else if (appointmentOrderExcelEntity.getOrderStatus() == 7) {
                appointmentOrderExcelEntity.setStatusRemark("\u6302\u53f7\u6210\u529f");
            } else if (appointmentOrderExcelEntity.getOrderStatus() == 11) {
                appointmentOrderExcelEntity.setStatusRemark("\u5f85\u786e\u8ba4");
            } else if (appointmentOrderExcelEntity.getOrderStatus() == 16) {
                appointmentOrderExcelEntity.setStatusRemark("\u6302\u53f7\u5931\u8d25");
            }
            if (appointType == 1) {
                appointmentOrderExcelEntity.setAppointTypeRemark("\u81ea\u8d39(\u9884\u7ea6)");
            } else if (appointType == 2) {
                appointmentOrderExcelEntity.setAppointTypeRemark("\u81ea\u8d39(\u5f53\u65e5)");
            } else if (appointType == 3) {
                appointmentOrderExcelEntity.setAppointTypeRemark("\u533b\u4fdd");
            }
            appointmentOrderExcelEntity.setCreateTime(DateUtils.dateToFullString((Date)appointmentOrderExcelEntity.getOrderDate()));
            appointmentOrderExcelEntity.setPatientIdCard(IdCardUtils.desensitizedIdNumber((String)appointmentOrderExcelEntity.getPatientIdCard()));
        }
        String fileName = DateUtils.getCurrentDateSimpleNoSpeToString() + "-\u6302\u53f7\u8ba2\u5355\u8ba2\u5355-\u4fdd\u5b9a\u5e02\u7b2c\u4e00\u4e2d\u533b\u9662";
        ExcelUtils.exportExcel((List)appointmentOrderExcelEntityList, null, null, AppointmentOrderExcelEntity.class, (String)fileName, (boolean)true, (HttpServletResponse)response);
    }

    private List<GetRealTimeHisBillInfoResItem> buildGetRealTimeHisBillReq(CheckOrderReqVo checkOrderReqVo) throws BillException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetRealTimeHisBillReqVo getRealTimeHisBillReqVo = new GetRealTimeHisBillReqVo();
        getRealTimeHisBillReqVo.setTransType(checkOrderReqVo.getTransType());
        getRealTimeHisBillReqVo.setCardNo(checkOrderReqVo.getCardNo());
        getRealTimeHisBillReqVo.setOrderid(checkOrderReqVo.getPayBillNo());
        gatewayRequest.setBody((Object)getRealTimeHisBillReqVo);
        gatewayRequest.setKeyWord(GET_REAL_TIME_HIS_BILL_INFO);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setChannel(ChannelEnum.MANAGER.getValue());
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getDisplay());
        log.info("\u9a8c\u8bc1\u662f\u5426\u53ef\u9000\u6b3e \u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.hisBillApi.getRealTimeHisBillInfo(gatewayRequest);
        log.info("\u9a8c\u8bc1\u662f\u5426\u53ef\u9000\u6b3e \u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        if (!REFUND_FLAG.equals(gatewayResponse.getCode())) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        GetRealTimeHisBillInfoRes getRealTimeHisBillInfoRes = (GetRealTimeHisBillInfoRes)gatewayResponse.getData();
        return getRealTimeHisBillInfoRes.getItems();
    }

    private List<OrderRecordResVo> getOrderRecordResVoList(List<AppointmentRecordEntity> orderRecordResVoList) {
        ArrayList<OrderRecordResVo> manageOrderRecordResVoList = new ArrayList<OrderRecordResVo>();
        if (null == orderRecordResVoList || orderRecordResVoList.isEmpty()) {
            return null;
        }
        for (AppointmentRecordEntity appointmentRecordEntity : orderRecordResVoList) {
            OrderRecordResVo orderRecordResVo = new OrderRecordResVo();
            String admDate = appointmentRecordEntity.getAdmDate();
            String admTimeRange = appointmentRecordEntity.getAdmTimeRange();
            if (Objects.equals("null-null", admTimeRange)) {
                orderRecordResVo.setAppointmentTime(admDate);
            } else {
                orderRecordResVo.setAppointmentTime(admDate + " " + admTimeRange);
            }
            orderRecordResVo.setDeptName(appointmentRecordEntity.getDeptName());
            orderRecordResVo.setDoctorName(appointmentRecordEntity.getDocName());
            orderRecordResVo.setOrderDate(appointmentRecordEntity.getCreatetime());
            orderRecordResVo.setOrderMoney(appointmentRecordEntity.getPayAmount());
            orderRecordResVo.setOrderSeq(appointmentRecordEntity.getSysAppointmentId());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (APPOINT_ORDER_STATUS_LIST.contains(String.valueOf(appointStatus))) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            orderRecordResVo.setOrderStatus(appointStatus);
            orderRecordResVo.setPatientIdCard(appointmentRecordEntity.getPatientIdCard());
            orderRecordResVo.setPatientName(appointmentRecordEntity.getPatientName());
            orderRecordResVo.setAppointType(Integer.valueOf(appointmentRecordEntity.getAppointmentType()));
            manageOrderRecordResVoList.add(orderRecordResVo);
        }
        return manageOrderRecordResVoList;
    }
}

