/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryAccountInfoResVo;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.ItemTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.OrderTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.RefundReq;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.PayItemDatasDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthRegisteredResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RechargeCardToHosReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetAdmissionRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetPayItemRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GuidedInfoResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ItemTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderDetailRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PayItemResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PaySuccessInfoRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetPayItemReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.QueryOutPatientPayStatusReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.RefundOrderVoReq;
import com.ebaiyihui.wisdommedical.service.ICardService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final byte OUTPATIENT_DEPARTMENT = 1;
    public static final byte EMERGENCY_TREATMENT = 2;
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    public static final String WECHAT = "WECHAT";
    public static final String ALIPAY = "ALIPAY";
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private EncryptUtils encryptUtils;
    @Autowired
    private ICardService iCardService;

    public List<GetAdmissionRespVO> getAdmission(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        GatewayRequest gatewayRequest = this.buildGetAdmissionGatewayReq(getAdmissionReqVO);
        log.info("OutpatientPaymentServiceImpl.getAdmission->\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
        List getAdmissionItemsList = this.getAdmission(gatewayRequest);
        return this.buildOutpatientPaymentRespVOList(getAdmissionItemsList, getAdmissionReqVO.getCardId());
    }

    private List<GetAdmissionItems> getAdmission(GatewayRequest<GetAdmissionReq> gatewayRequest) throws OutpatientPaymentException {
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getAdmission(gatewayRequest);
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868:" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (null == gatewayResponse.getData()) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        GetAdmissionRes getAdmissionRes = (GetAdmissionRes)gatewayResponse.getData();
        if (null == getAdmissionRes.getItems() || getAdmissionRes.getItems().isEmpty()) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
        }
        return getAdmissionRes.getItems();
    }

    private List<GetAdmissionRespVO> buildOutpatientPaymentRespVOList(List<GetAdmissionItems> getAdmissionItemsList, String cardId) {
        if (CollectionUtils.isEmpty(getAdmissionItemsList)) {
            return new ArrayList<GetAdmissionRespVO>();
        }
        List<GetAdmissionRespVO> listOutpatientPaymentRespVOs = getAdmissionItemsList.stream().map(getAdmissionItems -> {
            GetAdmissionRespVO getAdmissionRespVO = new GetAdmissionRespVO();
            BeanUtils.copyProperties((Object)getAdmissionItems, (Object)getAdmissionRespVO);
            String date = getAdmissionItems.getAdmDate().split(" ")[0];
            if (date.contains("\u5e74") || date.contains("\u6708") || date.contains("\u65e5")) {
                getAdmissionRespVO.setAdmDate(DateUtils.hzToString((String)date));
            } else {
                getAdmissionRespVO.setAdmDate(date);
            }
            getAdmissionRespVO.setCardId(cardId);
            getAdmissionRespVO.setPayStatus("0");
            OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByAdmId(getAdmissionItems.getAdmId());
            if (Objects.nonNull(opBusinessOrderEntity)) {
                getAdmissionRespVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
            }
            return getAdmissionRespVO;
        }).collect(Collectors.toList());
        return listOutpatientPaymentRespVOs;
    }

    private GatewayRequest<GetAdmissionReq> buildGetAdmissionGatewayReq(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        GetAdmissionReq getAdmissionReq = new GetAdmissionReq();
        getAdmissionReq.setBgDate(getAdmissionReqVO.getBgDate());
        getAdmissionReq.setEdDate(getAdmissionReqVO.getEdDate());
        getAdmissionReq.setCardNo(getAdmissionReqVO.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("getAdmission");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)getAdmissionReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public GetPayItemRespVO getPayItem(GetPayItemReqVO getPayItemReqVO) throws OutpatientPaymentException {
        GetPayItemRespVO getPayItemRespVO = new GetPayItemRespVO();
        GatewayRequest gatewayRequest = this.buildPayItemGatewayReq(getPayItemReqVO);
        log.info("OutpatientPaymentServiceImpl.getPayItem->\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
        PayItemRes payItemRes = this.payItem(gatewayRequest);
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(getPayItemReqVO.getCardId());
        String outPatientId = String.valueOf(this.snowflakeIdWorker.nextId());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
        getPayItemRespVO.setOutPatientId(outPatientId);
        this.buildPayItemDatasRespVO(outPatientId, getPayItemReqVO, getPayItemRespVO, payItemRes, cardDetailsInfoRespVO);
        PayItemDatasDTO payItemDatasDTO = this.buildPayItemDatasDTOForRedis(outPatientId, getPayItemReqVO, payItemRes, cardDetailsInfoRespVO);
        String payItemDatasDTOStr = JSON.toJSONString((Object)payItemDatasDTO);
        this.jedisCluster.set(outPatientId, payItemDatasDTOStr);
        this.jedisCluster.expire(outPatientId, 7200);
        return getPayItemRespVO;
    }

    private PayItemRes payItem(GatewayRequest<PayItemReq> gatewayRequest) throws OutpatientPaymentException {
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.payItem(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (null == gatewayResponse.getData()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        PayItemRes payItemRes = (PayItemRes)gatewayResponse.getData();
        if (null == payItemRes.getDatas() || payItemRes.getDatas().isEmpty()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
        }
        return payItemRes;
    }

    private void buildPayItemDatasRespVO(String outPatientId, GetPayItemReqVO getPayItemReqVO, GetPayItemRespVO getPayItemRespVO, PayItemRes payItemRes, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        getPayItemRespVO.setOutPatientId(outPatientId);
        getPayItemRespVO.setName(cardDetailsInfoRespVO.getPatientName());
        getPayItemRespVO.setSex(cardDetailsInfoRespVO.getGender().toString());
        getPayItemRespVO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        getPayItemRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        getPayItemRespVO.setAdmDate(getPayItemReqVO.getAdmDate());
        getPayItemRespVO.setCreateTime(DateUtils.dateToFullString((Date)new Date()));
        List payItemResVos = this.buildPayItemResVoList((List)payItemRes.getDatas(), getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        getPayItemRespVO.setAmount(amount.toString());
        getPayItemRespVO.setPayItemResVoList(payItemResVos);
        getPayItemRespVO.setCardNo(getPayItemReqVO.getCardNo());
        getPayItemRespVO.setDeptName(getPayItemReqVO.getDeptName());
        getPayItemRespVO.setDocName(getPayItemReqVO.getDocName());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
    }

    private List<PayItemResVo> buildPayItemResVoList(List<PayItemResDatas> payItemResDatasList, String admId) {
        ArrayList<PayItemResVo> payItemResList = new ArrayList<PayItemResVo>();
        PayItemResVo treatmentPayItemResVo = this.buildPayItemResVo(payItemResDatasList);
        if (null != treatmentPayItemResVo) {
            payItemResList.add(treatmentPayItemResVo);
        }
        return payItemResList;
    }

    private PayItemResVo buildPayItemResVo(List<PayItemResDatas> payList) {
        if (!CollectionUtils.isEmpty(payList)) {
            PayItemResVo payItemResVo = new PayItemResVo();
            BigDecimal amount = BigDecimal.ZERO;
            ArrayList items = new ArrayList();
            ArrayList feeIdList = new ArrayList();
            for (PayItemResDatas payItemResDatas : payList) {
                amount = amount.add(new BigDecimal(payItemResDatas.getAmount()));
                items.addAll(payItemResDatas.getItems());
            }
            payItemResVo.setFeeId(feeIdList);
            payItemResVo.setItemType(payList.get(0).getItemType());
            payItemResVo.setItems(items);
            payItemResVo.setAmount(amount.toString());
            return payItemResVo;
        }
        return null;
    }

    private PayItemDatasDTO buildPayItemDatasDTOForRedis(String outPatientId, GetPayItemReqVO getPayItemReqVO, PayItemRes payItemRes, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        PayItemDatasDTO payItemDatasDTO = new PayItemDatasDTO();
        payItemDatasDTO.setIdCard(cardDetailsInfoRespVO.getCredNo());
        payItemDatasDTO.setUserId(getPayItemReqVO.getUserId());
        payItemDatasDTO.setOutPatientId(outPatientId);
        payItemDatasDTO.setPatientId(cardDetailsInfoRespVO.getOrganPmi());
        payItemDatasDTO.setPatientOrganId(cardDetailsInfoRespVO.getOrganPmi());
        payItemDatasDTO.setCardId(cardDetailsInfoRespVO.getCardId());
        payItemDatasDTO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        String date = getPayItemReqVO.getAdmDate();
        if (date.contains("\u5e74") || date.contains("\u6708") || date.contains("\u65e5")) {
            payItemDatasDTO.setAdmDate(DateUtils.hzToString((String)date));
        } else {
            payItemDatasDTO.setAdmDate(date);
        }
        payItemDatasDTO.setAdmType(getPayItemReqVO.getAdmType());
        payItemDatasDTO.setName(cardDetailsInfoRespVO.getPatientName());
        payItemDatasDTO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        payItemDatasDTO.setSex(cardDetailsInfoRespVO.getGender().toString());
        payItemDatasDTO.setAdmId(getPayItemReqVO.getAdmId());
        payItemDatasDTO.setDeptName(getPayItemReqVO.getDeptName());
        payItemDatasDTO.setDeptCode(getPayItemReqVO.getDeptCode());
        payItemDatasDTO.setDocName(getPayItemReqVO.getDocName());
        payItemDatasDTO.setDocCode(getPayItemReqVO.getDocCode());
        List payItemResVos = this.buildPayItemResVoList((List)payItemRes.getDatas(), getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        payItemDatasDTO.setAmount(amount.toString());
        payItemDatasDTO.setPayItemResVoList(payItemResVos);
        return payItemDatasDTO;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) throws OutpatientPaymentException {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        log.info("\u83b7\u53d6\u5c31\u8bca\u5361\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cardDetailsInfoReqVO));
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private GatewayRequest<PayItemReq> buildPayItemGatewayReq(GetPayItemReqVO getPayItemReqVO) {
        PayItemReq payItemReq = new PayItemReq();
        payItemReq.setAdmId(getPayItemReqVO.getAdmId());
        payItemReq.setCardNo(getPayItemReqVO.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("payItem");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getPayItemReqVO.getChannelCode()));
        gatewayRequest.setChannel(getPayItemReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)payItemReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private OpBusinessOrderEntity buildOpBusinessOrderEntity(PayItemDatasDTO payItemDatasDTO, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opBusinessOrderEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
        opBusinessOrderEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        opBusinessOrderEntity.setOrganName(outpatientPaymentReqVO.getHospitalName());
        opBusinessOrderEntity.setAdmId(payItemDatasDTO.getAdmId());
        opBusinessOrderEntity.setAdmTime(payItemDatasDTO.getAdmDate());
        if ("E".equals(payItemDatasDTO.getAdmType())) {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)2));
        } else {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)1));
        }
        opBusinessOrderEntity.setDeptName(payItemDatasDTO.getDeptName());
        opBusinessOrderEntity.setDeptCode(payItemDatasDTO.getDeptCode());
        opBusinessOrderEntity.setDocName(payItemDatasDTO.getDocName());
        opBusinessOrderEntity.setDocCode(payItemDatasDTO.getDocCode());
        opBusinessOrderEntity.setPatientId(payItemDatasDTO.getPatientId());
        opBusinessOrderEntity.setPatientOrganId(payItemDatasDTO.getPatientOrganId());
        opBusinessOrderEntity.setPatientName(payItemDatasDTO.getName());
        opBusinessOrderEntity.setPatientGender(Integer.valueOf(Integer.parseInt(payItemDatasDTO.getSex())));
        opBusinessOrderEntity.setPatientAge(payItemDatasDTO.getAge());
        opBusinessOrderEntity.setCardNo(payItemDatasDTO.getCardNo());
        opBusinessOrderEntity.setCardId(payItemDatasDTO.getCardId());
        opBusinessOrderEntity.setIdCard(payItemDatasDTO.getIdCard());
        opBusinessOrderEntity.setUserId(payItemDatasDTO.getUserId());
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.NOT_PAY.getValue());
        opBusinessOrderEntity.setMoney(new BigDecimal(payItemDatasDTO.getAmount()));
        opBusinessOrderEntity.setReceiptId(payItemDatasDTO.getFeeIds());
        return opBusinessOrderEntity;
    }

    private List<OpBusinessOrderDetailEntity> buildOpBusinessOrderDetailEntity(PayItemDatasDTO payItemDatasDTO, String hospitalName) {
        ArrayList<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntityList = new ArrayList<OpBusinessOrderDetailEntity>();
        List payItemResVoList = payItemDatasDTO.getPayItemResVoList();
        for (PayItemResVo payItemResVo : payItemResVoList) {
            List items = payItemResVo.getItems();
            for (PayItemResItems payItemResItems : items) {
                OpBusinessOrderDetailEntity opBusinessOrderDetailEntity = new OpBusinessOrderDetailEntity();
                opBusinessOrderDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
                opBusinessOrderDetailEntity.setOrganName(hospitalName);
                opBusinessOrderDetailEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
                opBusinessOrderDetailEntity.setItemName(payItemResItems.getDesc());
                opBusinessOrderDetailEntity.setItemType(payItemResItems.getItemType());
                opBusinessOrderDetailEntity.setItemId(payItemResItems.getId());
                opBusinessOrderDetailEntity.setQuantity(Double.valueOf(Double.parseDouble(payItemResItems.getQty())));
                opBusinessOrderDetailEntity.setUnit(payItemResItems.getUnit());
                opBusinessOrderDetailEntity.setPrice(new BigDecimal(payItemResItems.getPrice()));
                opBusinessOrderDetailEntity.setMoney(new BigDecimal(payItemResItems.getSum()));
                opBusinessOrderDetailEntity.setPrescriptionNo(payItemResItems.getId());
                opBusinessOrderDetailEntityList.add(opBusinessOrderDetailEntity);
            }
        }
        return opBusinessOrderDetailEntityList;
    }

    public OutpatientPaymentOrderDetailRespVO getOutpatientSucssessDetail(OutpatientPaymentOrderDetailReqVO outpatientPaymentOrderDetailReqVO) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderEntity) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
        }
        List opBusinessOrderDetailEntitiesList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderDetailEntitiesList) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
        }
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(opBusinessOrderEntity.getCardId());
        OutpatientPaymentOrderDetailRespVO outpatientPaymentOrderDetailRespVO = new OutpatientPaymentOrderDetailRespVO();
        outpatientPaymentOrderDetailRespVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        outpatientPaymentOrderDetailRespVO.setName(opBusinessOrderEntity.getPatientName());
        outpatientPaymentOrderDetailRespVO.setSex(opBusinessOrderEntity.getPatientGender().toString());
        outpatientPaymentOrderDetailRespVO.setAge(opBusinessOrderEntity.getPatientAge());
        outpatientPaymentOrderDetailRespVO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        outpatientPaymentOrderDetailRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        outpatientPaymentOrderDetailRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        outpatientPaymentOrderDetailRespVO.setCreateTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getCreateTime()));
        if (Objects.nonNull(opBusinessOrderEntity.getPayTime())) {
            outpatientPaymentOrderDetailRespVO.setPayTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getPayTime()));
        }
        List payItemResVos = this.buidPayItemResVoList(opBusinessOrderDetailEntitiesList);
        outpatientPaymentOrderDetailRespVO.setPayItemResVoList(payItemResVos);
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        outpatientPaymentOrderDetailRespVO.setStatus(opBusinessOrderEntity.getStatus());
        outpatientPaymentOrderDetailRespVO.setEleStr(opBusinessOrderEntity.getEleStr());
        outpatientPaymentOrderDetailRespVO.setAmount(amount.toString());
        outpatientPaymentOrderDetailRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        outpatientPaymentOrderDetailRespVO.setDocName(opBusinessOrderEntity.getDocName());
        outpatientPaymentOrderDetailRespVO.setAdmId(opBusinessOrderEntity.getAdmId());
        outpatientPaymentOrderDetailRespVO.setClinicNumber(opBusinessOrderEntity.getPatientId());
        outpatientPaymentOrderDetailRespVO.setGuidedInfoList(this.getGuidedInfo(outpatientPaymentOrderDetailReqVO.getOutPatientId()));
        return outpatientPaymentOrderDetailRespVO;
    }

    private List<PayItemResVo> buidPayItemResVoList(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        ArrayList<PayItemResVo> payItemResVoList = new ArrayList<PayItemResVo>();
        PayItemResVo treatmentPayItemResVo = this.buildPayItemResVoForDetail(opBusinessOrderDetailList);
        if (null != treatmentPayItemResVo) {
            payItemResVoList.add(treatmentPayItemResVo);
        }
        return payItemResVoList;
    }

    private PayItemResVo buildPayItemResVoForDetail(List<OpBusinessOrderDetailEntity> payItemList) {
        if (!CollectionUtils.isEmpty(payItemList)) {
            List items = this.buildPayItemResItems(payItemList);
            if (CollectionUtils.isEmpty((Collection)items)) {
                return null;
            }
            BigDecimal amount = BigDecimal.ZERO;
            for (PayItemResItems payItemResItems : items) {
                amount = amount.add(new BigDecimal(payItemResItems.getSum()));
            }
            PayItemResVo payItemResVo = new PayItemResVo();
            payItemResVo.setAmount(amount.toString());
            payItemResVo.setItems(items);
            payItemResVo.setItemType(((PayItemResItems)items.get(0)).getItemType());
            return payItemResVo;
        }
        return null;
    }

    private List<PayItemResItems> buildPayItemResItems(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntitiesList) {
        ArrayList<PayItemResItems> payItemResItemsList = new ArrayList<PayItemResItems>();
        if (null == opBusinessOrderDetailEntitiesList || opBusinessOrderDetailEntitiesList.isEmpty()) {
            return payItemResItemsList;
        }
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntitiesList) {
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setId(opBusinessOrderDetailEntity.getItemId());
            payItemResItems.setDesc(opBusinessOrderDetailEntity.getItemName());
            payItemResItems.setUnit(opBusinessOrderDetailEntity.getUnit());
            payItemResItems.setPrice(opBusinessOrderDetailEntity.getPrice().toString());
            payItemResItems.setQty(opBusinessOrderDetailEntity.getQuantity().toString());
            payItemResItems.setSum(opBusinessOrderDetailEntity.getMoney().toString());
            payItemResItems.setItemType(opBusinessOrderDetailEntity.getItemType());
            payItemResItemsList.add(payItemResItems);
        }
        return payItemResItemsList;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public BaseResponse outpatientPayment(OutpatientPaymentReqVO outpatientPaymentReqVO) throws OutpatientPaymentException {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        OpBusinessOrderEntity orderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        if (null != orderEntity) {
            BigDecimal oldAmount;
            PayItemDatasDTO payItemDatasDTO = this.checkOutPatientMoney(outpatientPaymentReqVO, orderEntity);
            BigDecimal newAmount = new BigDecimal(payItemDatasDTO.getAmount());
            int compareTo = newAmount.compareTo(oldAmount = orderEntity.getMoney());
            if (compareTo != 0) {
                OpBusinessOrderEntity opBusinessOrder = new OpBusinessOrderEntity();
                opBusinessOrder.setId(orderEntity.getId());
                opBusinessOrder.setStatus(BusinessOrderStatusEnum.HAS_CANCEL.getValue());
                opBusinessOrder.setRemark(BusinessOrderStatusEnum.HAS_CANCEL.getDisplay());
                this.opBusinessOrderEntityMapper.updateByPrimaryKeySelective(opBusinessOrder);
                return new BaseResponse("3", "", null);
            }
            OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(orderEntity, outpatientPaymentReqVO, serviceMerchantConfigEntity);
            log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
            BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO);
            log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
            if ("10".equals(baseResponse.getCode())) {
                QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO = new QueryOutPatientPayStatusReqVO();
                queryOutPatientPayStatusReqVO.setOutPatientId(orderEntity.getOutPatientId());
                queryOutPatientPayStatusReqVO.setHospitalName(orderEntity.getOrganName());
                queryOutPatientPayStatusReqVO.setChannelCode(outpatientPaymentReqVO.getPayChannel());
                queryOutPatientPayStatusReqVO.setPayType(outpatientPaymentReqVO.getPayType());
                queryOutPatientPayStatusReqVO.setPayItemResItemsList(outpatientPaymentReqVO.getPayItemResItemsList());
                queryOutPatientPayStatusReqVO.setClinicNo(orderEntity.getAdmId());
                BaseResponse stringBaseResponse = this.queryOutPatientPayStatus(queryOutPatientPayStatusReqVO);
                if (!"1".equals(baseResponse.getCode())) {
                    return stringBaseResponse;
                }
                return BaseResponse.success((Object)"\u7f34\u8d39\u6210\u529f");
            }
            return baseResponse;
        }
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0ckey\u4e3a\uff1a{}", (Object)outpatientPaymentReqVO.getOutPatientId());
        String payItemDatasDTOStr = this.jedisCluster.get(outpatientPaymentReqVO.getOutPatientId());
        if (StringUtils.isEmpty((CharSequence)payItemDatasDTOStr)) {
            throw new OutpatientPaymentException("\u8be5\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u4e0b\u5355\uff01");
        }
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0c\u83b7\u53d6\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)payItemDatasDTOStr);
        PayItemDatasDTO payItemDatasDTO = (PayItemDatasDTO)JSON.parseObject((String)payItemDatasDTOStr, PayItemDatasDTO.class);
        OpBusinessOrderEntity opBusinessOrderDb = new OpBusinessOrderEntity();
        opBusinessOrderDb.setAdmId(payItemDatasDTO.getAdmId());
        opBusinessOrderDb.setCardId(payItemDatasDTO.getCardId());
        opBusinessOrderDb.setCardNo(payItemDatasDTO.getCardNo());
        opBusinessOrderDb.setChannelCode(outpatientPaymentReqVO.getChannelCode());
        opBusinessOrderDb.setCardId(payItemDatasDTO.getCardId());
        opBusinessOrderDb.setDeptCode(payItemDatasDTO.getDeptCode());
        opBusinessOrderDb.setDeptName(payItemDatasDTO.getDeptName());
        opBusinessOrderDb.setDocCode(payItemDatasDTO.getDocCode());
        opBusinessOrderDb.setDocName(payItemDatasDTO.getDocName());
        opBusinessOrderDb.setUserId(payItemDatasDTO.getUserId());
        opBusinessOrderDb.setAdmTime(payItemDatasDTO.getAdmDate());
        PayItemDatasDTO payItemDatasDTODB = this.checkOutPatientMoney(outpatientPaymentReqVO, opBusinessOrderDb);
        BigDecimal newAmount = new BigDecimal(payItemDatasDTODB.getAmount());
        BigDecimal oldAmount = new BigDecimal(payItemDatasDTO.getAmount());
        int compareTo = newAmount.compareTo(oldAmount);
        if (compareTo != 0) {
            return new BaseResponse("3", "", null);
        }
        BaseResponse baseResponse = this.outPatientToPay(payItemDatasDTODB, outpatientPaymentReqVO, serviceMerchantConfigEntity);
        return baseResponse;
    }

    private BaseResponse outPatientToPay(PayItemDatasDTO payItemDatasDTO, OutpatientPaymentReqVO outpatientPaymentReqVO, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.buildOpBusinessOrderEntity(payItemDatasDTO, outpatientPaymentReqVO);
        this.opBusinessOrderEntityMapper.insertSelective(opBusinessOrderEntity);
        List opBusinessOrderDetailEntityList = this.buildOpBusinessOrderDetailEntity(payItemDatasDTO, outpatientPaymentReqVO.getHospitalName());
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntityList) {
            this.opBusinessOrderDetailEntityMapper.insertSelective(opBusinessOrderDetailEntity);
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrder = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(opBusinessOrderEntity, outpatientPaymentReqVO, serviceMerchantConfigEntity);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.buildOpRechargePaymentOrderEntity(payItemDatasDTO, outpatientPaymentReqVO, opBusinessOrderEntity);
        this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntity);
        opBusinessOrderEntity.setChannelCode(outpatientPaymentReqVO.getChannelCode());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
        BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        if ("10".equals(baseResponse.getCode())) {
            QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO = new QueryOutPatientPayStatusReqVO();
            queryOutPatientPayStatusReqVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
            queryOutPatientPayStatusReqVO.setHospitalName(opBusinessOrderEntity.getOrganName());
            queryOutPatientPayStatusReqVO.setChannelCode(outpatientPaymentReqVO.getPayChannel());
            queryOutPatientPayStatusReqVO.setPayType(outpatientPaymentReqVO.getPayType());
            queryOutPatientPayStatusReqVO.setPayItemResItemsList(outpatientPaymentReqVO.getPayItemResItemsList());
            queryOutPatientPayStatusReqVO.setClinicNo(opBusinessOrderEntity.getAdmId());
            BaseResponse stringBaseResponse = this.queryOutPatientPayStatus(queryOutPatientPayStatusReqVO);
            if (!"1".equals(baseResponse.getCode())) {
                return stringBaseResponse;
            }
            return BaseResponse.success((Object)"\u7f34\u8d39\u6210\u529f");
        }
        return baseResponse;
    }

    public BaseResponse<String> outPatientRefund(String outPatientId) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientAndOrderType(outPatientId, String.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue()));
        if (null == opRechargePaymentOrderEntity) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u53ef\u9000\u6b3e\u8ba2\u5355");
        }
        if (!PayStatusEnum.HAS_PAY_OR_REFUND.getValue().equals(opRechargePaymentOrderEntity.getPayStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u9000");
        }
        BaseResponse baseResponse = this.outpatientRefund(opBusinessOrderEntity, opRechargePaymentOrderEntity);
        if (!baseResponse.isSuccess()) {
            opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            opBusinessOrderEntity.setRemark(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
            log.error("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
            return BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
        opBusinessOrderEntity.setRemark(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        this.saveOpRechargePaymentOrder(opRechargePaymentOrderEntity);
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    public BaseResponse<String> queryOutPatientPayStatus(QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(queryOutPatientPayStatusReqVO.getOutPatientId());
        OpBusinessOrderEntity orderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(queryOutPatientPayStatusReqVO.getOutPatientId());
        orderEntity.setPayTime(new Date());
        GatewayRequest comfirmPayNewReqGatewayRequest = this.bulidComfirmPayNew(queryOutPatientPayStatusReqVO, orderEntity);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(comfirmPayNewReqGatewayRequest);
        log.info("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u786e\u8ba4 gatewayResponse:{}", (Object)JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u786e\u8ba4 deposit -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return BaseResponse.error((String)"\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u786e\u8ba4\u8bf7\u6c42his\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u786e\u8ba4 deposit -> his\u652f\u4ed8\u786e\u8ba4\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return BaseResponse.error((String)gatewayResponse.getMsg());
        }
        String[] eleStrArray = ((ComfirmPayNewRes)gatewayResponse.getData()).getEleStr().split("--");
        String eleStr = this.restEleStr(((ComfirmPayNewRes)gatewayResponse.getData()).getEleStr());
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        opBusinessOrderEntity.setId(orderEntity.getId());
        opBusinessOrderEntity.setEleStr(eleStr);
        opBusinessOrderEntity.setPayTime(new Date());
        this.opBusinessOrderEntityMapper.updateByPrimaryKeySelective(opBusinessOrderEntity);
        OpRechargePaymentOrderEntity opRechargePaymentOrder = new OpRechargePaymentOrderEntity();
        opRechargePaymentOrder.setPayStatus(Byte.valueOf("1"));
        opRechargePaymentOrder.setRemark("\u5df2\u652f\u4ed8");
        opRechargePaymentOrder.setId(opRechargePaymentOrderEntity.getId());
        opRechargePaymentOrder.setPaymentTime(new Date());
        opRechargePaymentOrder.setPaymentSeq(queryOutPatientPayStatusReqVO.getPayChannel());
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKeySelective(opRechargePaymentOrder);
        return BaseResponse.success((Object)"\u652f\u4ed8\u6210\u529f");
    }

    public BaseResponse<String> outPatientRefundEasy(String outPatientId) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        RefundReq refundReq = new RefundReq();
        refundReq.setMachineNo("wechat");
        refundReq.setTrace(opBusinessOrderEntity.getOutPatientId());
        refundReq.setCardNo(opBusinessOrderEntity.getCardNo());
        refundReq.setTotalFee(opBusinessOrderEntity.getMoney().toString());
        refundReq.setOutTradeNo(opRechargePaymentOrderEntity.getDealSeq());
        log.info("\u9884\u7ea6\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
        HashMap<String, RefundReq> map = new HashMap<String, RefundReq>();
        map.put("refundReq", refundReq);
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.encrypt("004", map, this.propertiesConstant.getRefund(), HisPayRes.class);
        if (Objects.equals(hisPayRes.getResultCode(), "0")) {
            log.info("--\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
            HisPayRes res = (HisPayRes)this.encryptUtils.queryPolymer("005", map, this.propertiesConstant.getRefundQuery(), HisPayRes.class);
            log.info("--\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)res));
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                return BaseResponse.success((Object)res.getResultMsg());
            }
            return BaseResponse.error((String)res.getResultMsg());
        }
        return BaseResponse.error((String)hisPayRes.getResultMsg());
    }

    private GatewayRequest<ComfirmPayNewReq> bulidComfirmPayNew(QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        GatewayRequest gatewayRequest = new GatewayRequest();
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setPayment(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReqMsg.setOrderid(opBusinessOrderEntity.getOutPatientId());
        comfirmPayNewReqMsg.setAccdate(simpleDateFormat.format(opBusinessOrderEntity.getPayTime()));
        comfirmPayNewReqMsg.setPosid(opBusinessOrderEntity.getPatientName());
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        comfirmPayNewReq.setId(queryOutPatientPayStatusReqVO.getClinicNo());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setPaychannel("CP");
        comfirmPayNewReq.setFlowNo(queryOutPatientPayStatusReqVO.getOutPatientId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        comfirmPayNewReq.setPayItemResItemsList(queryOutPatientPayStatusReqVO.getPayItemResItemsList());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)queryOutPatientPayStatusReqVO.getPayChannel()));
        gatewayRequest.setChannel(queryOutPatientPayStatusReqVO.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private BaseResponse<String> outpatientRefund(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        RefundOrderVoReq refundOrderVoReq = new RefundOrderVoReq();
        refundOrderVoReq.setPayChannel(opRechargePaymentOrderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        refundOrderVoReq.setOutTradeNo(opRechargePaymentOrderEntity.getOutPatientId());
        refundOrderVoReq.setDealTradeNo(opRechargePaymentOrderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(opBusinessOrderEntity.getMoney());
        refundOrderVoReq.setRefundAmount(opRechargePaymentOrderEntity.getDealMoney());
        refundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        refundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        refundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getOutpatientRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)refundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        refundOrderVoReq.setSign(sign);
        log.info("RefundServiceImpl.refund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("RefundServiceImpl.refund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        if (baseResponse == null) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)baseResponse.getMsg());
        }
        return baseResponse;
    }

    private OutpatientPayReqVO buildOutpatientPayReqVO(OpBusinessOrderEntity opBusinessOrderEntity, OutpatientPaymentReqVO outpatientPaymentReqVO, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        OutpatientPayReqVO outpatientPayReqVO = new OutpatientPayReqVO();
        outpatientPayReqVO.setMchCode(this.propertiesConstant.getMchCode());
        outpatientPayReqVO.setOutTradeNo(outpatientPaymentReqVO.getOutPatientId());
        outpatientPayReqVO.setPayChannel(outpatientPaymentReqVO.getPayChannel());
        outpatientPayReqVO.setPayType(outpatientPaymentReqVO.getPayType());
        outpatientPayReqVO.setProductInfo("\u95e8\u8bca\u7f34\u8d39");
        outpatientPayReqVO.setServiceCode(ServiceCodeEnum.OUTPATIENT.getValue());
        outpatientPayReqVO.setActuallyAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setTotalAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setUserSign(outpatientPaymentReqVO.getOpenId());
        outpatientPayReqVO.setNonceStr(SignUtil.getNonceStr());
        outpatientPayReqVO.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        outpatientPayReqVO.setPayNotifyUrl(this.propertiesConstant.getJfPayNotifyUrl());
        outpatientPayReqVO.setPatientName(opBusinessOrderEntity.getPatientName());
        outpatientPayReqVO.setCardNo(opBusinessOrderEntity.getCardNo());
        outpatientPayReqVO.setHosCode(opBusinessOrderEntity.getOrganCode());
        Map map = SignUtil.getKeyAndValue((Object)outpatientPayReqVO);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        outpatientPayReqVO.setSign(sign);
        return outpatientPayReqVO;
    }

    private OpRechargePaymentOrderEntity buildOpRechargePaymentOrderEntity(PayItemDatasDTO payItemDatasDTO, OutpatientPaymentReqVO outpatientPaymentReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = new OpRechargePaymentOrderEntity();
        Date date = new Date();
        opRechargePaymentOrderEntity.setCreateTime(date);
        opRechargePaymentOrderEntity.setUpdateTime(date);
        opRechargePaymentOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opRechargePaymentOrderEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
        opRechargePaymentOrderEntity.setOrderType(Byte.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue().byteValue()));
        opRechargePaymentOrderEntity.setDealMoney(opBusinessOrderEntity.getMoney());
        opRechargePaymentOrderEntity.setBizSysSeq(ServiceCodeEnum.OUTPATIENT.getValue());
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)0));
        opRechargePaymentOrderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        opRechargePaymentOrderEntity.setUserId(outpatientPaymentReqVO.getUserId());
        return opRechargePaymentOrderEntity;
    }

    private BaseResponse payCreateOrder(OutpatientPayReqVO outpatientPayReqVO) {
        try {
            BigDecimal bigDecimal = new BigDecimal("100");
            String totalfee = String.valueOf(outpatientPayReqVO.getActuallyAmount().multiply(bigDecimal).intValue());
            RechargeCardToHosReqVo rechargeCardToHosReqVo = new RechargeCardToHosReqVo();
            rechargeCardToHosReqVo.setCardNo(outpatientPayReqVO.getCardNo());
            rechargeCardToHosReqVo.setChannelCode(outpatientPayReqVO.getPayChannel());
            rechargeCardToHosReqVo.setHosCode(outpatientPayReqVO.getHosCode());
            BaseResponse queryAccountInfoResVoBaseResponse = this.iCardService.queryCardAccount(rechargeCardToHosReqVo);
            if (!"1".equals(queryAccountInfoResVoBaseResponse.getCode())) {
                return BaseResponse.error((String)queryAccountInfoResVoBaseResponse.getMsg());
            }
            QueryAccountInfoResVo queryAccountInfoResVo = (QueryAccountInfoResVo)queryAccountInfoResVoBaseResponse.getData();
            BigDecimal multiply = new BigDecimal(queryAccountInfoResVo.getVacancy()).multiply(bigDecimal);
            int flag = multiply.compareTo(new BigDecimal(totalfee));
            if (flag < 0) {
                BigDecimal subtract = new BigDecimal(totalfee).subtract(multiply);
                String sub = subtract.divide(bigDecimal).toString();
                HealthRegisteredResVo healthRegisteredResVo = new HealthRegisteredResVo();
                healthRegisteredResVo.setMessage("\u4f59\u989d\u4e0d\u8db3,\u8bf7\u5145\u503c!\u5361\u4f59\u989d:" + queryAccountInfoResVo.getVacancy().toString() + ",\u5e94\u8865\u7f34:" + sub);
                healthRegisteredResVo.setSumMoney(sub);
                return BaseResponse.success((Object)healthRegisteredResVo);
            }
            log.error("outpatientPayReqVO.getOutTradeNo():{}", (Object)JSON.toJSONString((Object)outpatientPayReqVO.getOutTradeNo()));
            OpRechargePaymentOrderEntity paymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outpatientPayReqVO.getOutTradeNo());
            log.error("paymentOrderEntity:{}", (Object)JSON.toJSONString((Object)paymentOrderEntity));
            this.opBusinessOrderEntityMapper.updateReceiptIdByOutPatientId(outpatientPayReqVO.getOutTradeNo(), outpatientPayReqVO.getOutTradeNo());
            if (!Objects.isNull(paymentOrderEntity)) {
                OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = new OpRechargePaymentOrderEntity();
                opRechargePaymentOrderEntity.setId(paymentOrderEntity.getId());
                opRechargePaymentOrderEntity.setDealSeq(outpatientPayReqVO.getOutTradeNo());
                this.opRechargePaymentOrderEntityMapper.updateByPrimaryKeySelective(opRechargePaymentOrderEntity);
            }
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.setCode("10");
            return baseResponse;
        }
        catch (Exception e) {
            log.error("OutpatientPaymentServiceImpl.payCreateOrder\u95e8\u8bca\u7f34\u8d39\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }

    public PaySuccessInfoRespVO getPaySuccessInfo(String outPatientId) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        List opBusinessOrderDetailList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity || null == opRechargePaymentOrderEntity || CollectionUtils.isEmpty((Collection)opBusinessOrderDetailList)) {
            throw new OutpatientPaymentException();
        }
        return this.buildPaySuccessInfoRespVO(opBusinessOrderEntity, opRechargePaymentOrderEntity, opBusinessOrderDetailList);
    }

    private PaySuccessInfoRespVO buildPaySuccessInfoRespVO(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        PaySuccessInfoRespVO paySuccessInfoRespVO = new PaySuccessInfoRespVO();
        paySuccessInfoRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        paySuccessInfoRespVO.setDocName(opBusinessOrderEntity.getDocName());
        paySuccessInfoRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        paySuccessInfoRespVO.setAmount(opRechargePaymentOrderEntity.getDealMoney().toString());
        paySuccessInfoRespVO.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        paySuccessInfoRespVO.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        TreeSet<String> itemType = new TreeSet<String>();
        for (OpBusinessOrderDetailEntity opBusinessOrderDetail : opBusinessOrderDetailList) {
            if (org.springframework.util.StringUtils.isEmpty((Object)opBusinessOrderDetail.getItemType())) continue;
            itemType.add(opBusinessOrderDetail.getItemType());
        }
        if (!CollectionUtils.isEmpty(itemType)) {
            ArrayList<ItemTypeVo> list = new ArrayList<ItemTypeVo>();
            for (String key : itemType) {
                ItemTypeVo itemTypeVo = new ItemTypeVo();
                if (ItemTypeEnum.MEDICAL_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.MEDICAL_PAY.getDisplay());
                }
                if (ItemTypeEnum.DIAGNOSIS_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.DIAGNOSIS_PAY.getDisplay());
                }
                list.add(itemTypeVo);
            }
            paySuccessInfoRespVO.setItemType(list);
        }
        if (opRechargePaymentOrderEntity.getPaymentSeq() != null && WECHAT.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u5fae\u4fe1\u652f\u4ed8");
        } else if (opRechargePaymentOrderEntity.getPaymentSeq() != null && ALIPAY.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u652f\u4ed8\u5b9d\u652f\u4ed8");
        }
        return paySuccessInfoRespVO;
    }

    public List<OutpatientPaymentOrderRespVO> getOutpatientPaymentOrder(OutpatientPaymentOrderReqVO outpatientPaymentOrderReqVO) throws OutpatientPaymentException {
        ArrayList<OutpatientPaymentOrderRespVO> outpatientPaymentOrderRespVOList = new ArrayList<OutpatientPaymentOrderRespVO>();
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setUserId(outpatientPaymentOrderReqVO.getUserId());
        opBusinessOrderEntity.setCardNo(outpatientPaymentOrderReqVO.getCardNo());
        List opBusinessOrderEntities = this.opBusinessOrderEntityMapper.selectByCardNoAndUserId(opBusinessOrderEntity);
        if (null == opBusinessOrderEntities || opBusinessOrderEntities.isEmpty()) {
            return outpatientPaymentOrderRespVOList;
        }
        for (OpBusinessOrderEntity opBusinessOrder : opBusinessOrderEntities) {
            OutpatientPaymentOrderRespVO outpatientPaymentOrderRespVO = new OutpatientPaymentOrderRespVO();
            outpatientPaymentOrderRespVO.setCreateTime(opBusinessOrder.getCreateTime().getTime());
            outpatientPaymentOrderRespVO.setDeptName(opBusinessOrder.getDeptName());
            outpatientPaymentOrderRespVO.setDocName(opBusinessOrder.getDocName());
            outpatientPaymentOrderRespVO.setOutPatientId(opBusinessOrder.getOutPatientId());
            outpatientPaymentOrderRespVO.setPayStatus(opBusinessOrder.getStatus().toString());
            outpatientPaymentOrderRespVO.setAdmDate(DateUtils.hzToXx((String)opBusinessOrder.getAdmTime()));
            outpatientPaymentOrderRespVO.setAmount(opBusinessOrder.getMoney());
            outpatientPaymentOrderRespVO.setClinicNumber(opBusinessOrder.getPatientId());
            outpatientPaymentOrderRespVOList.add(outpatientPaymentOrderRespVO);
        }
        outpatientPaymentOrderRespVOList.sort(Comparator.comparing(OutpatientPaymentOrderRespVO::getAdmDate).reversed());
        return outpatientPaymentOrderRespVOList;
    }

    private void saveOpRechargePaymentOrder(OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntityNew = new OpRechargePaymentOrderEntity();
        opRechargePaymentOrderEntityNew.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u7ba1\u7406\u7aef\u53d1\u8d77\u9000\u6b3e");
        opRechargePaymentOrderEntityNew.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        opRechargePaymentOrderEntityNew.setDealSeq(opRechargePaymentOrderEntity.getDealSeq());
        opRechargePaymentOrderEntityNew.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        Date now = new Date();
        opRechargePaymentOrderEntityNew.setCreateTime(now);
        opRechargePaymentOrderEntityNew.setUpdateTime(now);
        opRechargePaymentOrderEntityNew.setDealMoney(opRechargePaymentOrderEntity.getDealMoney());
        opRechargePaymentOrderEntityNew.setBizSysSeq(opRechargePaymentOrderEntity.getBizSysSeq());
        opRechargePaymentOrderEntityNew.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        opRechargePaymentOrderEntityNew.setMerchantSeq(opRechargePaymentOrderEntity.getMerchantSeq());
        opRechargePaymentOrderEntityNew.setMerchantId(opRechargePaymentOrderEntity.getMerchantId());
        opRechargePaymentOrderEntityNew.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        opRechargePaymentOrderEntityNew.setUserId(opRechargePaymentOrderEntity.getUserId());
        this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntityNew);
    }

    private BaseResponse<String> refund(RefundOrderVoReq refundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)refundOrderVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u8c03\u7528\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("RefundServiceImpl.refund->\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            return BaseResponse.error((String)"\u8c03\u7528\u5931\u8d25");
        }
    }

    private List<GuidedInfoResVO> getGuidedInfo(String outPatientId) {
        OpGuideEntity opGuideEntity = this.opGuideEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opGuideEntity) {
            return new ArrayList<GuidedInfoResVO>();
        }
        String guideInfo = opGuideEntity.getGuideInfo();
        String[] split = guideInfo.split("\\|\\|");
        ArrayList<GuidedInfoResVO> guidedInfoList = new ArrayList<GuidedInfoResVO>();
        for (int i = 0; i < split.length; ++i) {
            String[] split1 = split[i].split("\\^\\^");
            System.out.println(split1.length);
            GuidedInfoResVO guidedInfoResVO = new GuidedInfoResVO();
            guidedInfoResVO.setGuidedItem(split1[0]);
            guidedInfoResVO.setGuidedDesc(split1[1]);
            guidedInfoList.add(guidedInfoResVO);
        }
        return guidedInfoList;
    }

    private String restEleStr(String eleStr) {
        String newEleStr = "";
        if (org.springframework.util.StringUtils.isEmpty((Object)eleStr)) {
            return newEleStr;
        }
        String[] split = eleStr.split("--");
        List collect = Arrays.stream(split).distinct().collect(Collectors.toList());
        for (String s : collect) {
            newEleStr = newEleStr.concat(s).concat("--");
        }
        return newEleStr;
    }

    private PayItemDatasDTO checkOutPatientMoney(OutpatientPaymentReqVO outpatientPaymentReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        try {
            GetPayItemReqVO getPayItemReqVO = new GetPayItemReqVO();
            getPayItemReqVO.setAdmId(opBusinessOrderEntity.getAdmId());
            getPayItemReqVO.setCardNo(opBusinessOrderEntity.getCardNo());
            getPayItemReqVO.setChannelCode(outpatientPaymentReqVO.getChannelCode());
            getPayItemReqVO.setCardId(opBusinessOrderEntity.getCardId());
            getPayItemReqVO.setDeptCode(opBusinessOrderEntity.getDeptCode());
            getPayItemReqVO.setDeptName(opBusinessOrderEntity.getDeptName());
            getPayItemReqVO.setDocCode(opBusinessOrderEntity.getDocCode());
            getPayItemReqVO.setDocName(opBusinessOrderEntity.getDocName());
            getPayItemReqVO.setUserId(opBusinessOrderEntity.getUserId());
            getPayItemReqVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
            GetPayItemRespVO getPayItemRespVO = new GetPayItemRespVO();
            GatewayRequest gatewayRequest = this.buildPayItemGatewayReq(getPayItemReqVO);
            log.info("OutpatientPaymentServiceImpl.getPayItem->\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
            PayItemRes payItemRes = this.payItem(gatewayRequest);
            log.info("OutpatientPaymentServiceImpl.getPayItem->\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee,\u8bf7\u6c42his\u7ed3\u679c payItemRes:{}", (Object)payItemRes);
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(getPayItemReqVO.getCardId());
            String outPatientId = String.valueOf(this.snowflakeIdWorker.nextId());
            if (Objects.isNull(opBusinessOrderEntity.getId())) {
                outPatientId = outpatientPaymentReqVO.getOutPatientId();
            }
            PayItemDatasDTO payItemDatasDTO = this.buildPayItemDatasDTOForRedis(outPatientId, getPayItemReqVO, payItemRes, cardDetailsInfoRespVO);
            log.info("\u83b7\u53d6\u5f85\u7f34\u8d39\u8be6\u60c5\u8fd4\u56de\u503c\u4e3a:{}", (Object)JSON.toJSONString((Object)payItemDatasDTO));
            return payItemDatasDTO;
        }
        catch (Exception e) {
            return null;
        }
    }
}

