/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.OutReachOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.TransTypeEnum;
import com.ebaiyihui.wisdommedical.exception.OutreachException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.DailyBillDetailItemsResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.DailyBillDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.DailyBillDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutReachHeadReq;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.QueryOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.QueryOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.RefundReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.TotalDailyBillDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.TotalDailyBillReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.TotalDailyBillResVO;
import com.ebaiyihui.wisdommedical.service.BillService;
import com.ebaiyihui.wisdommedical.service.OutreachService;
import com.ebaiyihui.wisdommedical.service.RefundService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.SignClinetUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutreachServiceImpl
implements OutreachService {
    private static final Logger log = LoggerFactory.getLogger(OutreachServiceImpl.class);
    @Autowired
    private RefundService refundService;
    @Autowired
    private BillService billService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    public static final long THIRTY_MINUTES = 1800000L;
    public static final String PAY_BILL = "0";
    public static final String REFUND_BILL = "1";
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;

    public OutreachResponse<String> refundForHis(OutreachRequest<RefundReqVO> refundReq) throws OutreachException {
        if (((RefundReqVO)refundReq.getBody()).getTransType().equals(TransTypeEnum.DAILY_REGIST.getValue())) {
            return this.refundService.refundforHis(refundReq);
        }
        if (((RefundReqVO)refundReq.getBody()).getTransType().equals(TransTypeEnum.OUTPATIENT.getValue())) {
            return this.refundService.outpatientRefundForHis(refundReq);
        }
        if (((RefundReqVO)refundReq.getBody()).getTransType().equals(TransTypeEnum.INHOSPITAL.getValue())) {
            return this.refundService.inHospitalRefundForHis(refundReq);
        }
        return OutreachResponse.error((String)"\u65e0\u6b64\u4ea4\u6613\u7c7b\u578b");
    }

    public OutreachResponse<TotalDailyBillResVO> getTotalDailyBill(OutreachRequest<TotalDailyBillReqVO> req) throws OutreachException {
        TotalDailyBillDetailResVO inHospTotalBill;
        this.checkParams(req);
        TotalDailyBillResVO totalDailyBillResVO = new TotalDailyBillResVO();
        ArrayList<TotalDailyBillDetailResVO> items = new ArrayList<TotalDailyBillDetailResVO>();
        items.add(this.buildAppointTotalBill((TotalDailyBillReqVO)req.getBody()));
        items.add(this.buildRegistTotalBill((TotalDailyBillReqVO)req.getBody()));
        TotalDailyBillDetailResVO outPatientTotalBill = this.billService.getOutPatientTotalBill((TotalDailyBillReqVO)req.getBody());
        if (null != outPatientTotalBill) {
            items.add(outPatientTotalBill);
        }
        if (null != (inHospTotalBill = this.billService.getInHospTotalBill((TotalDailyBillReqVO)req.getBody()))) {
            items.add(inHospTotalBill);
        }
        totalDailyBillResVO.setItems(items);
        return OutreachResponse.success((Object)totalDailyBillResVO);
    }

    public OutreachResponse<DailyBillDetailResVO> getDailyDetailBill(OutreachRequest<DailyBillDetailReqVO> req) throws OutreachException {
        List inHospDetailBill;
        List outPatientDetailBill;
        List registDetailBill;
        this.checkParams(req);
        DailyBillDetailResVO dailyBillDetailResVO = new DailyBillDetailResVO();
        ArrayList detailItems = new ArrayList();
        List appointDetailBill = this.buildAppointDetailBill((DailyBillDetailReqVO)req.getBody());
        if (!CollectionUtils.isEmpty((Collection)appointDetailBill)) {
            detailItems.addAll(appointDetailBill);
        }
        if (!CollectionUtils.isEmpty((Collection)(registDetailBill = this.buildRegistDetailBill((DailyBillDetailReqVO)req.getBody())))) {
            detailItems.addAll(registDetailBill);
        }
        if (!CollectionUtils.isEmpty((Collection)(outPatientDetailBill = this.billService.getOutPatientDetailBill((DailyBillDetailReqVO)req.getBody())))) {
            detailItems.addAll(outPatientDetailBill);
        }
        if (!CollectionUtils.isEmpty((Collection)(inHospDetailBill = this.billService.getInHospDetailBill((DailyBillDetailReqVO)req.getBody())))) {
            detailItems.addAll(inHospDetailBill);
        }
        dailyBillDetailResVO.setItems(detailItems);
        return OutreachResponse.success((Object)dailyBillDetailResVO);
    }

    public OutreachResponse<QueryOrderResVO> queryOrder(OutreachRequest<QueryOrderReqVO> queryOrderReq) throws OutreachException {
        this.checkParams(queryOrderReq);
        return OutreachResponse.error((String)"\u4ea4\u6613\u7c7b\u578b\u4e0d\u5b58\u5728");
    }

    private void checkParams(OutreachRequest outreachRequest) throws OutreachException {
        OutReachHeadReq head = outreachRequest.getHead();
        if (!this.propertiesConstant.getAppId().equals(head.getAppId())) {
            log.error("Refund.checkParams->\u6821\u9a8c appId\u4e0d\u5339\u914d,\u8bf7\u6c42\u7684appId\u4e3a:{}", (Object)head.getAppId());
            throw new OutreachException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0cappId\u4e0d\u5339\u914d\uff01");
        }
        Date now = new Date();
        long systemTime = now.getTime();
        Long transDateAndTime = null;
        try {
            transDateAndTime = DateUtils.stringToTimestamp((String)(head.getTransDate().trim() + " " + head.getTransTime().trim())).getTime();
        }
        catch (Exception e) {
            log.error("Refund.checkParams->\u6821\u9a8c\u65e5\u671f\u8f6c\u5316\u5f02\u5e38");
            throw new OutreachException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4ea4\u6613\u65e5\u671f\u3001\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (transDateAndTime + 1800000L < systemTime) {
            log.error("Refund.checkParams->\u6821\u9a8c\u4ea4\u6613\u65f6\u95f4\u8fc7\u671f,\u4ea4\u6613\u65e5\u671f\u4e3a:{},\u4ea4\u6613\u65f6\u95f4\u4e3a:{},\u7cfb\u7edf\u65f6\u95f4\u4e3a:{}", new Object[]{head.getTransDate().trim(), head.getTransTime().trim(), now});
            throw new OutreachException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4ea4\u6613\u65f6\u95f4\u8fc7\u671f\uff01");
        }
        String sign = SignClinetUtil.sign((Map)this.buildSignParams(outreachRequest));
        if (!sign.equals(head.getSign())) {
            log.error("Refund.checkParams->\u6821\u9a8c\u8bf7\u6c42\u53c2\u6570\u4f20\u8f93\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)outreachRequest);
            throw new OutreachException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u6c42\u53c2\u6570\u4f20\u8f93\u5f02\u5e38\uff01");
        }
    }

    private Map<String, String> buildSignParams(OutreachRequest outreachRequest) {
        OutReachHeadReq head = outreachRequest.getHead();
        HashMap<String, String> parameters = new HashMap<String, String>(6);
        parameters.put("transactionId", head.getTransactionId());
        parameters.put("command", head.getCommand());
        parameters.put("channel", head.getChannel());
        parameters.put("transDate", head.getTransDate());
        parameters.put("transTime", head.getTransTime());
        parameters.put("appId", this.propertiesConstant.getAppId());
        return parameters;
    }

    private TotalDailyBillDetailResVO buildAppointTotalBill(TotalDailyBillReqVO reqVO) {
        TotalDailyBillDetailResVO totalDailyBillDetailResVO = new TotalDailyBillDetailResVO();
        List RecordList = this.appointmentRecordMapper.selectByCreateTimeAndAppointStatus(reqVO.getBgDate(), reqVO.getEdDate(), String.join((CharSequence)",", Arrays.asList("7", "8")), String.valueOf(AppointmentTypeEnums.APPOINTMENT.getValue()), this.propertiesConstant.getOrganCode());
        BigDecimal totalMoney = BigDecimal.ZERO;
        BigDecimal refundMoney = BigDecimal.ZERO;
        BigDecimal actualMoney = BigDecimal.ZERO;
        for (AppointmentRecordEntity recordEntity : RecordList) {
            totalMoney = totalMoney.add(new BigDecimal(recordEntity.getPayAmount()));
            if (recordEntity.getAppointStatus().equals(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue())) {
                refundMoney = refundMoney.add(new BigDecimal(recordEntity.getPayAmount()));
            }
            if (!recordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) continue;
            actualMoney = actualMoney.add(new BigDecimal(recordEntity.getPayAmount()));
        }
        totalDailyBillDetailResVO.setTransDate(DateUtils.getCurrentDateToString());
        totalDailyBillDetailResVO.setTotalAmount(String.valueOf(totalMoney));
        totalDailyBillDetailResVO.setRefundMoney(String.valueOf(refundMoney));
        totalDailyBillDetailResVO.setActualMoney(String.valueOf(actualMoney));
        return totalDailyBillDetailResVO;
    }

    private TotalDailyBillDetailResVO buildRegistTotalBill(TotalDailyBillReqVO reqVO) {
        TotalDailyBillDetailResVO totalDailyBillDetailResVO = new TotalDailyBillDetailResVO();
        List RecordList = this.appointmentRecordMapper.selectByCreateTimeAndAppointStatus(reqVO.getBgDate(), reqVO.getEdDate(), String.join((CharSequence)",", Arrays.asList("7", "8")), String.valueOf(AppointmentTypeEnums.DAY_APPOINTMENT.getValue()), this.propertiesConstant.getOrganCode());
        BigDecimal totalMoney = BigDecimal.ZERO;
        BigDecimal refundMoney = BigDecimal.ZERO;
        BigDecimal actualMoney = BigDecimal.ZERO;
        for (AppointmentRecordEntity recordEntity : RecordList) {
            totalMoney = totalMoney.add(new BigDecimal(recordEntity.getPayAmount()));
            if (recordEntity.getAppointStatus().equals(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue())) {
                refundMoney = refundMoney.add(new BigDecimal(recordEntity.getPayAmount()));
            }
            if (!recordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) continue;
            actualMoney = actualMoney.add(new BigDecimal(recordEntity.getPayAmount()));
        }
        totalDailyBillDetailResVO.setTransDate(DateUtils.getCurrentDateToString());
        totalDailyBillDetailResVO.setTotalAmount(String.valueOf(totalMoney));
        totalDailyBillDetailResVO.setRefundMoney(String.valueOf(refundMoney));
        totalDailyBillDetailResVO.setActualMoney(String.valueOf(actualMoney));
        return totalDailyBillDetailResVO;
    }

    private List<DailyBillDetailItemsResVO> buildAppointDetailBill(DailyBillDetailReqVO dailyBillDetailReqVO) {
        ArrayList<DailyBillDetailItemsResVO> detailItemsResVOList = new ArrayList<DailyBillDetailItemsResVO>();
        List RecordList = this.appointmentRecordMapper.selectByCreateTimeAndAppointStatus(dailyBillDetailReqVO.getTransDate(), dailyBillDetailReqVO.getTransDate(), String.join((CharSequence)",", Arrays.asList("7", "8")), String.valueOf(AppointmentTypeEnums.APPOINTMENT.getValue()), this.propertiesConstant.getOrganCode());
        for (AppointmentRecordEntity recordEntity : RecordList) {
            DailyBillDetailItemsResVO dailyBillDetailItemsResVO = new DailyBillDetailItemsResVO();
            if (recordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(recordEntity.getSysAppointmentId());
                dailyBillDetailItemsResVO.setReceiptId(recordEntity.getReceptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(recordEntity.getPayTransationId());
                dailyBillDetailItemsResVO.setAmount(recordEntity.getPayAmount());
                dailyBillDetailItemsResVO.setTradeType(PAY_BILL);
                dailyBillDetailItemsResVO.setTransDate(recordEntity.getPayAccdate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.APPOINT_REGIST.getValue());
            }
            if (recordEntity.getAppointStatus().equals(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(recordEntity.getSysAppointmentId());
                dailyBillDetailItemsResVO.setReceiptId(recordEntity.getReceptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(recordEntity.getReturnTransationId());
                dailyBillDetailItemsResVO.setAmount(recordEntity.getPayAmount());
                dailyBillDetailItemsResVO.setTradeType(REFUND_BILL);
                dailyBillDetailItemsResVO.setTransDate(recordEntity.getReturnAccdate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.APPOINT_REGIST.getValue());
            }
            detailItemsResVOList.add(dailyBillDetailItemsResVO);
        }
        return detailItemsResVOList;
    }

    private List<DailyBillDetailItemsResVO> buildRegistDetailBill(DailyBillDetailReqVO dailyBillDetailReqVO) {
        ArrayList<DailyBillDetailItemsResVO> detailItemsResVOList = new ArrayList<DailyBillDetailItemsResVO>();
        List RecordList = this.appointmentRecordMapper.selectByCreateTimeAndAppointStatus(dailyBillDetailReqVO.getTransDate(), dailyBillDetailReqVO.getTransDate(), String.join((CharSequence)",", Arrays.asList("7", "8")), String.valueOf(AppointmentTypeEnums.DAY_APPOINTMENT.getValue()), this.propertiesConstant.getOrganCode());
        for (AppointmentRecordEntity recordEntity : RecordList) {
            DailyBillDetailItemsResVO dailyBillDetailItemsResVO = new DailyBillDetailItemsResVO();
            if (recordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(recordEntity.getSysAppointmentId());
                dailyBillDetailItemsResVO.setReceiptId(recordEntity.getReceptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(recordEntity.getPayTransationId());
                dailyBillDetailItemsResVO.setAmount(recordEntity.getPayAmount());
                dailyBillDetailItemsResVO.setTradeType(PAY_BILL);
                dailyBillDetailItemsResVO.setTransDate(recordEntity.getPayAccdate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.DAILY_REGIST.getValue());
            }
            if (recordEntity.getAppointStatus().equals(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(recordEntity.getSysAppointmentId());
                dailyBillDetailItemsResVO.setReceiptId(recordEntity.getReceptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(recordEntity.getReturnTransationId());
                dailyBillDetailItemsResVO.setAmount(recordEntity.getPayAmount());
                dailyBillDetailItemsResVO.setTradeType(REFUND_BILL);
                dailyBillDetailItemsResVO.setTransDate(recordEntity.getReturnAccdate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.DAILY_REGIST.getValue());
            }
            detailItemsResVOList.add(dailyBillDetailItemsResVO);
        }
        return detailItemsResVOList;
    }

    private OutreachResponse<QueryOrderResVO> queryAppointRegistOrder(OutreachRequest<QueryOrderReqVO> queryOrderReq) {
        QueryOrderResVO queryOrderResVO = new QueryOrderResVO();
        OutReachHeadReq head = queryOrderReq.getHead();
        OutreachResponse outreachResponse = new OutreachResponse();
        outreachResponse.setTransDate(head.getTransDate());
        outreachResponse.setTransactionId(head.getTransactionId());
        outreachResponse.setTransDate(head.getTransDate());
        outreachResponse.setTransTime(head.getTransTime());
        QueryOrderReqVO orderReqVO = (QueryOrderReqVO)queryOrderReq.getBody();
        AppointmentRecordEntity appointmentRecordEntity = null;
        if (StringUtils.isNotBlank((CharSequence)orderReqVO.getOrderNo())) {
            appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(orderReqVO.getOrderNo());
        } else if (StringUtils.isNotBlank((CharSequence)orderReqVO.getTradeNo())) {
            appointmentRecordEntity = this.appointmentRecordMapper.selectByPayTransId(orderReqVO.getTradeNo());
        } else {
            outreachResponse.setIssucess(PAY_BILL);
            outreachResponse.setMessage("\u5546\u6237\u8ba2\u5355\u53f7\u548c\u4e09\u65b9\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return outreachResponse;
        }
        if (null == appointmentRecordEntity) {
            outreachResponse.setIssucess(PAY_BILL);
            outreachResponse.setMessage("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\uff01");
            return outreachResponse;
        }
        log.info("\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        queryOrderResVO.setOrderNo(appointmentRecordEntity.getSysAppointmentId());
        queryOrderResVO.setOrderStatus(OutReachOrderStatusEnum.getDisplay((String)String.valueOf(appointmentRecordEntity.getAppointStatus())));
        queryOrderResVO.setTradeNo(appointmentRecordEntity.getPayTransationId());
        queryOrderResVO.setTransType(orderReqVO.getTransType());
        queryOrderResVO.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        queryOrderResVO.setPayAmount(appointmentRecordEntity.getPayAmount());
        queryOrderResVO.setPayTime(appointmentRecordEntity.getPayAccdate());
        if (appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue())) {
            queryOrderResVO.setRefundTime(appointmentRecordEntity.getReturnAccdate());
            queryOrderResVO.setRefundAmount(appointmentRecordEntity.getReturnAmount().toString());
        }
        outreachResponse.setIssucess(REFUND_BILL);
        outreachResponse.setMessage("\u64cd\u4f5c\u6210\u529f");
        outreachResponse.setBody((Object)queryOrderResVO);
        return outreachResponse;
    }
}

