/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.api.HospitalizationApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.HealthBackPayReqVo;
import com.ebaiyihui.his.pojo.vo.appoint.HealthBackPayResVo;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.his.pojo.vo.card.QueryAccountInfoResVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeReqVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceBillTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServicePayBillStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.CardPayOrderMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.CardPayOrderEntity;
import com.ebaiyihui.wisdommedical.model.HisPayRes;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.RefundReq;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.InHospDepostPayCallDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthBackReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthRegisteredReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.HealthRegisteredResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.PayPlatformCallBackVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RechargeCardToHosReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateStatusVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.QueryOutPatientPayStatusReqVO;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.IWaitingQueueService;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.EncryptUtils;
import com.ebaiyihui.wisdommedical.util.EncryptionUtils;
import com.ebaiyihui.wisdommedical.util.GetUserInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    public static final String ACCEPT_REQUEST = "0";
    public static final String PAY_SUCCESS = "3";
    public static final String SUCCESS = "Y";
    public static final String HIS_SUCCESS = "1";
    @Autowired
    private HospitalizationApi hospitalizationApi;
    public static final byte PAID = 1;
    public static final int HEALTH_APPOINTMENT = 3;
    @Autowired
    JedisCluster jedisCluster;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private CardPayOrderMapper cardPayOrderMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private IWaitingQueueService iWaitingQueueService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private GetUserInfoUtil getUserInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    EncryptUtils encryptUtils;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    private final String OUT_TRADE_NO = "OUT_TRADE_NO";
    private final String ORDER_QUERY_TIMES = "ORDER_QUERY_TIMES";
    private final String REDIS_PAY_LOCK = "HBBD-YYGH-SH-";
    @Value(value="${hisFontUrl}")
    private String hisFontUrl;
    @Value(value="${projprops.refundUrl}")
    private String refundUrl;
    @Value(value="${projprops.organCode}")
    private String organCode;
    @Value(value="${projprops.mchCode}")
    private String mchCode;
    @Value(value="${projprops.bizSysSeq}")
    private String bizSysSeq;

    public void dayAppointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.mchCode, this.bizSysSeq);
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(responseNotifyRestVo.getOutTradeNo());
        if (!Objects.equals(appointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) {
            log.error("\u8ba2\u5355\u72b6\u6001\u5f02\u5e38 \u65e0\u6cd5\u8fdb\u884c\u6302\u53f7,\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e3a:" + AppointmentStatusEnum.WAIT_PAY.getValue());
            return;
        }
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.organCode);
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        servicePayBillEntity.setGoodsInfo("\u5f53\u65e5\u6302\u53f7");
        servicePayBillEntity.setRemark("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u8bb0\u5f55\u652f\u4ed8\u8d26\u5355");
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        RechargeReqVo rechargeReqVo = this.buildRechargeReqVo(appointmentRecordEntity, responseNotifyRestVo);
        if (null == rechargeReqVo) {
            log.error("\u6784\u9020\u5c31\u8bca\u5361\u5145\u503c\u5165\u53c2\u5931\u8d25");
            return;
        }
        boolean b = this.cardRecharge(rechargeReqVo, appointmentRecordEntity, HIS_SUCCESS);
        if (!b) {
            log.error("\u5c31\u8bca\u5361\u5145\u503c\u5931\u8d25");
            return;
        }
        try {
            log.info("\u5c31\u8bca\u5361\u652f\u4ed8\u6210\u529f\u5f00\u59cb\u5f53\u65e5\u6302\u53f7");
            appointmentRecordEntity.setPayChannel("ALIPAY");
            this.dayAppointment(appointmentRecordEntity);
        }
        catch (Exception e) {
            log.error("\u5c31\u8bca\u5361\u5145\u503c\u6210\u529f,\u5f53\u65e5\u6302\u53f7\u5931\u8d25->{}", (Throwable)e);
        }
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, new PayRegistrationRes());
        CardPayOrderEntity cardPayOrderEntity = new CardPayOrderEntity();
        cardPayOrderEntity.setSysId(responseNotifyRestVo.getOutTradeNo());
        cardPayOrderEntity.setDealSeq(responseNotifyRestVo.getTradeNo());
        cardPayOrderEntity.setOrderStatus(Integer.valueOf(1));
        cardPayOrderEntity.setUpdateTime((Date)DateUtil.date());
        this.cardPayOrderMapper.updateBysysID(cardPayOrderEntity);
        String authCode = this.jedisCluster.get(appointmentRecordEntity.getSysAppointmentId() + "_authCode");
        this.taskExecutor.execute(() -> {
            try {
                this.pushService.alipayAppointmentSuccessMsgPush(appointmentRecordEntity.getSysAppointmentId(), HIS_SUCCESS, authCode);
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u5b9d\u667a\u80fd\u6d88\u606f\u63a8\u9001\u5931\u8d25");
            }
        });
    }

    public void dayAppointment(AppointmentRecordEntity appointmentRecordEntity1) throws Exception {
        PayRegistrationRes payRegistrationRes = this.appointmentService.hisSameDayRegistration(appointmentRecordEntity1, null);
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setId(appointmentRecordEntity1.getId());
        appointmentRecordEntity.setAdmId(payRegistrationRes.getAdmId());
        appointmentRecordEntity.setReceptId(payRegistrationRes.getReceiptId());
        appointmentRecordEntity.setAppointmentId(payRegistrationRes.getReceiptId());
        appointmentRecordEntity.setRegFee(new BigDecimal(payRegistrationRes.getRegistFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(payRegistrationRes.getInspectFee()));
        appointmentRecordEntity.setPayChannelCode(payRegistrationRes.getNo());
        appointmentRecordEntity.setAppointmentNo(payRegistrationRes.getNo());
        appointmentRecordEntity.setAdmAddress(payRegistrationRes.getAdmitAddress());
        appointmentRecordEntity.setEleStr(payRegistrationRes.getEleStr());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u5f53\u65e5\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        appointmentRecordEntity.setPayAccdate(DateUtil.now());
        appointmentRecordEntity.setTakeTime(payRegistrationRes.getPubCost() + "-" + payRegistrationRes.getPayCost() + "-" + payRegistrationRes.getOwnCost());
        if (appointmentRecordEntity.getId() == null) {
            log.error("\u4fee\u6539\u8ba2\u5355 id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    public boolean cardRecharge(RechargeReqVo rechargeReqVo, AppointmentRecordEntity appointmentRecordEntity, String type) {
        log.info("\u5c31\u8bca\u5361\u5145\u503c\u63a5\u53e3\u5165\u53c2 - > {}", (Object)JSON.toJSONString((Object)rechargeReqVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)rechargeReqVo);
        FrontResponse rechargeResVoFrontResponse = null;
        try {
            log.info("\u8bf7\u6c42his\u8fdb\u884c\u5c31\u8bca\u5361\u5145\u503c\u5165\u53c2 - > {}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            String post = HttpUtil.post((String)(this.hisFontUrl + "card/recharge"), (String)JSON.toJSONString((Object)frontRequest));
            log.info("\u8bf7\u6c42his\u8fdb\u884c\u5c31\u8bca\u5361\u5145\u503c\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)post, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            rechargeResVoFrontResponse = (FrontResponse)JSON.parseObject((String)post, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            log.info("\u8f6c\u5b9e\u4f53\u540e\u7684\u5c31\u8bca\u5361\u5145\u503c\u7ed3\u679c  - > {}", (Object)JSON.toJSONString((Object)rechargeResVoFrontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        catch (Exception e) {
            log.error("\u5c31\u8bca\u5361\u5145\u503c\u5931\u8d25,\u5f53\u524d\u8ba2\u5355\u53f7\u4e3a - >{}", (Object)rechargeReqVo.getOrderNO());
            return false;
        }
        if (null == rechargeResVoFrontResponse) {
            return false;
        }
        if (null == rechargeResVoFrontResponse.getBody()) {
            return false;
        }
        if (null == ((RechargeResVo)rechargeResVoFrontResponse.getBody()).getVacancy()) {
            return false;
        }
        return !rechargeResVoFrontResponse.getCode().equals(ACCEPT_REQUEST);
    }

    private RechargeReqVo buildRechargeReqVo(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVoParam) {
        try {
            RechargeReqVo rechargeReqVo = new RechargeReqVo();
            rechargeReqVo.setCardNO(appointmentRecordEntity.getPatientCardNo());
            rechargeReqVo.setName(appointmentRecordEntity.getPatientName());
            RechargeCardToHosReqVo rechargeCardToHosReqVo = new RechargeCardToHosReqVo();
            rechargeCardToHosReqVo.setChannelCode("PATIENT_WX");
            rechargeCardToHosReqVo.setHosCode("651");
            rechargeCardToHosReqVo.setCardNo(appointmentRecordEntity.getPatientCardNo());
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
            frontRequest.setOrganCode("651");
            frontRequest.setBody((Object)rechargeCardToHosReqVo);
            FrontResponse queryAccountInfoResVoBaseResponse = null;
            try {
                log.info("\u8bf7\u6c42his\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u5165\u53c2 - >{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                String post = HttpUtil.post((String)(this.hisFontUrl + "card/queryAccountInfo"), (String)JSON.toJSONString((Object)frontRequest));
                log.info("\u8bf7\u6c42his\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u8fd4\u56de\u503c - >{}", (Object)JSON.toJSONString((Object)post));
                queryAccountInfoResVoBaseResponse = (FrontResponse)JSON.parseObject((String)post, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                log.info("\u5f53\u65e5\u6302\u53f7his\u51fa\u53c2\u8f6c\u5b9e\u4f53\u540e\u6253\u5370 - >{}", (Object)JSON.toJSONString((Object)queryAccountInfoResVoBaseResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            catch (Exception e) {
                log.info("\u8bf7\u6c42his\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\u4e3a - >{}", (Object)JSON.toJSONString((Object)e.getMessage()));
                return new RechargeReqVo();
            }
            if (queryAccountInfoResVoBaseResponse.getCode().equals(ACCEPT_REQUEST)) {
                log.info("\u83b7\u53d6\u9662\u5185\u8d26\u6237\u4fe1\u606f\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u4fe1\u606f\u4e3a - >{}", (Object)queryAccountInfoResVoBaseResponse.getMessage());
                return new RechargeReqVo();
            }
            if (null == ((QueryAccountInfoResVo)queryAccountInfoResVoBaseResponse.getBody()).getAccountNo()) {
                log.info("\u83b7\u53d6\u9662\u5185\u8d26\u6237\u4fe1\u606f\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u4fe1\u606f\u4e3a - >{}", (Object)queryAccountInfoResVoBaseResponse.getMessage());
                return new RechargeReqVo();
            }
            rechargeReqVo.setAccountNO(((QueryAccountInfoResVo)queryAccountInfoResVoBaseResponse.getBody()).getAccountNo());
            rechargeReqVo.setPayType("CP");
            rechargeReqVo.setCost(Convert.toStr((Object)responseNotifyRestVoParam.getTotalAmount()));
            rechargeReqVo.setTransType(HIS_SUCCESS);
            rechargeReqVo.setOrderNO(appointmentRecordEntity.getPayTransationId());
            rechargeReqVo.setTransNO(appointmentRecordEntity.getPayTransationId());
            rechargeReqVo.setMachineNO("HLWYY");
            return rechargeReqVo;
        }
        catch (Exception e) {
            log.info("\u6784\u9020\u5c31\u8bca\u5361\u5145\u503c\u5165\u53c2\u51fa\u73b0\u5f02\u5e38\u5f53\u524d\u8ba2\u5355\u53f7\u4e3a - > {},\u94f6\u884c\u6d41\u6c34\u53f7\u4e3a - >{},\u5c31\u8bca\u5361\u53f7\u4e3a - >{}", new Object[]{appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), appointmentRecordEntity.getPatientCardNo()});
            return new RechargeReqVo();
        }
    }

    private BaseResponse<String> appointRefund(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        RefundReq refundReq = new RefundReq();
        refundReq.setMachineNo("wechat");
        refundReq.setTrace(appointmentRecordEntity.getSysAppointmentId());
        refundReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        BigDecimal bigDecimal = new BigDecimal("100");
        String totalfee = String.valueOf(appointmentRecordEntity.getRegFee().multiply(bigDecimal).intValue());
        refundReq.setTotalFee(totalfee);
        refundReq.setOutTradeNo(appointmentPayorderEntity.getDealSeq());
        log.info("\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
        HashMap<String, RefundReq> map = new HashMap<String, RefundReq>();
        map.put("refundReq", refundReq);
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.encrypt("004", map, this.propertiesConstant.getRefund(), HisPayRes.class);
        log.info("\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u4e3ahisPayRes:{}", (Object)JSON.toJSONString((Object)hisPayRes));
        if (Objects.equals(hisPayRes.getResultCode(), ACCEPT_REQUEST)) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)hisPayRes.getResultMsg());
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private AppointmentPayorderEntity saveAppointmentPayorder(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        AppointmentPayorderEntity payOrderEntity = new AppointmentPayorderEntity();
        payOrderEntity.setDealSeq(null == responseNotifyRestVo.getOutTradeNo() ? responseNotifyRestVo.getOrderNo() : responseNotifyRestVo.getOutTradeNo());
        payOrderEntity.setBizSysSeq(responseNotifyRestVo.getOutTradeNo());
        payOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        payOrderEntity.setPayBillNo(responseNotifyRestVo.getOrderNo());
        payOrderEntity.setOrderStatus(new Byte(PAY_SUCCESS));
        payOrderEntity.setDealMoney(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payOrderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        payOrderEntity.setBizDealSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setPaymentTime((Date)DateUtil.date());
        if (Objects.isNull(appointmentPayorderEntity)) {
            this.appointmentPayOrderMapper.insertSelective(payOrderEntity);
        } else {
            payOrderEntity.setId(appointmentPayorderEntity.getId());
            this.appointmentPayOrderMapper.updateByPrimaryKeySelective(payOrderEntity);
        }
        return payOrderEntity;
    }

    private void updateAppointmentPayorder(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity payOrderEntity, PayRegistrationRes dayRegisterRes) {
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setBusinessByToDay(JSON.toJSONString((Object)dayRegisterRes));
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKeySelective(payOrderEntity);
    }

    private void updateHisReturnMsg(AppointmentRecordEntity appointmentRecordEntity, PayRegistrationRes dayRegisterRes) {
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setAppointmentId(dayRegisterRes.getReceiptId());
        appointmentRecordEntity.setAdmId(dayRegisterRes.getAdmId());
        appointmentRecordEntity.setReceptId(dayRegisterRes.getReceiptId());
        appointmentRecordEntity.setAppointmentNo(dayRegisterRes.getNo());
        appointmentRecordEntity.setTakeAddress(dayRegisterRes.getAdmitAddress());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u5f53\u65e5\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        appointmentRecordEntity.setEleStr(dayRegisterRes.getEleStr());
        String takeTime = dayRegisterRes.getPubCost() + "-" + dayRegisterRes.getPayCost() + "-" + dayRegisterRes.getOwnCost();
        appointmentRecordEntity.setTakeTime(takeTime);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private void waitHisConfirm(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setPayPostId(appointmentRecordEntity.getPayTransationId());
        appointmentRecordEntity.setPayTransationId(appointmentRecordEntity.getPayTransationId());
        appointmentRecordEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getDisplay());
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private GatewayRequest<PayRegistrationReq> buildDayRegisterParams(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentNo());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getRegFee().toString());
        payRegistrationReq.setFlowNo(appointmentRecordEntity.getPayTransationId());
        payRegistrationReq.setAppointDate(appointmentRecordEntity.getAdmDate());
        payRegistrationReq.setPhone(appointmentRecordEntity.getPatientPhone());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(responseNotifyRestVo.getOrderNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getRegFee().toString());
        payRegistrationMsg.setSuccess(SUCCESS);
        String patientIdCard = appointmentRecordEntity.getPatientIdCard();
        String birthStr = IdCardUtil.getBirthByIdCard2((String)patientIdCard);
        payRegistrationReq.setBirthDay(birthStr.replaceAll("-", "/"));
        String genderByIdCard = IdCardUtil.getGenderByIdCard((String)patientIdCard);
        payRegistrationReq.setSex(genderByIdCard);
        payRegistrationReq.setPactCode("01");
        payRegistrationReq.setDeptCode(appointmentRecordEntity.getDeptCode());
        payRegistrationReq.setDeptName(appointmentRecordEntity.getDeptName());
        payRegistrationReq.setDoctCode(appointmentRecordEntity.getDocCode());
        payRegistrationReq.setDoctName(appointmentRecordEntity.getDocName());
        payRegistrationReq.setRegLeve(appointmentRecordEntity.getPatientIndex());
        payRegistrationReq.setRegLeveName(appointmentRecordEntity.getRegTitleName());
        payRegistrationReq.setNoonID(String.valueOf(appointmentRecordEntity.getAdmRange()));
        payRegistrationReq.setName(appointmentRecordEntity.getPatientName());
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("dayRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void appointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws Exception {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.mchCode, this.bizSysSeq);
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(responseNotifyRestVo.getOutTradeNo());
        if (!Objects.equals(appointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) {
            log.error("\u8ba2\u5355\u72b6\u6001\u5f02\u5e38 \u65e0\u6cd5\u8fdb\u884c\u6302\u53f7,\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e3a:" + AppointmentStatusEnum.WAIT_PAY.getValue());
            return;
        }
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.organCode);
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        servicePayBillEntity.setGoodsInfo("\u9884\u7ea6\u6302\u53f7");
        servicePayBillEntity.setRemark("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u8bb0\u5f55\u652f\u4ed8\u8d26\u5355");
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u5165\u53c2 PayRegistrationReq{}", (Object)JSON.toJSONString((Object)gatewayRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        GatewayResponse gatewayResponse = this.appointApi.confirmRegister(gatewayRequest);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u51fa\u53c2 gatewayResponse{}", (Object)JSON.toJSONString((Object)gatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (ACCEPT_REQUEST.equals(gatewayResponse.getCode())) {
            log.error("\u9884\u7ea6\u6302\u53f7\u5931\u8d25");
            return;
        }
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        ConfirmRegisterRes payRegistrationRes = (ConfirmRegisterRes)gatewayResponse.getData();
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        updatePayAppointment.setPayPostId(responseNotifyRestVo.getTradeNo());
        updatePayAppointment.setAppointmentId(((ConfirmRegisterRes)gatewayResponse.getData()).getBookingNo());
        updatePayAppointment.setPayTransationId(responseNotifyRestVo.getTradeNo());
        updatePayAppointment.setPayChannel(responseNotifyRestVo.getPayChannel());
        updatePayAppointment.setAppointNo(payRegistrationRes.getBookingNo());
        updatePayAppointment.setAdmAdress(payRegistrationRes.getAdmitAddress());
        if (null != payRegistrationRes) {
            updatePayAppointment.setAppointNo(payRegistrationRes.getNo());
            updatePayAppointment.setReceptId(payRegistrationRes.getAppointId());
        }
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        updatePayAppointment.setPayChannelCode(payRegistrationRes.getBookingNo());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        updatePayAppointment.setPayAccdate(DateUtil.now());
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        String authCode = this.jedisCluster.get(appointmentRecordEntity.getSysAppointmentId() + "_authCode");
        this.taskExecutor.execute(() -> {
            try {
                this.pushService.alipayAppointmentSuccessMsgPush(appointmentRecordEntity.getSysAppointmentId(), HIS_SUCCESS, authCode);
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u5b9d\u667a\u80fd\u6d88\u606f\u63a8\u9001\u5931\u8d25");
            }
        });
    }

    public void cardRechargeCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws Exception {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.mchCode, this.bizSysSeq);
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        CardPayOrderEntity cardPayOrderEntity = this.cardPayOrderMapper.selectBySysId(responseNotifyRestVo.getOutTradeNo());
        if (cardPayOrderEntity.getOrderStatus() != 0) {
            log.error("\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5bf9 \u65e0\u6cd5\u8fdb\u884c\u5145\u503c");
            return;
        }
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.organCode);
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        servicePayBillEntity.setGoodsInfo("\u5c31\u8bca\u5361\u5145\u503c");
        servicePayBillEntity.setRemark("\u5c31\u8bca\u5361\u5145\u503c\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u8bb0\u5f55\u652f\u4ed8\u8d26\u5355");
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setPatientCardNo(cardPayOrderEntity.getPatientCardNo());
        appointmentRecordEntity.setPatientName(cardPayOrderEntity.getPatientName());
        RechargeReqVo rechargeReqVo = this.buildRechargeReqVo(appointmentRecordEntity, responseNotifyRestVo);
        if (null == rechargeReqVo) {
            log.error("\u6784\u9020\u5c31\u8bca\u5361\u5145\u503c\u5165\u53c2\u5931\u8d25");
            return;
        }
        boolean b = this.cardRecharge(rechargeReqVo, appointmentRecordEntity, HIS_SUCCESS);
        if (!b) {
            log.error("\u5c31\u8bca\u5361\u5145\u503c\u5931\u8d25");
            return;
        }
        cardPayOrderEntity.setDealSeq(responseNotifyRestVo.getTradeNo());
        cardPayOrderEntity.setOrderStatus(Integer.valueOf(1));
        cardPayOrderEntity.setUpdateTime((Date)DateUtil.date());
        this.cardPayOrderMapper.updateBysysID(cardPayOrderEntity);
    }

    public List<PayPlatformCallBackVoRes> payPlatformCallBack(String posId, String tranDate) {
        return this.appointmentRecordMapper.selectByPayPosIdAndDate(posId, tranDate, this.propertiesConstant.getOrganCode());
    }

    public void outpatientPaymentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws Exception {
        log.info("\u7f34\u8d39\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.mchCode, this.bizSysSeq);
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(responseNotifyRestVo.getOutTradeNo());
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setPatientCardNo(opBusinessOrderEntity.getCardNo());
        appointmentRecordEntity.setPatientName(opBusinessOrderEntity.getPatientName());
        RechargeReqVo rechargeReqVo = this.buildRechargeReqVo(appointmentRecordEntity, responseNotifyRestVo);
        boolean b = this.cardRecharge(rechargeReqVo, appointmentRecordEntity, HIS_SUCCESS);
        if (!b) {
            log.error("\u5c31\u8bca\u5361\u5145\u503c\u5931\u8d25");
            return;
        }
        CardPayOrderEntity cardPayOrderEntity = new CardPayOrderEntity();
        cardPayOrderEntity.setSysId(responseNotifyRestVo.getOutTradeNo());
        cardPayOrderEntity.setDealSeq(responseNotifyRestVo.getTradeNo());
        cardPayOrderEntity.setOrderStatus(Integer.valueOf(1));
        cardPayOrderEntity.setUpdateTime((Date)DateUtil.date());
        this.cardPayOrderMapper.updateBysysID(cardPayOrderEntity);
        String s = this.redisTemplate.opsForValue().get((Object)responseNotifyRestVo.getOutTradeNo()).toString();
        log.info("\u95e8\u8bca\u7f34\u8d39redis\u5185\u83b7\u53d6\u5230\u7684\u5185\u5bb9\u4e3a->{}", (Object)s);
        QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO = (QueryOutPatientPayStatusReqVO)JSON.parseObject((String)s, QueryOutPatientPayStatusReqVO.class);
        log.info("\u95e8\u8bca\u7f34\u8d39redis\u5185\u83b7\u53d6\u5230\u7684\u5185\u5bb9\u8f6c\u5bf9\u8c61\u540e\u4e3a->{}", (Object)JSON.toJSONString((Object)queryOutPatientPayStatusReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(queryOutPatientPayStatusReqVO.getOutPatientId());
        OpBusinessOrderEntity orderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(queryOutPatientPayStatusReqVO.getOutPatientId());
        orderEntity.setPayTime(new Date());
        GatewayRequest comfirmPayNewReqGatewayRequest = this.bulidComfirmPayNew(queryOutPatientPayStatusReqVO, orderEntity);
        log.info("\u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42his\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)comfirmPayNewReqGatewayRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(comfirmPayNewReqGatewayRequest);
        log.info("\u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42his\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)gatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (gatewayResponse == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return;
        }
        if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return;
        }
        log.info("gatewayResponse.getData():" + ((ComfirmPayNewRes)gatewayResponse.getData()).toString());
        ComfirmPayNewRes comfirmPayNewRes = (ComfirmPayNewRes)gatewayResponse.getData();
        if (null == comfirmPayNewRes) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        String eleStr = this.restEleStr(((ComfirmPayNewRes)gatewayResponse.getData()).getEleStr());
        OpBusinessOrderEntity opBusinessOrderEntity1 = new OpBusinessOrderEntity();
        opBusinessOrderEntity1.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity1.setRemark("\u5df2\u652f\u4ed8");
        opBusinessOrderEntity1.setId(orderEntity.getId());
        opBusinessOrderEntity1.setEleStr(eleStr);
        opBusinessOrderEntity1.setPayTime(new Date());
        this.opBusinessOrderEntityMapper.updateByPrimaryKeySelective(opBusinessOrderEntity1);
        OpRechargePaymentOrderEntity opRechargePaymentOrder = new OpRechargePaymentOrderEntity();
        opRechargePaymentOrder.setPayStatus(Byte.valueOf(HIS_SUCCESS));
        opRechargePaymentOrder.setRemark("\u5df2\u652f\u4ed8");
        opRechargePaymentOrder.setId(opRechargePaymentOrderEntity.getId());
        opRechargePaymentOrder.setPaymentTime(new Date());
        opRechargePaymentOrder.setPaymentSeq(queryOutPatientPayStatusReqVO.getPayChannel());
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKeySelective(opRechargePaymentOrder);
    }

    private String restEleStr(String eleStr) {
        String newEleStr = "";
        if (StringUtils.isEmpty((Object)eleStr)) {
            return newEleStr;
        }
        String[] split = eleStr.split("--");
        List collect = Arrays.stream(split).distinct().collect(Collectors.toList());
        for (String s : collect) {
            newEleStr = newEleStr.concat(s).concat("--");
        }
        return newEleStr;
    }

    private GatewayRequest<ComfirmPayNewReq> bulidComfirmPayNew(QueryOutPatientPayStatusReqVO queryOutPatientPayStatusReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        GatewayRequest gatewayRequest = new GatewayRequest();
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setPayment(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReqMsg.setOrderid(opBusinessOrderEntity.getOutPatientId());
        comfirmPayNewReqMsg.setAccdate(simpleDateFormat.format(opBusinessOrderEntity.getPayTime()));
        comfirmPayNewReqMsg.setPosid(opBusinessOrderEntity.getPatientName());
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        comfirmPayNewReq.setId(queryOutPatientPayStatusReqVO.getClinicNo());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setPaychannel("CP");
        comfirmPayNewReq.setFlowNo(queryOutPatientPayStatusReqVO.getOutPatientId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        comfirmPayNewReq.setPayItemResItemsList(queryOutPatientPayStatusReqVO.getPayItemResItemsList());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)queryOutPatientPayStatusReqVO.getPayChannel()));
        gatewayRequest.setChannel(queryOutPatientPayStatusReqVO.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void inHospDepositPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws Exception {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.mchCode, this.bizSysSeq);
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntityDb = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(responseNotifyRestVo.getOutTradeNo());
        GatewayRequest depositReqGatewayRequest = this.buildDepositReqGetWay(inpatientDepositDetailEntityDb, responseNotifyRestVo);
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)JSON.toJSONString((Object)depositReqGatewayRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        GatewayResponse gatewayResponse = this.hospitalizationApi.deposit(depositReqGatewayRequest);
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u51fa\u53c2 :{}", (Object)JSON.toJSONString((Object)gatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (Objects.isNull(gatewayResponse)) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c deposit -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return;
        }
        if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c deposit -> his\u5145\u503c\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return;
        }
        InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
        inHospDepostPayCallDTO.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210 \u7b49\u5f85\u8c03\u7528his");
        inHospDepostPayCallDTO.setOrderSeq(inpatientDepositDetailEntityDb.getOrderSeq());
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
        inHospDepostPayCallDTO.setPayTime(DateUtil.now());
        this.inpatientDepositDetailEntityMapper.updateByOrderSeq(inHospDepostPayCallDTO);
        inHospDepostPayCallDTO.setDealSeq(responseNotifyRestVo.getMerchatOrderNo());
        this.inpatientPayorderEntityMapper.updateByInpatientDepositId(inHospDepostPayCallDTO);
        inHospDepostPayCallDTO.setReceiptId(((DepositRes)gatewayResponse.getData()).getReceiptId());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
        this.inpatientDepositDetailEntityMapper.updateByOrderSeqToHisPaid(inHospDepostPayCallDTO);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    private GatewayRequest<DepositReq> buildDepositReqGetWay(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DepositReq depositReq = new DepositReq();
        depositReq.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        depositReq.setPayChannel("CP");
        depositReq.setFlowNo(inpatientDepositDetailEntity.getOrderSeq());
        depositReq.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositReq.setBankTransNO(inpatientDepositDetailEntity.getReceiptId());
        DepositRespmsg depositRespmsg = new DepositRespmsg();
        depositRespmsg.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositRespmsg.setOrderid(responseNotifyRestVo.getTradeNo());
        depositRespmsg.setPayment(String.valueOf(responseNotifyRestVo.getTotalAmount()));
        depositRespmsg.setAccDate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        gatewayRequest.setBody((Object)depositReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inpatientDepositDetailEntity.getChannel()));
        gatewayRequest.setChannel(inpatientDepositDetailEntity.getChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("InHospDeposit");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void updateStatus(UpdateStatusVoReq updateStatusVoReq) throws AppointmentException {
        log.info("updateStatus\u65b9\u6cd5\u4f20\u5165\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)updateStatusVoReq, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(updateStatusVoReq.getSysAppointmentId());
        if (!Objects.isNull(appointmentRecordEntity)) {
            log.info("\u67e5\u8be2\u8ba2\u5355\u4e3a->{}", (Object)JSON.toJSONString((Object)appointmentRecordEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            String deptCode = appointmentRecordEntity.getDeptCode();
            String date = DateUtils.getCurrentDateToString();
            if (Objects.equals("9074", deptCode) || Objects.equals("9075", deptCode)) {
                try {
                    AppointmentRecordEntity appointmentRecordEntityNew = this.appointmentRecordMapper.selectBySysAppointId(updateStatusVoReq.getSysAppointmentId());
                    this.registerToday(appointmentRecordEntityNew);
                    this.appointmentRecordMapper.updateDate(updateStatusVoReq.getSysAppointmentId(), date);
                }
                catch (AppointmentException e) {
                    log.error("\u6838\u9178\u6302\u53f7\u5f02\u5e38", (Throwable)e);
                    throw e;
                }
            }
            try {
                AppointmentRecordEntity appointmentRecordEntityNew = this.appointmentRecordMapper.selectBySysAppointId(updateStatusVoReq.getSysAppointmentId());
                if (Objects.equals(appointmentRecordEntity.getAdmDate(), DateUtils.getCurrentDateSimpleToString())) {
                    this.registerToday(appointmentRecordEntityNew);
                } else {
                    this.registerBooking(appointmentRecordEntityNew);
                }
                this.appointmentRecordMapper.updateDate(updateStatusVoReq.getSysAppointmentId(), date);
            }
            catch (AppointmentException e) {
                log.error("\u6302\u53f7\u5f02\u5e38", (Throwable)e);
                throw e;
            }
        }
        log.error("\u8ba2\u5355\u7f16\u53f7\u6709\u8bef:{}", (Object)updateStatusVoReq);
    }

    public BaseResponse healthRegistered(HealthRegisteredReqVo healthRegisteredReqVo) throws InHospitalException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(healthRegisteredReqVo.getSysAppointmentId());
        if (!Objects.isNull(appointmentRecordEntity)) {
            AppointmentRecordEntity appointmentRecord = new AppointmentRecordEntity();
            appointmentRecord.setId(appointmentRecordEntity.getId());
            appointmentRecord.setAppointmentType(3);
            log.info("\u4fee\u6539\u5bf9\u8c61\u5165\u53c2{}", JSON.toJSON((Object)appointmentRecord));
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecord);
            log.info("\u6302\u53f7\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)appointmentRecordEntity));
            String deptCode = appointmentRecordEntity.getDeptCode();
            String date = DateUtils.getCurrentDateToString();
            if (Objects.equals("9074", deptCode) || Objects.equals("9075", deptCode)) {
                this.appointmentRecordMapper.updatePayTransationIdBysysId(appointmentRecordEntity.getSysAppointmentId(), "2022010888888888888");
                try {
                    AppointmentRecordEntity appointmentRecordEntityNew = this.appointmentRecordMapper.selectBySysAppointId(healthRegisteredReqVo.getSysAppointmentId());
                    this.registerToday(appointmentRecordEntityNew);
                    return BaseResponse.success((Object)"\u6838\u9178\u6302\u53f7\u6210\u529f");
                }
                catch (AppointmentException e) {
                    log.error("\u6838\u9178\u6302\u53f7\u5f02\u5e38", (Throwable)e);
                }
            } else {
                try {
                    AppointmentRecordEntity appointmentRecordEntityNew = this.appointmentRecordMapper.selectBySysAppointId(healthRegisteredReqVo.getSysAppointmentId());
                    if (Objects.equals(appointmentRecordEntityNew.getAdmDate(), DateUtils.getCurrentDateSimpleToString())) {
                        GatewayRequest payRegistrationReqGatewayRequest = this.buildHealthRegistered(appointmentRecordEntityNew, healthRegisteredReqVo);
                        log.info("\u8bf7\u6c42his\u533b\u4fdd\u6302\u53f7\u63a5\u53e3\u5165\u53c2\u4e3a->{}", (Object)JSON.toJSONString((Object)payRegistrationReqGatewayRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        GatewayResponse payRegistrationResGatewayResponse = this.appointApi.healthRegistered(payRegistrationReqGatewayRequest);
                        log.info("\u8bf7\u6c42his\u533b\u4fdd\u6302\u53f7\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a:{}", (Object)JSON.toJSONString((Object)payRegistrationResGatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        if (Objects.isNull(payRegistrationResGatewayResponse)) {
                            return BaseResponse.error((String)"his\u533b\u4fdd\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38");
                        }
                        HealthRegisteredResVo healthRegisteredResVo = new HealthRegisteredResVo();
                        if (!HIS_SUCCESS.equals(payRegistrationResGatewayResponse.getCode())) {
                            if ("-2".equals(payRegistrationResGatewayResponse.getErrCode())) {
                                String[] split = payRegistrationResGatewayResponse.getMsg().split("\\|");
                                healthRegisteredResVo.setSumMoney(split[1]);
                                healthRegisteredResVo.setMessage(split[2]);
                                return BaseResponse.success((Object)healthRegisteredResVo);
                            }
                            return BaseResponse.error((String)payRegistrationResGatewayResponse.getMsg());
                        }
                        this.healthRegistered(appointmentRecordEntityNew, payRegistrationResGatewayResponse);
                        this.appointmentRecordMapper.updateDate(appointmentRecordEntityNew.getSysAppointmentId(), date);
                        healthRegisteredResVo.setMessage(payRegistrationResGatewayResponse.getMsg());
                        return BaseResponse.success();
                    }
                    return BaseResponse.error((String)"\u975e\u5f53\u65e5\u6302\u53f7\u4e0d\u53ef\u4f7f\u7528\u533b\u4fdd\u6302\u53f7");
                }
                catch (Exception e) {
                    log.error("\u6302\u53f7\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return BaseResponse.error((String)"\u8ba2\u5355\u5f02\u5e38,\u8bf7\u91cd\u65b0\u6302\u53f7");
    }

    public BaseResponse<HealthBackPayResVo> healthBackPay(HealthBackReqVo healthBackReqVo) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(healthBackReqVo.getAppointmentId());
        log.info("\u533b\u4fdd\u9000\u53f7\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a:{}", (Object)appointmentRecordEntity);
        if (!Objects.isNull(appointmentRecordEntity)) {
            if (appointmentRecordEntity.getAppointmentType() == 1) {
                log.info("\u533b\u4fdd\u9000\u53f7\u7684\u8ba2\u5355\u4e3a\u9884\u7ea6\u53f7");
                return BaseResponse.error((String)"\u8be5\u6302\u53f7\u4e3a\u9884\u7ea6\u53f7,\u4e0d\u53ef\u8fdb\u884c\u5f53\u65e5\u53f7\u9000\u53f7\u6d41\u7a0b");
            }
            GatewayRequest gatewayRequest = new GatewayRequest();
            HealthBackPayReqVo healthBackPayReqVo = new HealthBackPayReqVo();
            healthBackPayReqVo.setClinicNo(appointmentRecordEntity.getAdmId());
            gatewayRequest.setBody((Object)healthBackPayReqVo);
            gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
            gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
            gatewayRequest.setKeyWord("healthBackPay");
            gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            GatewayResponse healthBackPayResVoGatewayResponse = this.appointApi.healthBackPay(gatewayRequest);
            if (Objects.isNull(healthBackPayResVoGatewayResponse)) {
                return BaseResponse.error((String)"his\u533b\u4fdd\u9000\u53f7\u8bf7\u6c42\u5f02\u5e38");
            }
            if (!HIS_SUCCESS.equals(healthBackPayResVoGatewayResponse.getCode())) {
                return BaseResponse.error((String)healthBackPayResVoGatewayResponse.getMsg());
            }
            AppointmentRecordEntity appointmentRecord = new AppointmentRecordEntity();
            appointmentRecord.setId(appointmentRecordEntity.getId());
            appointmentRecord.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
            appointmentRecord.setRemark(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getDisplay());
            appointmentRecord.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            appointmentRecord.setAdmRange(appointmentRecordEntity.getAdmRange());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecord);
            HealthBackPayResVo data = (HealthBackPayResVo)healthBackPayResVoGatewayResponse.getData();
            this.taskExecutor.execute(() -> {
                try {
                    this.jedisCluster.del(healthBackReqVo.getAppointmentId() + "_authCode");
                    this.pushService.alipayAppointmentSuccessMsgPush(healthBackReqVo.getAppointmentId(), "8", null);
                }
                catch (Exception e) {
                    log.error("\u652f\u4ed8\u5b9d\u667a\u80fd\u6d88\u606f\u63a8\u9001\u5931\u8d25");
                }
            });
            return BaseResponse.success((Object)data);
        }
        return BaseResponse.error((String)"\u8ba2\u5355\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u5b9e");
    }

    private GatewayRequest<PayRegistrationReq> buildHealthRegistered(AppointmentRecordEntity appointmentRecordEntity, HealthRegisteredReqVo healthRegisteredReqVo) throws Exception {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentNo());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getRegFee().toString());
        payRegistrationReq.setFlowNo(appointmentRecordEntity.getPayTransationId());
        payRegistrationReq.setAppointDate(appointmentRecordEntity.getAdmDate());
        payRegistrationReq.setPhone(appointmentRecordEntity.getPatientPhone());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(appointmentRecordEntity.getPayTransationId());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getRegFee().toString());
        payRegistrationMsg.setSuccess(SUCCESS);
        String patientIdCard = appointmentRecordEntity.getPatientIdCard();
        String birthStr = IdCardUtil.getBirthByIdCard2((String)patientIdCard);
        payRegistrationReq.setBirthDay(birthStr.replaceAll("-", "/"));
        String genderByIdCard = IdCardUtil.getGenderByIdCard((String)patientIdCard);
        payRegistrationReq.setSex(genderByIdCard);
        payRegistrationReq.setPactCode(healthRegisteredReqVo.getPactCode());
        payRegistrationReq.setDeptCode(appointmentRecordEntity.getDeptCode());
        payRegistrationReq.setDeptName(appointmentRecordEntity.getDeptName());
        payRegistrationReq.setDoctCode(appointmentRecordEntity.getDocCode());
        payRegistrationReq.setDoctName(appointmentRecordEntity.getDocName());
        payRegistrationReq.setRegLeve(appointmentRecordEntity.getPatientIndex());
        payRegistrationReq.setRegLeveName(appointmentRecordEntity.getRegTitleName());
        payRegistrationReq.setNoonID(String.valueOf(appointmentRecordEntity.getAdmRange()));
        payRegistrationReq.setName(appointmentRecordEntity.getPatientName());
        payRegistrationReq.setIdNo(healthRegisteredReqVo.getIdNo());
        payRegistrationReq.setPwd(EncryptionUtils.privateKeyEncrypt((String)healthRegisteredReqVo.getPwd()));
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("healthRegistered");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void registerToday(AppointmentRecordEntity appointmentRecordEntity) throws AppointmentException {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        log.info("\u5f53\u65e5appointStatus:{}", (Object)String.valueOf(appointStatus));
        ResponseNotifyRestVo responseNotifyRestVoParam = new ResponseNotifyRestVo();
        responseNotifyRestVoParam.setOrderNo(appointmentRecordEntity.getPayTransationId());
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVoParam, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVoParam, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVoParam);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayRegisterGatewayRes = this.appointApi.dayPayRegistration(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMsg());
            businessResultEntity.setTransationId(dayRegisterGatewayRes.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        String deptCode = appointmentRecordEntity.getDeptCode();
        if (null == dayRegisterGatewayRes && !Objects.equals("9074", deptCode) && !Objects.equals("9075", deptCode)) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 dayRegister -> \u8bf7\u6c42his\u4e0d\u901a");
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        if (!HIS_SUCCESS.equals(dayRegisterGatewayRes.getCode())) {
            if (!Objects.equals("9074", deptCode) && !Objects.equals("9075", deptCode)) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
                appointmentRecordEntity.setRemark(dayRegisterGatewayRes.getMsg());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
                log.error("\u5f53\u65e5\u6302\u53f7 dayRegister -> his\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)dayRegisterGatewayRes.getErrCode(), (Object)dayRegisterGatewayRes.getMsg());
            }
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        PayRegistrationRes dayRegisterRes = (PayRegistrationRes)dayRegisterGatewayRes.getData();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setTradeNo(appointmentRecordEntity.getPayTransationId());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVoParam.getOrderNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(Double.valueOf(appointmentRecordEntity.getRegFee().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(appointmentRecordEntity.getRegFee().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(appointmentRecordEntity.getPayTransationId());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    public void healthRegistered(AppointmentRecordEntity appointmentRecordEntity, GatewayResponse<PayRegistrationRes> payRegistrationResGatewayResponse) throws AppointmentException {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        log.info("\u533b\u4fdd\u5f53\u65e5appointStatus:{}", (Object)String.valueOf(appointStatus));
        ResponseNotifyRestVo responseNotifyRestVoParam = new ResponseNotifyRestVo();
        responseNotifyRestVoParam.setOrderNo(appointmentRecordEntity.getPayTransationId());
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVoParam, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVoParam, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVoParam);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        if (null != payRegistrationResGatewayResponse) {
            businessResultEntity.setErrorCode(payRegistrationResGatewayResponse.getErrCode());
            businessResultEntity.setErrorMsg(payRegistrationResGatewayResponse.getMsg());
            businessResultEntity.setTransationId(payRegistrationResGatewayResponse.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString(payRegistrationResGatewayResponse));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        String deptCode = appointmentRecordEntity.getDeptCode();
        PayRegistrationRes dayRegisterRes = (PayRegistrationRes)payRegistrationResGatewayResponse.getData();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setTradeNo(appointmentRecordEntity.getPayTransationId());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVoParam.getOrderNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(Double.valueOf(appointmentRecordEntity.getRegFee().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(appointmentRecordEntity.getRegFee().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(appointmentRecordEntity.getPayTransationId());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public void registerBooking(AppointmentRecordEntity appointmentRecordEntity) throws AppointmentException {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        ResponseNotifyRestVo responseNotifyRestVoParm = new ResponseNotifyRestVo();
        responseNotifyRestVoParm.setOrderNo(appointmentRecordEntity.getPayTransationId());
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVoParm, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        log.info("*************1 \u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u65b9\u786e\u8ba4");
        this.waitHisConfirm(responseNotifyRestVoParm, appointmentRecordEntity);
        this.payAppointmentPayToHis(appointmentRecordEntity, responseNotifyRestVoParm, payOrderEntity);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setTradeNo(responseNotifyRestVoParm.getOrderNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVoParm.getOrderNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(Double.valueOf(appointmentRecordEntity.getRegFee().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(appointmentRecordEntity.getRegFee().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVoParm.getOrderNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        log.info("\u6302\u53f7\u786e\u8ba4==============");
        GatewayRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity, responseNotifyRestVo);
        log.info("gatewayRequest=============={}", (Object)gatewayRequest);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u5165\u53c2 PayRegistrationReq{}", gatewayRequest.getBody());
        GatewayResponse gatewayResponse = this.appointApi.confirmRegister(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u51fa\u53c2 PayRegistrationRes{}", (Object)JSON.toJSONString((Object)gatewayResponse));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (gatewayResponse == null) {
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, null, null);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, null, null);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg());
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg() + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        ConfirmRegisterRes payRegistrationRes = (ConfirmRegisterRes)gatewayResponse.getData();
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        updatePayAppointment.setPayPostId(appointmentRecordEntity.getPayTransationId());
        updatePayAppointment.setPayTransationId(appointmentRecordEntity.getPayTransationId());
        updatePayAppointment.setPayChannel(PayChannelEnum.getDisplay((String)"WECHAT"));
        updatePayAppointment.setAppointNo(payRegistrationRes.getBookingNo());
        updatePayAppointment.setAdmAdress(payRegistrationRes.getAdmitAddress());
        if (null != payRegistrationRes) {
            updatePayAppointment.setAppointNo(payRegistrationRes.getNo());
            updatePayAppointment.setReceptId(payRegistrationRes.getAppointId());
        }
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        updatePayAppointment.setPayChannelCode(payRegistrationRes.getBookingNo());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        log.info("redis\u89e3\u9501key\u4e3a{}", (Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
        Boolean delete = this.redisTemplate.delete((Object)("HBBD-YYGH-SH-" + appointmentRecordEntity.getPatientCardNo() + "-" + appointmentRecordEntity.getDeptCode() + "-" + appointmentRecordEntity.getDocCode() + appointmentRecordEntity.getAdmDate()));
        log.info("\u53f7\u6e90\u89e3\u9501\u540e \u9700\u8981\u540c\u6b65\u5220\u9664redis key \u5f53\u524d\u5220\u9664redis key\u7ed3\u679c - > {}", (Object)delete);
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private GatewayRequest<ConfirmRegisterReq> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ConfirmRegisterReq payRegistrationReq = new ConfirmRegisterReq();
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        log.info("\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u4e3a->{}", (Object)responseNotifyRestVo.getPayChannel());
        if (null != responseNotifyRestVo.getPayChannel() && responseNotifyRestVo.getPayChannel().equals("ALIPAY")) {
            payRegistrationReq.setPayChannel(responseNotifyRestVo.getPayChannel());
            payRegistrationReq.setFlowNo(responseNotifyRestVo.getTradeNo());
            payRegistrationReq.setOrderNumber(responseNotifyRestVo.getTradeNo());
            payRegistrationReq.setTransNo(responseNotifyRestVo.getTradeNo());
            payRegistrationMsg.setOrderid(responseNotifyRestVo.getTradeNo());
            payRegistrationReq.setMark(appointmentRecordEntity.getSeeNo());
        } else {
            payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayTransationId());
            payRegistrationReq.setFlowNo(appointmentRecordEntity.getPayTransationId());
            payRegistrationReq.setOrderNumber(responseNotifyRestVo.getOrderNo());
            payRegistrationReq.setTransNo(responseNotifyRestVo.getOrderNo());
            payRegistrationMsg.setOrderid(responseNotifyRestVo.getOrderNo());
        }
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientName(appointmentRecordEntity.getPatientName());
        payRegistrationReq.setMark(appointmentRecordEntity.getSeeNo());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getRegFee().toString());
        payRegistrationReq.setRelaPhone(appointmentRecordEntity.getPatientPhone());
        payRegistrationReq.setIdNo(appointmentRecordEntity.getPatientIdCard());
        payRegistrationReq.setSchemaId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setSortId(appointmentRecordEntity.getTakeTime());
        payRegistrationReq.setIsFirst(HIS_SUCCESS);
        String admTimeRange = appointmentRecordEntity.getAdmTimeRange();
        String[] split = admTimeRange.split("-");
        payRegistrationReq.setBeginTime(split[0]);
        payRegistrationReq.setEndTime(split[1]);
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("PayRegistrationReq");
        gatewayRequest.setTransactionId(String.valueOf(System.currentTimeMillis()));
        return gatewayRequest;
    }

    private OpGuideEntity buildOpGuideEntity(OpBusinessOrderEntity opBusinessOrderEntity, GatewayResponse<ComfirmPayNewRes> gatewayResponse) {
        OpGuideEntity opGuideEntity = new OpGuideEntity();
        Date now = new Date();
        opGuideEntity.setGuideInfoId(String.valueOf(this.snowflakeIdWorker.nextId()));
        opGuideEntity.setGuideInfo(((ComfirmPayNewRes)gatewayResponse.getData()).getRemark());
        opGuideEntity.setCreateTime(now);
        opGuideEntity.setUpdateTime(now);
        opGuideEntity.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        opGuideEntity.setAdmId(opBusinessOrderEntity.getAdmId());
        opGuideEntity.setPatientId(opBusinessOrderEntity.getPatientId());
        opGuideEntity.setPatientOrganId(opBusinessOrderEntity.getPatientOrganId());
        opGuideEntity.setCardNo(opBusinessOrderEntity.getCardNo());
        opGuideEntity.setCardId(opBusinessOrderEntity.getCardId());
        opGuideEntity.setUserId(opBusinessOrderEntity.getUserId());
        opGuideEntity.setOrganCode(opBusinessOrderEntity.getOrganCode());
        opGuideEntity.setOrganName(opBusinessOrderEntity.getOrganName());
        return opGuideEntity;
    }

    private GatewayResponse<ComfirmPayNewRes> comfirmPayNew(GatewayRequest<ComfirmPayNewReq> gatewayRequest) throws OutpatientPaymentException {
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(gatewayRequest);
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 gatewayResponse ->{}" + gatewayResponse.toString() + gatewayResponse.getCode() + gatewayResponse.getMsg() + gatewayResponse.getData());
        if (gatewayResponse == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        log.info("gatewayResponse.getData():" + ((ComfirmPayNewRes)gatewayResponse.getData()).toString());
        ComfirmPayNewRes comfirmPayNewRes = (ComfirmPayNewRes)gatewayResponse.getData();
        if (null == comfirmPayNewRes) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
            throw new OutpatientPaymentException("his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
        }
        return gatewayResponse;
    }

    private GatewayRequest<ComfirmPayNewReq> buildComfirmPayNewReq(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setId(opBusinessOrderEntity.getAdmId());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setPaychannel(opRechargePaymentOrderEntity.getPaymentSeq());
        comfirmPayNewReq.setFlowNo(opBusinessOrderEntity.getOutPatientId());
        comfirmPayNewReq.setPrescriptionNos(opBusinessOrderEntity.getReceiptId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        comfirmPayNewReqMsg.setPayment(opRechargePaymentOrderEntity.getDealMoney().toString());
        comfirmPayNewReqMsg.setAccdate(DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime()));
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)opBusinessOrderEntity.getChannelCode()));
        gatewayRequest.setChannel(opBusinessOrderEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RefundCallBackReq refundCallBackReq = new RefundCallBackReq();
        refundCallBackReq.setFlowNo(orderNo);
        refundCallBackReq.setRefundTrandNo(responseRefundNotifyRestVo.getRefundNo());
        refundCallBackReq.setMoney(String.valueOf(responseRefundNotifyRestVo.getRefundMoney()));
        gatewayRequest.setBody((Object)refundCallBackReq);
        gatewayRequest.setChannel(responseRefundNotifyRestVo.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("refundResult");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse refundCallBack = this.hisBillApi.refundCallBack(gatewayRequest);
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        return refundCallBack.isSuccess() && HIS_SUCCESS.equals(((RefundCallBackRes)refundCallBack.getData()).getState());
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), refundSerialNo);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }
}

