/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorInformationMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.TExpertNationalMapper;
import com.ebaiyihui.wisdommedical.model.DeptRecordEntity;
import com.ebaiyihui.wisdommedical.model.DoctorInformationEntity;
import com.ebaiyihui.wisdommedical.model.ExpertNationalEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.model.VO.GetDeptDoctorInfoVo;
import com.ebaiyihui.wisdommedical.pojo.dto.DoctorBaseInfoListDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.GetScheduleDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.DayDoctorScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RecommendedDoctorInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleStatusResVO;
import com.ebaiyihui.wisdommedical.service.DoctorInformationService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private TExpertNationalMapper tExpertNationalMapper;
    @Autowired
    private DoctorInformationService doctorInformationService;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private DoctorInformationMapper doctorInformationMapper;
    private static final String[] WEEK_DAYS = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private String GENERAL_HOSPITAL_AREA = "1000";
    private String WEST_YARD = "1001";
    public static int defaultDay = 7;

    public List<GetScheduleVoRes> getSchedule(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        ArrayList<GetScheduleVoRes> getScheduleVoResList = new ArrayList<GetScheduleVoRes>();
        String lyyDeptCode = "1033";
        if (lyyDeptCode.equals(getScheduleVoReq.getDeptCode())) {
            String theDay = DateUtils.getCurrentDateSimpleToString();
            String nextDay = DateUtils.getNextDayToString((String)theDay);
            if (!theDay.equals(getScheduleVoReq.getStartDate()) && !nextDay.equals(getScheduleVoReq.getStartDate())) {
                return getScheduleVoResList;
            }
        }
        List expertNationalEntityList = this.tExpertNationalMapper.selectByDeptCode(getScheduleVoReq.getFirstDeptCode(), getScheduleVoReq.getDeptCode());
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(getScheduleVoReq);
        log.info("\u5b9e\u65f6\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u5b9e\u65f6\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
            return new ArrayList<GetScheduleVoRes>();
        }
        log.info("\u8fc7\u6ee4\u8fc7\u65f6\u7684\u53f7\u6e90\u4e4b\u540e\uff1a" + scheduleResItemsList);
        LinkedHashMap getScheduleResItemMap = scheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode, LinkedHashMap::new, Collectors.toList()));
        log.info("\u67e5\u8be2\u4eac\u6d25\u4e13\u5bb6\u8fd4\u56de\u503c\u4e3a\uff1a" + expertNationalEntityList);
        if (!CollectionUtils.isEmpty((Collection)expertNationalEntityList)) {
            LinkedHashMap getScheduleResItemNewMap = new LinkedHashMap();
            for (ExpertNationalEntity expertNationalEntity : expertNationalEntityList) {
                List getScheduleResItems = (List)getScheduleResItemMap.get(expertNationalEntity.getDocCode());
                if (CollectionUtils.isEmpty((Collection)getScheduleResItems)) continue;
                getScheduleResItemNewMap.put(expertNationalEntity.getDocCode(), getScheduleResItemMap.get(expertNationalEntity.getDocCode()));
            }
            log.info("\u8fc7\u6ee4\u4eac\u6d25\u4e13\u5bb6\u672a\u8d4b\u503c\u524d\uff1a" + JSON.toJSONString(getScheduleResItemNewMap));
            getScheduleResItemMap = getScheduleResItemNewMap;
        }
        log.info("\u8fc7\u6ee4\u4eac\u6d25\u4e13\u8d4b\u503c\u540e\u524d\uff1a" + JSON.toJSONString((Object)getScheduleResItemMap));
        log.info("\u6839\u636edoccode\u5206\u7ec4\u4e4b\u540e\uff1a" + scheduleResItemsList);
        LinkedHashMap finalGetScheduleResItemMap = getScheduleResItemMap;
        getScheduleResItemMap.keySet().forEach(docCode -> {
            GetScheduleResItems getScheduleResItems = (GetScheduleResItems)((List)finalGetScheduleResItemMap.get(docCode)).get(0);
            GetScheduleVoRes getScheduleVoRes = this.buildGetScheduleVoResVo(getScheduleResItems);
            List scheduleBaseInfoVoList = ((List)finalGetScheduleResItemMap.get(docCode)).stream().map(scheduleResItem -> this.buildScheduleBaseInfoVo(scheduleResItem)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            getScheduleVoResList.add(getScheduleVoRes);
        });
        log.info("\u5f00\u59cb\u83b7\u53d6\u9662\u533acode - > {}", (Object)JSON.toJSONString(getScheduleVoResList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        List hospitalAreaAddress = this.getHospitalAreaCode(getScheduleVoResList);
        List<GetScheduleVoRes> collect = hospitalAreaAddress.stream().map(item -> {
            if (item.getSort() == 0) {
                item.setSort(Integer.valueOf(100));
            }
            return item;
        }).collect(Collectors.toList());
        Collections.sort(collect);
        return collect;
    }

    public List<GetScheduleVoRes> getHospitalAreaCode(List<GetScheduleVoRes> scheduleVoResList) {
        List deptRecordEntities = this.deptRecordMapper.selectAll();
        List<GetScheduleVoRes> collect1 = scheduleVoResList.stream().map(p -> {
            List collect = deptRecordEntities.stream().filter(d -> d.getDeptCode().equals(p.getLocCode())).collect(Collectors.toList());
            log.info("\u6839\u636e\u4e8c\u7ea7code \u7b5b\u9009\u51fa\u6765\u7684\u9662\u533a - > {}", (Object)JSON.toJSONString(collect, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (collect.size() == 0) {
                p.setHospitalAreaCode("1000");
                log.error("\u83b7\u53d6\u5230\u4e8c\u7ea7\u79d1\u5ba4code\u4e3a\u7a7a");
                return p;
            }
            p.setHospitalAreaCode(((DeptRecordEntity)collect.get(0)).getHospitalAreaCode());
            log.info("\u8fd4\u56de\u7684\u7ec4\u88c5\u540e\u7684\u5bf9\u8c61 - > {}", (Object)JSON.toJSONString((Object)p, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return p;
        }).collect(Collectors.toList());
        return collect1;
    }

    private GetScheduleVoRes buildGetScheduleVoResVo(GetScheduleResItems scheduleResItem) {
        GetScheduleVoRes getScheduleVoRes = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doc_code", (Object)scheduleResItem.getDocCode());
        queryWrapper.eq((Object)"dept_code", (Object)scheduleResItem.getLocCode());
        List list = this.doctorInformationService.list((Wrapper)queryWrapper);
        try {
            getScheduleVoRes = new GetScheduleVoRes();
            getScheduleVoRes.setDocCode(scheduleResItem.getDocCode());
            getScheduleVoRes.setDocName(scheduleResItem.getDocName());
            getScheduleVoRes.setHospitalArea(scheduleResItem.getHospitalArea());
            getScheduleVoRes.setHospitalAreaCode(scheduleResItem.getHospitalAreaCode());
            getScheduleVoRes.setLocCode(scheduleResItem.getLocCode());
            getScheduleVoRes.setLocName(scheduleResItem.getLocName());
            getScheduleVoRes.setRegTitleCode(scheduleResItem.getRegTitleCode());
            getScheduleVoRes.setRegTitleName(scheduleResItem.getRegTitleName());
            getScheduleVoRes.setSort(Integer.valueOf(0));
            if (list.size() == 0) {
                log.info("\u5f53\u524d\u79d1\u5ba4\u4e0b\u7684\u533b\u751f\u6682\u672a\u5728\u7cfb\u7edf\u4e2d\u7ef4\u62a4 \u6682\u65e0\u533b\u751f\u5934\u50cf \u7b80\u4ecb");
                return getScheduleVoRes;
            }
            getScheduleVoRes.setDoctorHeadPortrait(((DoctorInformationEntity)list.get(0)).getDoctorPortraitAddress());
            getScheduleVoRes.setDoctorSpeciality(((DoctorInformationEntity)list.get(0)).getAreasExpertise());
            getScheduleVoRes.setProfile(((DoctorInformationEntity)list.get(0)).getDoctorProfile());
            getScheduleVoRes.setSort(((DoctorInformationEntity)list.get(0)).getSort());
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u533b\u751f\u6570\u636e\u51fa\u73b0\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\u4e3a - > {}", (Object)e.getMessage());
        }
        return getScheduleVoRes;
    }

    public GetDoctorScheduleVoRes getDoctorSchedule(GetDoctorScheduleVoReq getDoctorScheduleVoReq) throws ScheduleException {
        String theDay = DateUtils.getCurrentDateSimpleToString();
        List<Object> scheduleResItemsList = new ArrayList();
        int defauDay = 7;
        String lyyDeptCode = "1033";
        if (lyyDeptCode.equals(getDoctorScheduleVoReq.getDeptCode())) {
            defauDay = 2;
        }
        for (int i = 0; i < defauDay; ++i) {
            getDoctorScheduleVoReq.setStartDate(theDay);
            getDoctorScheduleVoReq.setEndDate(theDay);
            GatewayRequest gatewayRequest = this.buildGetDoctorScheduleGatewayReq(getDoctorScheduleVoReq);
            List itemsList = this.getDocSchedule(gatewayRequest);
            theDay = DateUtils.getNextDayToString((String)theDay);
            if (CollectionUtils.isEmpty((Collection)itemsList)) continue;
            scheduleResItemsList.addAll(itemsList);
        }
        if (CollectionUtils.isEmpty(scheduleResItemsList = scheduleResItemsList.stream().map(getScheduleResItems -> {
            getScheduleResItems.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate())));
            return getScheduleResItems;
        }).collect(Collectors.toList()))) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        GetDoctorScheduleVoRes getDoctorScheduleVoRes = new GetDoctorScheduleVoRes();
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
        getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
        getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
        getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
        getDoctorScheduleVoRes.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
        getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleResItems.getAdmDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemsMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getAdmDate));
        ArrayList dayDoctorScheduleVoList = new ArrayList();
        List<String> admDateList = getScheduleResItemsMap.keySet().stream().map(amdDate -> amdDate).collect(Collectors.toList());
        admDateList.sort(Comparator.comparing(admDate -> admDate));
        admDateList.forEach(amdDate -> {
            DayDoctorScheduleVo dayDoctorScheduleVo = new DayDoctorScheduleVo();
            List getScheduleResItems = (List)getScheduleResItemsMap.get(amdDate);
            List scheduleBaseInfoVoList = getScheduleResItems.stream().map(getScheduleRes -> this.buildScheduleBaseInfoVo(getScheduleRes)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            dayDoctorScheduleVo.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            dayDoctorScheduleVoList.add(dayDoctorScheduleVo);
        });
        getDoctorScheduleVoRes.setDayDoctorScheduleVoList(dayDoctorScheduleVoList);
        List doctorBaseInfoDTOList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), (List)new /* Unavailable Anonymous Inner Class!! */);
        if (!CollectionUtils.isEmpty((Collection)doctorBaseInfoDTOList)) {
            getDoctorScheduleVoRes.setDoctorHeadPortrait(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getHeadPortrait());
            getDoctorScheduleVoRes.setDoctorSpeciality(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getSpeciality());
            getDoctorScheduleVoRes.setDoctorIntroduce(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getProfile());
            getDoctorScheduleVoRes.setDocCode(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getDocCode());
            getDoctorScheduleVoRes.setDocName(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getDocName());
            getDoctorScheduleVoRes.setDoctorScore(5.0);
            getDoctorScheduleVoRes.setCommentOfDoctorRes(null);
        }
        Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        getDoctorScheduleVoRes.setAppointmentCount(appointmentCount);
        List scheduleRecordEntityList = this.scheduleRecordMapper.selectRecommendedDoctor(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getDeptCode(), getDoctorScheduleVoReq.getOrganCode());
        if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
            List doctorCodeList = scheduleRecordEntityList.stream().map(ScheduleRecordEntity::getDocCode).collect(Collectors.toList());
            List doctorInfoList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), doctorCodeList);
            Map<String, DoctorBaseInfoListDTO> doctorBaseInfoDTOMap = doctorInfoList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfo.getEmplCode(), doctorBaseInfoDTO -> doctorBaseInfoDTO));
            if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
                List recommendedDoctorInfoVoList = scheduleRecordEntityList.stream().map(scheduleRecordEntity -> {
                    RecommendedDoctorInfoVo recommendedDoctorInfoVo = new RecommendedDoctorInfoVo();
                    recommendedDoctorInfoVo.setDeptCode(scheduleRecordEntity.getDeptCode());
                    recommendedDoctorInfoVo.setDeptName(scheduleRecordEntity.getDeptName());
                    recommendedDoctorInfoVo.setDoctorCode(scheduleRecordEntity.getDocCode());
                    recommendedDoctorInfoVo.setDoctorName(scheduleRecordEntity.getDocName());
                    recommendedDoctorInfoVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
                    DoctorBaseInfoListDTO doctorBaseInfo = (DoctorBaseInfoListDTO)doctorBaseInfoDTOMap.get(scheduleRecordEntity.getDocCode());
                    if (null != doctorBaseInfo) {
                        recommendedDoctorInfoVo.setDoctorHeadPortrait(doctorBaseInfo.getHeadPortrait());
                        recommendedDoctorInfoVo.setDoctorSpeciality(doctorBaseInfo.getSpeciality());
                        recommendedDoctorInfoVo.setDoctorGender(String.valueOf(doctorBaseInfo.getGender()));
                        recommendedDoctorInfoVo.setDoctorScore(new Double(5.0));
                    }
                    Integer count = this.appointmentRecordMapper.selectDoctorAppointmentCount(scheduleRecordEntity.getDocCode(), scheduleRecordEntity.getHospitalCode());
                    recommendedDoctorInfoVo.setAppointmentCount(count);
                    return recommendedDoctorInfoVo;
                }).collect(Collectors.toList());
                getDoctorScheduleVoRes.setRecommendedDoctorInfoVoList(recommendedDoctorInfoVoList);
            }
        }
        return getDoctorScheduleVoRes;
    }

    public GetDoctorScheduleVoRes getDoctorScheduleCourtyard(GetDoctorScheduleVoReq getDoctorScheduleVoReq) throws ScheduleException {
        log.info("getDoctorScheduleCourtyard\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)getDoctorScheduleVoReq));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dept_name", (Object)getDoctorScheduleVoReq.getDeptName());
        queryWrapper.eq((Object)"doc_code", (Object)getDoctorScheduleVoReq.getDoctorCode());
        queryWrapper.eq((Object)"affiliated_hospital", (Object)getDoctorScheduleVoReq.getHospitalName());
        DoctorInformationEntity doctorInformationEntity = (DoctorInformationEntity)this.doctorInformationMapper.selectOne((Wrapper)queryWrapper);
        log.info("getDoctorScheduleCourtyard\u67e5\u8be2\u5230\u7684\u5bf9\u8c61\u4e3a->{}", (Object)JSON.toJSONString((Object)doctorInformationEntity));
        if (BeanUtil.isEmpty((Object)doctorInformationEntity, (String[])new String[0])) {
            return new GetDoctorScheduleVoRes();
        }
        getDoctorScheduleVoReq.setDeptCode(doctorInformationEntity.getDeptCode());
        String theDay = DateUtils.getCurrentDateSimpleToString();
        List<Object> scheduleResItemsList = new ArrayList();
        int defauDay = 7;
        String lyyDeptCode = "1033";
        if (lyyDeptCode.equals(getDoctorScheduleVoReq.getDeptCode())) {
            defauDay = 2;
        }
        for (int i = 0; i < defauDay; ++i) {
            getDoctorScheduleVoReq.setStartDate(theDay);
            getDoctorScheduleVoReq.setEndDate(theDay);
            GatewayRequest gatewayRequest = this.buildGetDoctorScheduleGatewayReq(getDoctorScheduleVoReq);
            List itemsList = this.getDocSchedule(gatewayRequest);
            theDay = DateUtils.getNextDayToString((String)theDay);
            if (CollectionUtils.isEmpty((Collection)itemsList)) continue;
            scheduleResItemsList.addAll(itemsList);
        }
        if (CollectionUtils.isEmpty(scheduleResItemsList = scheduleResItemsList.stream().map(getScheduleResItems -> {
            getScheduleResItems.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate())));
            return getScheduleResItems;
        }).collect(Collectors.toList()))) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        GetDoctorScheduleVoRes getDoctorScheduleVoRes = new GetDoctorScheduleVoRes();
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
        getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
        getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
        getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
        getDoctorScheduleVoRes.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
        getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleResItems.getAdmDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemsMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getAdmDate));
        ArrayList dayDoctorScheduleVoList = new ArrayList();
        List<String> admDateList = getScheduleResItemsMap.keySet().stream().map(amdDate -> amdDate).collect(Collectors.toList());
        admDateList.sort(Comparator.comparing(admDate -> admDate));
        admDateList.forEach(amdDate -> {
            DayDoctorScheduleVo dayDoctorScheduleVo = new DayDoctorScheduleVo();
            List getScheduleResItems = (List)getScheduleResItemsMap.get(amdDate);
            List scheduleBaseInfoVoList = getScheduleResItems.stream().map(getScheduleRes -> this.buildScheduleBaseInfoVo(getScheduleRes)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            dayDoctorScheduleVo.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            dayDoctorScheduleVoList.add(dayDoctorScheduleVo);
        });
        getDoctorScheduleVoRes.setDayDoctorScheduleVoList(dayDoctorScheduleVoList);
        List doctorBaseInfoDTOList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), (List)new /* Unavailable Anonymous Inner Class!! */);
        if (!CollectionUtils.isEmpty((Collection)doctorBaseInfoDTOList)) {
            getDoctorScheduleVoRes.setDoctorHeadPortrait(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getHeadPortrait());
            getDoctorScheduleVoRes.setDoctorSpeciality(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getSpeciality());
            getDoctorScheduleVoRes.setDoctorIntroduce(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getProfile());
            getDoctorScheduleVoRes.setDocCode(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getDocCode());
            getDoctorScheduleVoRes.setDocName(((DoctorBaseInfoListDTO)doctorBaseInfoDTOList.get(0)).getDocName());
            getDoctorScheduleVoRes.setDoctorScore(5.0);
            getDoctorScheduleVoRes.setCommentOfDoctorRes(null);
        }
        Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        getDoctorScheduleVoRes.setAppointmentCount(appointmentCount);
        List scheduleRecordEntityList = this.scheduleRecordMapper.selectRecommendedDoctor(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getDeptCode(), getDoctorScheduleVoReq.getOrganCode());
        if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
            List doctorCodeList = scheduleRecordEntityList.stream().map(ScheduleRecordEntity::getDocCode).collect(Collectors.toList());
            List doctorInfoList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), doctorCodeList);
            Map<String, DoctorBaseInfoListDTO> doctorBaseInfoDTOMap = doctorInfoList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfo.getEmplCode(), doctorBaseInfoDTO -> doctorBaseInfoDTO));
            if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
                List recommendedDoctorInfoVoList = scheduleRecordEntityList.stream().map(scheduleRecordEntity -> {
                    RecommendedDoctorInfoVo recommendedDoctorInfoVo = new RecommendedDoctorInfoVo();
                    recommendedDoctorInfoVo.setDeptCode(scheduleRecordEntity.getDeptCode());
                    recommendedDoctorInfoVo.setDeptName(scheduleRecordEntity.getDeptName());
                    recommendedDoctorInfoVo.setDoctorCode(scheduleRecordEntity.getDocCode());
                    recommendedDoctorInfoVo.setDoctorName(scheduleRecordEntity.getDocName());
                    recommendedDoctorInfoVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
                    DoctorBaseInfoListDTO doctorBaseInfo = (DoctorBaseInfoListDTO)doctorBaseInfoDTOMap.get(scheduleRecordEntity.getDocCode());
                    if (null != doctorBaseInfo) {
                        recommendedDoctorInfoVo.setDoctorHeadPortrait(doctorBaseInfo.getHeadPortrait());
                        recommendedDoctorInfoVo.setDoctorSpeciality(doctorBaseInfo.getSpeciality());
                        recommendedDoctorInfoVo.setDoctorGender(String.valueOf(doctorBaseInfo.getGender()));
                        recommendedDoctorInfoVo.setDoctorScore(new Double(5.0));
                    }
                    Integer count = this.appointmentRecordMapper.selectDoctorAppointmentCount(scheduleRecordEntity.getDocCode(), scheduleRecordEntity.getHospitalCode());
                    recommendedDoctorInfoVo.setAppointmentCount(count);
                    return recommendedDoctorInfoVo;
                }).collect(Collectors.toList());
                getDoctorScheduleVoRes.setRecommendedDoctorInfoVoList(recommendedDoctorInfoVoList);
            }
        }
        return getDoctorScheduleVoRes;
    }

    public List<ScheduleStatusResVO> getScheduleStatus(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        String admDate = DateUtils.getCurrentDateSimpleToString();
        ArrayList<ScheduleStatusResVO> list = new ArrayList<ScheduleStatusResVO>();
        int defauDay = 7;
        String lyyDeptCode = "1033";
        if (lyyDeptCode.equals(getScheduleVoReq.getDeptCode())) {
            defauDay = 2;
        }
        for (int i = 0; i < defauDay; ++i) {
            ScheduleStatusResVO scheduleStatusResVO = new ScheduleStatusResVO();
            getScheduleVoReq.setStartDate(admDate);
            getScheduleVoReq.setEndDate(admDate);
            GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(getScheduleVoReq);
            boolean flag = false;
            flag = getScheduleVoReq.getTesting() != null ? this.getSchduleStatus(gatewayRequest) : this.getHsSchduleStatus(gatewayRequest, getScheduleVoReq);
            if (flag) {
                scheduleStatusResVO.setStatus("1");
            } else {
                scheduleStatusResVO.setStatus("-1");
            }
            scheduleStatusResVO.setAdmDate(admDate);
            if (admDate.equals(DateUtils.getCurrentDateSimpleToString())) {
                scheduleStatusResVO.setWeek("\u4eca\u5929");
            } else {
                scheduleStatusResVO.setWeek(DateUtils.getWeekSimpleChinese((String)admDate));
            }
            scheduleStatusResVO.setViewDate(admDate.replace("-", ".").substring(5));
            list.add(scheduleStatusResVO);
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
        return list;
    }

    public List<GetDeptDoctorInfoResItems> getDeptDoctorInfo(GetDeptDoctorInfoVo param) throws ScheduleException {
        String theDay = DateUtils.getCurrentDateToString();
        ArrayList<GetDeptDoctorInfoResItems> scheduleResItemsList = new ArrayList<GetDeptDoctorInfoResItems>();
        int defauDay = 7;
        String lyyDeptCode = "1033";
        if (lyyDeptCode.equals(param.getDeptCode())) {
            defauDay = 2;
        }
        for (int i = 0; i < defauDay; ++i) {
            param.setBookingDate(theDay);
            GatewayRequest gatewayRequest = this.buildGetDeptDoctorInfoGatewayReq(param);
            List itemsList = this.getDeptDoctorInfo(gatewayRequest);
            theDay = DateUtils.getNextDayToString((String)theDay);
            if (CollectionUtils.isEmpty((Collection)itemsList)) continue;
            scheduleResItemsList.addAll(itemsList);
        }
        return scheduleResItemsList;
    }

    private ScheduleBaseInfoVo buildScheduleBaseInfoVo(GetScheduleResItems scheduleResItem) {
        ScheduleBaseInfoVo scheduleBaseInfoVo = new ScheduleBaseInfoVo();
        BigDecimal countRegex = new BigDecimal(scheduleResItem.getRegFee()).add(new BigDecimal(scheduleResItem.getDiagFee()));
        scheduleBaseInfoVo.setRegFee(String.valueOf(new BigDecimal(scheduleResItem.getRegFee()).doubleValue()));
        scheduleBaseInfoVo.setDiagFee(scheduleResItem.getDiagFee());
        BigDecimal totalFee = new BigDecimal(scheduleResItem.getRegFee()).add(new BigDecimal(scheduleResItem.getDiagFee()));
        scheduleBaseInfoVo.setTotalFee(String.valueOf(totalFee.doubleValue()));
        scheduleBaseInfoVo.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)scheduleResItem.getAdmDate())));
        scheduleBaseInfoVo.setAdmTimeRange(scheduleResItem.getAdmTimeRange());
        scheduleBaseInfoVo.setAppStartNo(scheduleResItem.getAppStartNo());
        scheduleBaseInfoVo.setIsTimeArrange(scheduleResItem.getIsTimeArrange());
        scheduleBaseInfoVo.setLocTypeCode(scheduleResItem.getLocTypeCode());
        scheduleBaseInfoVo.setLocTypeName(scheduleResItem.getLocTypeName());
        scheduleBaseInfoVo.setRegAvailable(scheduleResItem.getRegAvailable());
        scheduleBaseInfoVo.setRegTotal(scheduleResItem.getRegTotal());
        scheduleBaseInfoVo.setReplaceScheduleId(scheduleResItem.getReplaceScheduleId());
        scheduleBaseInfoVo.setScheduleId(scheduleResItem.getScheduleId());
        scheduleBaseInfoVo.setScheduleLevelCode(scheduleResItem.getScheduleLevelCode());
        scheduleBaseInfoVo.setScheduleLevelName(scheduleResItem.getScheduleLevelName());
        scheduleBaseInfoVo.setScheduleStatus("1");
        scheduleBaseInfoVo.setScheduleType(scheduleResItem.getScheduleType());
        scheduleBaseInfoVo.setAdmDate(scheduleResItem.getAdmDate());
        scheduleBaseInfoVo.setBranchCode(scheduleResItem.getBranchCode());
        String isAppend = scheduleResItem.getIsAppend();
        if (StringUtils.isEmpty((CharSequence)isAppend)) {
            isAppend = "0";
        }
        scheduleBaseInfoVo.setIsAppend(isAppend);
        ArrayList timeArrangeItemsList = scheduleResItem.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            timeArrangeItemsList = new ArrayList();
        }
        scheduleBaseInfoVo.setTimeArrangeItems((List)timeArrangeItemsList);
        return scheduleBaseInfoVo;
    }

    private List<DoctorBaseInfoListDTO> getDoctorInfoList(String organId, List<String> doctorCodeList) throws ScheduleException {
        if (CollectionUtils.isEmpty(doctorCodeList)) {
            return new ArrayList<DoctorBaseInfoListDTO>();
        }
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570 doctorCodeList={},organId={}", doctorCodeList, (Object)organId);
        QueryWrapper doctorInformationEntityQueryWrapper = new QueryWrapper();
        doctorInformationEntityQueryWrapper.in((Object)"doc_code", doctorCodeList);
        doctorInformationEntityQueryWrapper.eq((Object)"hospital_code", (Object)organId);
        doctorInformationEntityQueryWrapper.eq((Object)"status", (Object)"1");
        List list = this.doctorInformationService.list((Wrapper)doctorInformationEntityQueryWrapper);
        log.info("\u533b\u751f\u57fa\u7840\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)list, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        ArrayList<DoctorBaseInfoListDTO> doctorBaseInfoDTOList = new ArrayList<DoctorBaseInfoListDTO>();
        for (DoctorInformationEntity doctorInformationEntity : list) {
            DoctorBaseInfoListDTO doctorInfoListDTO = new DoctorBaseInfoListDTO();
            doctorInfoListDTO.setHeadPortrait(doctorInformationEntity.getDoctorPortraitAddress());
            doctorInfoListDTO.setDocName(doctorInformationEntity.getDocName());
            doctorInfoListDTO.setDocCode(doctorInformationEntity.getDocCode());
            doctorInfoListDTO.setId(doctorInformationEntity.getDocCode());
            doctorInfoListDTO.setEmplCode(doctorInformationEntity.getDocCode());
            doctorInfoListDTO.setOrganId(doctorInformationEntity.getHospitalCode());
            doctorInfoListDTO.setProfile(doctorInformationEntity.getDoctorProfile());
            doctorInfoListDTO.setSpeciality(doctorInformationEntity.getAreasExpertise());
            doctorInfoListDTO.setSort(doctorInformationEntity.getSort());
            doctorBaseInfoDTOList.add(doctorInfoListDTO);
        }
        if (doctorBaseInfoDTOList == null) {
            return new ArrayList<DoctorBaseInfoListDTO>();
        }
        return doctorBaseInfoDTOList;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(GetScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(getScheduleVoReq.getScheduleCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetDoctorScheduleGatewayReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetDeptDoctorInfoReqVO> buildGetDeptDoctorInfoGatewayReq(GetDeptDoctorInfoVo getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetDeptDoctorInfoReqVO getScheduleReqVO = new GetDeptDoctorInfoReqVO();
        getScheduleReqVO.setBookingDate(getDoctorScheduleVoReq.getBookingDate());
        getScheduleReqVO.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setNoonCode(getDoctorScheduleVoReq.getNoonCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildDaySchduleReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDaySchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GetScheduleResItems buildGetScheduleResItems(ScheduleRecordEntity scheduleRecordEntity, List<TimeArrangeItems> timeArrangeItemsList) {
        GetScheduleResItems scheduleResItems = new GetScheduleResItems();
        scheduleResItems.setScheduleId(scheduleRecordEntity.getScheduleHisId());
        scheduleResItems.setScheduleType(Integer.valueOf(scheduleRecordEntity.getScheduleType().intValue()));
        scheduleResItems.setAdmDate(DateUtils.dateToString((Date)scheduleRecordEntity.getScheduleDate(), (String)"yyyy-MM-dd"));
        scheduleResItems.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
        scheduleResItems.setHospitalArea(scheduleRecordEntity.getHospitalAreaName());
        scheduleResItems.setHospitalAreaCode(scheduleRecordEntity.getHospitalArea());
        scheduleResItems.setDocCode(scheduleRecordEntity.getDocCode());
        scheduleResItems.setDocName(scheduleRecordEntity.getDocName());
        scheduleResItems.setLocCode(scheduleRecordEntity.getDeptCode());
        scheduleResItems.setLocName(scheduleRecordEntity.getDeptName());
        scheduleResItems.setRegFee(scheduleRecordEntity.getRegFee().toString());
        scheduleResItems.setRegTitleCode(scheduleRecordEntity.getRegTitelCode());
        scheduleResItems.setRegTitleName(scheduleRecordEntity.getRegTitelName());
        scheduleResItems.setScheduleLevelCode(scheduleRecordEntity.getScheduleLevelCode());
        scheduleResItems.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
        scheduleResItems.setLocTypeCode(scheduleRecordEntity.getDeptCategoryCode());
        scheduleResItems.setLocTypeName(scheduleRecordEntity.getDeptCategoryName());
        scheduleResItems.setAdmLocation(scheduleRecordEntity.getAdmLocation());
        scheduleResItems.setRegAvailable(scheduleRecordEntity.getAvailableCount());
        scheduleResItems.setRegTotal(scheduleRecordEntity.getTotalCount());
        scheduleResItems.setAppStartNo(String.valueOf(scheduleRecordEntity.getStartNo()));
        scheduleResItems.setScheduleStatus(scheduleRecordEntity.getStatus().toString());
        scheduleResItems.setReplaceScheduleId(scheduleRecordEntity.getReplaceScheduleHisId());
        scheduleResItems.setIsTimeArrange(Integer.valueOf(scheduleRecordEntity.getIsPrecise().intValue()));
        scheduleResItems.setDiagFee(scheduleRecordEntity.getDiagFee().toString());
        scheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
        return scheduleResItems;
    }

    private List<TimeArrangeItems> buildTimeArrangeItems(List<ScheduleDetailRecordEntity> scheduleDetailRecordList) {
        List<TimeArrangeItems> TimeArrangeItemList = scheduleDetailRecordList.stream().map(scheduleDetailRecordEntity -> {
            TimeArrangeItems getTimeArrangeItems = new TimeArrangeItems();
            getTimeArrangeItems.setStartNo(scheduleDetailRecordEntity.getStartNo());
            getTimeArrangeItems.setEndNo(scheduleDetailRecordEntity.getEndNo());
            getTimeArrangeItems.setStartTime(scheduleDetailRecordEntity.getStartTime());
            getTimeArrangeItems.setEndTime(scheduleDetailRecordEntity.getEndTime());
            getTimeArrangeItems.setTimeArrangeId(scheduleDetailRecordEntity.getHisTimeArrangeId());
            getTimeArrangeItems.setBookedNos(scheduleDetailRecordEntity.getBookedNos());
            return getTimeArrangeItems;
        }).collect(Collectors.toList());
        return TimeArrangeItemList;
    }

    private List<ScheduleRecordEntity> getScheduleByScheduleDTO(GetScheduleDTO getScheduleDTO) {
        return this.scheduleRecordMapper.selectByGetScheduleDTO(getScheduleDTO);
    }

    private List<ScheduleDetailRecordEntity> getScheduleDetailRecord(String hisScheduleId, String organCode) {
        return this.scheduleDetailRecordMapper.selectByHisScheduleId(hisScheduleId, organCode);
    }

    private List<GetScheduleResItems> getScheduleResItemsList(GetScheduleDTO getScheduleDTO) {
        List recordEntityList = this.getScheduleByScheduleDTO(getScheduleDTO);
        List filterRecordEntityList = recordEntityList.stream().filter(scheduleRecordEntity -> scheduleRecordEntity.getRegFee().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        List<GetScheduleResItems> scheduleResItemsList = filterRecordEntityList.stream().map(scheduleRecordEntity -> {
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            List scheduleDetailRecordList = this.getScheduleDetailRecord(scheduleRecordEntity.getScheduleHisId(), scheduleRecordEntity.getHospitalCode());
            List TimeArrangeItems2 = this.buildTimeArrangeItems(scheduleDetailRecordList);
            getScheduleResItems = this.buildGetScheduleResItems(scheduleRecordEntity, TimeArrangeItems2);
            return getScheduleResItems;
        }).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u6392\u73ed\u4fe1\u606f \uff1a{}", (Object)JSON.toJSONString(scheduleResItemsList));
        return scheduleResItemsList;
    }

    private List<GetScheduleResItems> getDocSchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDocCode().equals(((GetScheduleReqVO)gatewayRequest.getBody()).getDocCode())).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + getScheduleResItemsList);
        return getScheduleResItemsList;
    }

    private List<GetDeptDoctorInfoResItems> getDeptDoctorInfo(GatewayRequest<GetDeptDoctorInfoReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDeptDoctorInfo(gatewayRequest);
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        GetDeptDoctorInfoResVO getScheduleResVO = (GetDeptDoctorInfoResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        List<GetDeptDoctorInfoResItems> getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDoctorCode().equals(((GetDeptDoctorInfoReqVO)gatewayRequest.getBody()).getDocCode())).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + getScheduleResItemsList);
        return getScheduleResItemsList;
    }

    private boolean getSchduleStatus(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return false;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return false;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return false;
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        List items = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return false;
        }
        for (GetScheduleResItems item : items) {
            if (item.getRegAvailable() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean getHsSchduleStatus(GatewayRequest<GetScheduleReqVO> gatewayRequest, GetScheduleVoReq getScheduleVoReq) {
        List expertNationalEntityList = this.tExpertNationalMapper.selectByDeptCode(getScheduleVoReq.getFirstDeptCode(), getScheduleVoReq.getDeptCode());
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return false;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return false;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return false;
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        List items = getScheduleResVO.getItems();
        Map<String, List<GetScheduleResItems>> getScheduleResItemMap = items.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode));
        if (!CollectionUtils.isEmpty((Collection)expertNationalEntityList)) {
            LinkedHashMap<String, List<GetScheduleResItems>> getScheduleResItemNewMap = new LinkedHashMap<String, List<GetScheduleResItems>>();
            for (ExpertNationalEntity expertNationalEntity : expertNationalEntityList) {
                List<GetScheduleResItems> getScheduleResItems = getScheduleResItemMap.get(expertNationalEntity.getDocCode());
                if (CollectionUtils.isEmpty(getScheduleResItems)) continue;
                getScheduleResItemNewMap.put(expertNationalEntity.getDocCode(), getScheduleResItemMap.get(expertNationalEntity.getDocCode()));
            }
            log.info("\u8fc7\u6ee4\u4eac\u6d25\u4e13\u5bb6\u672a\u8d4b\u503c\u524d\uff1a" + JSON.toJSONString(getScheduleResItemNewMap));
            getScheduleResItemMap = getScheduleResItemNewMap;
        }
        if (CollectionUtils.isEmpty(getScheduleResItemMap)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return false;
        }
        for (GetScheduleResItems item : items) {
            if (item.getRegAvailable() <= 0) continue;
            return true;
        }
        return false;
    }
}

