/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.doctoruser.api.pojo.base.dto.OrganIdReq;
import com.doctoruser.api.pojo.base.dto.dept.SynHisDeptReq;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.vo.doctor.OrganDeptInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.dto.DoctorBaseInfoListDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DoctorVoReq;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetDoctorInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(GetDoctorInfoUtil.class);
    @Autowired
    private ProPropertiesConstant constant;

    public DoctorBaseInfoDTO getDoctorInfo(Long doctorId, String organId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("doctorId", doctorId.toString());
            params.put("organId", organId);
            String body = HttpKit.get((String)this.constant.getGetDoctorInfoUrl(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},mag:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            DoctorBaseInfoDTO doctorBaseInfoDTO = (DoctorBaseInfoDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), DoctorBaseInfoDTO.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> " + doctorBaseInfoDTO);
            return doctorBaseInfoDTO;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new DoctorBaseInfoDTO();
        }
    }

    public List<DoctorBaseInfoDTO> getDoctorInfoList(List<Long> doctorIdList, String organId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("doctorIdList", doctorIdList.toString());
            params.put("organId", organId);
            String body = HttpKit.get((String)this.constant.getGetDoctorInfoListUrl(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},msg:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)response.getData()), DoctorBaseInfoDTO.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> " + list);
            return list;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new ArrayList<DoctorBaseInfoDTO>();
        }
    }

    public BaseResponse getSynchronizeHisDeptInfo(SynHisDeptReq synHisDeptReq) {
        try {
            String body = HttpKit.jsonPost((String)this.constant.getGetSynchronizeHisDeptInfoUrl(), (String)JSON.toJSONString((Object)synHisDeptReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011SynchronizeHisDeptInfo -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011SynchronizeHisDeptInfo -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                return null;
            }
            return response;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011SynchronizeHisDeptInfo -> doctorUserService\u8bf7\u6c42\u51fa\u9519");
            return null;
        }
    }

    public List<OrganDeptInfoVO> getListOrganDept(OrganIdReq organIdReq) {
        try {
            String body = HttpKit.jsonPost((String)this.constant.getGetListOrganDeptUrl(), (String)JSON.toJSONString((Object)organIdReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getListOrganDept -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getListOrganDept -> \u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1 err_code:{},msg:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getListOrganDept -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                return null;
            }
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)response.getData()), OrganDeptInfoVO.class);
            log.info("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getListOrganDept -> " + list);
            return list;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getListOrganDept -> doctorUserService\u8bf7\u6c42\u51fa\u9519");
            return new ArrayList<OrganDeptInfoVO>();
        }
    }

    public List<DepartmentEntity> getHotDepartmentList(String organId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("organId", organId);
            String body = HttpKit.get((String)this.constant.getGetHotDepartmentListUrl(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getHotDepartmentList -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getHotDepartmentList -> \u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1 err_code:{},msg:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getHotDepartmentList -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                return null;
            }
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)response.getData()), DepartmentEntity.class);
            log.info("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getHotDepartmentList -> " + list);
            return list;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u4e91\u4e0a\u533b\u751f\u670d\u52a1\u3011getHotDepartmentList -> doctorUserService\u8bf7\u6c42\u51fa\u9519");
            return new ArrayList<DepartmentEntity>();
        }
    }

    public List<DoctorBaseInfoListDTO> getDoctorList(DoctorVoReq doctor) {
        try {
            String body = HttpKit.jsonPost((String)this.constant.getGetDoctorListUrl(), (String)JSON.toJSONString((Object)doctor));
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> http\u8fd4\u56de\uff1a" + body);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},msg:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)response.getData()), DoctorBaseInfoListDTO.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> " + list);
            return list;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new ArrayList<DoctorBaseInfoListDTO>();
        }
    }
}

