/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.HospitalTitleEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.GetHospitalTitleVo;
import com.ebaiyihui.wisdommedical.service.HospitalTitleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7840api"})
@RequestMapping(value={"/api/v1/base/"})
public class BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private HospitalTitleService hospitalTitleService;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;

    @DisableAuthConfig
    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u524d\u7aef\u52a8\u6001\u6309\u94ae\u83b7\u53d6", notes="\u9884\u7ea6\u6302\u53f7\u524d\u7aef\u52a8\u6001\u6309\u94ae\u83b7\u53d6")
    @GetMapping(value={"getMenu"})
    public BaseResponse<Map<String, String>> getMenu(@RequestParam(value="appCode") String appCode, @RequestParam(value="organCode") String organCode) {
        HashMap<String, String> menuMap = new HashMap<String, String>();
        menuMap.put("menuButton", "[[\"1 && 2 && 1\",[\"qxgh\", \"goPay\"]],[\"1 && 2 && 2\",[\"qxgh\"]],[\"1 && 5 && 1\",[\"zcyy\"]],[\"1 && 5 && 2\",[\"zcyy\"]],[\"1 && 6 && 1\",[\"zcyy\"]],[\"1 && 6 && 2\",[\"zcyy\"]],[\"1 && 8 && 1\",[\"zcyy\"]],[\"1 && 8 && 2\",[\"zcyy\"]],[\"1 && 7 && 1\",[\"zcyy\"]],[\"1 && 7 && 2\",[\"zcyy\"]],[\"1 && 11 && 1\",[\"zcyy\"]],[\"1 && 11 && 2\",[\"zcyy\"]],[\"2 && 2 && 1\",[\"goPay\"]],[\"2 && 2 && 2\",[\"goPay\"]],[\"2 && 5 && 1\",[\"zcyy\"]],[\"2 && 5 && 2\",[\"zcyy\"]],[\"2 && 6 && 1\",[\"zcyy\"]],[\"2 && 6 && 2\",[\"zcyy\"]],[\"2 && 8 && 1\",[\"zcyy\"]],[\"2 && 8 && 2\",[\"zcyy\"]],[\"2 && 7 && 1\",[\"zcyy\"]],[\"2 && 7 && 2\",[\"zcyy\"]],[\"2 && 11 && 1\",[\"zcyy\"]],[\"2 && 11 && 2\",[\"zcyy\"]]]");
        menuMap.put("docDesc", "[[2,{\"stateName\":\"\u5f85\u652f\u4ed8\",\"color\":\"#FF9921\",\"bgColor\":\"#FFF3CB\",\"funName\":\"deadline\"}],[7,{\"stateName\":\"\u5df2\u6302\u53f7\",\"color\":\"#3576E0\",\"bgColor\":\"#D6EDFF\",\"tip\":\"\u8bf7\u60a8\u6309\u65f6\u524d\u5f80\u533b\u9662\u5c31\u8bca\"}],[5,{\"stateName\":\"\u5df2\u53d6\u6d88\",\"color\":\"#FF5F5F\",\"bgColor\":\"#FFEDED\",\"tip\":\"\u8d85\u65f6\u672a\u652f\u4ed8\uff0c\u9884\u7ea6\u53f7\u6e90\u5df2\u53d6\u6d88\"}],[8,{\"stateName\":\"\u5df2\u9000\u8d39\",\"color\":\"#FF5F5F\",\"bgColor\":\"#FFEDED\",\"tip\":\"\u6302\u53f7\u8d39\u7528\u5df2\u539f\u8def\u9000\u56de\uff0c\u8bf7\u5173\u6ce8\u67e5\u8be2\"}],[6,{\"stateName\":\"\u5df2\u9000\u53f7\",\"color\":\"#FF5F5F\",\"bgColor\":\"#FFEDED\",\"tip\":\"\u5df2\u7533\u8bf7\u9000\u53f7\uff0c\u8bf7\u7b49\u5f85\u6b3e\u9879\u9000\u56de\"}],[11,{\"stateName\":\"\u5f85\u786e\u8ba4\",\"color\":\"#3576E0\",\"bgColor\":\"#D6EDFF\",\"tip\":\"\u8bf7\u7b49\u5f85\u786e\u8ba4\u6302\u53f7\u7ed3\u679c\uff0c\u4e0b\u62c9\u53ef\u5237\u65b0\u6302\u53f7\u72b6\u6001\"}]]\n");
        menuMap.put("statusDesc", "[[2,{\"stateName\":\"\u5f85\u652f\u4ed8\",\"color\":\"#FF9921\"}],[7,{\"stateName\":\"\u5df2\u6302\u53f7\",\"color\":\"#3576E0\"}],[5,{\"stateName\":\"\u5df2\u53d6\u6d88\",\"color\":\"#999999\"}],[8,{\"stateName\":\"\u5df2\u9000\u8d39\",\"color\":\"#999999\"}],[6,{\"stateName\":\"\u5df2\u9000\u53f7\",\"color\":\"#999999\"}],[11,{\"stateName\":\"\u5f85\u786e\u8ba4\",\"color\":\"#3576E0\"}]]");
        menuMap.put("admDesc", "[[1,[ \"\u5c31\u8bca\u8bf4\u660e\uff1a1\u3001\u770b\u8bca\u5f53\u65e5\uff0c\u8bf7\u60a8\u5728\u9884\u7ea6\u65f6\u6bb5\u4e4b\u524d\u5230\u73b0\u573a\u5c31\u8bca;2\u3001\u5728\u9884\u7ea6\u65f6\u6bb530\u5206\u949f\u5185\u672a\u6765\u5c31\u8bca\u8005\uff0c\u89c6\u4e3a\u8fc7\u53f7\uff0c\u82e5\u9700\u5c31\u8bca\uff0c\u8bf7\u5230\u5bfc\u8bca\u53f0\uff0c\u7531\u5206\u8bca\u62a4\u58eb\u5b89\u6392\u91cd\u65b0\u53d6\u53f7;3\u3001\u5f53\u65e5\u672a\u6765\u5c31\u8bca\u8005\uff0c\u89c6\u4e3a\u723d\u7ea6\uff0c\u723d\u7ea6\u4e09\u6b21\uff0c\u5c06\u5217\u5165\u9884\u7ea6\u8bca\u7597\u9ed1\u540d\u5355\uff0c12\u4e2a\u6708\u5185\u65e0\u6cd5\u9884\u7ea6\u6302\u53f7\u3002\"]],[2,[\"\u9000\u53f7\u8bf4\u660e\uff1a1\u3001\u9884\u7ea6\u770b\u8bca\u65e5\uff0c\u5f53\u65e50:00\u4e4b\u524d\uff0c\u53ef\u4ee5\u5728\u201c\u6211\u7684\u201c-\u201d\u6211\u7684\u6302\u53f7\u4e2d\u64cd\u4f5c\u9000\u53f7\uff0c\u6302\u53f7\u8d39\u7528\u5c06\u539f\u8def\u8fd4\u56de\u60a8\u7684\u4ed8\u6b3e\u8d26\u6237\uff1b2\u3001\u9884\u7ea6\u770b\u8bca\u65e5\uff0c\u5f53\u65e50:00\u4ee5\u540e\uff0c\u8bf7\u60a8\u5230\u95e8\u8bca\u4eba\u5de5\u7a97\u53e3\u9000\u8d39\uff0c\u4e0d\u53ef\u7ebf\u4e0a\u9000\u53f7\u3002\"]]]");
        menuMap.put("hideEntry", "[\"queryInHosinfo/patient\",\"hospitalCheckBalance/patient\"]");
        menuMap.put("listUrl", "[[\"tgjzkcz\",\"/pages/patient/pages/patientList/index?origin=4\"],[\"zyfyqd\",\"/wisdomTreatment/pages/queryInHosinfo/index?queryType=2\"],[\"cxyemx\",\"/wisdomTreatment/pages/queryInHosinfo/index?queryType=3\"],[\"cxzyjl\",\"/wisdomTreatment/pages/queryInHosinfo/index?queryType=1\"]]");
        menuMap.put("queryInHosinfoTitles", "[[1,\"\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55\"],[2,\"\u67e5\u8be2\u4f4f\u9662\u8d39\u7528\u6e05\u5355\"],[3,\"\u67e5\u8be2\u4f4f\u9662\u4f59\u989d\u660e\u7ec6\"]]");
        menuMap.put("queryTypeJumpUrl", "[[1,\"/wisdomTreatment/pages/hospticalRecordDetail/index\"],[2,\"/wisdomTreatment/pages/consumptionList/index\"],[3,\"/wisdomTreatment/pages/hospitalCheckBalance/index\"]]");
        menuMap.put("closeBusiness", "[]");
        return BaseResponse.success(menuMap);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4", notes="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4")
    @GetMapping(value={"/getCurrentDate"})
    public BaseResponse<Date> getCurrentDate() {
        return BaseResponse.success((Object)new Date());
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u804c\u79f0\u5217\u8868", notes="\u83b7\u53d6\u533b\u9662\u804c\u79f0\u5217\u8868")
    @GetMapping(value={"/getHospitalTitle"})
    public BaseResponse<List<HospitalTitleEntity>> getHospitalTitle(@Valid GetHospitalTitleVo getHospitalTitleVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List hospitalTitleEntityList = this.hospitalTitleService.getHospitalTitleByCategoryAndHospitalCode(getHospitalTitleVo.getCategory(), getHospitalTitleVo.getHospitalCode());
        return BaseResponse.success((Object)hospitalTitleEntityList);
    }

    @ApiOperation(value="\u5065\u5eb7\u76d1\u6d4b", notes="\u5065\u5eb7\u76d1\u6d4b")
    @GetMapping(value={"check_health"})
    public BaseResponse<String> checkHealth() {
        this.appointmentRecordMapper.checkHealth();
        return BaseResponse.success((Object)"\u667a\u6167\u5c31\u533b\u670d\u52a1\u6b63\u5e38");
    }
}

