/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79d1\u5ba4api"})
@RequestMapping(value={"api/v1/dept"})
public class DepartmentController {
    private static final Logger log = LoggerFactory.getLogger(DepartmentController.class);
    @Autowired
    private DepartmentService departmentService;

    @DisableAuthConfig
    @ApiOperation(value="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4", notes="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4")
    @GetMapping(value={"/getDeptList"})
    public BaseResponse<List<GetDeptListVoRes>> getDeptList(@RequestParam(value="organCode", required=false) String organCode, @RequestParam(value="userId") String userId, @RequestParam(value="organId") String organId, @RequestParam(value="hospAreaCode") String hospAreaCode) {
        List getDeptListVoResList = null;
        try {
            getDeptListVoResList = this.departmentService.getDeptList(organCode, userId, hospAreaCode);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getDeptListVoResList);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u83b7\u53d6\u79d1\u5ba4\u7ea7\u522b", notes="\u83b7\u53d6\u79d1\u5ba4\u7ea7\u522b")
    @GetMapping(value={"/getIntroduction"})
    public BaseResponse<String> getIntroduction(@RequestParam(value="deptCode") String deptCode, @RequestParam(value="deptName") String deptName) {
        String introduction = "";
        introduction = this.departmentService.getIntroduction(deptCode, deptName);
        return BaseResponse.success((Object)introduction);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u641c\u7d22\u79d1\u5ba4", notes="\u641c\u7d22\u4e8c\u7ea7\u79d1\u5ba4")
    @GetMapping(value={"/searchDept"})
    public BaseResponse<List<HospitalDeptVo>> searchDept(@ApiParam(name="organCode", value="\u533b\u9662id") @RequestParam(value="organCode") String organCode, @ApiParam(name="userId", value="\u7528\u6237id") @RequestParam(value="userId") String userId, @ApiParam(name="searchKey", value="\u641c\u7d22\u5185\u5bb9") @RequestParam(value="searchKey") String key) {
        List hospitalDeptVoList = null;
        try {
            hospitalDeptVoList = this.departmentService.searchDept(organCode, userId, key);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)hospitalDeptVoList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5386\u53f2\u641c\u7d22\u8bb0\u5f55", notes="\u83b7\u53d6\u5386\u53f2\u641c\u7d22\u8bb0\u5f55")
    @GetMapping(value={"/getRecentSearchDeptList"})
    public BaseResponse<List<String>> getRecentSearchDeptList(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId) {
        List keywordList = null;
        try {
            keywordList = this.departmentService.getRecentSearchDeptList(organCode, userId);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)keywordList);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u5386\u53f2\u8bb0\u5f55", notes="\u5220\u9664\u5355\u4e2a\u5386\u53f2\u8bb0\u5f55")
    @GetMapping(value={"/deleteOneSearchRecord"})
    public BaseResponse deleteOneSearchRecord(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId, @RequestParam(value="keyword") String deptCode) {
        try {
            this.departmentService.deleteOneSearchRecord(organCode, userId, deptCode);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5220\u9664\u5168\u90e8\u5386\u53f2\u8bb0\u5f55", notes="\u5220\u9664\u5168\u90e8\u5386\u53f2\u8bb0\u5f55")
    @GetMapping(value={"/deleteSearchRecord"})
    public BaseResponse deleteAllSearchRecords(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId) {
        try {
            this.departmentService.deleteAllSearchRecords(organCode, userId);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }
}

