/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.UploadDocExcelReqVo;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDocInfoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorPositionInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetDoctorBaseInfoVo;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u533b\u751fapi"})
@RequestMapping(value={"/api/v1/doctor"})
public class DoctorController {
    private static final Logger log = LoggerFactory.getLogger(DoctorController.class);
    @Autowired
    private DoctorService doctorService;

    @DisableAuthConfig
    @GetMapping(value={"/getDoctorDeptRecord"})
    public BaseResponse<List<DoctorRecordEntity>> getDoctorDeptRecord(@RequestParam(value="docCode") String docCode, @RequestParam(value="hospitalCode") String hospitalCode) {
        List doctorRecordEntitys = this.doctorService.getDoctorDeptRecord(docCode, hospitalCode);
        return BaseResponse.success((Object)doctorRecordEntitys);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u8c03\u7528his \u6839\u636e\u533b\u751f\u79d1\u5ba4code\u83b7\u53d6\u533b\u751f\u57fa\u7840\u4fe1\u606f", notes="\u8c03\u7528his \u6839\u636e\u533b\u751f\u79d1\u5ba4code\u83b7\u53d6\u533b\u751f\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"/getDoctorBasicInfoFromHis"})
    public BaseResponse<GetDocInfoRes> getDoctorBasicInfoFromHis(@ApiParam(name="doctorCode", value="\u533b\u751fCode") @RequestParam(value="doctorCode") String doctorCode, @ApiParam(name="deptCode", value="\u79d1\u5ba4Code") @RequestParam(value="deptCode") String deptCode) {
        return this.doctorService.getDoctorBasicInfoFromHis(doctorCode, deptCode);
    }

    @GetMapping(value={"/getDoctorRecordEntity"})
    public BaseResponse<DoctorRecordEntity> getDoctorRecordEntity(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="hospitalCode") String hospitalCode) {
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordEntity(doctorId, hospitalCode);
        return BaseResponse.success((Object)doctorRecordEntity);
    }

    @PostMapping(value={"/updateDoctorIdByDoctorCode"})
    public BaseResponse<String> updateDoctorIdByDoctorCode(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="doctorCode") String doctorCode, @RequestParam(value="hospitalCode") String hospitalCode) {
        this.doctorService.updateDoctorIdByDoctorCode(doctorId, doctorCode, hospitalCode);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getDoctorCodesByDoctorIds"})
    public BaseResponse<List<Long>> getDoctorCodeByDoctorId(@RequestParam(value="doctorId") String doctorId) {
        List doctorCodeList = this.doctorService.getDoctorCodeListBydoctorIds(doctorId);
        return BaseResponse.success((Object)doctorCodeList);
    }

    @PostMapping(value={"/getSchduleDoctor"})
    public BaseResponse<List<ScheduleDoctorVoRes>> getSchduleDoctor(@RequestBody @Valid ScheduleDoctorVoReq scheduleDoctorVoReq) {
        List scheduleDoctor = this.doctorService.getScheduleDoctor(scheduleDoctorVoReq);
        return BaseResponse.success((Object)scheduleDoctor);
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751f\u4ee3\u7801\u83b7\u53d6\u533b\u751f\u57fa\u7840\u4fe1\u606f", notes="\u6839\u636e\u533b\u751f\u4ee3\u7801\u83b7\u53d6\u533b\u751f\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"/getDoctorBasicInfo"})
    public BaseResponse<GetDoctorBaseInfoVo> getDoctorBasicInfo(@ApiParam(name="docCode", value="\u533b\u751f\u7f16\u7801") @RequestParam(value="docCode") String docCode, @ApiParam(name="organId", value="\u533b\u9662id\u503c") @RequestParam(value="organId") String organId) {
        return this.doctorService.getDoctorBasicInfo(docCode, organId);
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751fId\u83b7\u53d6\u533b\u751f\u57fa\u7840\u4fe1\u606f", notes="\u6839\u636e\u533b\u751fId\u83b7\u53d6\u533b\u751f\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"/getDoctorBasicInfoByDoctorId"})
    public BaseResponse<GetDoctorPositionInfoVo> getDoctorBasicInfoByDoctorId(@ApiParam(name="doctorId", value="\u533b\u751f\u57fa\u7840\u4fe1\u606fid") @RequestParam(value="doctorId") String doctorId) {
        return this.doctorService.getDoctorBasicInfoByDoctorId(doctorId);
    }

    @PostMapping(value={"/importWesternFileUpload"})
    @ApiOperation(value="\u6587\u4ef6\u5bfc\u5165", notes="\u6587\u4ef6\u5bfc\u5165")
    public BaseResponse<Object> importWesternFileUpload(@RequestParam MultipartFile file) throws IOException {
        List uploadDocList = ExcelUtil.importExcel((MultipartFile)file, UploadDocExcelReqVo.class);
        return this.doctorService.importWestern(uploadDocList);
    }

    @DisableAuthConfig
    @PostMapping(value={"/docimportWesternFileUpload"})
    @ApiOperation(value="\u6587\u4ef6\u5bfc\u5165", notes="\u6587\u4ef6\u5bfc\u5165")
    public BaseResponse<Object> docimportWesternFileUpload(@RequestBody @Valid ScheduleDoctorVoReq scheduleDoctorVoReq) throws IOException {
        return this.doctorService.docimportWesternFileUpload(scheduleDoctorVoReq.getDeptCode());
    }
}

