/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.DoctorScheduleException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.pojo.vo.DocScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorSchedulePackingVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocSchedulePageVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleAndRecommendVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleStatusResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.ScheduleTimeArrangeReq;
import com.ebaiyihui.wisdommedical.service.DoctorScheduleService;
import com.ebaiyihui.wisdommedical.service.ManageDocScheduleService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6392\u73edapi"})
@RequestMapping(value={"/api/v1/schedule"})
public class ScheduleController {
    private static final Logger log = LoggerFactory.getLogger(ScheduleController.class);
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private DoctorScheduleService doctorScheduleService;
    @Autowired
    private ManageDocScheduleService manageDocScheduleService;

    @DisableAuthConfig
    @ApiOperation(value="\u7528\u6237\u7aef\u53f7\u6e90\u6709\u65e0", notes="\u7528\u6237\u7aef\u53f7\u6e90\u6709\u65e0")
    @GetMapping(value={"/getScheduleStatus"})
    public BaseResponse<List<ScheduleStatusResVO>> getScheduleStatus(@Valid GetScheduleVoReq getScheduleVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List scheduleStatusRes = null;
        try {
            scheduleStatusRes = this.scheduleService.getScheduleStatus(getScheduleVoReq);
        }
        catch (ScheduleException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)scheduleStatusRes);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u7528\u6237\u7aef\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606f", notes="\u7528\u6237\u7aef\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606f")
    @GetMapping(value={"/getSchedule"})
    public BaseResponse<List<GetScheduleVoRes>> getDoctorSchedule(@Valid GetScheduleVoReq getScheduleVoReq, BindingResult bindingResult) {
        long startTime = System.currentTimeMillis();
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List getDeptListVoResList = null;
        try {
            getDeptListVoResList = this.scheduleService.getScheduleNew(getScheduleVoReq);
        }
        catch (ScheduleException e) {
            BaseResponse.error((String)e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        log.info("\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return BaseResponse.success((Object)getDeptListVoResList);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u7528\u6237\u7aef\u67e5\u8be2\u533b\u751f\u5f53\u65e5\u6392\u73ed(\u652f\u6301\u901a\u8fc7\u533b\u751f\u7f16\u7801\u8fc7\u6ee4)", notes="\u7528\u6237\u7aef\u67e5\u8be2\u533b\u751f\u5f53\u65e5\u6392\u73ed")
    @GetMapping(value={"/getNewSchedule"})
    public BaseResponse<List<GetScheduleVoRes>> getNewSchedule(@Valid GetDoctorScheduleVoReq getScheduleVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List getDeptListVoResList = null;
        try {
            getDeptListVoResList = this.scheduleService.getNewSchedule(getScheduleVoReq);
        }
        catch (ScheduleException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getDeptListVoResList);
    }

    @ApiOperation(value="\u7528\u6237\u7aef\u83b7\u53d6\u533b\u751f\u8be6\u60c5\u9875\u9762\u6392\u73ed\u4fe1\u606f", notes="\u7528\u6237\u7aef\u83b7\u53d6\u533b\u751f\u8be6\u60c5\u9875\u9762\u6392\u73ed\u4fe1\u606f")
    @GetMapping(value={"/getDoctorSchedule"})
    public BaseResponse<GetDoctorScheduleVoRes> getDoctorSchedule(@Valid GetDoctorScheduleVoReq getDoctorScheduleVoReq, BindingResult bindingResult) {
        long startTime = System.currentTimeMillis();
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        GetDoctorScheduleVoRes getDoctorScheduleVoRes = null;
        try {
            getDoctorScheduleVoRes = this.scheduleService.getDoctorSchedule(getDoctorScheduleVoReq);
        }
        catch (ScheduleException e) {
            BaseResponse.error((String)e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        log.info("\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return BaseResponse.success((Object)getDoctorScheduleVoRes);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u533b\u751f\u4e3b\u9875\u9884\u7ea6\u6302\u53f7\u6392\u73ed", notes="\u533b\u751f\u4e3b\u9875\u9884\u7ea6\u6302\u53f7\u6392\u73ed")
    @GetMapping(value={"/getNewDoctorSchedule"})
    public BaseResponse<List<GetScheduleResItems>> getNewDoctorSchedule(@Valid GetDoctorScheduleVoReq getDoctorScheduleVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.scheduleService.getNewDoctorSchedule(getDoctorScheduleVoReq));
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u83b7\u53d6\u533b\u751f\u6392\u73ed\u4fe1\u606f", notes="\u533b\u751f\u7aef\u83b7\u53d6\u533b\u751f\u6392\u73ed\u4fe1\u606f")
    @GetMapping(value={"/getDoctorScheduleList"})
    public BaseResponse<List<DocScheduleVoRes>> getDoctorScheduleList(@RequestParam(value="organCode") String organCode, @RequestParam(value="doctorId") String doctorId) throws DoctorScheduleException {
        List getDoctorScheduleResList = null;
        try {
            log.info("\u67e5\u8be2\u533b\u751f\u7aef7\u5929\u6392\u73ed \u5165\u53c2  : \u533b\u9662\u7f16\u7801{},\u533b\u751fid{}", (Object)organCode, (Object)doctorId);
            getDoctorScheduleResList = this.doctorScheduleService.getDoctorScheduleVoRes(organCode, doctorId);
            if (null == getDoctorScheduleResList || getDoctorScheduleResList.isEmpty()) {
                log.error("\u533b\u751f\u7aef \u6ca1\u6709\u83b7\u53d6\u5230\u8be5\u533b\u751f\u7684\u6392\u73ed\u4fe1\u606f\uff0c\u533b\u9662\u7f16\u7801/\u533b\u751fid \uff1a" + organCode + "/" + doctorId);
                return BaseResponse.error((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5\u533b\u9662\u7684\u8be5\u533b\u751f\u7684\u6392\u73ed");
            }
            log.info("\u67e5\u8be2\u533b\u751f\u7aef7\u5929\u6392\u73ed \u51fa\u53c2  :" + getDoctorScheduleResList);
        }
        catch (DoctorScheduleException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getDoctorScheduleResList);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u533b\u751f\u6392\u73ed\u8be6\u7ec6\u4fe1\u606f", notes="\u7ba1\u7406\u7aef\u533b\u751f\u6392\u73ed\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/getManageDocSchedule"})
    public BaseResponse<ManageDocScheduleVoRes> getManageDocSchedule(@RequestParam(value="organCode") String organCode, @RequestParam(value="docCode") String docCode, @RequestParam(value="orderByFlag") String orderByFlag) throws DoctorScheduleException {
        ManageDocScheduleVoRes manageDocScheduleVoRes = null;
        try {
            manageDocScheduleVoRes = this.manageDocScheduleService.getManageDocSchedule(organCode, docCode, orderByFlag);
            if (null == manageDocScheduleVoRes) {
                log.info("\u7ba1\u7406\u7aef  \u6ca1\u6709\u83b7\u53d6\u5230\u8be5\u533b\u751f\u7684\u6392\u73ed\u4fe1\u606f\uff0c\u533b\u9662\u7f16\u7801/\u533b\u751f\u7f16\u7801 \uff1a" + organCode + "/" + docCode);
                return BaseResponse.error((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5\u533b\u9662\u7684\u8be5\u533b\u751f\u7684\u6392\u73ed");
            }
            log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed\u8be6\u7ec6 \u51fa\u53c2  :" + manageDocScheduleVoRes);
        }
        catch (DoctorScheduleException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)manageDocScheduleVoRes);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u6761\u4ef6\u6392\u73ed\u4fe1\u606f", notes="\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u6761\u4ef6\u6392\u73ed\u4fe1\u606f")
    @GetMapping(value={"/getPageManageDocSchedule"})
    public BaseResponse<PageResult<ManageDocScheduleVo>> getPageManageDocSchedule(@Valid ManageDocSchedulePageVoReq manageDocSchedulePageVoReq, BindingResult bindingResult) throws DoctorScheduleException {
        log.info("\u7ba1\u7406\u7aef\u6392\u73ed\u5206\u9875\u63a5\u6536\u53c2\u6570request: {}", (Object)manageDocSchedulePageVoReq.toString());
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        PageResult pageResult = null;
        try {
            pageResult = this.manageDocScheduleService.getPageManageDocScheduleVo(manageDocSchedulePageVoReq);
            log.info("\u7ba1\u7406\u7aef\u6392\u73ed\u5206\u9875\u8fd4\u56de\u53c2\u6570response: {}", (Object)pageResult.toString());
        }
        catch (DoctorScheduleException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)pageResult);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u7528\u6237\u7aef\u67e5\u8be2\u533b\u751f\u5f53\u65e5\u6392\u73ed\u53ca\u63a8\u8350\u540c\u79d1\u5ba4\u533b\u751f", notes="\u7528\u6237\u7aef\u67e5\u8be2\u533b\u751f\u5f53\u65e5\u6392\u73ed\u53ca\u63a8\u8350\u540c\u79d1\u5ba4\u533b\u751f")
    @GetMapping(value={"/getNewScheduleAndRecommend"})
    public BaseResponse<ScheduleAndRecommendVO> getNewScheduleAndRecommend(@Valid GetDoctorSchedulePackingVoReq getScheduleVoReq) {
        return this.scheduleService.getNewScheduleAndRecommend(getScheduleVoReq);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u8be6\u7ec6\u65f6\u95f4\u6bb5", notes="\u67e5\u8be2\u6392\u73ed\u8be6\u7ec6\u65f6\u95f4\u6bb5")
    @GetMapping(value={"/getScheduleTimeArrangeItems"})
    public BaseResponse<GetScheduleResItems> getScheduleTimeArrangeItems(@Valid ScheduleTimeArrangeReq scheduleTimeArrangeReq) {
        return this.scheduleService.getScheduleTimeArrange(scheduleTimeArrangeReq);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u8be6\u7ec6\u65f6\u95f4\u6bb5", notes="\u6839\u636e\u6392\u73edid\uff0c\u5c31\u8bca\u65e5\u671f\uff0c\u5c31\u8bca\u65f6\u95f4\u6bb5\u67e5\u8be2\u6392\u73ed\u8be6\u7ec6\u65f6\u95f4\u6bb5")
    @GetMapping(value={"/getScheduleTimeArrangeItemsByScheduleId"})
    public BaseResponse<GetScheduleResItems> getScheduleTimeArrangeItemsByScheduleId(@RequestParam(value="scheduleId") String scheduleId, @RequestParam(value="admDate") String admDate, @RequestParam(value="admTimeRange") String admTimeRange, @RequestParam(value="hosId") String hosId) {
        log.info("\u67e5\u8be2\u6392\u73ed\u8be6\u7ec6\u65f6\u95f4\u6bb5\u524d\u7aef\u5165\u53c2\uff1a" + scheduleId + "|" + admDate + "|" + admTimeRange);
        return this.scheduleService.getScheduleTimeArrangeItemsByScheduleId(scheduleId, admDate, admTimeRange, hosId);
    }
}

