/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.bdhealth;

import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.BdHealthException;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.BdDoctorScheduleReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.BdDoctorScheduleResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.DoctorNumberSourceReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.DoctorResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.DoctorScheduleResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.GetArrivalDataReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalBasicInforReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalBasicInforResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalDeptResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalDoctorReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalScheduleReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalScheduleResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.BaiduCommonResVo;
import com.ebaiyihui.wisdommedical.service.BaiduDataQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ed9\u767e\u5ea6\u63d0\u4f9b\u6570\u636e\u67e5\u8be2\u63a5\u53e3api"})
@RequestMapping(value={"/api/v1/bdhosquery"})
public class BaiduDataQueryController {
    private static final Logger log = LoggerFactory.getLogger(BaiduDataQueryController.class);
    @Autowired
    private BaiduDataQueryService baiduDataQueryService;

    @DisableAuthConfig
    @ApiOperation(value="\u533b\u751f\u6392\u73ed\u53f7\u6e90", notes="\u533b\u751f\u6392\u73ed\u53f7\u6e90")
    @PostMapping(value={"/doctorSchedule"})
    public BaiduCommonResVo<BdDoctorScheduleResVo> doctorSchedule(@Valid @RequestBody BdDoctorScheduleReqVo bdDoctorScheduleReqVo) {
        BaiduCommonResVo doctorSchedule;
        try {
            doctorSchedule = this.baiduDataQueryService.doctorSchedule(bdDoctorScheduleReqVo);
        }
        catch (BdHealthException e) {
            return BaiduCommonResVo.error((String)e.getMessage());
        }
        return doctorSchedule;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u533b\u9662\u57fa\u7840\u4fe1\u606f\u63a5\u53e3", notes="\u533b\u9662\u57fa\u7840\u4fe1\u606f\u63a5\u53e3")
    @PostMapping(value={"/hospitalBasicInfor"})
    public BaiduCommonResVo<HospitalBasicInforResVo> hospitalBasicInfor(@Valid @RequestBody HospitalBasicInforReqVo hospitalBasicInforReqVo) {
        BaiduCommonResVo hospitalBasicInforRes;
        try {
            hospitalBasicInforRes = this.baiduDataQueryService.hospitalBasicInfor(hospitalBasicInforReqVo);
        }
        catch (BdHealthException e) {
            return BaiduCommonResVo.error((String)e.getMessage());
        }
        return hospitalBasicInforRes;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u533b\u9662\u79d1\u5ba4\u4fe1\u606f\u63a5\u53e3", notes="\u533b\u9662\u79d1\u5ba4\u4fe1\u606f\u63a5\u53e3")
    @PostMapping(value={"/getHospitalDept"})
    public BaiduCommonResVo<List<HospitalDeptResVo>> getHospitalDept(@Valid @RequestBody HospitalBasicInforReqVo hospitalBasicInforReqVo) {
        BaiduCommonResVo hospitalDeptInfo;
        try {
            hospitalDeptInfo = this.baiduDataQueryService.getHospitalDept(hospitalBasicInforReqVo);
        }
        catch (BdHealthException e) {
            return BaiduCommonResVo.error((String)e.getMessage());
        }
        return hospitalDeptInfo;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u533b\u9662\u533b\u751f\u4fe1\u606f\u63a5\u53e3", notes="\u533b\u9662\u533b\u751f\u4fe1\u606f\u63a5\u53e3")
    @PostMapping(value={"/getHospitalDoctor"})
    public BaiduCommonResVo<List<DoctorResVo>> getHospitalDoctor(@Valid @RequestBody HospitalDoctorReqVo hospitalBasicInforReqVo) {
        BaiduCommonResVo hospitalDoctorInfo;
        try {
            hospitalDoctorInfo = this.baiduDataQueryService.getHospitalDoctor(hospitalBasicInforReqVo);
        }
        catch (BdHealthException e) {
            return BaiduCommonResVo.error((String)e.getMessage());
        }
        return hospitalDoctorInfo;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u83b7\u53d6\u79d1\u5ba4\u6709\u53f7\u6e90\u7684\u533b\u751f\u4fe1\u606f", notes="\u83b7\u53d6\u79d1\u5ba4\u6709\u53f7\u6e90\u7684\u533b\u751f\u4fe1\u606f")
    @PostMapping(value={"/getDeptSchedule"})
    public BaiduCommonResVo<HospitalScheduleResVo> getDeptSchedule(@Valid @RequestBody HospitalScheduleReqVo hospitalScheduleReqVo) {
        BaiduCommonResVo hospitalScheduleResVo;
        try {
            hospitalScheduleResVo = this.baiduDataQueryService.getDeptSchedule(hospitalScheduleReqVo);
        }
        catch (BdHealthException e) {
            return BaiduCommonResVo.error((String)e.getMessage());
        }
        return hospitalScheduleResVo;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6839\u636e\u533b\u751f\u83b7\u53d6\u533b\u751f\u53f7\u6e90\u4fe1\u606f", notes="\u6839\u636e\u533b\u751f\u83b7\u53d6\u533b\u751f\u53f7\u6e90\u4fe1\u606f")
    @PostMapping(value={"/getDoctorSchedule"})
    public BaiduCommonResVo<DoctorScheduleResVo> getHospitalSchedule(@Valid @RequestBody DoctorNumberSourceReqVo doctorNumberSourceReqVo) {
        BaiduCommonResVo hospitalScheduleResVo;
        try {
            hospitalScheduleResVo = this.baiduDataQueryService.getDoctorSchedule(doctorNumberSourceReqVo);
        }
        catch (BdHealthException e) {
            return BaiduCommonResVo.error((String)e.getMessage());
        }
        return hospitalScheduleResVo;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u4e13\u75c5\u5230\u9662\u6570\u636e\u5bf9\u649e", notes="\u4e13\u75c5\u5230\u9662\u6570\u636e\u5bf9\u649e")
    @PostMapping(value={"/getArrivalData"})
    public BaiduCommonResVo<Map<String, Integer>> getArrivalData(@Valid @RequestBody GetArrivalDataReqVo getArrivalDataReqVo) {
        BaiduCommonResVo getArrivalData;
        try {
            getArrivalData = this.baiduDataQueryService.getArrivalData(getArrivalDataReqVo);
        }
        catch (BdHealthException e) {
            return BaiduCommonResVo.error((String)e.getMessage());
        }
        return getArrivalData;
    }
}

